/*
   fofx: function grapher for ASCII terminals
   Copyright (C) 1997 Tom Stepleton

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
   GraphEquation: Graphs the equation. (duh)
   DoDeterminanant: This one is neat (or I like to think so). DoDeterminant
        evaluates the determinant of the equation using that old saw:

                             f(x+h) - f(x)
                        lim  -------------
                        h->0       h

        Depending on the slope, DoDeterminant outputs one of the following
        characters: '-','\','|','/'. Hopefully the user can connect the
        dots afterwards.
   calc_and_plot: Calculates the numbers and plots them.
     Notes:
       Why all the HUGE_VALs? HUGE_VAL is fofx's way of telling itself not
       to bother graphing the equation anymore because it's already been
       graphed or because it's out of bounds. Nobody is going to graph
       infinity with fofx, or so I hope.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "fofx.h"
#include "fofx_err.h"

void GraphEquation(void)
{
  double x;

  if(yaxis) if(!((tlx < 0) && (0 < brx))) yaxis = 0;
  if(xaxis) if(!((bry < 0) && (0 < tly))) xaxis = 0;

  x = tlx;

  if(yaxis) {
    for(;x<=-iv;x=x+iv) {
      Variable = x;
      calc_and_plot(' ');
    }
    Variable = x;
      calc_and_plot('-');
      x = x+iv;
  }
  for(;x<brx;x=x+iv) {
    Variable = x;
    calc_and_plot(' ');
  }
}

void calc_and_plot(char plane_char)
{
  double answer,y,interval;

  answer=DoEquation();
  interval = ((tly-bry)/(cols-1));
  y = bry;

  if(answer<bry) answer = HUGE_VAL;

  if(xaxis) {
    for(;y<-interval;y=y+interval) {
      if(y>answer) fprintf(stdout,"%c",DoDeterminant(&answer));
      else fprintf(stdout,"%c",plane_char);
    }
    if(!(y>answer)) fprintf(stdout,"|");
    y=y+interval;
  }
  for(;((y<tly) && (answer<=tly));y=y+interval) {
    if(y>answer) fprintf(stdout,"%c",DoDeterminant(&answer));
    else fprintf(stdout,"%c",plane_char);
  }

  if(plane_char == '-')
    for(y;y<tly;y=y+interval) fprintf(stdout,"-");
  fprintf(stdout,"\n");
}

char DoDeterminant(double *answer)
{
  double x_plus_h,slope;

  Variable = Variable + DETERMINANT_H;
  x_plus_h = DoEquation(); 

  slope = ((x_plus_h - *answer)/DETERMINANT_H);
 
  *answer = HUGE_VAL; /* Chrono-synclastic infundibulate the answer so
                         we won't try to graph it anymore */
  if(slope >= 8 || slope <= -8) return('-');
  if(slope < 8 && slope > 0.6) return('\\');
  if(slope > -8 && slope < -0.6) return('/');
  if(slope >= -0.6 && slope <= 0.6) return('|');
  return('.');
}
