;/*************************************************************************
;** funct-3.1      (command interpreter - funct)                          **
;** geom.cmd : geometry programs                                          **
;** Copyright (C) 2003  Jean-Marc Drezet                                  **
;**                                                                       **
;**  This library is free software; you can redistribute it and/or        **
;**  modify it under the terms of the GNU Library General Public          **
;**  License as published by the Free Software Foundation; either         **
;**  version 2 of the License, or (at your option) any later version.     **
;**                                                                       **
;**  This library is distributed in the hope that it will be useful,      **
;**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
;**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
;**  Library General Public License for more details.                     **
;**                                                                       **
;**  You should have received a copy of the GNU Library General Public    **
;**  License along with this library; if not, write to the Free           **
;**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
;**                                                                       **
;** Please mail any bug reports/fixes/enhancements to me at:              **
;**      drezet@math.jussieu.fr                                           **
;** or                                                                    **
;**      Jean-Marc Drezet                                                 **
;**      Institut de Mathematiques                                        **
;**      UMR 7586 du CNRS                                                 **
;**      173, rue du Chevaleret                                           **
;**      75013 Paris                                                      **
;**      France                                                           **
;**                                                                       **
;**************************************************************************/


;---------------------------------------------------------------------------
; This program draws a triangle with its altitudes on a X window
;---------------------------------------------------------------------------
:ex0
1
0
-1
;
defframe f
frame f 0 1 0 1 1 1
setframe X f
setcolor X black
title X f Triangle with altitudes
point A
point B
point C
coord A 0.1 0.1
coord B 0.8 0.15
coord C 0.55 0.9
draw A X f
width X 2
draw_to B X f
draw_to C X f
draw_to A X f
width X 1
line AB
line BC
line CA
span_l AB A B
span_l BC B C
span_l CA C A
point HA
point HB
point HC
orthoproj A BC HA
orthoproj B CA HB
orthoproj C AB HC
draw A X f
setcolor X blue
putstring X f -O A
dash X 2
setcolor X red
draw_to HA X f
dash X 0
setcolor X blue
putstring X f -E P
draw B X f
setcolor X blue
putstring X f -E B
dash X 2
setcolor X red
draw_to HB X f
dash X 0
setcolor X blue
putstring X f -O Q
draw C X f
setcolor X blue
putstring X f -N C
dash X 2
setcolor X red
draw_to HC X f
dash X 0
setcolor X blue
putstring X f -S R
destroy A
destroy B
destroy C
destroy AB
destroy BC
destroy CA
destroy HA
destroy HB
destroy HC
destroy f
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;  This programs draws a Lissajou curve and another curve "around" it
;  Usage ;
;       ex1 a b n
;  with 
;     a,b = parameters of the Lissajou curve
;     n   = number of turns
;---------------------------------------------------------------------------
:ex1
4
0
-1
n=#1
if> n-#2 E1
n=#2
E1:
n0=n
if> n-#3 E2
n=#3
E2:
n=n*40
n0=n0*100
dx=2*pi/n0
xrange xr 1 n0+1
fix_xrange xr 0 dx
function xx xr
function yy xr
fill_func xx 0.5+0.5*cos(#1*x)
fill_func yy 0.5+0.5*sin(#2*x)
defframe f
frame f -0.1 1.1 -0.1 1.1 0.2 0.2
setframe X f
setcolor X black
title X f Lissajou curve in red and curve around it in blue
setcolor X red
polyg p 10
polyg_funct p xx yy
draw p X f
xrange xr2 1 n
dx=2*pi/n
fix_xrange xr2 0 dx
function xx2 xr2
function yy2 xr2
fill_func xx2 0.5+0.5*cos(#1*x)+0.05*cos(#3*x)
fill_func yy2 0.5+0.5*sin(#2*x)+0.05*sin(#3*x)
setcolor X blue
polyg q 10
polyg_funct q xx2 yy2
draw q X f
clean_ex1
;
;
:clean_ex1
1
1
-1
destroy xr
destroy xr2
destroy p
destroy q
destroy f
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws an octogon on a X window
;---------------------------------------------------------------------------
:ex2
1
0
-1
defframe f
frame f 0 1 0 1 0.2 0.2
setframe X f
setcolor X black
title X f Octogon
setcolor X red
polyg p 9
t=2*pi/8
;
do i 0 8
u=i*t
x=0.5+0.4*cos(u)
y=0.5+0.4*sin(u)
coord p i x y
enddo
;
draw p X f
destroy p
destroy f
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    Subprogram of ex5 and ex5b
;---------------------------------------------------------------------------
:ex3
1
1
-1
point A
line AB
point B
coord A 1 2
coord B 2 6
point C
coord C 7 1.5
line AC
clear X
defframe f
frame f -4 11 -4 11 15 15
line BC
point AA
line lA
line lB
point BB
line lC
point CC
point mA
point mB
point mC
point MA
point MB
point MC
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws a moving triangle with medians, altitudes and
;    bissectices.
;    Usage :
;        ex5 n
;    where n is the number of triangles
;---------------------------------------------------------------------------
:ex5
2
0
-1
ex3
do i 0 #1
coord A 1+i/100 2+i/100
coord B 2 6-i/100
coord C 7-i/80 1.5
prog
sleep 10
enddo
destroy f
destroy A
destroy B
destroy C
destroy CC
destroy AB
destroy BC
destroy AC
destroy AA
destroy BB
destroy lA
destroy lB
destroy lC
destroy mA
destroy mB
destroy mC
destroy MA
destroy MB
destroy MC
;
;
:prog
1
0
-1
clear X
setframe X f noax
setcolor X black
span_l AB A B
span_l AC A C
bissec AB AC lA
draw A X f
draw_to B X f
draw A X f
draw_to C X f
setcolor X red
span_l BC B C
inters lA BC AA
draw A X f
draw_to AA X f
draw B X f
inverse AB AB
setcolor X black
draw_to C X f
bissec AB BC lB
inters lB AC BB
setcolor X red  
draw B X f
draw_to BB X f
bissec AC BC lC
inters lC AB CC
draw C X f
draw_to CC X f
middle A B mC
middle C B mA
middle A C mB
orthoproj A BC MA
orthoproj B AC MB
orthoproj C AB MC
setcolor X green
draw A X f
draw_to mA X f
draw B X f
draw_to mB X f
draw C X f
draw_to mC X f
setcolor X blue
draw A X f
draw_to MA X f
draw B X f
draw_to MB X f
draw C X f
draw_to MC X f
;---------------------------------------------------------------------------
;
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws a moving triangle with medians, altitudes and
;    bissectices.
;    Usage :
;        ex5b n
;    where n is the number of sequences of 400 triangles
;---------------------------------------------------------------------------
:ex5b
2
0
-1
ex3
clear X
setframe X f noax
setcolor X black
title X f Moving triangle with heigths, medians and bissectrices
do j 1 #1
do i 0 400
coord A -5/7+i/70 -3/11+i/55
coord B -2/3+i/60 6-i/80
coord C 25/3-i/75 -17/26+i/65
progb
xflush
sleep 10
clean_progb
enddo
do i 0 400
coord A 5-i/70 7-i/55
coord B 6-i/60 1+i/80
coord C 3+i/75 5.5-i/65
progb
xflush
sleep 10
clean_progb
enddo
enddo
progb
destroy f
destroy A
destroy B
destroy C
destroy CC
destroy AB
destroy BC
destroy AC
destroy AA
destroy BB
destroy lA
destroy lB
destroy lC
destroy mA
destroy mB
destroy mC
destroy MA
destroy MB
destroy MC
;
;
:progb
1
0
-1
setcolor X black
span_l AB A B
span_l AC A C
bissec AB AC lA
draw A X f
draw_to B X f
draw A X f
draw_to C X f
setcolor X red
span_l BC B C
inters lA BC AA
draw A X f
draw_to AA X f
draw B X f
inverse AB AB
setcolor X black
draw_to C X f
bissec AB BC lB
inters lB AC BB
setcolor X red  
draw B X f
draw_to BB X f
bissec AC BC lC
inters lC AB CC
draw C X f
draw_to CC X f
middle A B mC
middle C B mA
middle A C mB
orthoproj A BC MA
orthoproj B AC MB
orthoproj C AB MC
setcolor X green
draw A X f
draw_to mA X f
draw B X f
draw_to mB X f
draw C X f
draw_to mC X f
setcolor X blue
draw A X f
draw_to MA X f
draw B X f
draw_to MB X f
draw C X f
draw_to MC X f
;
;
:clean_progb
1
0
-1
setcolor X white
draw A X f
draw_to B X f
draw A X f
draw_to C X f
draw A X f
draw_to AA X f
draw B X f
draw_to C X f
draw B X f
draw_to BB X f
draw C X f
draw_to CC X f
draw A X f
draw_to mA X f
draw B X f
draw_to mB X f
draw C X f
draw_to mC X f
draw A X f
draw_to MA X f
draw B X f
draw_to MB X f
draw C X f
draw_to MC X f
;---------------------------------------------------------------------------
;
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws hypocycloids, i.e. curves with parametric equations
;        x(t) = (a-b)cos(t) + b.cos(a/b-1)t)
;        y(t) = (a-b)sin(t) - b.sin(a/b-1)t)
;    see http://www-groups.dcs.st-and.ac.uk/~history/Curves/Hypocycloid.html
;    Usage
;        ex4 a b
;---------------------------------------------------------------------------
:ex4
3
0
-1
xrange xr 1 10000
fix_xrange xr 0 2*pi/300
function xx xr
function yy xr
a=#1
b=#2
c=a-b
d=a/b-1
fill_func xx c*cos(x)+b*cos(d*x)
fill_func yy c*sin(x)-b*sin(d*x)
defframe f
frame f -abs(c)-b abs(c)+b -abs(c)-b abs(c)+b abs(c)+b abs(c)+b
setframe X f
setcolor X black
title X f Hypocycloid with a=12, b=17
setcolor X red
polyg p 10
polyg_funct p xx yy
draw p X f
destroy xr
destroy p
destroy f
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program computes and draws intermediate curves between 2 Lissajou
;    curves :
;    Let
;       x1(t) = cos(at) ,  y1(t) = sin(bt)
;       x2(t) = cos(ct) ,  y2(t) = sin(dt)
;    be the parametric equations of the two Lissajou curves. An intermediate
;    curve has parametric equations
;       x(t) = cos(pt)  ,  y(t) = sin(qt)
;    with
;       p = t.a + (1-t).c   ,   q = t.b + (1-t).d
;    where 0 <= t <= 1.
;    Usage :
;        ex1b a b c d n
;    where n is the number of intermediate curves.
;---------------------------------------------------------------------------
:ex1b
6
0
-1
n=#1
if> n-#2 E1
n=#2
E1:
if> n-#3 E2
n=#3
E2:
if> n-#4 E3
n=#4
E3:
n=60*n
dx=2*pi/n
xrange xr 1 n+10
fix_xrange xr 0 dx
function xx xr
function yy xr
clear X
defframe f
frame f -0.1 1.1 -0.1 1.1 2 2
polyg p 10
do i 0 #5
setframe X f
t=i/#5
u=1-t
a=#1*t+#3*u
b=#2*t+#4*u
fill_func xx 0.5+0.5*cos(a*x)
fill_func yy 0.5+0.5*sin(b*x)
polyg_funct p xx yy
setcolor X red
draw p X f
xflush
sleep 10
setcolor X white
draw p X f
enddo
setcolor X red
draw p X f
destroy xr
destroy f
destroy p
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program computes and draws intermediate curves between 2 Lissajou
;    curves :
;    Let
;       x1(t) = cos(at) ,  y1(t) = sin(bt)
;       x2(t) = cos(ct) ,  y2(t) = sin(dt)
;    be the parametric equations of the two Lissajou curves. An intermediate
;    curve has parametric equations
;       x(t) = u.cos(at) + (1-u).cos(ct),  q = u.sin(bt) + (1-u).sin(dt)
;    where 0 <= u <= 1.
;    Usage :
;        ex1c a b c d n
;    where n is the number of intermediate curves.
;---------------------------------------------------------------------------
:ex1c
5
0
-1
n=#1
if> n-#2 E1
n=#2
E1:
if> n-#3 E2
n=#3
E2:
if> n-#4 E3
n=#4
E3:
n=30*n
dx=2*pi/n
xrange xr 1 n+10
fix_xrange xr -dx-dx dx
function xx xr
function yy xr
clear X
defframe f
frame f -0.1 1.1 -0.1 1.1 2 2
setframe X f noax
setcolor X black
title X f Curves between two Lissajou curves
polyg p 10
do i 0 #5
t=i/#5
u=1-t
fill_func xx 0.5+0.5*(t*cos(#1*x)+u*cos(#3*x))
fill_func yy 0.5+0.5*(t*sin(#2*x)+u*sin(#4*x))
polyg_funct p xx yy
setcolor X red
draw p X f
xflush
sleep 20
setcolor X white
draw p X f
enddo
setcolor X black
setcolor X red
draw p X f
setcolor X black
destroy xr
destroy f
destroy p
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws a moving triangle with medians, altitudes and
;    bissectices.
;    Usage :
;        ex5c n a b c d e f
;    where n is the number of sequences triangles. The coordinates of
;    the vertices will be
;    (cos(at), sin(bt)) , (cos(ct), sin(dt)) , (cos(et), sin(ft))
;     0 <= t <= 1
;---------------------------------------------------------------------------
:ex5c
7
0
-1
ex3c
clear X
setframe X f noax
dt=1/#1
do i 0 #1
t=i*dt
coord A cos(#2*t) sin(#3*t)
coord B cos(#4*t) sin(#5*t)
coord C cos(#6*t) sin(#7*t)
progc
xflush
sleep 10
clean_progc
setframe X f noax
enddo
progc
destroy f
destroy A
destroy B
destroy C
destroy CC
destroy AB
destroy BC
destroy AC
destroy AA
destroy BB
destroy lA
destroy lB
destroy lC
destroy mA
destroy mB
destroy mC
destroy MA
destroy MB
destroy MC
;
;
:progc
1
0
-1
setcolor X black
span_l AB A B
span_l AC A C
bissec AB AC lA
draw A X f
draw_to B X f
draw A X f
draw_to C X f
setcolor X red
span_l BC B C
inters lA BC AA
draw A X f
draw_to AA X f
draw B X f
inverse AB AB
setcolor X black
draw_to C X f
bissec AB BC lB
inters lB AC BB
setcolor X red  
draw B X f
draw_to BB X f
bissec AC BC lC
inters lC AB CC
draw C X f
draw_to CC X f
middle A B mC
middle C B mA
middle A C mB
orthoproj A BC MA
orthoproj B AC MB
orthoproj C AB MC
setcolor X green
draw A X f
draw_to mA X f
draw B X f
draw_to mB X f
draw C X f
draw_to mC X f
setcolor X blue
draw A X f
draw_to MA X f
draw B X f
draw_to MB X f
draw C X f
draw_to MC X f
;
;
:clean_progc
1
0
-1
setcolor X white
draw A X f
draw_to B X f
draw A X f
draw_to C X f
draw A X f
draw_to AA X f
draw B X f
draw_to C X f
draw B X f
draw_to BB X f
draw C X f
draw_to CC X f
draw A X f
draw_to mA X f
draw B X f
draw_to mB X f
draw C X f
draw_to mC X f
draw A X f
draw_to MA X f
draw B X f
draw_to MB X f
draw C X f
draw_to MC X f
;
;
:ex3c
1
1
-1
point A
line AB
point B
point C
line AC
clear X
defframe f
frame f -1 1 -1 1 -2 2
line BC
point AA
line lA
line lB
point BB
line lC
point CC
point mA
point mB
point mC
point MA
point MB
point MC
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws a moving cube
;    Usage :
;        ex6 n
;    where n is the number of cubes that will be drawn.
;---------------------------------------------------------------------------
:ex6
2
0
-1
point O
point A
point B
point C
point O2
point A2
point B2
point C2
defframe f
frame f -1.5 1.5 -1.5 1.5 3 3
coord O -3 0
setframe X f noax
draw O X f
coord O 3 0
setcolor X white
draw_to O X f
coord O 0 -3
draw O X f
coord O 0 3
draw_to O X f
vector U
vector V
vector Tr
dt=pi/400
do i 1 #1
t=i*dt
som_par t 2*t 3*t
transl cos(5*t) sin(4*t)
somm
drawube
xflush
sleep 10
clean_cube
setframe X f noax
enddo
drawube
destroy O
destroy A
destroy B
destroy C
destroy O2
destroy A2
destroy B2
destroy C2
destroy f
destroy U
destroy V
destroy Tr
;
;
:somm
1
0
-1
; U=vec(OC), V=vec(OB)
vector_p O C U
vector_p O B V
point_v A U C2
point_v B U B2
point_v A V A2
point_v A2 U O2
;
;
:som_par
4
0
-1
; 1 : theta0, 2 : phi0, 3 : rot
c0=cos(#1)
s0=sin(#1)
sp0=sin(#2)
cp0=cos(#2)
cr=cos(#3)
sr=sin(#3)
coord A c0*cp0 s0*cp0
coord B -s0*cr+sp0*c0*sr c0*cr+sp0*s0*sr
coord C s0*sr+sp0*c0*cr -c0*sr+sp0*s0*cr
;
;
:transl
3
0
-1
coord O #1 #2
coord Tr #1 #2
point_v A Tr A
point_v B Tr B
point_v C Tr C
;
;
:drawube
1
0
-1
setcolor X red
draw O X f
draw_to A X f
draw_to A2 X f
draw_to B X f
draw_to O X f
setcolor X blue
draw_to C X f
setcolor X red
draw_to C2 X f
draw_to O2 X f
draw_to B2 X f
draw_to C X f
setcolor X blue
draw C2 X f
draw_to A X f
draw O2 X f
draw_to A2 X f
draw B2 X f
draw_to B X f
;
;
:clean_cube
1
0
-1
setcolor X white
draw O X f
draw_to A X f
draw_to A2 X f
draw_to B X f
draw_to O X f
draw_to C X f
draw_to C2 X f
draw_to O2 X f
draw_to B2 X f
draw_to C X f
draw C2 X f
draw_to A X f
draw O2 X f
draw_to A2 X f
draw B2 X f
draw_to B X f
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws a moving cube, without drawing the hidden faces. 
;    Usage :
;        ex6b n
;    where n is the number of cubes that will be drawn.
;---------------------------------------------------------------------------
:ex6b
2
0
-1
point O
point A
point B
point C
point O2
point A2
point B2
point C2
vector OB
vector BA2
vector AA2
vector A2O2
vector BB2
vector B2O2
vector B2C
vector CC2
vector OC
defframe f
frame f -1.5 1.5 -1.5 1.5 3 3
coord O -3 0
setframe X f noax
draw O X f
coord O 3 0
setcolor X white
draw_to O X f
coord O 0 -3
draw O X f
coord O 0 3
draw_to O X f
vector U
vector V
vector Tr
dt=pi/400
do i 1 #1
t=i*dt
som_par t 2*t 3*t
transl cos(5*t) sin(4*t)
somm
setcolor X red
drawubeb
xflush
sleep 10
setcolor X white
drawubeb
setframe X f noax
enddo
setcolor X red
drawubeb
destroy O
destroy A
destroy B
destroy C
destroy O2
destroy A2
destroy B2
destroy C2
destroy OB
destroy BA2
destroy AA2
destroy A2O2
destroy BB2
destroy B2O2
destroy B2C
destroy CC2
destroy OC
destroy f
destroy U
destroy V
destroy Tr
;
;
:drawubeb
1
0
-1
vect_s
; face O B A2 A
ext_prod OB BA2
if< ext_p XXX1
draw_sqr O B A2 A
; face A A2 O2 C2
XXX1:
ext_prod AA2 A2O2
if< ext_p XXX2
draw_sqr A A2 O2 C2
; face B B2 O2 A2
XXX2:
ext_prod BB2 B2O2
if< ext_p XXX3
draw_sqr B B2 O2 A2
; face B2 C C2 O2
XXX3:
ext_prod B2C CC2
if< ext_p XXX4
draw_sqr B2 C C2 O2
; face B O C B2
XXX4:
ext_prod OB OC
if> ext_p XXX5
draw_sqr B O C B2
; face C2 C O A
XXX5:
ext_prod CC2 OC
if< ext_p XXX6
draw_sqr C2 C O A
;
XXX6:
;
;
:draw_sqr
5
0
-1
draw #1 X f
draw_to #2 X f
draw_to #3 X f
draw_to #4 X f
draw_to #1 X f
;
;
:vect_s
1
0
-1
vector_p O B OB
vector_p B A2 BA2
vector_p A A2 AA2
vector_p A2 O2 A2O2
vector_p B B2 BB2
vector_p B2 O2 B2O2
vector_p B2 C B2C
vector_p C C2 CC2
vector_p O C OC
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws a moving cube, without drawing the hidden faces,
;    with diagonals on the faces. 
;    Usage :
;        ex6c n
;    where n is the number of cubes that will be drawn.
;---------------------------------------------------------------------------
:ex6c
2
0
-1
point O
point A
point B
point C
point O2
point A2
point B2
point C2
vector OB
vector BA2
vector AA2
vector A2O2
vector BB2
vector B2O2
vector B2C
vector CC2
vector OC
defframe f
frame f -1.5 1.5 -1.5 1.5 3 3
coord O -3 0
setframe X f noax
draw O X f
coord O 3 0
setcolor X white
draw_to O X f
coord O 0 -3
draw O X f
coord O 0 3
draw_to O X f
vector U
vector V
vector Tr
dt=pi/400
do i 1 #1
t=i*dt
som_par t 2*t 3*t
transl cos(5*t) sin(4*t)
somm
drawubec
xflush
sleep 10
clean_cubec
setframe X f noax
enddo
drawubec
destroy O
destroy A
destroy B
destroy C
destroy O2
destroy A2
destroy B2
destroy C2
destroy OB
destroy BA2
destroy AA2
destroy A2O2
destroy BB2
destroy B2O2
destroy B2C
destroy CC2
destroy OC
destroy f
destroy U
destroy V
destroy Tr
;
;
:drawubec
1
0
-1
vect_s
; face O B A2 A
ext_prod OB BA2
if< ext_p XXX1
setcolor X black
draw_sqr O B A2 A
setcolor X blue
draw_diag O B A2 A
; face A A2 O2 C2
XXX1:
ext_prod AA2 A2O2
if< ext_p XXX2
setcolor X black
draw_sqr A A2 O2 C2
setcolor X green
draw_diag A A2 O2 C2
; face B B2 O2 A2
XXX2:
ext_prod BB2 B2O2
if< ext_p XXX3
setcolor X black
draw_sqr B B2 O2 A2
setcolor X red
draw_diag B B2 O2 A2
; face B2 C C2 O2
XXX3:
ext_prod B2C CC2
if< ext_p XXX4
setcolor X black
draw_sqr B2 C C2 O2
setcolor X blue
draw_diag B2 C C2 O2
; face B O C B2
XXX4:
ext_prod OB OC
if> ext_p XXX5
setcolor X black
draw_sqr B O C B2
setcolor X green
draw_diag B O C B2
; face C2 C O A
XXX5:
ext_prod CC2 OC
if< ext_p XXX6
setcolor X black
draw_sqr C2 C O A
setcolor X red
draw_diag C2 C O A
;
XXX6:
;
;
:clean_cubec
1
0
-1
setcolor X white
vect_s
; face O B A2 A
ext_prod OB BA2
if< ext_p XXX1
draw_sqr O B A2 A
draw_diag O B A2 A
; face A A2 O2 C2
XXX1:
ext_prod AA2 A2O2
if< ext_p XXX2
draw_sqr A A2 O2 C2
draw_diag A A2 O2 C2
; face B B2 O2 A2
XXX2:
ext_prod BB2 B2O2
if< ext_p XXX3
draw_sqr B B2 O2 A2
draw_diag B B2 O2 A2
; face B2 C C2 O2
XXX3:
ext_prod B2C CC2
if< ext_p XXX4
draw_sqr B2 C C2 O2
draw_diag B2 C C2 O2
; face B O C B2
XXX4:
ext_prod OB OC
if> ext_p XXX5
draw_sqr B O C B2
draw_diag B O C B2
; face C2 C O A
XXX5:
ext_prod CC2 OC
if< ext_p XXX6
draw_sqr C2 C O A
draw_diag C2 C O A
;
XXX6:
;
;
:draw_diag
5
0
-1
draw #1 X f
draw_to #3 X f
draw #2 X f
draw_to #4 X f
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws a moving cube, without drawing the hidden faces,
;    with diagonals on the faces. It is the almost the same as ex6c, but
;    the cube moves differently. 
;    Usage :
;        ex6d n
;    where n is the number of cubes that will be drawn.
;---------------------------------------------------------------------------
:ex6d
2
0
-1
point O
point A
point B
point C
point O2
point A2
point B2
point C2
vector OB
vector BA2
vector AA2
vector A2O2
vector BB2
vector B2O2
vector B2C
vector CC2
vector OC
defframe f
frame f -0.8 0.8 -0.8 0.8 3 3
setcolor X black
title X f Moving cube
coord O -3 0
setframe X f noax
draw O X f
coord O 3 0
setcolor X white
draw_to O X f
coord O 0 -3
draw O X f
coord O 0 3
draw_to O X f
vector U
vector V
vector Tr
dt=pi/400
do i 1 #1
t=i*dt
som_pard t 2*t 3*t abs(cos(t/4))
transl cos(5*t)/2 sin(4*t)/2
somm
drawubec
setframe X f noax
sleep 10
xflush
clean_cubec
enddo
drawubec
destroy O
destroy A
destroy B
destroy C
destroy O2
destroy A2
destroy B2
destroy C2
destroy f
destroy OB
destroy BA2
destroy AA2
destroy A2O2
destroy BB2
destroy B2O2
destroy B2C
destroy CC2
destroy OC
destroy U
destroy V
destroy Tr
;
;
:som_pard
5
0
-1
; 1 : theta0, 2 : phi0, 3 : rot
c0=cos(#1)
s0=sin(#1)
sp0=sin(#2)
cp0=cos(#2)
cr=cos(#3)
sr=sin(#3)
coord A #4*c0*cp0 #4*s0*cp0
coord B #4*(-s0*cr+sp0*c0*sr) #4*(c0*cr+sp0*s0*sr)
coord C #4*(s0*sr+sp0*c0*cr) #4*(-c0*sr+sp0*s0*cr)
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws the curve with parametric coordinates
;        x(t) = t(1-t)  ,  y(t) = sin(pi*t^2)
;    and tangent lines to it.
;    Usage :
;        ex7 n
;    where n is the number of tangent lines
;---------------------------------------------------------------------------
:ex7
2
0
-1
xrange xr 1 1000
fix_xrange xr 0 0.001
function xx xr
function yy xr
fill_func xx x*(1-x)
fill_func yy sin(pi*x*x)
defframe f
frame f -0.2 0.5 -0.5 1.5 0.2 0.2
setframe X f
setcolor X black
title X f Tangents to a curve
setcolor X red
polyg p 10
polyg_funct p xx yy
draw p X f
polyg_curv p p 1035
length_pol p
dt=length_pol/#1
line L
setcolor X blue
do i 1 #1
x=i*dt
tangent_p p x L
draw L X f
enddo
destroy xr
destroy f
destroy p
destroy L
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws the curve with parametric coordinates
;        x(t) = t(1-t)  ,  y(t) = sin(pi*t^2)
;    and tangent vectors to it.
;    Usage :
;        ex7b n
;    where n is the number of tangent vectors
;---------------------------------------------------------------------------
:ex7b
2
0
-1
xrange xr 1 1000
fix_xrange xr 0 0.001
function xx xr
function yy xr
fill_func xx x*(1-x)
fill_func yy 0.25*sin(pi*x*x)
defframe f
frame f -0.3 0.5 -0.25 0.5. 0.1 0.1
setframe X f
setcolor X black
title X f Tangent vectors to a curve
setcolor X red
polyg p 10
polyg_funct p xx yy
draw p X f
polyg_curv p p 1035
length_pol p
dt=length_pol/#1
line L
vector v
point A
setcolor X green
do i 1 #1
x=i*dt
tangent_p p x L
vector_l L v
multiply v 0.25 v
point_pol p x A
draw A X f
draw v X f
enddo
destroy xr
destroy f
destroy p
destroy L
destroy v
destroy A
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws the curve with parametric coordinates
;        x(t) = t(1-t)  ,  y(t) = sin(pi*t^2)
;     computes its curvilinear parametrization and the curve of 
;    acceleration vectors.
;    Usage :
;        ex7c n
;    where n is the number of points of the curve where the acceleration
;    vectors are computed.
;---------------------------------------------------------------------------
:ex7c
2
0
-1
xrange xr 1 5000
fix_xrange xr 0 0.0002
function xx xr
function yy xr
fill_func xx x*(1-x)
fill_func yy 0.25*sin(pi*x*x)
defframe f
frame f -0.05 0.3 -0.1 0.3. 0.1 0.1
setframe X f
setcolor X black
title X f In green : acceleration vectors of the blue curve
setcolor X red
polyg p 10
polyg_funct p xx yy
draw p X f
polyg q 10
polyg_curv p q 2000
setcolor X blue
length_pol q
draw q X f
dt=length_pol/#1
line L
vector v
point A
point B
point B0
setcolor X green
do i 1 #1-1
x=i*dt
accel_p q x v A
multiply v 0.01 v
;point_pol q x A
;draw A X f
;draw v X f
point_v A v B
draw_to B X f
enddo
destroy xr
destroy f
destroy A
destroy B0
destroy B
destroy p
destroy q
destroy L
destroy v
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws the "cardioid", i.e. the curve with parametric
;    coordinates
;        x(t) = (1+cos(t))cos(t) , y(t) = (1+cos(t))sin(t) 
;    and its evolute.
;---------------------------------------------------------------------------
;  Cardioid
:evolx2
1
0
-1
xrange xr 1 4000
fix_xrange xr 0 pi/1900
function xx xr
function yy xr
fill_func xx (1+cos(x))*cos(x)
fill_func yy (1+cos(x))*sin(x)
defframe f
frame f -0.5 2.5 -1.5 1.5 0.5 0.5
setframe X f
setcolor X black
title X f The cardioid in red and its evolute in blue
setcolor X red
polyg p 10
polyg_funct p xx yy
polyg q 10
polyg_curv p q 2000
draw q X f
polyg r 10
setcolor X blue
evol q r
draw r X f 0 1900
destroy xr
destroy f
destroy p
destroy q
destroy r
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws the "epycycloid", i.e. the curve with parametric
;    coordinates
;        x(t) = cos(t) - 3cos(7t/3)/7 , y(t) = sin(t) - 3sin(7t/3)/7
;    and its evolute.
;---------------------------------------------------------------------------
;  Epicycloid
:evolx3
1
0
-1
xrange xr 1 8000
fix_xrange xr 0 pi/600
function xx xr
function yy xr
fill_func xx cos(x)-3*cos(7*x/3)/7
fill_func yy sin(x)-3*sin(7*x/3)/7
defframe f
frame f -1.5 1.5 -1.5 1.5 0.5 0.5
setframe X f
setcolor X black
title X f An epicycloid in red and its evolute in blue
setcolor X red
polyg p 10
polyg_funct p xx yy
polyg q 10
polyg_curv p q 2000
draw q X f
polyg r 10
setcolor X blue
evol q r
draw r X f 10 900
destroy xr
destroy f
destroy p
destroy q
destroy r
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws the "trifolium", i.e. the curve with parametric
;    coordinates
;        x(t) = cos(t)^2(4sin(t)^2 - 1) , 
;        y(t) = sin(t)cos(t)(4sin(t)^2 - 1)
;    and its evolute.
;---------------------------------------------------------------------------
;  Trifolium
:evolx4
1
0
-1
xrange xr 1 8000
fix_xrange xr 0 pi/3800
function xx xr
function yy xr
fill_func xx cos(x)*cos(x)*(4*sin(x)*sin(x)-1)
fill_func yy sin(x)*cos(x)*(4*sin(x)*sin(x)-1)
defframe f
frame f -1.5 1.5 -1.5 1.5 0.5 0.5
setframe X f
setcolor X black
title X f The trifolium in red and its evolute in blue
setcolor X red
polyg p 10
polyg_funct p xx yy
polyg q 10
polyg_curv p q 2000
draw q X f
polyg r 10
setcolor X blue
evol q r
draw r X f
destroy xr
destroy f
destroy p
destroy q
destroy r
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws the "nephroid", i.e. the curve with parametric
;    coordinates
;        x(t) = 3cos(t) - cos(3t) , y(t) = 3sin(t) - sin(3t)
;    and its evolute.
;---------------------------------------------------------------------------
;  Nephroid
:evolx5
1
0
-1
xrange xr 1 8000
fix_xrange xr 0 pi/3800
function xx xr
function yy xr
fill_func xx 3*cos(x)-cos(3*x)
fill_func yy 3*sin(x)-sin(3*x)
defframe f
frame f -5 5 -5 5 2 2
setframe X f
setcolor X black
title X f The nephroid in red and its evolute in blue
setcolor X red
polyg p 10
polyg_funct p xx yy
polyg q 10
polyg_curv p q 2000
draw q X f
polyg r 10
setcolor X blue
evol q r
draw r X f
destroy xr
destroy f
destroy p
destroy q
destroy r
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws the "rhodonea curve", i.e. the curve with parametric
;    coordinates
;        x(t) = cos(t)*sin(5t) , y(t) = sin(t)*sin(5t)
;    and its evolute.
;---------------------------------------------------------------------------
;  Rhodonea Curve
:evolx6
1
0
-1
xrange xr 1 8000
fix_xrange xr 0 pi/3800
function xx xr
function yy xr
fill_func xx cos(x)*sin(5*x)
fill_func yy sin(x)*sin(5*x)
defframe f
frame f -2.5 2.5 -2.5 2.5 1 1
setframe X f
setcolor X black
title X f The rhodonea curve in red and its evolute in blue
setcolor X red
polyg p 10
polyg_funct p xx yy
polyg q 10
polyg_curv p q 2000
draw q X f
polyg r 10
setcolor X blue
evol q r
draw r X f
destroy xr
destroy f
destroy p
destroy q
destroy r
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws the "tricuspoid", i.e. the curve with parametric
;    coordinates
;        x(t) = 2cos(t) + cos(2t) , y(t) = 2sin(t) - sin(2t)
;    and its evolute.
;---------------------------------------------------------------------------
;  Tricuspoid
:evolx7
1
0
-1
xrange xr 1 8000
fix_xrange xr 0 pi/3800
function xx xr
function yy xr
fill_func xx 2*cos(x)+cos(2*x)
fill_func yy 2*sin(x)-sin(2*x)
defframe f
frame f -9 9 -9 9 2.5 2.5
setframe X f
setcolor X black
title X f The tricuspoid in red and its evolute in blue
setcolor X red
polyg p 10
polyg_funct p xx yy
polyg q 10
polyg_curv p q 2000
draw q X f
polyg r 10
setcolor X blue
evol q r
draw r X f
destroy xr
destroy f
destroy p
destroy q
destroy r
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program computes a geometric locus associated to a triangle
;    (see the tutorial)
;---------------------------------------------------------------------------
; ex9 0.85
:ex9
2
0
-1
point A
coord A 0 0
point B
coord B 1 0
point C
coord C #1 0.8660254037844386
line AB
span_l AB A B
line BC
span_l BC B C
line AC
span_l AC A C
defframe f
frame f -0.1 1.5 -0.1 1.5 0.5 0.5
setframe X f
setcolor X black
title X f A triangle and a geometric locus associated to it
draw A X f
putstring X f -SO A
draw B X f
putstring X f -SE B
draw C X f
putstring X f -N C
setcolor X red
draw B X f
draw_to C X f
draw_to A X f
draw_to B X f
point AT
point BT
point CT
point XT
vector ct
vector xt
vector bt
vector V
vector W
vector X
setcolor X blue
do i -1250 650 4
t=i/100
bary2 A B t AT
bary2 B C t BT
bary2 C A t CT
dist AT BT
ct=dist_p
dist CT BT
at=dist_p
dist AT CT
bt=dist_p
vector_p AT BT ct
vector_p AT CT bt
multiply ct bt/(at+bt+ct) V
multiply bt ct/(at+bt+ct) W
add V W X
point_v AT X XT
if> i+1250 XXX
draw XT X f
XXX:
draw_to XT X f
enddo
destroy A
destroy B
destroy C
destroy AB
destroy BC
destroy AC
destroy AT
destroy BT
destroy CT
destroy XT
destroy ct
destroy xt
destroy bt
destroy V
destroy W
destroy X
destroy f
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;     This program computes the same geometric locus as ex9, but
;     zoom an interesting part of this locus
;---------------------------------------------------------------------------
:ex10
1
0
-1
point A
coord A 0 0
point B
coord B 1 0
point C
coord C 1.5 0.9
line AB
span_l AB A B
line BC
span_l BC B C
line AC
span_l AC A C
defframe f
frame f 0.6 1. 0.1 0.5 0.1 0.1
setframe X f
setcolor X red
draw B X f
draw_to C X f
draw_to A X f
draw_to B X f
point AT
point BT
point CT
point XT
vector ct
vector xt
vector bt
vector V
vector W
vector X
setcolor X blue
dist A B
ct=dist_p
dist C B
at=dist_p
dist A C
bt=dist_p
vector_p A B ct
vector_p A C bt
multiply ct bt/(at+bt+ct) V
multiply bt ct/(at+bt+ct) W
add V W X
point_v A X XT
draw XT X f
do i -400 600 
t=i/400
bary2 A B t AT
bary2 B C t BT
bary2 C A t CT
dist AT BT
ct=dist_p
dist CT BT
at=dist_p
dist AT CT
bt=dist_p
vector_p AT BT ct
vector_p AT CT bt
multiply ct bt/(at+bt+ct) V
multiply bt ct/(at+bt+ct) W
add V W X
point_v AT X XT
if> i+400 XXX
draw XT X f
XXX:
draw_to XT X f
enddo
destroy A
destroy B
destroy C
destroy AB
destroy BC
destroy AC
destroy AT
destroy BT
destroy CT
destroy XT
destroy ct
destroy xt
destroy bt
destroy V
destroy W
destroy X
destroy f
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws a triangle, its interior and exterior bissectrices,
;    and the 4 circles tangent to the sides of the triangle.
;---------------------------------------------------------------------------
:ex12
1
0
-1
point P
point Q
point R
point O1
point O2
point O3
point O4
line L
line L1
line L2
line L3
line invL1
line invL2
line invL3
coord P 0 0   
coord Q 1 0
coord R 0.7 1.2
defframe f
frame f -1 2 -1 2 3 3
setframe X f noax
setcolor X black
title X f The 4 circles tangent to the 3 sides of a triangle
span_l L1 P Q            
span_l L3 R P
span_l L2 Q R
inverse L1 invL1
inverse L2 invL2
inverse L3 invL3
setcolor X red
draw L1 X f
draw L2 X f
draw L3 X f
circle C
span_c C L1 L2 L3
show C
coord O1 center_x center_y
setcolor X blue
draw C X f
span_c C invL1 L2 invL3
show C
coord O2 center_x center_y
draw C X f
span_c C invL3 L1 invL2
show C
coord O3 center_x center_y
draw C X f
span_c C invL2 L3 invL1
show C
coord O4 center_x center_y
draw C X f
setcolor X green
span_l L O1 O2
draw L X f
span_l L O1 O3
draw L X f
span_l L O1 O4
draw L X f
span_l L O2 O3
draw L X f
span_l L O2 O4
draw L X f
span_l L O3 O4
draw L X f
destroy P
destroy Q
destroy R
destroy O1
destroy O2
destroy O3
destroy O4
destroy L
destroy L1
destroy L2
destroy L3
destroy C
destroy invL1
destroy invL2
destroy invL3
destroy f
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program defines a triangle, computes its interior and exterior
;    bissectrices and the 4 circles tangent to the sides of the triangle,
;    and draws the images of this objects by the following plane transform :
;        (x,y) |------> (x+sin(xy)/3 , y-cos(x+y)/3)  .
;---------------------------------------------------------------------------
:ex12b
1
0
-1
transform_gen T x+sin(x*y)/3 y-cos(x+y)/3
polyg s 400
point P
point Q
point R
point O1
point O2
point O3
point O4
line L
line L1
line L2
line L3
line invL1
line invL2
line invL3
coord P 0 0   
coord Q 1 0
coord R 0.7 1.2
defframe f
frame f -1.5 2.5 -1.5 2.5 4 4
setframe X f noax
setcolor X black
title X f Transformation of the 4 circles tangent to the 3 sides of a triangle
span_l L1 P Q            
span_l L3 R P
span_l L2 Q R
inverse L1 invL1
inverse L2 invL2
inverse L3 invL3
setcolor X red
act T L1 s -4 4
draw s X f
act T L2 s -4 4
draw s X f
act T L3 s -4 4
draw s X f
circle C
span_c C L1 L2 L3
show C
coord O1 center_x center_y
setcolor X blue
act T C s
draw s X f
span_c C invL1 L2 invL3
show C
coord O2 center_x center_y
act T C s
draw s X f
span_c C invL3 L1 invL2
show C
coord O3 center_x center_y
act T C s
draw s X f
span_c C invL2 L3 invL1
show C
coord O4 center_x center_y
act T C s
draw s X f
setcolor X green
span_l L O1 O2
act T L s -4 4
draw s X f
span_l L O1 O3
act T L s -4 4
draw s X f
span_l L O1 O4
act T L s -4 4
draw s X f
span_l L O2 O3
act T L s -4 4
draw s X f
span_l L O2 O4
act T L s -4 4
draw s X f
span_l L O3 O4
act T L s -4 4
draw s X f
destroy P
destroy Q
destroy R
destroy O1
destroy O2
destroy O3
destroy O4
destroy L
destroy L1
destroy L2
destroy L3
destroy C
destroy invL1
destroy invL2
destroy invL3
destroy f
destroy s
destroy T
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    Program used to test string printing on X windows
;---------------------------------------------------------------------------
:ex15
1
0
-1
defframe f
frame f 0 1 0 1 0.5 0.5
setframe X f
point A
point B
point C
setcolor X red
coord A 0.2 0.8
coord B 0.9 0.1
coord C 0.1 0.25
draw A X f
draw_to B X f
draw_to C X f
draw_to A X f
setcolor X black
putstring X f -O A
putstring X f -E A
putstring X f -N A
putstring X f -S A
putstring X f -SE A
putstring X f -SO A
putstring X f -NE A
putstring X f -NO A
point D
coord D 0.2 0.45
draw D X f
setcolor X blue
putstring X f How to put strings !!!
setcolor X black
draw B X f
putstring X f -E B
draw C X f     
putstring X f -O C
destroy A
destroy B
destroy C
destroy D
destroy f
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    Program used to test string printing on graphic files
;---------------------------------------------------------------------------
:ex15b
1
0
-1
defframe f
frame f 0 1 0 1 0.5 0.5
defgraph ps Dps xx.ps portrait
setframe Dps f
point A
point B
point C
setcolor Dps red
coord A 0.2 0.8
coord B 0.9 0.1
coord C 0.1 0.25
draw A Dps f
draw_to B Dps f
draw_to C Dps f
draw_to A Dps f
setcolor Dps black
putstring Dps f -O A
putstring Dps f -E A
putstring Dps f -N A
putstring Dps f -S A
putstring Dps f -SE A
putstring Dps f -SO A
putstring Dps f -NE A
putstring Dps f -NO A
point D
coord D 0.2 0.45
draw D Dps f
setcolor Dps blue
putstring Dps f How to put strings !!!
setcolor Dps black
draw B Dps f
putstring Dps f -E B
draw C Dps f     
putstring Dps f -O C
destroy Dps
;
defgraph png Dpng xx.png 800 600
setframe Dpng f
setcolor Dpng red
draw A Dpng f
draw_to B Dpng f
draw_to C Dpng f
draw_to A Dpng f
setcolor Dpng black
putstring Dpng f -O A
putstring Dpng f -E A
putstring Dpng f -N A
putstring Dpng f -S A
putstring Dpng f -SE A
putstring Dpng f -SO A
putstring Dpng f -NE A
putstring Dpng f -NO A
draw D Dpng f
setcolor Dpng blue
putstring Dpng f How to put strings !!!
draw B Dpng f
setcolor Dpng black
putstring Dpng f -E B
draw C Dpng f     
putstring Dpng f -O C
destroy Dpng
destroy A
destroy B
destroy C
destroy D
destroy f
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------    
;    This program defines and draws a circle with two fixed points on it. 
;    A third point is moving on the circle and defines a triangle with the 
;    two fixed points. It computes then and draws the locus of the 
;    intersections of the medians and the locus of the intersections of the 
;    bissectrices.
;---------------------------------------------------------------------------
:ex16
1
0
-1
defframe f
frame f 0 1 0 1 1 1
setframe X f noax
setcolor X black
title X f Two geometric locus associated to a moving triangle (I)
circle C00
point O
coord O 0.5 0.5
coord C00 O 0.45
point A
point B
point C
point P
point P1
line BA
line AB
line BC
line AC
line lA
line lB
line lC
line lA1
line lB1
line lC1
point A0
point B0
point C0
point A1
point B1
point C1
polyg Pol 361
polyg Pol2 361
ang1=-20
ang2=210
da=pi/180
coord A 0.5+0.45*cos(ang1*da) 0.5+0.45*sin(ang1*da)
coord B 0.5+0.45*cos(ang2*da) 0.5+0.45*sin(ang2*da)
span_l AB A B
span_l BA B A
j=-1
;
do i ang1+1 ang1+361
ang=i*da
j=j+1
coord C 0.5+0.45*cos(ang) 0.5+0.45*sin(ang)
span_l BC B C
span_l AC A C
bissec AB AC lA
bissec BA BC lB
bissec AC BC lC
inters BC lA A0
inters AB lC C0
inters AC lB B0
inters lA lB P
middle A B C1
middle B C A1
middle A C B1
span_l lA1 A A1
span_l lB1 B B1
span_l lC1 C C1
inters lA1 lB1 P1
show P
coord Pol j point_x point_y
show P1
coord Pol2 j point_x point_y
draw C00 X f
setcolor X red
draw A X f
draw_to B X f
draw_to C X f
draw_to A X f
setcolor X violet
draw C X f
draw_to C0 X f
draw A X f
draw_to A0 X f
draw B X f
draw_to B0 X f
setcolor X blue
draw C X f
draw_to C1 X f
draw A X f
draw_to A1 X f
draw B X f
draw_to B1 X f
;
sleep 10
setcolor X white
draw A X f
draw_to B X f
draw_to C X f
draw_to A X f
draw C X f
draw_to C0 X f
draw A X f
draw_to A0 X f
draw B X f
draw_to B0 X f
draw C X f
draw_to C1 X f
draw A X f
draw_to A1 X f
draw B X f
draw_to B1 X f
;
setcolor X green
draw Pol X f 0 j
setcolor X blue
draw Pol2 X f 0 j
setcolor X black
enddo
draw C00 X f
destroy f
destroy O
destroy A
destroy B
destroy C
destroy P
destroy P1
destroy A0
destroy B0
destroy C0
destroy A1
destroy B1
destroy C1
destroy BA
destroy AB
destroy BC
destroy AC
destroy lA
destroy lB
destroy lC
destroy lA1
destroy lB1
destroy lC1
destroy C00
destroy Pol
destroy Pol2
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This computes the "middle curve" of two Lissajou curves. if 
;    (x1(t),y1(t)) , (x2(t),y2(t)) are curvilinear parametrizations
;    of the two curves, the middle curve has the following parametrization
;        x(t) = x1(t) + x2(t)  ,   y(t) = y1(t) + y2(t)  .
;    In general it will not have a finite length.
;    Usage :
;        ex17 n a b c d
;    where a,b,c,d are the parameters of the two Lissajou curves, and n
;    the number of times the two curves are covered
;---------------------------------------------------------------------------
; ex17 80 6 7 16 17 
:ex17
6
0
-1
n=1800*#1
xrange xr 1 n
fix_xrange xr 0 pi/900
function xx xr
function yy xr
function xx1 xr
function yy1 xr
a=#2
b=#3
a1=#4
b1=#5
fill_func xx sin(a*x)
fill_func yy sin(b*x)
fill_func xx1 sin(a1*x)
fill_func yy1 sin(b1*x)
polyg P 10
polyg P1 10
polyg p 10
polyg p1 10
polyg_funct P xx yy
polyg_funct P1 xx1 yy1
polyg_curv P p n
polyg_curv P1 p1 n
point A
point A1
point B
length_pol p
a=length_pol
length_pol p1
tmax=length_pol
if>a-tmax xxx
tmax=a
xxx:
dt=tmax/n
defframe f
frame f -1.1 1.1 -1.1 1.1 2 2
setframe X f noax
setcolor X black
title X f The middle curve of two Lissajou curves
setcolor X violet
point_pol p 0 A
point_pol p1 0 A1
middle A A1 B
draw B X f
subex17
setcolor X blue
draw p X f 0 1800
setcolor X black
draw p1 X f 0 1800
destroy A
destroy A1
destroy B
destroy P
destroy P1
destroy p
destroy p1
destroy xr
destroy f
;
;
:subex17
1
0
-1
do i 0 n-1
t=i*dt
point_pol p t A
point_pol p1 t A1
middle A A1 B
draw_to B X f
enddo
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program defines and draws a circle with two fixed tangent lines.
;    A third tangent line is moving on the circle and the three lines define
;    a moving triangle whose sides are tangent to the circle. The program 
;    computes and draws the locus of intersections of medians and the 
;    locus of intersections of mediatrices.
;---------------------------------------------------------------------------
:ex18
1
0
-1
point A
point O
point O1
point O2
point A1
point A2
point P
point P1
point Q1
point Q
point M
vector U
line l
line lp
line lq
line ort
line ort2
line med1
line med2
polyg Pol 362
polyg Pol2 362
circle C
circle C2
coord O 0 0
coord C O 0.5
d=-3
coord A -2 0
dist A O
d2=sqrt(dist_p*dist_p-0.25)
coord C2 A d2
inters_cc C C2 P Q
span_l lp P A
span_l lq Q A
defframe f
frame f -2.2 1.2 -1.7 1.7 5 5
setframe X f noax
setcolor X black
title X f Two geometric locus associated to a moving triangle (II)
dt=pi/180
subex18
destroy f
destroy A
destroy A1
destroy A2
destroy O
destroy O1
destroy O2
destroy P
destroy P1
destroy Q
destroy Q1
destroy M
destroy U
destroy l
destroy lp
destroy lq
destroy ort
destroy ort2
destroy med1
destroy med2
destroy C
destroy C2
destroy Pol
destroy Pol2
;
;
:subex18
1
0
-1
j=-1
do i 0 361
j=j+1
a=i*dt
coord M 0.5*cos(a) 0.5*sin(a)
coord U -sin(a) cos(a)
coord l M U
inters l lp P
setcolor X blue
draw l X f
draw lp X f
draw lq X f
trace 1
b=retval-1
if= b XXX
inters l lp P1
inters l lq Q1
b=1-retval
if= b XXX
trace 0
XXX:
middle A P1 A1
middle A Q1 A2
ortholine lp A1 ort
ortholine lq A2 ort2
setcolor X red
draw ort X f
draw ort2 X f
span_l med1 Q1 A1
span_l med2 P1 A2
setcolor X orange
draw med1 X f
draw med2 X f
inters med1 med2 O1
inters ort ort2 O2
show O1
coord Pol j point_x point_y
show O2
coord Pol2 j point_x point_y
sleep 20
setcolor X white
draw l X f
draw ort X f
draw ort2 X f
draw med1 X f
draw med2 X f
setcolor X green
draw Pol X f 0 j
setcolor X violet
draw Pol2 X f 0 j
setcolor X black
draw C X f
setcolor X blue
draw lp X f
draw lq X f
setframe X f noax
enddo
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    Demo
;---------------------------------------------------------------------------
:all_geom
1
0
-1
; 1
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo In this program we draw a triangle with its altitudes\n
ex0
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo In this program we draw a Lissajou curve and another curve "around" it\n
echo \n
; 2
ex1 5 6 800
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo In this program we draw a moving triangle with medians, altitudes\n
echo and bissetrices
echo \n
; 3
ex5b 1
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo In this program we draw a hypocycloid\n
echo \n
; 4
ex4 12 17
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo In this program we draw another hypocycloid\n
echo \n
; 5
ex4 17 5
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This programs defines two Lissajou curves with parametric coordinates\n
echo x1(t)=cos(3t) , y1(t)=sin(4t) ,\n
echo x2(t)=cos(7t) , y2(t)=sin(8t) ,\n
echo respectively, and will draw sucessively 200 curves defined by the \n
echo equations\n
echo x(t)=u.x1(t)+(1-u).x2(t), y(t)=u.y1(t)+(1-u).y2(t) ,\n
echo with 0 <= u <= 1 .\n
echo \n
; 6
ex1c 3 4 7 8 200
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program draws a moving cube\n
echo \n
; 7
ex6d 2123
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program draws a curve with 100 tangent lines on it\n
echo \n
; 8
ex7 100
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
; 9
echo This program draws a curve with 100 tangent vectors on it\n
echo \n
ex7b 100
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program draws a curve and the curve of extremities of accelerations\n
echo vectors \n
; 10
echo \n
ex7c 1000
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
; 11
echo this program draws the cardioid curve and its evolute\n
echo \n
evolx2
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
; 12
echo this program draws the epycycloid curve and its evolute\n
echo \n
evolx3
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo this program draws the trifolium curve and its evolute\n
; 13
echo \n
evolx4
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
; 14
echo this program draws the nephroid curve and its evolute\n
echo \n
evolx5
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
; 15
echo this program draws the rhodonea curve and its evolute\n
echo \n
evolx6
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
; 16
echo this program draws the tricuspoid curve and its evolute\n
echo \n
evolx7
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program draws a triangle and a complicated geometric locus\n
echo associated to it (see the tutorial to have a description of this locus)\n
echo \n
; 17
ex9 0.85
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program draws a circle with two fixed point on it. A third point\n 
echo is moving on the circle. The program draws the geometric locus of\n
echo intersections of medians (in blue) and the geometric locus of intersections\n
echo of interior bissectrices (in green)\n
echo \n
; 18
ex16
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program draws a circle with a fixed point on it. A second point is\n
echo moving. For each value of the second point, a third point is moving and\n
echo the geometric locus of intersections of medians is drawn (it is the\n
echo moving red circle).\n
echo When the second point is moving the geometric locus of centers of the red\n
echo circles is the blue circle\n
echo \n
; 19
ex16b
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program defines and draws a circle with two fixed points on it.\n 
echo A third point is moving on the circle and defines a triangle with the \n
echo two fixed points. It computes then and draws the locus of the\n 
echo intersections of the interior and exterior bissectrices (the green\n
echo circles).\n
echo \n
; 20
ex16c 210
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program defines and draws a circle with two fixed tangent lines.\n
echo A third tangent line is moving on the circle and the three lines define\n
echo a moving triangle whose sides are tangent to the circle. The program \n
echo computes and draws the locus of intersections of medians (the green\n
echo curve) and the locus of intersections of mediatrices (the violine one).\n
echo \n
; 21
ex18
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program computes and draws 40 sucessive images\n
echo T(C) , T^2(C), T^3(C)\n
echo of the unit circle C by the plane transform T\n
echo (x,y) |------> (x + sin(17y)/40 , y + cos(17x)/40)\n
echo \n
; 22
trans3c 17 40 40
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program computes, draws and erases 40 sucessive images\n
echo T(C) , T^2(C), T^3(C)\n
echo of the unit circle C by the plane transform T\n
echo (x,y) |------> (x + sin(17y)/40 , y + cos(17x)/40)\n
echo \n
; 23
trans3d 17 40 40
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program computes, draws and erases 40 sucessive images\n
echo T(C) , T^2(C), T^3(C)\n
echo of the unit circle C by the plane transform T\n
echo (x,y) |------> (x + sin(7y)/14 , y + cos(7x)/14)\n
echo \n
; 24
trans3d 7 14 40
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program draws a moving isocahedron. \n
echo \n
; 25
ex22 1422
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program draws a moving isocahedron, without drawing the hidden faces.\n 
echo \n
; 26
ex22b 1422
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo ------------------------------------------------------------------------\n
color_echo black
echo This program draws a moving isocahedron, with a dodecahedron inside it.\n
echo \n
; 27
ex23 1422
echo \n
echo \n
echo \n
echo \n
color_echo green
echo next\n
waitkey
clear X
color_echo red
echo \n
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    (definition of functions from polygons, in progress ....)
;---------------------------------------------------------------------------
:funct_PP
1
1
-1
xrange xr 1 1201
fix_xrange xr 0 pi/600
function f xr
function g xr
fill_func f sin(3*x)*cos(x)
fill_func g sin(3*x)*sin(x)
polyg p 10
polyg_funct p f g
defframe F
frame F -1 1 -1 1 0.2 0.2 2 2
setframe X F
setcolor X red
draw p X F
funct_pol p f1 f2 x1
destroy xr
destroy x1
destroy F
destroy p
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program computes and draws the image by the plane transform
;        (x,y) |------> (x^2/3 + y - x/2 , (y^2/2 + x + y)/2)
;    of concentric circles around the origin.
;---------------------------------------------------------------------------
:trans1
1
0
-1
transform_gen T x*x/3+y-x/2 (y*y/2+x+y)/2
circle C
point O
polyg P 100
defframe F
frame F -2 2 -2 2 1 1
setframe X F
setcolor X red
do i 1 100
coord C O i*0.05
act T C P
draw P X F
enddo
destroy P
destroy F
destroy C
destroy T
destroy O
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program computes and draws the image by the plane transform
;        (x,y) |------> (x.cos(x) + y , y.sin(x) - x)
;    of concentric circles around the origin.
;---------------------------------------------------------------------------
:trans2
1
0
-1
transform_gen T cos(x)*x+y sin(x)*y-x
circle C
point O
polyg P 400
defframe F
frame F -3 3 -3 3 1 1
setframe X F
setcolor X red
do i 1 100
coord C O i*0.05
act T C P
draw P X F
enddo
destroy P
destroy F
destroy C
destroy T
destroy O
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program computes and draws 100 sucessive images
;        T(C) , T^2(C), T^3(C)
;    of the unit circle C by the plane transform T
;        (x,y) |------> (x + sin(4y)/5 , y + cos(4x)/5)
;---------------------------------------------------------------------------
:trans3
1
0
-1
transform_gen T x+sin(4*y)/5 y+cos(4*x)/5
transform_gen T0 x y
circle C
point O
polyg P 400
act T0 C P
defframe F
frame F -3 3 -3 3 1 1
setframe X F
setcolor X red
do i 1 100 
act T P P
draw P X F
enddo
destroy P
destroy F
destroy C
destroy T
destroy T0
destroy O
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program computes and draws 100 sucessive images
;        T(C) , T^2(C), T^3(C)
;    of the unit circle C by the plane transform T
;        (x,y) |------> (x + sin(ay)/5 , y + cos(ax)/5)
;    Usage :
;        trans3b a
;    where a is the parameter a in the transform.
;---------------------------------------------------------------------------
:trans3b
2
0
-1
transform_gen T x+sin(#1*y)/5 y+cos(#1*x)/5
transform_gen T0 x y
circle C
point O
polyg P 400
act T0 C P
defframe F
frame F -3 3 -3 3 1 1
setframe X F
setcolor X red
do i 1 100 
act T P P
draw P X F
enddo
destroy P
destroy F
destroy C
destroy T
destroy T0
destroy O
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program computes and draws sucessive images
;        T(C) , T^2(C), T^3(C)
;    of the unit circle C by the plane transform T
;        (x,y) |------> (x + sin(ay)/b , y + cos(ax)/b)
;    Usage :
;        trans3c a b n
;    where a,b are the parameters a,b in the transform and n the number
;    of successive images.
;---------------------------------------------------------------------------
; trans3c 17 40 40
:trans3c
4
0
-1
transform_gen T x+sin(#1*y)/#2 y+cos(#1*x)/#2
xrange xr 1 10001
fix_xrange xr 0 pi/5000
function X xr
function Y xr
fill_func X cos(x)
fill_func Y sin(x)
polyg P 10000
polyg_funct P X Y
defframe F
frame F -2 2 -2 2 1 1
setframe X F
title X F 100 successive transforms of a circle (all)
setcolor X red
do i 1 #3 
echoi i
act T P P
draw P X F
enddo
echo \n
;win 2
;setcolor X black
;setframe X F
;setcolor X red
;draw P X F
destroy P
destroy F
destroy T
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program computes, draws and erases 100 sucessive images
;        T(C) , T^2(C), T^3(C)
;    of the unit circle C by the plane transform T
;        (x,y) |------> (x + sin(ay)/b , y + cos(ax)/b)
;    Usage :
;        trans3d a b
;    where a,b are the parameters a,b in the transform.
;---------------------------------------------------------------------------
; trans3d 17 40 40
:trans3d
4
0
-1
transform_gen T x+sin(#1*y)/#2 y+cos(#1*x)/#2
xrange xr 1 10001
fix_xrange xr 0 pi/5000
function X xr
function Y xr
fill_func X cos(x)
fill_func Y sin(x)
polyg P 10000
polyg_funct P X Y
defframe F
if> #1-4 XXX
frame F -4 4 -4 4 2 2
goto YYY
XXX:
frame F -2 2 -2 2 1 1
YYY:
setframe X F
title X F 100 successive transforms of a circle 
do i 1 #3
echoi i 
setcolor X red
act T P P
draw P X F
sleep 10
setcolor X white
draw P X F
setcolor X black
setframe X F
enddo
echo \n
setcolor X red
draw P X F
destroy P
destroy F
destroy T
destroy xr
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program computes and draws the transforms of 100 parallel lines
;    by the plane transform T
;        (x,y) |------> (x + sin(ay)/b , y + cos(ax)/b)
;    Usage :
;        trans4 a b
;    where a,b are the parameters a,b in the transform.
;---------------------------------------------------------------------------
:trans4
3
0
-1
transform_gen T x+sin(#1*y)/#2 y+cos(#1*x)/#2
line L
point A
vector U
coord U 1 2
polyg P 400
defframe F
frame F -5 5 -5 5 1 1 2 1
setframe X F
setcolor X red
do i 1 100
coord A i*0.4-20 0
coord L A U
act T L P -6 6
draw P X F
enddo
destroy P
destroy U
destroy F
destroy T
destroy L
destroy A
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program computes and draws the transforms of 100 parallel lines
;    by the plane transform T
;        (x,y) |------> (cos(x.log(y^2+1))/2 + x.(2 + sin(x))/2 + y ,
;                        sin(x-y)/2 - y.(2 + cos(y)/2) + 2x)
;---------------------------------------------------------------------------
:trans4b
1
0
-1
transform_gen T cos(x*log(y*y+1))/2+x*(2+sin(x)/2)+y sin(x-y)/2-y*(2+cos(y)/2)+2*x
line L
point A
vector U
coord U 1 2
polyg P 600
defframe F
frame F -20 20 -20 20 4 4 2 1
setframe X F
setcolor X red
do i 1 100
coord A i*0.4-20 0
coord L A U
act T L P -20 20
draw P X F
enddo
destroy P
destroy U
destroy F
destroy T
destroy L
destroy A
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program defines a circle a fixed point on it. Two other points are
;    moving on it. When the second point is fixed and the third is moving
;    the geometric locus of the barycenters of the 3 points is a circle.
;    When the second point is moving the geometric locus of the centers
;    of these circles is again a circle (easy to prove).
;---------------------------------------------------------------------------
:ex16b
1
0
-1
defframe f
frame f 0 1 0 1 1 1
setframe X f noax
setcolor X black
title X f Moving geometric locus associated to a moving triangle
circle C00
point O
coord O 0.5 0.5
coord C00 O 0.45
point A
point B
point C
point P1
polyg Pol 123
polyg Pol2 120
ang1=0
da=pi/180
draw C00 X f
k=-1
;
;
do ang2 1 367 3
k=k+1
if< ang2-1 XXX
setcolor X red
draw Pol2 X f
setcolor X black
draw C00 X f
XXX:
setcolor X white
sleep 10
draw Pol2 X f
echoi ang2
coord A 0.5+0.45*cos(ang1*da) 0.5+0.45*sin(ang1*da)
coord B 0.5+0.45*cos(ang2*da) 0.5+0.45*sin(ang2*da)
j=-1
;
do i ang1+1.5 ang1+361.5 3
ang=i*da
j=j+1
coord C 0.5+0.45*cos(ang) 0.5+0.45*sin(ang)
bary A B C P1
show P1
coord Pol2 j point_x point_y
enddo
;
bary2 Pol2 P1
show P1
coord Pol k point_x point_y
setcolor X red
draw Pol2 X f
setcolor X blue
draw Pol X f 0 k
enddo
setcolor X white
draw Pol2 X f
setcolor X black
draw C00 X f
setcolor X blue
draw Pol X f 0 k
echo \n
destroy f
destroy O
destroy A
destroy B
destroy C
destroy P1
destroy C00
destroy Pol
destroy Pol2
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program defines and draws a circle with two fixed points on it. 
;    A third point is moving on the circle and defines a triangle with the 
;    two fixed points. It computes then and draws the locus of the 
;    intersections of the interior and exterior bissectrices.
;---------------------------------------------------------------------------
:ex16c
2
0
-1
defframe f
frame f -0.6 1.6 -0.48 1.72 5 5
setframe X f noax
setcolor X black
title X f Two geometric locus associated to a moving triangle (Ib)
circle C00
point O
coord O 0.5 0.5
coord C00 O 0.45
point A
point B
point C
point P
point PA
point PB
point PC
line BA
line AB
line BC
line AC
line CA
line lA
line lB
line lC
line lA2
line lB2
line lC2
polyg Pol 361
polyg Pol2 361
polyg Pol3 361
polyg Pol4 361
polyg Polb 361
polyg Pol2b 361
polyg Pol3b 361
polyg Pol4b 361
ang1=-20
ang2=#1
da=pi/180
coord A 0.5+0.45*cos(ang1*da) 0.5+0.45*sin(ang1*da)
coord B 0.5+0.45*cos(ang2*da) 0.5+0.45*sin(ang2*da)
span_l AB A B
span_l BA B A
j=-1
;
do i ang1+1 ang2-1
ang=i*da
j=j+1
j0=j
coord C 0.5+0.45*cos(ang) 0.5+0.45*sin(ang)
span_l BC B C
span_l AC A C
span_l CA C A
bissec AB AC lA
bissec BA BC lB
bissec AC BC lC
bissec AB BC lB2
bissec AC BA lA2
bissec CA BC lC2
inters lA lB P
inters lC2 lA2 PB
inters lC2 lB2 PA
inters lA2 lB2 PC
show P
coord Pol j point_x point_y
show PA
coord Pol2 j point_x point_y
show PB
coord Pol3 j point_x point_y
show PC
coord Pol4 j point_x point_y
draw C00 X f
setcolor X red
draw A X f
draw_to B X f
draw_to C X f
draw_to A X f
setcolor X blue
draw lA X f
draw lA2 X f
draw lB X f
draw lB2 X f
draw lC X f
draw lC2 X f
;
sleep 10
setcolor X white
draw A X f
draw_to B X f
draw_to C X f
draw_to A X f
draw lA X f
draw lA2 X f
draw lB X f
draw lB2 X f
draw lC X f
draw lC2 X f
;
setcolor X green
draw Pol X f 0 j
draw Pol2 X f 0 j
draw Pol3 X f 0 j
draw Pol4 X f 0 j
setcolor X black
setframe X f noax
enddo
;
j=-1
do i ang2+1 ang1+359
ang=i*da
j=j+1
coord C 0.5+0.45*cos(ang) 0.5+0.45*sin(ang)
span_l BC B C
span_l AC A C
span_l CA C A
bissec AB AC lA
bissec BA BC lB
bissec AC BC lC
bissec AB BC lB2
bissec AC BA lA2
bissec CA BC lC2
inters lA lB P
inters lC2 lA2 PB
inters lC2 lB2 PA
inters lA2 lB2 PC
show P
coord Polb j point_x point_y
show PA
coord Pol2b j point_x point_y
show PB
coord Pol3b j point_x point_y
show PC
coord Pol4b j point_x point_y
draw C00 X f
setcolor X red
draw A X f
draw_to B X f
draw_to C X f
draw_to A X f
setcolor X blue
draw lA X f
draw lA2 X f
draw lB X f
draw lB2 X f
draw lC X f
draw lC2 X f
;
sleep 10
setcolor X white
draw A X f
draw_to B X f
draw_to C X f
draw_to A X f
draw lA X f
draw lA2 X f
draw lB X f
draw lB2 X f
draw lC X f
draw lC2 X f
;
setcolor X green
draw Polb X f 0 j
draw Pol2b X f 0 j
draw Pol3b X f 0 j
draw Pol4b X f 0 j
draw Pol X f 0 j0
draw Pol2 X f 0 j0
draw Pol3 X f 0 j0
draw Pol4 X f 0 j0
setcolor X black
setframe X f noax
enddo
draw C00 X f
destroy f
destroy O
destroy A
destroy B
destroy C
destroy P
destroy PA
destroy PB
destroy PC
destroy BA
destroy AB
destroy BC
destroy AC
destroy CA
destroy lA
destroy lB
destroy lC
destroy lA2
destroy lB2
destroy lC2
destroy C00
destroy Pol
destroy Pol2
destroy Pol3
destroy Pol4
destroy Polb
destroy Pol2b
destroy Pol3b
destroy Pol4b
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    (in progress...)
;---------------------------------------------------------------------------
:ex19b
1
0
-1
defframe f
frame f -2 2 -2 2 5 5
setframe X f noax
setcolor X black
title X f XXX
point A
point B
point C
point AP
point BP
point CP
point O
vector U
vector UT
vector AB
vector AC
vector ACP
line lCCP
line lAAP
line lACP
line lBBP
line lBCP
polyg pa 2000
polyg pa2 2000
polyg pb 2000
polyg pb2 2000
polyg pc 2000
polyg pc2 2000
polyg po 2000
coord A 0 0
coord B 1 0.01
coord C 0.7 0.8
vector_p A B AB
vector_p A C AC
int_prod AB AB
ab2=int_p
dt=pi/1800
j=-1
;
do i 0 1800
echoi i
t=i*dt
;t=135*dt
coord U cos(t) sin(t)
coord UT -sin(t) cos(t)
int_prod U AB
u_ab=int_p
int_prod UT AB
ut_ab=int_p
int_prod U AC
u_ac=int_p
int_prod UT AC
ut_ac=int_p
a1=u_ac*u_ab
if= a1 XXX
a1t=ut_ac*ut_ab
a=-a1
b=a1+a1t-ab2
c=-a1t
delta=b*b-4*a*c
echof delta
if< delta XXX
r=sqrt(delta)
mu1=(-b+r)/a/2
mu2=(-b-r)/a/2
lambda1=u_ac*(1-mu1)
lambda2=u_ac*(1-mu2)
multiply U lambda1 ACP
point_v A ACP CP
span_l lCCP C CP
coord lAAP A UT
inters lAAP lCCP O
span_l lBBP B O
span_l lACP A CP
inters lBBP lACP BP
span_l lBCP B CP
inters lBCP lAAP AP
j=j+1
show AP
coord pa j point_x point_y
show BP
coord pb j point_x point_y
show CP
coord pc j point_x point_y
show O
coord po j point_x point_y
setcolor X red
draw A X f
draw_to B X f
draw_to C X f
draw_to A X f
setcolor X blue
draw AP X f
draw_to BP X f
draw_to CP X f
draw_to AP X f
setcolor X green
draw AP X f
draw_to A X f
draw BP X f
draw_to B X f
draw CP X f
draw_to C X f
sleep 10
setcolor X white
draw AP X f
draw_to BP X f
draw_to CP X f
draw_to AP X f
draw AP X f
draw_to A X f
draw BP X f
draw_to B X f
draw CP X f
draw_to C X f
multiply U lambda2 ACP
point_v A ACP CP
span_l lCCP C CP
coord lAAP A UT
inters lAAP lCCP O
span_l lBBP B O
span_l lACP A CP
inters lBBP lACP BP
span_l lBCP B CP
inters lBCP lAAP AP
show AP
coord pa2 j point_x point_y
show BP
coord pb2 j point_x point_y
show CP
coord pc2 j point_x point_y
setcolor X black
draw pa X f 0 j
draw pb X f 0 j
draw pc X f 0 j
draw pa2 X f 0 j
draw pb2 X f 0 j
draw pc2 X f 0 j
setcolor X red
draw A X f
draw_to B X f
draw_to C X f
draw_to A X f
draw po X f 0 j
setcolor X blue
draw AP X f
draw_to BP X f
draw_to CP X f
draw_to AP X f
setcolor X green
draw AP X f
draw_to A X f
draw BP X f
draw_to B X f
draw CP X f
draw_to C X f
sleep 10
setcolor X white
draw AP X f
draw_to BP X f
draw_to CP X f
draw_to AP X f
draw AP X f
draw_to A X f
draw BP X f
draw_to B X f
draw CP X f
draw_to C X f
XXX:
enddo
setcolor X black
draw pa X f 0 j
draw pb X f 0 j
draw pc X f 0 j
draw pa2 X f 0 j
draw pb2 X f 0 j
draw pc2 X f 0 j
setcolor X red
draw A X f
draw_to B X f
draw_to C X f
draw_to A X f
draw po X f 0 j
destroy A
destroy B
destroy C
destroy AP
destroy BP
destroy CP
destroy O
destroy U
destroy UT
destroy AB
destroy AC
destroy ACP
destroy lCCP
destroy lAAP
destroy lACP
destroy lBBP
destroy lBCP
destroy f
destroy pa
destroy pa2
destroy pb
destroy pb2
destroy pc
destroy pc2
destroy po
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    (in progress...)
;---------------------------------------------------------------------------
;string X cos(x*pi)*cos(x*pi)*(4*sin(x*pi)*sin(x*pi)-1)
;string Y sin(x*pi)*cos(x*pi)*(4*sin(x*pi)*sin(pi*x)-1)
;ex20 $[X] $[Y] 0.9 1.2 1.6 1
;ex20 sin(6.02*pi*x) cos(10.04*pi*x) 0.7 0.3 1.6 1
:ex20
6
0
-1
polyg P0 10
polyg P1 10
polyg res 4401
xrange xr 1 1401
fix_xrange xr -0.2 1/1200
function X xr
function Y xr
fill_func X #1
fill_func Y #2
polyg_funct P0 X Y
polyg_curv P0 P1 1801
length_pol P1
dt=length_pol/4400
t0=0.015*length_pol
point A
coord A #3 #4
point B
line L
defframe f
s=#5
frame f -s s -s s s s
setframe X f noax
setcolor X red
draw P1 X f
setcolor X green
do i 20 4390
t=i*dt
tangent_p P1 t L
orthoproj A L B
show B
coord res i point_x point_y
if< i-22 XXX
draw res X f i-1 i
XXX:
enddo
destroy P0
destroy P1
destroy res
destroy A
destroy B
destroy f
destroy L
destroy xr
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws a moving isocahedron
;    Usage :
;        ex22 n
;    where n is the number of isocahedrons that will be drawn.
;---------------------------------------------------------------------------
:ex22
2
0
-1
defframe f
frame f -1.5 1.5 -1.5 1.5 1.5 3 3
setframe X f noax
setcolor X black
title X f Moving isocahedron
point A
point B
point C
point D
point E
point M
point AP
point BP
point CP
point DP
point EP
point MP
c=cos(pi/5)
s=sin(pi/5)
c2=cos(2*pi/5)
s2=sin(2*pi/5)
s3=sqrt(4*s*s-1)
mx0=0
my0=0
mz0=0.5+s3
mpx0=0
mpy0=0
mpz0=-0.5-s3
ax0=1
ay0=0
az0=0.5
bz0=0.5
cz0=0.5
dz0=0.5
ez0=0.5
rot5 ax0 ay0 bx0 by0
rot5 bx0 by0 cx0 cy0
rot5 cx0 cy0 dx0 dy0
rot5 dx0 dy0 ex0 ey0
apx0=c
apy0=s
apz0=-0.5
bpz0=-0.5
cpz0=-0.5
dpz0=-0.5
epz0=-0.5
rot5 apx0 apy0 bpx0 bpy0
rot5 bpx0 bpy0 cpx0 cpy0
rot5 cpx0 cpy0 dpx0 dpy0
rot5 dpx0 dpy0 epx0 epy0
dt=pi/400
do i 1 #1
t=i*dt
transf1 t 2*t 3*t
x=abs(cos(t/4))
ox=cos(5*t)/2
oy=sin(4*t)/2
transf2 ax0 ay0 az0 ax1 ay1
transf2 bx0 by0 bz0 bx1 by1
transf2 cx0 cy0 cz0 cx1 cy1
transf2 dx0 dy0 dz0 dx1 dy1
transf2 ex0 ey0 ez0 ex1 ey1
transf2 apx0 apy0 apz0 apx1 apy1
transf2 bpx0 bpy0 bpz0 bpx1 bpy1
transf2 cpx0 cpy0 cpz0 cpx1 cpy1
transf2 dpx0 dpy0 dpz0 dpx1 dpy1
transf2 epx0 epy0 epz0 epx1 epy1
transf2 mx0 my0 mz0 mx1 my1
transf2 mpx0 mpy0 mpz0 mpx1 mpy1
coord A ox+ax1 oy+ay1
coord B ox+bx1 oy+by1
coord C ox+cx1 oy+cy1
coord D ox+dx1 oy+dy1
coord E ox+ex1 oy+ey1
coord AP ox+apx1 oy+apy1
coord BP ox+bpx1 oy+bpy1
coord CP ox+cpx1 oy+cpy1
coord DP ox+dpx1 oy+dpy1
coord EP ox+epx1 oy+epy1
coord M ox+mx1 oy+my1
coord MP ox+mpx1 oy+mpy1
setcolor X red
draw_icos
sleep 10
setcolor X white
draw_icos
setcolor X black
setframe X f noax
enddo
setcolor X red
draw_icos
destroy A
destroy B
destroy C
destroy D
destroy E
destroy M
destroy AP
destroy BP
destroy CP
destroy DP
destroy EP
destroy MP
destroy f
;
;
:rot5
5
0
-1
#3=c2*#1-s2*#2
#4=s2*#1+c2*#2
;
;
; complete 3d orthogonal transform
; cos(t)sin(p), sin(t)sin(p), -cos(p)
; sin(a)sin(t)+cos(p)cos(t)cos(a), cos(p)sin(t)cos(a)-sin(a)cos(t), sin(p)cos(a)
; cos(p)cos(t)sin(a)-cos(a)sin(t), cos(a)cos(t)+cos(p)sin(t)sin(a), sin(a)sin(p)
; transf1 t p a
:transf1
4
0
-1
c0=cos(#1)
s0=sin(#1)
cp0=cos(#2)
sp0=sin(#2)
ca=cos(#3)
sa=sin(#3)
a11=c0*sp0
a12=s0*sp0
a13=-cp0
b11=sa*s0+cp0*c0*ca
b12=cp0*s0*ca-sa*c0
b13=ca*sp0
;c11=cp0*c0*sa-ca*s0
;c12=ca*c0+cp0*s0*sa
;c13=sa*sp0
;
;
; transf2 x0 y0 z0 x1 y1
:transf2
6
0
-1
#4=x*(a11*#1+a12*#2+a13*#3)
#5=x*(b11*#1+b12*#2+b13*#3)
;
;
; draws the icosaedron
:draw_icos
1
0
-1
; MA AB BM MC CD DM ME EA (8)
draw M X f
draw_to A X f
draw_to B X f
draw_to M X f
draw_to C X f
draw_to D X f
draw_to M X f
draw_to E X f
draw_to A X f
; BC C.BP BP.B B.AP AP.A (5)
draw B X f
draw_to C X f
draw_to BP X f
draw_to B X f
draw_to AP X f
draw_to A X f
; DE E.DP DP.D D.CP CP.C (5)
draw D X f
draw_to E X f
draw_to DP X f
draw_to D X f
draw_to CP X f
draw_to C X f
; E.EP EP.A (2)
draw E X f
draw_to EP X f
draw_to A X f
; MP.AP AP.BP BP.MP MP.CP CP.BP (5)
draw MP X f
draw_to AP X f
draw_to BP X f
draw_to MP X f
draw_to CP X f
draw_to BP X f
; CP.DP DP.MP (2)
draw CP X f
draw_to DP X f
draw_to MP X f
; MP.EP EP.DP (2)
draw MP X f
draw_to EP X f
draw_to DP X f
; EP.AP (1)
draw EP X f
draw_to AP X f
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws a moving isocahedron, without drawing the hidden
;    faces. 
;    Usage :
;        ex22b n
;    where n is the number of isocahedrons that will be drawn.
;---------------------------------------------------------------------------
:ex22b
2
0
-1
defframe f
frame f -1.5 1.5 -1.5 1.5 3 3
setframe X f noax
setcolor X black
title X f Moving isocahedron
point A
point B
point C
point D
point E
point M
point AP
point BP
point CP
point DP
point EP
point MP
vector MA
vector MB
vector MC
vector MD
vector ME
vector MPAP
vector MPBP
vector MPCP
vector MPDP
vector MPEP
vector AAP
vector BBP
vector CCP
vector DDP
vector EEP
vector AB
vector BC
vector CD
vector DE
vector EA
vector BAP
vector CBP
vector DCP
vector EDP
vector AEP
c=cos(pi/5)
s=sin(pi/5)
c2=cos(2*pi/5)
s2=sin(2*pi/5)
s3=sqrt(4*s*s-1)
mx0=0
my0=0
mz0=0.5+s3
mpx0=0
mpy0=0
mpz0=-0.5-s3
ax0=1
ay0=0
az0=0.5
bz0=0.5
cz0=0.5
dz0=0.5
ez0=0.5
rot5 ax0 ay0 bx0 by0
rot5 bx0 by0 cx0 cy0
rot5 cx0 cy0 dx0 dy0
rot5 dx0 dy0 ex0 ey0
apx0=c
apy0=s
apz0=-0.5
bpz0=-0.5
cpz0=-0.5
dpz0=-0.5
epz0=-0.5
rot5 apx0 apy0 bpx0 bpy0
rot5 bpx0 bpy0 cpx0 cpy0
rot5 cpx0 cpy0 dpx0 dpy0
rot5 dpx0 dpy0 epx0 epy0
dt=pi/400
do i 1 #1
t=i*dt
transf1 t 2*t 3*t
x=abs(cos(t/4))
ox=cos(5*t)/2
oy=sin(4*t)/2
transf2 ax0 ay0 az0 ax1 ay1
transf2 bx0 by0 bz0 bx1 by1
transf2 cx0 cy0 cz0 cx1 cy1
transf2 dx0 dy0 dz0 dx1 dy1
transf2 ex0 ey0 ez0 ex1 ey1
transf2 apx0 apy0 apz0 apx1 apy1
transf2 bpx0 bpy0 bpz0 bpx1 bpy1
transf2 cpx0 cpy0 cpz0 cpx1 cpy1
transf2 dpx0 dpy0 dpz0 dpx1 dpy1
transf2 epx0 epy0 epz0 epx1 epy1
transf2 mx0 my0 mz0 mx1 my1
transf2 mpx0 mpy0 mpz0 mpx1 mpy1
coord A ox+ax1 oy+ay1
coord B ox+bx1 oy+by1
coord C ox+cx1 oy+cy1
coord D ox+dx1 oy+dy1
coord E ox+ex1 oy+ey1
coord AP ox+apx1 oy+apy1
coord BP ox+bpx1 oy+bpy1
coord CP ox+cpx1 oy+cpy1
coord DP ox+dpx1 oy+dpy1
coord EP ox+epx1 oy+epy1
coord M ox+mx1 oy+my1
coord MP ox+mpx1 oy+mpy1
vector_p A B AB 
vector_p B C BC 
vector_p C D CD 
vector_p D E DE 
vector_p E A EA 
vector_p B AP BAP
vector_p C BP CBP
vector_p D CP DCP
vector_p E DP EDP
vector_p A EP AEP
vector_p M A MA
vector_p M B MB
vector_p M C MC
vector_p M D MD
vector_p M E ME
vector_p A AP AAP
vector_p B BP BBP
vector_p C CP CCP
vector_p D DP DDP
vector_p E EP EEP
vector_p MP AP MPAP
vector_p MP BP MPBP
vector_p MP CP MPCP
vector_p MP DP MPDP
vector_p MP EP MPEP
setcolor X blue
draw_icos1
setcolor X green
draw_icos2
setcolor X red
draw_icos3
sleep 10
setcolor X white
draw_icos1
draw_icos2
draw_icos3
setcolor X black
setframe X f noax
enddo
setcolor X blue
draw_icos1
setcolor X green
draw_icos2
setcolor X red
draw_icos3
destroy MA
destroy MB
destroy MC
destroy MD
destroy ME
destroy MPAP
destroy MPBP
destroy MPCP
destroy MPDP
destroy MPEP
destroy AAP
destroy BBP
destroy CCP
destroy DDP
destroy EEP
destroy AB
destroy BC
destroy CD
destroy DE
destroy EA
destroy BAP
destroy CBP
destroy DCP
destroy EDP
destroy AEP
destroy A
destroy B
destroy C
destroy D
destroy E
destroy M
destroy AP
destroy BP
destroy CP
destroy DP
destroy EP
destroy MP
destroy f
;
;
:draw_icos1
1
0
-1
; MAB
ext_prod MA MB
if< ext_p X1
draw M X f
draw_to A X f
draw_to B X f
draw_to M X f
X1:
; MBC
ext_prod MB MC
if< ext_p X2
draw M X f
draw_to B X f
draw_to C X f
draw_to M X f
X2:
; MCD
ext_prod MC MD
if< ext_p X3
draw M X f
draw_to C X f
draw_to D X f
draw_to M X f
X3:
; MDE
ext_prod MD ME
if< ext_p X4
draw M X f
draw_to D X f
draw_to E X f
draw_to M X f
X4:
; MEA
ext_prod ME MA
if< ext_p X5
draw M X f
draw_to E X f
draw_to A X f
draw_to M X f
X5:
;
;
:draw_icos2
1
0
-1
; MPAPBP
ext_prod MPAP MPBP
if> ext_p XP1
draw MP X f
draw_to AP X f
draw_to BP X f
draw_to MP X f
XP1:
; MPBPCP
ext_prod MPBP MPCP
if> ext_p XP2
draw MP X f
draw_to BP X f
draw_to CP X f
draw_to MP X f
XP2:
; MPCPDP
ext_prod MPCP MPDP
if> ext_p XP3
draw MP X f
draw_to CP X f
draw_to DP X f
draw_to MP X f
XP3:
; MPDPEP
ext_prod MPDP MPEP
if> ext_p XP4
draw MP X f
draw_to DP X f
draw_to EP X f
draw_to MP X f
XP4:
; MPEPAP
ext_prod MPEP MPAP
if> ext_p XP5
draw MP X f
draw_to EP X f
draw_to AP X f
draw_to MP X f
XP5:
;
;
:draw_icos3
1
0
-1
; AAPB
ext_prod AAP AB
if< ext_p X1X
draw A X f
draw_to AP X f
draw_to B X f
draw_to A X f
X1X:
; BBPC
ext_prod BBP BC
if< ext_p X2X
draw B X f
draw_to BP X f
draw_to C X f
draw_to B X f
X2X:
; CCPD
ext_prod CCP CD
if< ext_p X3X
draw C X f
draw_to CP X f
draw_to D X f
draw_to C X f
X3X:
; DDPE
ext_prod DDP DE
if< ext_p X4X
draw D X f
draw_to DP X f
draw_to E X f
draw_to D X f
X4X:
; EEPA
ext_prod EEP EA
if< ext_p X5X
draw E X f
draw_to EP X f
draw_to A X f
draw_to E X f
X5X:
; BAPBP
ext_prod BAP BBP
if< ext_p X1Y
draw B X f
draw_to AP X f
draw_to BP X f
draw_to B X f
X1Y:
; CBPCP
ext_prod CBP CCP
if< ext_p X2Y
draw C X f
draw_to BP X f
draw_to CP X f
draw_to C X f
X2Y:
; DCPDP
ext_prod DCP DDP
if< ext_p X3Y
draw D X f
draw_to CP X f
draw_to DP X f
draw_to D X f
X3Y:
; EDPEP
ext_prod EDP EEP
if< ext_p X4Y
draw E X f
draw_to DP X f
draw_to EP X f
draw_to E X f
X4Y:
; AEPAP
ext_prod AEP AAP
if< ext_p X5Y
draw A X f
draw_to EP X f
draw_to AP X f
draw_to A X f
X5Y:
;---------------------------------------------------------------------------
;
;
;
;
;---------------------------------------------------------------------------
;    This program draws a moving isocahedron with a dodecahedron inside.
;    Usage :
;        ex22 n
;    where n is the number of isocahedrons and dodecahedrons that will be
;    drawn.
;---------------------------------------------------------------------------
:ex23
2
0
-1
defframe f
frame f -1.5 1.5 -1.5 1.5 1.5 3 3
setframe X f noax
setcolor X black
title X f Moving isocahedron
point A
point B
point C
point D
point E
point M
point AP
point BP
point CP
point DP
point EP
point MP
point P1
point P2
point P3
point P4
point P5
point PP1
point PP2
point PP3
point PP4
point PP5
point Q1
point Q2
point Q3
point Q4
point Q5
point QP1
point QP2
point QP3
point QP4
point QP5
c=cos(pi/5)
s=sin(pi/5)
c2=cos(2*pi/5)
s2=sin(2*pi/5)
s3=sqrt(4*s*s-1)
mx0=0
my0=0
mz0=0.5+s3
mpx0=0
mpy0=0
mpz0=-0.5-s3
ax0=1
ay0=0
az0=0.5
bz0=0.5
cz0=0.5
dz0=0.5
ez0=0.5
rot5 ax0 ay0 bx0 by0
rot5 bx0 by0 cx0 cy0
rot5 cx0 cy0 dx0 dy0
rot5 dx0 dy0 ex0 ey0
apx0=c
apy0=s
apz0=-0.5
bpz0=-0.5
cpz0=-0.5
dpz0=-0.5
epz0=-0.5
rot5 apx0 apy0 bpx0 bpy0
rot5 bpx0 bpy0 cpx0 cpy0
rot5 cpx0 cpy0 dpx0 dpy0
rot5 dpx0 dpy0 epx0 epy0
dt=pi/400
do i 1 #1
t=i*dt
transf1 t 2*t 3*t
x=abs(cos(t/4))
ox=cos(5*t)/2
oy=sin(4*t)/2
transf2 ax0 ay0 az0 ax1 ay1
transf2 bx0 by0 bz0 bx1 by1
transf2 cx0 cy0 cz0 cx1 cy1
transf2 dx0 dy0 dz0 dx1 dy1
transf2 ex0 ey0 ez0 ex1 ey1
transf2 apx0 apy0 apz0 apx1 apy1
transf2 bpx0 bpy0 bpz0 bpx1 bpy1
transf2 cpx0 cpy0 cpz0 cpx1 cpy1
transf2 dpx0 dpy0 dpz0 dpx1 dpy1
transf2 epx0 epy0 epz0 epx1 epy1
transf2 mx0 my0 mz0 mx1 my1
transf2 mpx0 mpy0 mpz0 mpx1 mpy1
coord A ox+ax1 oy+ay1
coord B ox+bx1 oy+by1
coord C ox+cx1 oy+cy1
coord D ox+dx1 oy+dy1
coord E ox+ex1 oy+ey1
coord AP ox+apx1 oy+apy1
coord BP ox+bpx1 oy+bpy1
coord CP ox+cpx1 oy+cpy1
coord DP ox+dpx1 oy+dpy1
coord EP ox+epx1 oy+epy1
coord M ox+mx1 oy+my1
coord MP ox+mpx1 oy+mpy1
bary A B M P1
bary B C M P2
bary C D M P3
bary D E M P4
bary E A M P5
bary A AP B Q1
bary B BP C Q2
bary C CP D Q3
bary D DP E Q4
bary E EP A Q5
bary AP B BP QP1
bary BP C CP QP2
bary CP D DP QP3
bary DP E EP QP4
bary EP A AP QP5
bary AP BP MP PP1
bary BP CP MP PP2
bary CP DP MP PP3
bary DP EP MP PP4
bary EP AP MP PP5
setcolor X red
draw_icos
setcolor X blue
draw_dodec
sleep 10
setcolor X white
draw_icos
draw_dodec
setcolor X black
setframe X f noax
enddo
setcolor X red
draw_icos
setcolor X blue
draw_dodec
destroy A
destroy B
destroy C
destroy D
destroy E
destroy M
destroy AP
destroy BP
destroy CP
destroy DP
destroy EP
destroy MP
destroy P1
destroy P2
destroy P3
destroy P4
destroy P5
destroy PP1
destroy PP2
destroy PP3
destroy PP4
destroy PP5
destroy Q1
destroy Q2
destroy Q3
destroy Q4
destroy Q5
destroy QP1
destroy QP2
destroy QP3
destroy QP4
destroy QP5
destroy f
;
;
:draw_dodec
1
0
-1
draw P5 X f
draw_to P1 X f
draw_to P2 X f
draw_to P3 X f
draw_to P4 X f
draw_to P5 X f
draw_to Q5 X f
draw_to QP4 X f
draw_to Q4 X f
draw_to P4 X f
draw Q4 X f
draw_to QP3 X f
draw_to Q3 X f
draw_to P3 X f
draw Q3 X f
draw_to QP2 X f
draw_to Q2 X f
draw_to P2 X f
draw Q2 X f
draw_to QP1 X f
draw_to Q1 X f
draw_to P1 X f
draw Q1 X f
draw_to QP5 X f
draw_to Q5 X f
draw QP5 X f
draw_to PP5 X f
draw_to PP1 X f
draw_to PP2 X f
draw_to PP3 X f
draw_to PP4 X f
draw_to PP5 X f
draw QP2 X f
draw_to PP2 X f
draw QP3 X f
draw_to PP3 X f
draw QP4 X f
draw_to PP4 X f
draw QP1 X f
draw_to PP1 X f
;---------------------------------------------------------------------------
;
;
