/*************************************************************************
** funct-3.1      (command interpreter - funct)                          **
** geom_cmd.c : graphic functions                                        **
** Copyright (C) 2003  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      UMR 7586 du CNRS                                                 **
**      173, rue du Chevaleret                                           **
**      75013 Paris                                                      **
**      France                                                           **
**                                                                       **
**************************************************************************/

#include "geom.h"



/*--------------------------------------------------------------------
    Function associated to the command 'point'
--------------------------------------------------------------------*/
int
Point_Def_Cmd(int argc, char *argv[])
{
    int             i0;
    char           *k[4],
                  **e;
    Point          *xx;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    k[0] = (char *) flow_interp;
    k[1] = ch_copy("objdef");
    k[2] = ch_copy_int(_GEOM_POINT - 1);
    k[3] = argv[1];
    i0 = obj_create(3, k + 1);
    free(k[1]);
    free(k[2]);
    if (i0 == -1) {
        return 1;
    }
    sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    xx = (Point *) malloc((size_t) sizeof(Point));
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    if (argc > 3) {
        xx->x = convert_float(argv[2], flow_interp);
        xx->y = convert_float(argv[3], flow_interp);
    }
    else {
        xx->x = 0.;
        xx->y = 0.;
    }
    e[0] = (char *) xx;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'vector'
--------------------------------------------------------------------*/
int
Vector_Def_Cmd(int argc, char *argv[])
{
    int             i0;
    char           *k[4],
                  **e;
    Vector          *xx;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    k[0] = (char *) flow_interp;
    k[1] = ch_copy("objdef");
    k[2] = ch_copy_int(_GEOM_VECTOR - 1);
    k[3] = argv[1];
    i0 = obj_create(3, k + 1);
    free(k[1]);
    free(k[2]);
    if (i0 == -1) {
        return 1;
    }
    sketch_obj_restr(argv[1], &i0, _GEOM_VECTOR, flow_interp);
    xx = (Vector *) malloc((size_t) sizeof(Vector));
    e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
    if (argc > 3) {
        xx->x = convert_float(argv[2], flow_interp);
        xx->y = convert_float(argv[3], flow_interp);
    }
    else {
        xx->x = 0.;
        xx->y = 0.;
    }
    e[0] = (char *) xx;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'line'
--------------------------------------------------------------------*/
int
Line_Def_Cmd(int argc, char *argv[])
{
    int             i0;
    char           *k[4],
                  **e;
    Line           *xx;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    k[0] = (char *) flow_interp;
    k[1] = ch_copy("objdef");
    k[2] = ch_copy_int(_GEOM_LINE - 1);
    k[3] = argv[1];
    i0 = obj_create(3, k + 1);
    free(k[1]);
    free(k[2]);
    if (i0 == -1) {
        return 1;
    }
    sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    xx = (Line *) malloc((size_t) sizeof(Line));
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    if (argc > 5) {
        xx->A.x = convert_float(argv[2], flow_interp);
        xx->A.y = convert_float(argv[3], flow_interp);
        xx->U.x = convert_float(argv[4], flow_interp);
        xx->U.y = convert_float(argv[5], flow_interp);
        if (Norm_Vector(xx->U, &xx->U) == 1) {
            xx->U.x = 1.;
            xx->U.y = 0.;
        }
    }
    else {
        xx->A.x = 0.;
        xx->A.y = 0.;
        xx->U.x = 1.;
        xx->U.y = 0.;
    }
    e[0] = (char *) xx;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'span_l'
--------------------------------------------------------------------*/
int
Span_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    i1,
                    i2,
                    iw;
    Line           *lin;
    Point          *p,
                   *q;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    iw = sketch_obj_restr(argv[2], &i1, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    iw = sketch_obj_restr(argv[3], &i2, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    e = (char **) Obj[_GEOM_POINT - 1][i1].adresse;
    p = (Point *) e[0];
    e = (char **) Obj[_GEOM_POINT - 1][i2].adresse;
    q = (Point *) e[0];
    if (Span(*p, *q, lin) == 1) {
        error_mess(flow_interp, _GEOM_MESS + 6);
        return 1;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'inters'
--------------------------------------------------------------------*/
int
Inters_Line_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    i1,
                    i2,
                    iw;
    Line           *lin,
                   *lin2;
    Point          *p;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    iw = sketch_obj_restr(argv[2], &i1, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    iw = sketch_obj_restr(argv[3], &i2, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    e = (char **) Obj[_GEOM_LINE - 1][i1].adresse;
    lin2 = (Line *) e[0];
    e = (char **) Obj[_GEOM_POINT - 1][i2].adresse;
    p = (Point *) e[0];
    if (Inters_Line_Line(*lin, *lin2, p) == 1) {
        error_mess(flow_interp, _GEOM_MESS + 7);
        return 1;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'symcent_p'
--------------------------------------------------------------------*/
int
Sym_Cent_Point_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Point          *p,
                   *O,
                   *q;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    O = (Point *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    q = (Point *) e[0];
    Sym_Cent_Point(*p, *O, q);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'symcent_l'
--------------------------------------------------------------------*/
int
Sym_Cent_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Line           *lin,
                   *lin2;
    Point          *O;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    O = (Point *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin2 = (Line *) e[0];
    Sym_Cent_Line(*O, *lin, lin2);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'symline_p'
--------------------------------------------------------------------*/
int
Sym_Line_Point_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Line           *lin;
    Point          *p,
                   *q;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    q = (Point *) e[0];
    Sym_Line_Point(*lin, *p, q);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'symline_l'
--------------------------------------------------------------------*/
int
Sym_Line_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Line           *lin,
                   *lin2,
                   *lin3;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin2 = (Line *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin3 = (Line *) e[0];
    Sym_Line_Line(*lin2, *lin, lin3);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'ortholine'
--------------------------------------------------------------------*/
int
Orthog_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Line           *lin,
                   *lin2;
    Point          *p;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin2 = (Line *) e[0];
    Orthog_Line(*lin, *p, lin2);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'orthoproj'
--------------------------------------------------------------------*/
int
Orthog_Proj_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Line           *lin;
    Point          *p,
                   *q;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    q = (Point *) e[0];
    Orthog_Proj(*lin, *p, q);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'parallel'
--------------------------------------------------------------------*/
int
Parallel_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Line           *lin,
                   *lin2;
    Point          *p;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin2 = (Line *) e[0];
    Parallel_Line(*lin, *p, lin2);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'middle'
--------------------------------------------------------------------*/
int
Middle_Point_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Point          *p,
                   *O,
                   *q;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    O = (Point *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    q = (Point *) e[0];
    Middle_Point(*p, *O, q);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'bary2'
--------------------------------------------------------------------*/
int
Bary2_Point_Cmd(int argc, char *argv[])
{
    int             i0,
                    i00,
                    iw,
                    iw0;
    double          t;
    Point          *p,
                   *O,
                   *q;
    Polygon        *pol;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw0 = sketch_obj_restr(argv[1], &i00, _GEOM_POINT, flow_interp);
    if (iw0 != _GEOM_POINT) {
        iw0 = sketch_obj_restr(argv[1], &i00, _GEOM_POLYG, flow_interp);
        if (iw0 != _GEOM_POLYG) {
            error_mess(flow_interp, _GEOM_MESS + 26);
            return 1;
        }
    }
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    O = (Point *) e[0];
    if (iw0 == _GEOM_POINT) {
        if (argc < 5) {
            error_mess(flow_interp, _GEOM_MESS + 27);
            return 1;
        }
        e = (char **) Obj[_GEOM_POINT - 1][i00].adresse;
        p = (Point *) e[0];
        t = convert_float(argv[3], flow_interp);
        iw = sketch_obj_restr(argv[4], &i0, _GEOM_POINT, flow_interp);
        if (iw != _GEOM_POINT) {
            error_mess(flow_interp, _GEOM_MESS);
            return 1;
        }
        e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
        q = (Point *) e[0];
        Bary_Point(*p, *O, t, q);
    }
    else {
        e = (char **) Obj[_GEOM_POLYG - 1][i00].adresse;
        pol = (Polygon *) e[0];
        Bary_Polyg(*pol, O);
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'bary'
--------------------------------------------------------------------*/
int
Bary_Point_Cmd(int argc, char *argv[])
{
    int             i,
                    i0,
                    iw;
    Point         **p;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    p = (Point **) malloc((size_t) argc * sizeof(Point *));

    for (i = 0; i < argc - 1; i++) {
        iw = sketch_obj_restr(argv[i + 1], &i0, _GEOM_POINT, flow_interp);
        if (iw != _GEOM_POINT) {
            error_mess(flow_interp, _GEOM_MESS);
            free(p);
            return 1;
        }
        e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
        p[i] = (Point *) e[0];
    }

    Bary_Many_Points(p, argc - 1);
    free(p);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'angle'
--------------------------------------------------------------------*/
int
Angle_Vect_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          t;
    Vector         *u,
                   *v;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_VECTOR, flow_interp);
    if (iw != _GEOM_VECTOR) {
        error_mess(flow_interp, _GEOM_MESS + 5);
        return 1;
    }
    e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
    u = (Vector *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_VECTOR, flow_interp);
    if (iw != _GEOM_VECTOR) {
        error_mess(flow_interp, _GEOM_MESS + 5);
        return 1;
    }
    e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
    v = (Vector *) e[0];
    t = Angle_Vector(*u, *v);
    SetValue("angle_v", &t, flow_interp);
    print(flow_interp, "%f\n", t);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'rotate'
--------------------------------------------------------------------*/
int
Rotate_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    i1,
                    iw;
    double          t;
    Line           *lin,
                   *lin2;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    iw = sketch_obj_restr(argv[2], &i1, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    t = convert_float(argv[3], flow_interp);
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    e = (char **) Obj[_GEOM_LINE - 1][i1].adresse;
    lin2 = (Line *) e[0];
    Rotate_Line(*lin, lin2, t);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'bissec'
--------------------------------------------------------------------*/
int
Bissec_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Line           *lin,
                   *lin2,
                   *lin3;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin2 = (Line *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin3 = (Line *) e[0];
    Bissec_Line(*lin, *lin2, lin3);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'bissec2'
--------------------------------------------------------------------*/
int
Bissec2_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          t;
    Line           *lin,
                   *lin2,
                   *lin3;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin2 = (Line *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin3 = (Line *) e[0];
    t = convert_float(argv[4], flow_interp);
    Bissec2_Line(*lin, *lin2, lin3, t);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'circle'
--------------------------------------------------------------------*/
int
Circle_Def_Cmd(int argc, char *argv[])
{
    int             i0;
    char           *k[4],
                  **e;
    Circle         *xx;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    k[0] = (char *) flow_interp;
    k[1] = ch_copy("objdef");
    k[2] = ch_copy_int(_GEOM_CIRC - 1);
    k[3] = argv[1];
    i0 = obj_create(3, k + 1);
    free(k[2]);
    free(k[1]);
    if (i0 == -1) {
        return 1;
    }
    sketch_obj_restr(argv[1], &i0, _GEOM_CIRC, flow_interp);
    xx = (Circle *) malloc((size_t) sizeof(Circle));
    e = (char **) Obj[_GEOM_CIRC - 1][i0].adresse;
    if (argc > 4) {
        xx->O.x = convert_float(argv[2], flow_interp);
        xx->O.y = convert_float(argv[3], flow_interp);
        xx->R = convert_float(argv[4], flow_interp);
    }
    else {
        xx->O.x = 0.;
        xx->O.y = 0.;
        xx->R = 1.;
    }
    e[0] = (char *) xx;
    return 0;
}
/*------------------------------------------------------------------*/
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'span_c'
--------------------------------------------------------------------*/
int
Circle_Span_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Point          *p,
                   *q,
                   *r;
    Line           *l1,
                   *l2,
                   *l3;
    Circle         *circ;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_CIRC, flow_interp);
    if (iw != _GEOM_CIRC) {
        error_mess(flow_interp, _GEOM_MESS + 2);
        return 1;
    }
    e = (char **) Obj[_GEOM_CIRC - 1][i0].adresse;
    circ = (Circle *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        iw = sketch_obj_restr(argv[2], &i0, _GEOM_LINE, flow_interp);
        if (iw != _GEOM_LINE) {
            error_mess(flow_interp, _GEOM_MESS + 1);
            return 1;
        }
        e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
        l1 = (Line *) e[0];
        iw = sketch_obj_restr(argv[3], &i0, _GEOM_LINE, flow_interp);
        if (iw != _GEOM_LINE) {
            error_mess(flow_interp, _GEOM_MESS + 1);
            return 1;
        }
        e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
        l2 = (Line *) e[0];
        iw = sketch_obj_restr(argv[4], &i0, _GEOM_LINE, flow_interp);
        if (iw != _GEOM_LINE) {
            error_mess(flow_interp, _GEOM_MESS + 1);
            return 1;
        }
        e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
        l3 = (Line *) e[0];
        if (Circle_Span4(*l1, *l2, *l3, circ) == 1) {
            error_mess(flow_interp, _GEOM_MESS + 21);
            return 1;
        }
    }
    else {
        e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
        p = (Point *) e[0];
        iw = sketch_obj_restr(argv[3], &i0, _GEOM_POINT, flow_interp);
        if (iw != _GEOM_POINT) {
            error_mess(flow_interp, _GEOM_MESS);
            return 1;
        }
        e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
        q = (Point *) e[0];
        iw = sketch_obj_restr(argv[4], &i0, _GEOM_POINT, flow_interp);
        if (iw != _GEOM_POINT) {
            error_mess(flow_interp, _GEOM_MESS);
            return 1;
        }
        e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
        r = (Point *) e[0];
        if (Circle_Span(*p, *q, *r, circ) == 1) {
            error_mess(flow_interp, _GEOM_MESS + 21);
            return 1;
        }
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'dist'
--------------------------------------------------------------------*/
int
Dist_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          t;
    Point          *p,
                   *q;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    q = (Point *) e[0];
    t = Dist(*p, *q);
    SetValue("dist_p", &t, flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'dist_pl'
--------------------------------------------------------------------*/
int
Dist_Point_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          t;
    Line           *lin;
    Point          *p;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    t = Dist_Point_Line(*p, *lin);
    SetValue("dist_p_l", &t, flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'inverse'
--------------------------------------------------------------------*/
int
Inverse_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Line           *lin,
                   *lin2;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin2 = (Line *) e[0];
    Inverse_Line(*lin, lin2);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'inters_cl'
--------------------------------------------------------------------*/
int
Inters_Line_Circle_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          x;
    Line           *lin;
    Circle         *circ;
    Point          *A,
                   *B;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_CIRC, flow_interp);
    if (iw != _GEOM_CIRC) {
        error_mess(flow_interp, _GEOM_MESS + 2);
        return 1;
    }
    e = (char **) Obj[_GEOM_CIRC - 1][i0].adresse;
    circ = (Circle *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    A = (Point *) e[0];
    iw = sketch_obj_restr(argv[4], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    B = (Point *) e[0];
    i0 = Inters_Line_Circle(*lin, *circ, A, B);
    x = (double) i0;
    SetValue("inters_cl", &x, flow_interp);
    if (i0 == 0) {
        error_mess(flow_interp, _GEOM_MESS + 23);
        return 1;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'inters_cc'
--------------------------------------------------------------------*/
int
Inters_Circle_Circle_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          x;
    Circle         *circ1,
                   *circ2;
    Point          *A,
                   *B;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_CIRC, flow_interp);
    if (iw != _GEOM_CIRC) {
        error_mess(flow_interp, _GEOM_MESS + 2);
        return 1;
    }
    e = (char **) Obj[_GEOM_CIRC - 1][i0].adresse;
    circ1 = (Circle *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_CIRC, flow_interp);
    if (iw != _GEOM_CIRC) {
        error_mess(flow_interp, _GEOM_MESS + 2);
        return 1;
    }
    e = (char **) Obj[_GEOM_CIRC - 1][i0].adresse;
    circ2 = (Circle *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    A = (Point *) e[0];
    iw = sketch_obj_restr(argv[4], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    B = (Point *) e[0];
    i0 = Inters_Circle_Circle(*circ1, *circ2, A, B);
    x = (double) i0;
    SetValue("inters_cc", &x, flow_interp);
    if (i0 == 0) {
        error_mess(flow_interp, _GEOM_MESS + 23);
        return 1;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
int
Tangents_to_Circle_from_Point_Cmd(int argc, char *argv[])
{
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'tangent_p'
--------------------------------------------------------------------*/
int
Tangent_to_Polygon_at_Point_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          x;
    Polygon        *s;
    Line           *lin;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POLYG, flow_interp);
    if (iw != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 3);
        return 1;
    }
    e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
    s = (Polygon *) e[0];
    x = convert_float(argv[2], flow_interp);
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    i0 = Point_on_Polyg_v(*s, x, &lin->A, &lin->U);
    if (i0 != 0) {
        if (i0 < 3)
            error_mess(flow_interp, _GEOM_MESS + 10 + i0);
        else
            error_mess(flow_interp, _GEOM_MESS + 20);
        return 1;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'accel_p'
--------------------------------------------------------------------*/
int
Accel_to_Polygon_at_Point_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          x;
    Polygon        *s;
    Vector         *U;
    Point          *A;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POLYG, flow_interp);
    if (iw != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 3);
        return 1;
    }
    e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
    s = (Polygon *) e[0];
    x = convert_float(argv[2], flow_interp);
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_VECTOR, flow_interp);
    if (iw != _GEOM_VECTOR) {
        error_mess(flow_interp, _GEOM_MESS + 2);
        return 1;
    }
    e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
    U = (Vector *) e[0];
    iw = sketch_obj_restr(argv[4], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    A = (Point *) e[0];
    i0 = Point_on_Polyg_v2(*s, x, A, U);
    if (i0 != 0) {
        if (i0 < 3)
            error_mess(flow_interp, _GEOM_MESS + 10 + i0);
        else
            error_mess(flow_interp, _GEOM_MESS + 20);
        return 1;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'moveorig'
--------------------------------------------------------------------*/
int
Move_Orig_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          x;
    Line           *lin;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    x = convert_float(argv[2], flow_interp);
    Move_Orig_Line(x, lin);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'moveorig2'
--------------------------------------------------------------------*/
int
Move_Orig_Line2_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Point          *p;
    Line           *lin;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    if (Move_Orig_Line2(*p, lin) == 1) {
        error_mess(flow_interp, _GEOM_MESS + 18);
        return 1;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'polyg'
--------------------------------------------------------------------*/
int
Polyg_Def_Cmd(int argc, char *argv[])
{
    int             i0,
                    n;
    char           *k[4],
                  **e;
    Polygon        *xx;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    n = convert_int(argv[2], flow_interp);
    if (n <= 2) {
        error_mess(flow_interp, _GEOM_MESS + 8);
        return 1;
    }
    k[0] = (char *) flow_interp;
    k[1] = ch_copy("objdef");
    k[2] = ch_copy_int(_GEOM_POLYG - 1);
    k[3] = argv[1];
    i0 = obj_create(3, k + 1);
    free(k[1]);
    free(k[2]);
    if (i0 == -1) {
        return 1;
    }
    sketch_obj_restr(argv[1], &i0, _GEOM_POLYG, flow_interp);
    xx = (Polygon *) malloc((size_t) sizeof(Polygon));
    e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
    xx->icurv = 0;
    xx->calc = 0;
    xx->step = 0.;
    xx->nb = n;
    xx->vertex = (Point *) malloc((size_t) n * sizeof(Point));
    xx->tgt = (Vector *) malloc((size_t) n * sizeof(Vector));
    xx->d_tgt = (Vector *) malloc((size_t) n * sizeof(Vector));
    xx->def_tgt = (int *) malloc((size_t) n * sizeof(int));

    for (i0 = 0; i0 < n; i0++) {
        xx->vertex[i0].x = 0.;
        xx->vertex[i0].y = 0.;
        xx->tgt[i0].x = 0.;
        xx->tgt[i0].y = 0.;
        xx->d_tgt[i0].x = 0.;
        xx->d_tgt[i0].y = 0.;
        xx->def_tgt[i0] = 0;
    }

    e[0] = (char *) xx;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'polyg_funct'
--------------------------------------------------------------------*/
int
Polyg_Funct_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Polygon        *p;
    funct_d        *X,
                   *Y;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POLYG, flow_interp);
    if (iw != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 3);
        return 1;
    }
    e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
    p = (Polygon *) e[0];
    iw = sketch_obj(argv[2], &i0, flow_interp);
    if (iw != _RFUNC_D) {
        error_mess(flow_interp, _FUNC_MESS + 7);
        return 1;
    }
    e = (char **) Obj[_RFUNC_D - 1][i0].adresse;
    X = (funct_d *) e[0];
    iw = sketch_obj(argv[3], &i0, flow_interp);
    if (iw != _RFUNC_D) {
        error_mess(flow_interp, _FUNC_MESS + 7);
        return 1;
    }
    e = (char **) Obj[_RFUNC_D - 1][i0].adresse;
    Y = (funct_d *) e[0];
    Polyg_From_Funcs(*X, *Y, p);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'polyg_curv'
--------------------------------------------------------------------*/
int
Polyg_Curv_Cmd(int argc, char *argv[])
{
    int             i,
                    i0,
                    iw,
                    n;
    Polygon        *p,
                   *q,
                   *xx;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POLYG, flow_interp);
    if (iw != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 3);
        return 1;
    }
    e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
    p = (Polygon *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_POLYG, flow_interp);
    if (iw != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 3);
        return 1;
    }
    e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
    q = (Polygon *) e[0];
    n = convert_int(argv[3], flow_interp);
    if (n < 2) {
        error_mess(flow_interp, _GEOM_MESS + 10);
        return 1;
    }
    xx = (Polygon *) malloc((size_t) sizeof(Polygon));
    xx->nb = p->nb;
    xx->vertex = (Point *) malloc((size_t) p->nb * sizeof(Point));

    for (i = 0; i < xx->nb; i++) {
        xx->vertex[i].x = p->vertex[i].x;
        xx->vertex[i].y = p->vertex[i].y;
    }

    Curvilinear_Polyg(*xx, n, q);
    free(xx->vertex);
    free(xx);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'vertex'
--------------------------------------------------------------------*/
int
Vertex_Polyg_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw,
                    n;
    Polygon        *s;
    Point          *p;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POLYG, flow_interp);
    if (iw != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 3);
        return 1;
    }
    e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
    s = (Polygon *) e[0];
    n = convert_int(argv[2], flow_interp);
    if (n < 0 || n >= s->nb) {
        error_mess(flow_interp, _GEOM_MESS + 9);
        return 1;
    }
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    p->x = s->vertex[n].x;
    p->y = s->vertex[n].y;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'point_pol'
--------------------------------------------------------------------*/
int
Point_on_Polyg_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          x;
    Polygon        *s;
    Point          *p;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POLYG, flow_interp);
    if (iw != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 3);
        return 1;
    }
    e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
    s = (Polygon *) e[0];
    x = convert_float(argv[2], flow_interp);
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    i0 = Point_on_Polyg(*s, x, p);
    if (i0 >= 1) {
        error_mess(flow_interp, _GEOM_MESS + 10 + i0);
        return 1;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'point_v'
--------------------------------------------------------------------*/
int
Def_Point_Vector_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Point          *p,
                   *q;
    Vector         *v;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_VECTOR, flow_interp);
    if (iw != _GEOM_VECTOR) {
        error_mess(flow_interp, _GEOM_MESS + 5);
        return 1;
    }
    e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
    v = (Vector *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    q = (Point *) e[0];
    Def_Point_Vector(*p, *v, q);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'vector_p'
--------------------------------------------------------------------*/
int
Def_Vector_Point_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Point          *p,
                   *q;
    Vector         *v;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    q = (Point *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_VECTOR, flow_interp);
    if (iw != _GEOM_VECTOR) {
        error_mess(flow_interp, _GEOM_MESS + 5);
        return 1;
    }
    e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
    v = (Vector *) e[0];
    Def_Vector_Point(*p, *q, v);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'transform_lin'
--------------------------------------------------------------------*/
int
LinTransf_Def_Cmd(int argc, char *argv[])
{
    int             i0;
    char           *k[4],
                  **e;
    LinTransform   *xx;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    k[0] = (char *) flow_interp;
    k[1] = ch_copy("objdef");
    k[2] = ch_copy_int(_GEOM_LINTR - 1);
    k[3] = argv[1];
    i0 = obj_create(3, k + 1);
    if (i0 == -1) {
        return 1;
    }
    sketch_obj_restr(argv[1], &i0, _GEOM_LINTR, flow_interp);
    xx = (LinTransform *) malloc((size_t) sizeof(LinTransform));
    e = (char **) Obj[_GEOM_LINTR - 1][i0].adresse;
    if (argc > 5) {
        xx->a = convert_float(argv[2], flow_interp);
        xx->b = convert_float(argv[3], flow_interp);
        xx->c = convert_float(argv[4], flow_interp);
        xx->d = convert_float(argv[5], flow_interp);
    }
    else {
        xx->a = 0.;
        xx->b = 0.;
        xx->c = 0.;
        xx->d = 0.;
    }
    e[0] = (char *) xx;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'transform_aff'
--------------------------------------------------------------------*/
int
AffTransf_Def_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    char           *k[4],
                  **e;
    Point          *p;
    LinTransform   *Tr;
    AffTransform   *xx;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    k[0] = (char *) flow_interp;
    k[1] = ch_copy("objdef");
    k[2] = ch_copy_int(_GEOM_AFFTR - 1);
    k[3] = argv[1];
    i0 = obj_create(3, k + 1);
    free(k[2]);
    free(k[1]);
    if (i0 == -1) {
        return 1;
    }
    sketch_obj_restr(argv[1], &i0, _GEOM_AFFTR, flow_interp);
    xx = (AffTransform *) malloc((size_t) sizeof(AffTransform));
    e = (char **) Obj[_GEOM_AFFTR - 1][i0].adresse;
    e[0] = (char *) xx;
    if (argc > 3) {
        iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
        if (iw != _GEOM_POINT) {
            error_mess(flow_interp, _GEOM_MESS);
            xx->T.a = 0.;
            xx->T.b = 0.;
            xx->T.c = 0.;
            xx->T.d = 0.;
            xx->P.x = 0.;
            xx->P.y = 0.;
            return 1;
        }
        else {
            e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
            p = (Point *) e[0];
            xx->P.x = p->x;
            xx->P.y = p->y;
            iw = sketch_obj_restr(argv[2], &i0, _GEOM_LINTR, flow_interp);
            if (iw != _GEOM_LINTR) {
                error_mess(flow_interp, _GEOM_MESS + 13);
                xx->T.a = 0.;
                xx->T.b = 0.;
                xx->T.c = 0.;
                xx->T.d = 0.;
                return 1;
            }
            else {
                e = (char **) Obj[_GEOM_LINTR - 1][i0].adresse;
                Tr = (LinTransform *) e[0];
                xx->T.a = Tr->a;
                xx->T.b = Tr->b;
                xx->T.c = Tr->c;
                xx->T.d = Tr->d;
            }
        }
    }
    else {
        xx->T.a = 0.;
        xx->T.b = 0.;
        xx->T.c = 0.;
        xx->T.d = 0.;
        xx->P.x = 0.;
        xx->P.y = 0.;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'coord_lin'
--------------------------------------------------------------------*/
int
LinTransf_Coord_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    char          **e;
    LinTransform   *xx;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINTR, flow_interp);
    if (iw != _GEOM_LINTR) {
        error_mess(flow_interp, _GEOM_MESS + 13);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINTR - 1][i0].adresse;
    xx = (LinTransform *) e[0];
    xx->a = convert_float(argv[2], flow_interp);
    xx->b = convert_float(argv[3], flow_interp);
    xx->c = convert_float(argv[4], flow_interp);
    xx->d = convert_float(argv[5], flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'coord_aff'
--------------------------------------------------------------------*/
int
AffTransf_Coord_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    char          **e;
    LinTransform   *Tr;
    Point          *p;
    AffTransform   *xx;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_AFFTR, flow_interp);
    if (iw != _GEOM_AFFTR) {
        error_mess(flow_interp, _GEOM_MESS + 14);
        return 1;
    }
    e = (char **) Obj[_GEOM_AFFTR - 1][i0].adresse;
    xx = (AffTransform *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_LINTR, flow_interp);
    if (iw != _GEOM_LINTR) {
        error_mess(flow_interp, _GEOM_MESS + 13);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINTR - 1][i0].adresse;
    Tr = (LinTransform *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
    p = (Point *) e[0];
    xx->T.a = Tr->a;
    xx->T.b = Tr->b;
    xx->T.c = Tr->c;
    xx->T.d = Tr->d;
    xx->P.x = p->x;
    xx->P.y = p->y;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'show_lin'
--------------------------------------------------------------------*/
int
Show_LinTransform_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    LinTransform   *p;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINTR, flow_interp);
    if (iw != _GEOM_LINTR) {
        error_mess(flow_interp, _GEOM_MESS + 13);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINTR - 1][i0].adresse;
    p = (LinTransform *) e[0];
    SetValue("lintr_a", &p->a, flow_interp);
    print(flow_interp, "a = %f\n", p->a);
    SetValue("lintr_b", &p->b, flow_interp);
    print(flow_interp, "b = %f\n", p->b);
    SetValue("lintr_c", &p->c, flow_interp);
    print(flow_interp, "c = %f\n", p->c);
    SetValue("lintr_d", &p->d, flow_interp);
    print(flow_interp, "d = %f\n", p->d);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'show_aff'
--------------------------------------------------------------------*/
int
Show_AffTransform_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    AffTransform   *p;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_AFFTR, flow_interp);
    if (iw != _GEOM_AFFTR) {
        error_mess(flow_interp, _GEOM_MESS + 14);
        return 1;
    }
    e = (char **) Obj[_GEOM_AFFTR - 1][i0].adresse;
    p = (AffTransform *) e[0];
    SetValue("afftr_T_a", &p->T.a, flow_interp);
    print(flow_interp, "a = %f\n", p->T.a);
    SetValue("afftr_T_b", &p->T.b, flow_interp);
    print(flow_interp, "b = %f\n", p->T.b);
    SetValue("afftr_T_c", &p->T.c, flow_interp);
    print(flow_interp, "c = %f\n", p->T.c);
    SetValue("afftr_T_d", &p->T.d, flow_interp);
    print(flow_interp, "d = %f\n", p->T.d);
    SetValue("afftr_P_x", &p->P.x, flow_interp);
    print(flow_interp, "x = %f\n", p->P.x);
    SetValue("afftr_P_y", &p->P.y, flow_interp);
    print(flow_interp, "y = %f\n", p->P.y);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'inv'
--------------------------------------------------------------------*/
int
Inv_Lin_Transform_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    LinTransform   *p,
                   *q;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINTR, flow_interp);
    if (iw != _GEOM_LINTR) {
        error_mess(flow_interp, _GEOM_MESS + 13);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINTR - 1][i0].adresse;
    p = (LinTransform *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_LINTR, flow_interp);
    if (iw != _GEOM_LINTR) {
        error_mess(flow_interp, _GEOM_MESS + 13);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINTR - 1][i0].adresse;
    q = (LinTransform *) e[0];
    if (inverse_Lin_Transform(*p, q) == 1) {
        error_mess(flow_interp, _GEOM_MESS + 15);
        return 1;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'ext_prod'
--------------------------------------------------------------------*/
int
Ext_Product_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          x;
    Vector         *u,
                   *v;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_VECTOR, flow_interp);
    if (iw != _GEOM_VECTOR) {
        error_mess(flow_interp, _GEOM_MESS + 5);
        return 1;
    }
    e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
    u = (Vector *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_VECTOR, flow_interp);
    if (iw != _GEOM_VECTOR) {
        error_mess(flow_interp, _GEOM_MESS + 5);
        return 1;
    }
    e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
    v = (Vector *) e[0];
    x = Ext_Product_Vector(*u, *v);
    SetValue("ext_p", &x, flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'vector_l'
--------------------------------------------------------------------*/
int
Vector_Line_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Vector         *u;
    Line           *lin;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
    if (iw != _GEOM_LINE) {
        error_mess(flow_interp, _GEOM_MESS + 1);
        return 1;
    }
    e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
    lin = (Line *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_VECTOR, flow_interp);
    if (iw != _GEOM_VECTOR) {
        error_mess(flow_interp, _GEOM_MESS + 5);
        return 1;
    }
    e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
    u = (Vector *) e[0];
    u->x = lin->U.x;
    u->y = lin->U.y;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'length_pol'
--------------------------------------------------------------------*/
int
Length_Polyg_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          x;
    Polygon        *p;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POLYG, flow_interp);
    if (iw != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 3);
        return 1;
    }
    e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
    p = (Polygon *) e[0];
    if (p->icurv != 1) {
        error_mess(flow_interp, _GEOM_MESS + 11);
        return 1;
    }
    x = (p->nb - 1) * p->step;
    SetValue("length_pol", &x, flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'evol'
--------------------------------------------------------------------*/
int
Evolute_Polyg_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Polygon        *p,
                   *p2;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POLYG, flow_interp);
    if (iw != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 3);
        return 1;
    }
    e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
    p = (Polygon *) e[0];
    if (p->icurv != 1) {
        error_mess(flow_interp, _GEOM_MESS + 11);
        return 1;
    }
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_POLYG, flow_interp);
    if (iw != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 3);
        return 1;
    }
    e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
    p2 = (Polygon *) e[0];
    Evolute_Polyg(*p, p2);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'transform_gen'
--------------------------------------------------------------------*/
int
GenTransf_Def_Cmd(int argc, char *argv[])
{
    int             i0;
    char           *k[4],
                  **e;
    GenTransform   *xx;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    k[0] = (char *) flow_interp;
    k[1] = ch_copy("objdef");
    k[2] = ch_copy_int(_GEOM_GENTR - 1);
    k[3] = argv[1];
    i0 = obj_create(3, k + 1);
    free(k[2]);
    free(k[1]);
    if (i0 == -1) {
        return 1;
    }
    sketch_obj_restr(argv[1], &i0, _GEOM_GENTR, flow_interp);
    xx = (GenTransform *) malloc((size_t) sizeof(GenTransform));
    xx->X = ch_copy(argv[2]);
    xx->Y = ch_copy(argv[3]);
    e = (char **) Obj[_GEOM_GENTR - 1][i0].adresse;
    e[0] = (char *) xx;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'act'
--------------------------------------------------------------------*/
int
Act_XTr_Geom_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw,
                    iw1,
                    iw2;
    double          a,
                    b;
    Point          *p,
                   *q;
    Vector         *u,
                   *v;
    Line           *lin1,
                   *lin2;
    Circle         *circ;
    Polygon        *pol1,
                   *pol2;
    AffTransform   *Aff_Tr;
    LinTransform   *Lin_Tr;
    GenTransform   *Gen_Tr;
    char          **e,
                  **e1,
                  **e2;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj(argv[1], &i0, flow_interp);
    if (iw != _GEOM_AFFTR && iw != _GEOM_LINTR && iw != _GEOM_GENTR) {
        error_mess(flow_interp, _GEOM_MESS + 4);
        return 1;
    }
    e = (char **) Obj[iw - 1][i0].adresse;
    iw1 = sketch_obj(argv[2], &i0, flow_interp);
    if (iw1 != _GEOM_POINT && iw1 != _GEOM_VECTOR && iw1 != _GEOM_LINE
        && iw1 != _GEOM_CIRC && iw1 != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 24);
        return 1;
    }
    if ((iw1 == _GEOM_VECTOR && iw != _GEOM_LINTR) || (iw1 != _GEOM_VECTOR
        && iw == _GEOM_LINTR)) {
        error_mess(flow_interp, _GEOM_MESS + 25);
        return 1;
    }
    e1 = (char **) Obj[iw1 - 1][i0].adresse;
    iw2 = sketch_obj(argv[3], &i0, flow_interp);
    if (iw2 != _GEOM_POINT && iw2 != _GEOM_VECTOR && iw2 != _GEOM_LINE
        && iw2 != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 24);
        return 1;
    }
    if ((iw2 != _GEOM_VECTOR && iw == _GEOM_LINTR) || (iw1 == _GEOM_POINT
        && iw2 != _GEOM_POINT) || (iw2 == _GEOM_VECTOR && iw != _GEOM_LINTR)) {
        error_mess(flow_interp, _GEOM_MESS + 26);
        return 1;
    }
    if (iw == _GEOM_AFFTR) {
         if ((iw1 == _GEOM_LINE && iw2 != _GEOM_LINE) || (iw1 == _GEOM_CIRC
         && iw2 != _GEOM_POLYG) || (iw1 == _GEOM_POLYG && iw2 != _GEOM_POLYG)) {
             error_mess(flow_interp, _GEOM_MESS + 26);
             return 1;
         }
    }
    if (iw == _GEOM_GENTR) {
        if ((iw1 == _GEOM_LINE && iw2 != _GEOM_POLYG) || (iw1 == _GEOM_CIRC
        && iw2 != _GEOM_POLYG) || (iw1 == _GEOM_POLYG && iw2 != _GEOM_POLYG)) {
            error_mess(flow_interp, _GEOM_MESS + 26);
            return 1;
        }
        if (iw1 == _GEOM_LINE && argc < 6) {
            error_mess(flow_interp, _GEOM_MESS + 27);
            return 1;
        }
    }
    e2 = (char **) Obj[iw2 - 1][i0].adresse;
    if (iw1 == _GEOM_POINT) {
        p = (Point *) e1[0];
        q = (Point *) e2[0];
    }
    if (iw1 == _GEOM_POLYG) {
        pol1 = (Polygon *) e1[0];
        pol2 = (Polygon *) e2[0];
    }
    if (iw1 == _GEOM_CIRC) {
        circ = (Circle *) e1[0];
        pol2 = (Polygon *) e2[0];
    }
    if (iw == _GEOM_LINTR) {
        Lin_Tr = (LinTransform *) e[0];
        u = (Vector *) e1[0];
        v = (Vector *) e2[0];
        Transform_Vector(*u, *Lin_Tr, v);
    }
    if (iw == _GEOM_AFFTR) {
        Aff_Tr = (AffTransform *) e[0];
        if (iw1 == _GEOM_LINE) {
            lin1 = (Line *) e1[0];
            lin2 = (Line *) e2[0];
            if (act_AffTr_Line(*Aff_Tr, *lin1, lin2) == 1) {
                error_mess(flow_interp, _GEOM_MESS + 28);
                return 1;
            }
        }
        if (iw1 == _GEOM_POINT)
            act_AffTr_Point(*Aff_Tr, *p, q);
        if (iw1 == _GEOM_CIRC)
            act_AffTr_Circle(*Aff_Tr, *circ, pol2);
        if (iw1 == _GEOM_POLYG)
            act_AffTr_Polyg(*Aff_Tr, *pol1, pol2);
    }
    if (iw == _GEOM_GENTR) {
        Gen_Tr = (GenTransform *) e[0];
        if (iw1 == _GEOM_LINE) {
            lin1 = (Line *) e1[0];
            pol2 = (Polygon *) e2[0];
            if (argc < 6) {
                error_mess(flow_interp, _GEOM_MESS + 27);
                return 1;
            }
            a = convert_float(argv[4], flow_interp);
            b = convert_float(argv[5], flow_interp);
            act_GenTr_Line(*Gen_Tr, *lin1, pol2, a, b, flow_interp);
        }
        if (iw1 == _GEOM_POINT)
            act_GenTr_Point(*Gen_Tr, *p, q, flow_interp);
        if (iw1 == _GEOM_CIRC)
            act_GenTr_Circle(*Gen_Tr, *circ, pol2, flow_interp);
        if (iw1 == _GEOM_POLYG)
            act_GenTr_Polyg(*Gen_Tr, *pol1, pol2, flow_interp);
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'coord'
--------------------------------------------------------------------*/
int
All_Coord_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Point          *p;
    Line           *lin;
    Vector         *u;
    Circle         *circ;
    Polygon        *Pol;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        iw = sketch_obj_restr(argv[1], &i0, _GEOM_VECTOR, flow_interp);
        if (iw != _GEOM_VECTOR) {
            iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
            if (iw != _GEOM_LINE) {
                iw = sketch_obj_restr(argv[1], &i0, _GEOM_CIRC, flow_interp);
                if (iw != _GEOM_CIRC) {
                    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POLYG,
                        flow_interp);
                    if (iw != _GEOM_POLYG) {
                        error_mess(flow_interp, _GEOM_MESS + 26);
                        return 1;
                    }
                }
            }
        }
    }
    e = (char **) Obj[iw - 1][i0].adresse;
    if (iw == _GEOM_POINT) {
        p = (Point *) e[0];
        p->x = convert_float(argv[2], flow_interp);
        p->y = convert_float(argv[3], flow_interp);
        return 0;
    }
    if (iw == _GEOM_LINE) {
        lin = (Line *) e[0];
        iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
        if (iw != _GEOM_POINT) {
            error_mess(flow_interp, _GEOM_MESS);
            return 1;
        }
        e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
        p = (Point *) e[0];
        iw = sketch_obj_restr(argv[3], &i0, _GEOM_VECTOR, flow_interp);
        if (iw != _GEOM_VECTOR) {
            error_mess(flow_interp, _GEOM_MESS + 5);
            return 1;
        }
        e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
        u = (Vector *) e[0];
        lin->A.x = p->x;
        lin->A.y = p->y;
        if (Norm_Vector(*u, &lin->U) == 1) {
            lin->U.x = 1.;
            lin->U.y = 0.;
        }
        return 0;
    }
    if (iw == _GEOM_VECTOR) {
        u = (Vector *) e[0];
        u->x = convert_float(argv[2], flow_interp);
        u->y = convert_float(argv[3], flow_interp);
        return 0;
    }
    if (iw == _GEOM_CIRC) {
        circ = (Circle *) e[0];
        iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
        if (iw != _GEOM_POINT) {
            error_mess(flow_interp, _GEOM_MESS);
            return 1;
        }
        e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
        p = (Point *) e[0];
        circ->O.x = p->x;
        circ->O.y = p->y;
        circ->R = convert_float(argv[3], flow_interp);
        return 0;
    }
    Pol = (Polygon *) e[0];
    i0 = convert_int(argv[2], flow_interp);
    if (i0 < 0 || i0 >= Pol->nb) {
        error_mess(flow_interp, _GEOM_MESS + 9);
        return 1;
    }
    if (argc < 5) {
        error_mess(flow_interp, _GEOM_MESS + 27);
        return 1;
    }
    Pol->vertex[i0].x = convert_float(argv[3], flow_interp);
    Pol->vertex[i0].y = convert_float(argv[4], flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'show'
--------------------------------------------------------------------*/
int
Show_All_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          x;
    Point          *p;
    Line           *lin;
    Vector         *v;
    Circle         *c;
    Polygon        *s;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        iw = sketch_obj_restr(argv[1], &i0, _GEOM_VECTOR, flow_interp);
        if (iw != _GEOM_VECTOR) {
            iw = sketch_obj_restr(argv[1], &i0, _GEOM_LINE, flow_interp);
            if (iw != _GEOM_LINE) {
                iw = sketch_obj_restr(argv[1], &i0, _GEOM_CIRC, flow_interp);
                if (iw != _GEOM_CIRC) {
                    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POLYG,
                        flow_interp);
                    if (iw != _GEOM_POLYG) {
                        error_mess(flow_interp, _GEOM_MESS + 26);
                        return 1;
                    }
                }
            }
        }
    }
    e = (char **) Obj[iw - 1][i0].adresse;
    if (iw == _GEOM_POINT) {
        p = (Point *) e[0];
        SetValue("point_x", &p->x, flow_interp);
        print(flow_interp, "x = %f\n", p->x);
        SetValue("point_y", &p->y, flow_interp);
        print(flow_interp, "y = %f\n", p->y);
        return 0;
    }
    if (iw == _GEOM_LINE) {
        lin = (Line *) e[0];
        SetValue("line_p_x", &lin->A.x, flow_interp);
        print(flow_interp, "x = %f\n", lin->A.x);
        SetValue("line_p_y", &lin->A.y, flow_interp);
        print(flow_interp, "y = %f\n", lin->A.y);
        SetValue("line_v_x", &lin->U.x, flow_interp);
        print(flow_interp, "u = %f\n", lin->U.x);
        SetValue("line_v_y", &lin->U.y, flow_interp);
        print(flow_interp, "v = %f\n", lin->U.y);
        return 0;
    }
    if (iw == _GEOM_VECTOR) {
        v = (Vector *) e[0];
        SetValue("vector_x", &v->x, flow_interp);
        print(flow_interp, "x = %f\n", v->x);
        SetValue("vector_y", &v->y, flow_interp);
        print(flow_interp, "y = %f\n", v->y);
        return 0;
    }
    if (iw == _GEOM_CIRC) {
        c = (Circle *) e[0];
        p = &c->O;
        SetValue("center_x", &p->x, flow_interp);
        print(flow_interp, "x = %f\n", p->x);
        SetValue("center_y", &p->y, flow_interp);
        print(flow_interp, "y = %f\n", p->y);
        SetValue("Radius", &c->R, flow_interp);
        print(flow_interp, "R = %f\n", c->R);
        return 0;
    }
    s = (Polygon *) e[0];
    x = (double) s->nb;
    SetValue("pol_nb", &x, flow_interp);
    print(flow_interp, "number of vertices : %f\n", x);
    x = (double) s->icurv;
    SetValue("pol_curv", &x, flow_interp);
    if (s->icurv == 1) {
        print(flow_interp, "curvilinear\n");
        SetValue("pol_step", &s->step, flow_interp);
        print(flow_interp, "length : %f\n", (s->nb -1) * s->step);
    }
    else
        print(flow_interp, "not curvilinear\n");
    x = (double) s->calc;
    SetValue("pol_calc", &x, flow_interp);
    if (s->calc == 1)
        print(flow_interp, "sides computed\n");
    else
        print(flow_interp, "sides not computed\n");
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'funct_pol'
--------------------------------------------------------------------*/
int
Funct_Polyg_Cmd(int argc, char *argv[])
{
    int             i,
                    i0,
                    iw;
    double         *x_r;
    funct_d        *X,
                   *Y;
    Polygon        *p;
    char          **e,
                   *k[5];
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_POLYG, flow_interp);
    if (iw != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 3);
        return 1;
    }
    e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
    p = (Polygon *) e[0];
    k[0] = (char *) flow_interp;
    k[1] = ch_copy("xrange");
    k[2] = ch_copy(argv[4]);
    k[3] = ch_copy("0");
    k[4] = ch_copy_int(p->nb);
    if (def_xrange_d(4, k + 1) == 1)
        return 1;
    iw = sketch_obj_restr(argv[4], &i0, _XRANGE_D, flow_interp);
    if (iw != _XRANGE_D) {
        error_mess(flow_interp, _GEOM_MESS + 29);
        return 1;
    }
    x_r = (double *) Obj[_XRANGE_D - 1][i0].adresse;
    free(k[1]);
    free(k[2]);
    free(k[3]);
    free(k[4]);
    k[1] = ch_copy("function");
    k[2] = ch_copy(argv[2]);
    k[3] = ch_copy(argv[4]);
    if (def_funct_d(3, k + 1) == 1)
        return 1;
    iw = sketch_obj_restr(argv[2], &i0, _RFUNC_D, flow_interp);
    if (iw != _RFUNC_D) {
        error_mess(flow_interp, _GEOM_MESS + 29);
        return 1;
    }
    e = (char **) Obj[_RFUNC_D - 1][i0].adresse;
    X = (funct_d *) e[0];
    free(k[2]);
    k[2] = ch_copy(argv[3]);
    if (def_funct_d(3, k + 1) == 1)
        return 1;
    iw = sketch_obj_restr(argv[3], &i0, _RFUNC_D, flow_interp);
    if (iw != _RFUNC_D) {
        error_mess(flow_interp, _GEOM_MESS + 29);
        return 1;
    }
    e = (char **) Obj[_RFUNC_D - 1][i0].adresse;
    Y = (funct_d *) e[0];
    free(k[1]);
    free(k[2]);
    free(k[3]);
    x_r[1] = 0.;
    X->f[1] = p->vertex[0].x;
    Y->f[1] = p->vertex[0].y;

    for (i = 2; i <= p->nb; i++) {
        x_r[i] = x_r[i - 1] + Dist(p->vertex[i - 2], p->vertex[i - 1]);
        X->f[i] = p->vertex[i - 1].x;
        Y->f[i] = p->vertex[i - 1].y;
    }

    SetValue("length_pol", &x_r[p->nb - 1], flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'act'
--------------------------------------------------------------------*/
int
Act_GenTr_Segment_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    Point          *p,
                   *q;
    Polygon        *pol;
    GenTransform   *Gen_Tr;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_GENTR, flow_interp);
    if (iw != _GEOM_GENTR) {
        error_mess(flow_interp, _GEOM_MESS + 4);
        return 1;
    }
    e = (char **) Obj[iw - 1][i0].adresse;
    Gen_Tr = (GenTransform *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[iw - 1][i0].adresse;
    p = (Point *) e[0];
    iw = sketch_obj_restr(argv[3], &i0, _GEOM_POINT, flow_interp);
    if (iw != _GEOM_POINT) {
        error_mess(flow_interp, _GEOM_MESS);
        return 1;
    }
    e = (char **) Obj[iw - 1][i0].adresse;
    q = (Point *) e[0];
    iw = sketch_obj_restr(argv[4], &i0, _GEOM_POLYG, flow_interp);
    if (iw != _GEOM_POLYG) {
        error_mess(flow_interp, _GEOM_MESS + 3);
        return 1;
    }
    e = (char **) Obj[iw - 1][i0].adresse;
    pol = (Polygon *) e[0];
    act_GenTr_Segment(*Gen_Tr, *p, *q, pol, flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'int_prod'
--------------------------------------------------------------------*/
int
Int_Product_Cmd(int argc, char *argv[])
{
    int             i0,
                    iw;
    double          x;
    Vector         *u,
                   *v;
    char          **e;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    iw = sketch_obj_restr(argv[1], &i0, _GEOM_VECTOR, flow_interp);
    if (iw != _GEOM_VECTOR) {
        error_mess(flow_interp, _GEOM_MESS + 5);
        return 1;
    }
    e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
    u = (Vector *) e[0];
    iw = sketch_obj_restr(argv[2], &i0, _GEOM_VECTOR, flow_interp);
    if (iw != _GEOM_VECTOR) {
        error_mess(flow_interp, _GEOM_MESS + 5);
        return 1;
    }
    e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
    v = (Vector *) e[0];
    x = Product_Vector(*u, *v);
    SetValue("int_p", &x, flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/



























