;/*************************************************************************
;** funct-3.1      (command interpreter - funct)                          **
;** graph.c :                                                             **
;** Copyright (C) 2003  Jean-Marc Drezet                                  **
;**                                                                       **
;**  This library is free software; you can redistribute it and/or        **
;**  modify it under the terms of the GNU Library General Public          **
;**  License as published by the Free Software Foundation; either         **
;**  version 2 of the License, or (at your option) any later version.     **
;**                                                                       **
;**  This library is distributed in the hope that it will be useful,      **
;**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
;**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
;**  Library General Public License for more details.                     **
;**                                                                       **
;**  You should have received a copy of the GNU Library General Public    **
;**  License along with this library; if not, write to the Free           **
;**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
;**                                                                       **
;** Please mail any bug reports/fixes/enhancements to me at:              **
;**      drezet@math.jussieu.fr                                           **
;** or                                                                    **
;**      Jean-Marc Drezet                                                 **
;**      Institut de Mathematiques                                        **
;**      UMR 7586 du CNRS                                                 **
;**      173, rue du Chevaleret                                           **
;**      75013 Paris                                                      **
;**      France                                                           **
;**                                                                       **
;**************************************************************************/

#include "graph.h"


#ifdef __GGILIB_X11
/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
_FUNCT_ggi_open_X11(void)
{
    ggi_mode s;

    if (ind0k_gr == 0) {
        if (ggiInit() != 0) {
            printf("error\n");
            exit(1);  /* can't start! */
        }
        ggi_vis = ggiOpen(NULL);
        if (ggi_vis == NULL) {
            printf("ggi error\n");
            exit(1);
        }
        if (ggiCheckGraphMode(ggi_vis, _GRAPH_X, _GRAPH_Y, GGI_AUTO, GGI_AUTO,
            GGI_AUTO, &s) == 0)
            ggiSetMode(ggi_vis, &s);
        else {
            printf("ggi error\n");
            exit(1);
        }
        color_white = ggiMapColor(ggi_vis, &white);
        ggiSetGCForeground(ggi_vis, color_white);
        ggiFillscreen(ggi_vis);
        color_black = ggiMapColor(ggi_vis, &black);
        ggiSetGCForeground(ggi_vis, color_black);
        ggiSetGCBackground(ggi_vis, color_white);
        ggiFlush(ggi_vis);
        _GRAPH_xx[0] = _GRAPH_X;
        _GRAPH_xx[1] = _GRAPH_Y;
        _GRAPH_xx[3] = 0.;
        _GRAPH_xx[4] = 0.;
        _GRAPH_xx[5] = 0.;
        _GRAPH_xx[6] = 0.;
        _GRAPH_xx[7] = 0.;
        _GRAPH_xx[8] = 1.;
        ind0k_gr = 1;
    }
    return 0;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_ggi_plot(int iw, int i0, double x, double y, float *xx)
{
    if (iw != -1)
        g2_plot(i0, x, y);
    else {
        ggiDrawPixel(ggi_vis, (int) x, (int) (xx[1] - y));
        xx[6] = x;
        xx[7] = y;
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_ggi_set_line_width(int iw, int i0, double w, float *xx)
{
    if (iw != -1)
        g2_set_line_width(i0, w);
    else
        xx[8] = w;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_ggi_line_to(int iw, int i0, double x, double y, float *xx)
{
    int             i,
                    imax;
    double          x2,
                    y2,
                    x0,
                    y0,
                    x1,
                    y1,
                    dx,
                    dy,
                    dx2,
                    dy2;

    if (iw != -1)
        g2_line_to(i0, x, y);
    else {
        if (xx[9] == 0.)
            ggiDrawLine(ggi_vis, (int) xx[6], (int) (xx[1] - xx[7]),
                (int) x, (int) (xx[1] - y));
        else {
            x2 = fabs((x - xx[6]) / 10.);
            y2 = fabs((y - xx[7]) / 10.);
            if (x2 < y2)
                x2 = y2;
            imax = (int) x2;
            if (imax > 0) {
                dx = (x - xx[6]) / imax;
                dy = (y - xx[7]) / imax;
                dx2 = dx / 2.;
                dy2 = dy / 2.;

                for (i = 0; i < imax; i++) {
                    x0 = xx[6] + i * dx;
                    y0 = xx[7] + i * dy;
                    x1 = x0 + dx2;
                    y1 = y0 + dy2;
                    ggiDrawLine(ggi_vis, (int) x0, (int)(xx[1] - y0),
                        (int) x1, (int)(xx[1] - y1));
                }
            }
        }
        xx[6] = x;
        xx[7] = y;
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_ggi_pen(int iw, int i0, int color_i)
{
    if (iw != -1)
        g2_pen(i0, color_i);
    else {
        color_ggi = ggiMapColor(ggi_vis, &ggi_col[color_i]);
        ggiSetGCForeground(ggi_vis, color_ggi);
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_ggi_move(int iw, int i0, double x, double y, float *xx)
{
    if (iw != -1)
        g2_move(i0, x, y);
    else {
        xx[6] = x;
        xx[7] = y;
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_ggi_set_dash(int iw, int i0, int N, double *dashes, float *xx)
{
    if (iw != -1)
        g2_set_dash(i0, N, dashes);
    if (dashes == NULL)
        xx[9] = 0.;
    else
        xx[9] = 1.;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_ggi_draw_string(int iw, int i0, double x, double y, char *text,
    float *xx)
{
    if (iw != -1)
        g2_draw_string(i0, x, y, text);
    else  {
        ggiPuts(ggi_vis, (int) x - 10, (int)(xx[1] - y - 10), text);
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_ggi_clear(int iw, int i0)
{
    ggi_pixel color;

    if (iw != -1)
        g2_clear(i0);
    else {
        color = ggiMapColor(ggi_vis, &white);
        ggiSetGCForeground(ggi_vis, color);
        ggiFillscreen(ggi_vis);
        color = ggiMapColor(ggi_vis, &black);
        ggiSetGCForeground(ggi_vis, color);
        color = ggiMapColor(ggi_vis, &white);
        ggiSetGCBackground(ggi_vis, color);
        ggiFlush(ggi_vis);
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
_FUNCT_ggi_ink(int iw, int i0, double red, double green, double blue, int i1)
{
    if (iw != -1)
        return g2_ink(i0, red, green, blue);
    else
        return i1;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_ggi_close(int iw, int i0)
{
    ggi_pixel color;

    if (iw != -1)
        g2_close(i0);
    else {
        color = ggiMapColor(ggi_vis, &white);
        ggiSetGCForeground(ggi_vis, color);
        ggiFillscreen(ggi_vis);
        color = ggiMapColor(ggi_vis, &black);
        ggiSetGCForeground(ggi_vis, color);
        color = ggiMapColor(ggi_vis, &white);
        ggiSetGCBackground(ggi_vis, color);
        ggiFlush(ggi_vis);
    }
}
/*-------------------------------------------------------------------------*/
#endif





#ifdef __ALLEGROLIB_X11
/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int main(int argc, char *argv[]);




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void _all_exit(void)
{
    allegro_exit();
    ind0k_gr = 0;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
_FUNCT_allegro_open_X11(int iw, int w, int h)
{
    PALETTE         pal;

    if (ind0k_gr == 0) {
        ind0k_gr = 1;
        allegro_init();
      /*  set_window_close_hook(_all_exit);*/
        set_color_depth(32);
        if (set_gfx_mode(GFX_XWINDOWS, _GRAPH_X, _GRAPH_Y, 0, 0) != 0) {
            set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
            allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
            exit(1);
        }
        generate_332_palette(pal);
        set_palette(pal);
        clear_to_color(screen, makecol(255, 255, 255));
        _GRAPH_xx[0] = _GRAPH_X;
        _GRAPH_xx[1] = _GRAPH_Y;
        _GRAPH_xx[3] = 0.;
        _GRAPH_xx[4] = 0.;
        _GRAPH_xx[5] = 0.;
        _GRAPH_xx[6] = 0.;
        _GRAPH_xx[7] = 0.;
        _GRAPH_xx[8] = 1.;
        _GRAPH_xx[10] = 0.;
        allegro_col[0] = makecol(0, 0, 0);
    }
    return 0;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_allegro_plot(int iw, int i0, double x, double y, float *xx)
{
    if (iw != -1)
        g2_plot(i0, x, y);
    else {
        xx[6] = x;
        xx[7] = y;
        putpixel(screen, (int) x, (int) (_GRAPH_Y - y),
            allegro_col[(int) xx[10]]);
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_allegro_set_line_width(int iw, int i0, double w, float *xx)
{
    if (iw != -1)
        g2_set_line_width(i0, w);
    else {
        xx[8] = w;
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_allegro_line_to(int iw, int i0, double x, double y, float *xx)
{
    int             i,
                    imax;
    double          x2,
                    y2,
                    x0,
                    y0,
                    x1,
                    y1,
                    dx,
                    dy,
                    dx2,
                    dy2;

    if (iw != -1)
        g2_line_to(i0, x, y);
    else {
        if (xx[9] == 0.)
            line(screen, (int) _GRAPH_xx[6], (int) (_GRAPH_Y - _GRAPH_xx[7]),
                (int) x, (int) (_GRAPH_Y - y), allegro_col[(int) xx[10]]);
        else {
            x2 = fabs((x - xx[6]) / 10.);
            y2 = fabs((y - xx[7]) / 10.);
            if (x2 < y2)
                x2 = y2;
            imax = (int) x2;
            if (imax > 0) {
                dx = (x - xx[6]) / imax;
                dy = (y - xx[7]) / imax;
                dx2 = dx / 2.;
                dy2 = dy / 2.;

                for (i = 0; i < imax; i++) {
                    x0 = xx[6] + i * dx;
                    y0 = xx[7] + i * dy;
                    x1 = x0 + dx2;
                    y1 = y0 + dy2;
                    line(screen, (int) x0, (int) (_GRAPH_Y - y0), (int) x1,
                        (int) (_GRAPH_Y - y1),
                            allegro_col[(int) _GRAPH_xx[10]]);
                }
            }
        }
        _GRAPH_xx[6] = x;
        _GRAPH_xx[7] = y;
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_allegro_ellipse(int iw, int i0, double x, double y, double r1,
    double r2, float *xx)
{
    if (iw != -1)
        g2_ellipse(i0, x, y, r1, r2);
    else
        ellipse(screen, (int) x, (int) (_GRAPH_Y -  y), (int) r1, (int) r2,
            allegro_col[(int) xx[10]]);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_allegro_pen(int iw, int i0, int color_i)
{
    if (iw != -1)
        g2_pen(i0, color_i);
    else {
        _GRAPH_xx[10] = color_i;
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_allegro_move(int iw, int i0, double x, double y, float *xx)
{
    if (iw != -1)
        g2_move(i0, x, y);
    else {
        xx[6] = x;
        xx[7] = y;
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_allegro_set_dash(int iw, int i0, int N, double *dashes, float *xx)
{
    if (iw != -1)
        g2_set_dash(i0, N, dashes);
    if (dashes == NULL)
        xx[9] = 0.;
    else
        xx[9] = 1.;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_allegro_draw_string(int iw, int i0, double x, double y, char *text,
    float *xx)
{
    if (iw != -1)
        g2_draw_string(i0, x, y, text);
    else  {
       text_mode(-1);
       textout_centre(screen, font, text, (int) x, (int) (_GRAPH_Y - y),
           makecol(0,0,0));
   }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_allegro_clear(int iw, int i0)
{
    if (iw != -1)
        g2_clear(i0);
    else {
        clear_to_color(screen, makecol(255, 255, 255));
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
_FUNCT_allegro_ink(int iw, int i0, double red, double green, double blue,
    int i1)
{
    if (iw != -1)
        return g2_ink(i0, red, green, blue);
    else
        return i1;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_allegro_close(int iw, int i0)
{
    if (iw != -1)
        g2_close(i0);
    else {
        clear_to_color(screen, makecol(255, 255, 255));
    }
}
/*-------------------------------------------------------------------------*/
#endif






#ifdef __NULLLIB_X11
/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
_FUNCT_null_open_X11(int iw, int w, int h)
{
    return 0;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_null_plot(int iw, int i0, double x, double y, float *xx)
{
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_null_set_line_width(int iw, int i0, double w, float *xx)
{
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_null_line_to(int iw, int i0, double x, double y, float *xx)
{
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_null_pen(int iw, int i0, int color_i)
{
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_null_move(int iw, int i0, double x, double y, float *xx)
{
    xx[6] = x;
    xx[7] = y;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_null_set_dash(int iw, int i0, int N, double *dashes, float *xx)
{
    if (dashes == NULL)
        xx[9] = 0.;
    else
        xx[9] = 1.;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_null_draw_string(int iw, int i0, double x, double y, char *text,
    float *xx)
{
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_null_clear(int iw, int i0)
{
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
_FUNCT_null_ink(int iw, int i0, double red, double green, double blue,
    int i1)
{
    return i1;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_null_close(int iw, int i0)
{
}
/*-------------------------------------------------------------------------*/
#endif






#ifdef __PLOTLIB_X11
/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
_FUNCT_plot_open_X11(int iw, int w, int h)
{
    plPlotterParams *plotter_params;
    char            hh[100];

    if (ind0k_gr[_ind_plot] == 0) {
        ind0k_gr[_ind_plot] = 1;
        memset(hh, 0, 100);
        sprintf(hh, "%dx%d", _GRAPH_X, _GRAPH_Y);
        plotter_params = pl_newplparams ();
        pl_setplparam(plotter_params, "BITMAPSIZE", hh);
        plotter[_ind_plot] = pl_newpl_r("X", NULL, NULL, stderr,
            plotter_params);
        pl_openpl_r(plotter[_ind_plot]);
        pl_bgcolor_r(plotter[_ind_plot], 65535, 65535, 65535);
        pl_color_r(plotter[_ind_plot], 0, 0 ,0);
        pl_fspace_r(plotter[_ind_plot], 0, 0, _GRAPH_X, _GRAPH_Y);
        _GRAPH_xx[_ind_plot][0] = _GRAPH_X;
        _GRAPH_xx[_ind_plot][1] = _GRAPH_Y;
        _GRAPH_xx[_ind_plot][3] = 0.;
        _GRAPH_xx[_ind_plot][4] = 0.;
        _GRAPH_xx[_ind_plot][5] = 0.;
        _GRAPH_xx[_ind_plot][6] = 0.;
        _GRAPH_xx[_ind_plot][7] = 0.;
        _GRAPH_xx[_ind_plot][8] = 1.;
        _GRAPH_xx[_ind_plot][9] = 0.;
        _GRAPH_xx[_ind_plot][10] = 0.;
        pl_flinewidth_r(plotter[_ind_plot], 1);
        pl_linemod_r(plotter[_ind_plot], "solid");
    }
    return 0;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_plot_plot(int iw, int i0, double x, double y, float *xx)
{
    xx[6] = x;
    xx[7] = y;
    if (iw != -1)
        pl_fmove_r(plotter2[i0], x, y);
    else
        pl_fmove_r(plotter[_ind_plot], x, y);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_plot_set_line_width(int iw, int i0, double w, float *xx)
{
    xx[8] = w;
    if (iw != -1) {
        if (xx[5] == 3)
            pl_flinewidth_r(plotter2[i0], xx[8] / 2.);
        else
            pl_flinewidth_r(plotter2[i0], xx[8]);

    }
    else
        pl_flinewidth_r(plotter[_ind_plot], xx[8]);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_plot_line_to(int iw, int i0, double x, double y, float *xx)
{
    int             i,
                    m,
                    imax;
    double          x2,
                    y2,
                    x0,
                    y0,
                    x1,
                    y1,
                    dx,
                    dy,
                    dx2,
                    dy2;
    float          *X;
    plPlotter      *P;

    if (iw != -1) {
        P = plotter2[i0];
        X = xx;
    }
    else {
        P = plotter[_ind_plot];
        X = _GRAPH_xx[_ind_plot];
    }
    m = X[10];
    pl_pencolor_r(P, plot_color_red[m], plot_color_green[m],
        plot_color_blue[m]);
    if (xx[9] == 0.) {
        pl_fline_r(P, X[6], X[7], x, y);
    }
    else {
        x2 = fabs((x - xx[6]) / 10.);
        y2 = fabs((y - xx[7]) / 10.);
        if (x2 < y2)
            x2 = y2;
        imax = (int) x2;
        if (imax > 0) {
            dx = (x - xx[6]) / imax;
            dy = (y - xx[7]) / imax;
            dx2 = dx / 2.;
            dy2 = dy / 2.;

            for (i = 0; i < imax; i++) {
                x0 = xx[6] + i * dx;
                y0 = xx[7] + i * dy;
                x1 = x0 + dx2;
                y1 = y0 + dy2;
                pl_fline_r(P, x0, y0, x1, y1);
            }
        }
    }
    X[6] = x;
    X[7] = y;
    pl_fmove_r(P, x, y);
    pl_endpath_r(P);
    pl_flushpl_r(P);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_plot_pen(int iw, int i0, int color_i)
{
/*    _GRAPH_xx[_ind_plot][10] = color_i;*/
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_plot_move(int iw, int i0, double x, double y, float *xx)
{
    xx[6] = x;
    xx[7] = y;
    if (iw != -1)
        pl_fmove_r(plotter2[i0], x, y);
    else
        pl_fmove_r(plotter[_ind_plot], x, y);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_plot_set_dash(int iw, int i0, int N, double *dashes, float *xx)
{
    float          *X;
    plPlotter      *P;

    if (iw != -1) {
        P = plotter2[i0];
        X = xx;
    }
    else {
        P = plotter[_ind_plot];
        X = _GRAPH_xx[_ind_plot];
    }
    xx[9] = N;
    switch(N) {
        case 0 :
            pl_linemod_r(P, "solid");
            break;
        case 1 :
            pl_linemod_r(P, "dotted");
            break;
        case 2 :
            pl_linemod_r(P, "dotdashed");
            break;
        case 3 :
            pl_linemod_r(P, "shortdashed");
            break;
        case 4 :
            pl_linemod_r(P, "longdashed");
            break;
        case 5 :
            pl_linemod_r(P, "dotdotdashed");
            break;
        case 6 :
            pl_linemod_r(P, "dotdotdotdashed");
            break;
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_plot_draw_string(int iw, int i0, double x, double y, char *text,
    float *xx)
{
    int             m;
    float          *X;
    plPlotter      *P;

    if (iw != -1) {
        P = plotter2[i0];
        X = xx;
    }
    else {
        P = plotter[_ind_plot];
        X = _GRAPH_xx[_ind_plot];
    }
    m = X[10];
    pl_pencolor_r(P, plot_color_red[m], plot_color_green[m],
        plot_color_blue[m]);
    pl_fmove_r(P, x - 14, y - 3);
    pl_label_r(P, text);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_plot_clear(int iw, int i0)
{
    if (iw != -1) {
        pl_erase_r(plotter2[i0]);
        pl_pencolor_r(plotter2[i0], 0, 0, 0);
    }
    else {
        pl_erase_r(plotter[_ind_plot]);
        pl_pencolor_r(plotter[_ind_plot], 0, 0, 0);
        _GRAPH_xx[_ind_plot][10] = 0;
    }
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
_FUNCT_plot_ink(int iw, int i0, double red, double green, double blue,
    int i1)
{
    return i1;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_plot_close(int iw, int i0)
{
    if (iw != -1) {
        pl_closepl_r(plotter2[i0]);
        pl_deletepl_r(plotter2[i0]);
        plotter2[i0] = NULL;
        if (plot_fic[i0] != NULL) {
            fclose(plot_fic[i0]);
            plot_fic[i0] = NULL;
        }
    }
    else {
        pl_erase_r(plotter[i0]);
        ind0k_gr[i0] = 0;
        pl_closepl_r(plotter[i0]);
        pl_deletepl_r(plotter[i0]);
        plotter[i0] = NULL;
    }
}
/*-------------------------------------------------------------------------*/
#endif





#ifdef __G2LIB_X11
/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
_FUNCT_g2_open_X11(void)
{
    if (ind0k_gr[_ind_plot] == 0) {
        _GRAPH_xx[_ind_plot][2] = g2_open_X11(_GRAPH_X, _GRAPH_Y);
        _GRAPH_xx[_ind_plot][0] = _GRAPH_X;
        _GRAPH_xx[_ind_plot][1] = _GRAPH_Y;
        _GRAPH_xx[_ind_plot][3] = 0.;
        _GRAPH_xx[_ind_plot][4] = 0.;
        _GRAPH_xx[_ind_plot][5] = 0.;
        _GRAPH_xx[_ind_plot][6] = 0.;
        _GRAPH_xx[_ind_plot][7] = 0.;
        _GRAPH_xx[_ind_plot][8] = 1.;
        ind0k_gr[_ind_plot] = 1;
	g2_set_font_size(_GRAPH_xx[_ind_plot][2], 16);
    }
    return 0;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_g2_plot(int iw, int i0, double x, double y, float *xx)
{
    g2_plot(i0, x, y);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_g2_set_line_width(int iw, int i0, double w, float *xx)
{
    g2_set_line_width(i0, w);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_g2_line_to(int iw, int i0, double x, double y, float *xx)
{
    g2_line_to(i0, x, y);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_g2_pen(int iw, int i0, int color_i)
{
    g2_pen(i0, color_i);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_g2_move(int iw, int i0, double x, double y, float *xx)
{
    g2_move(i0, x, y);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_g2_set_dash(int iw, int i0, int N, double *dashes, float *xx)
{
    g2_set_dash(i0, N, dashes);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_g2_draw_string(int iw, int i0, double x, double y, char *text,
    float *xx)
{
    g2_draw_string(i0, x, y, text);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_g2_clear(int iw, int i0)
{
    g2_clear(i0);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
_FUNCT_g2_ink(int iw, int i0, double red, double green, double blue, int i1)
{
    return g2_ink(i0, red, green, blue);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
_FUNCT_g2_close(int iw, int i0)
{
    g2_close(i0);
}
/*-------------------------------------------------------------------------*/
#endif
