/*************************************************************************
** funct-3.1      (command interpreter - funct_graph)                    **
** funct_graphcmd.c : one command                                        **
**                                                                       **
** Copyright (C) 2003  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      UMR 7586 du CNRS                                                 **
**      173, rue du Chevaleret                                           **
**      75013 Paris                                                      **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include "interp.h"
#include "funct_graph.h"


/*-------------------------------------------------------------------------
    function associated to the command 'funct_plot...' used to plot
    a function on a window or a PS-file.
-------------------------------------------------------------------------*/
int
functplot_cmd(int argc, char *argv[])
{
    int             i,
                    i0,
                    iw,
                    i1,
                    iw1,
                    i00,
                    iw0,
                    npoints;
    float          *Ix,
                   *xx,
                    xmin,
                    xmax,
                    dx,
                    x,
                    y,
                    ax,
                    bx,
                    u,
                    v,
                    ay,
                    by,
                    bx2,
                    by2,
                    xp,
                    yp,
                    x0,
                    y0,
                    x1,
                    y1,
                    X[2],
                    Y[2];
    char            h[200],
                  **c;
    funct_f        *a_f;
    funct_d        *a_d;
    funct_C        *a_C;
    funct_dC       *a_dC;
    flow_data      *flow_interp;
    funct_clip     *f_clip;

    flow_interp = (flow_data *) argv[-1];
    f_clip = (funct_clip *) flow_interp->extra[2];
    a_f = NULL;
    a_d = NULL;
    a_C = NULL;
    a_dC = NULL;
    iw0 = sketch_obj_restr(argv[1], &i00, _RFUNC_F, flow_interp);
    if (iw0 != _RFUNC_F) {
        iw0 = sketch_obj_restr(argv[1], &i00, _RFUNC_D, flow_interp);
        if (iw0 != _RFUNC_D) {
            iw0 = sketch_obj_restr(argv[1], &i00, _CFUNC_F, flow_interp);
            if (iw0 != _CFUNC_F) {
                iw0 = sketch_obj_restr(argv[1], &i00, _CFUNC_D, flow_interp);
                if (iw0 != _CFUNC_D) {
                    error_mess(flow_interp, _FUNC_MESS + 7);
                    return 1;
                }
            }
        }
    }
    c = (char **) Obj[iw0 - 1][i00].adresse;
    if (comp(argv[2], "X") == 1) {
        _FUNCT_OPEN_X11();
#ifdef __PLOTG2LIB_X11
        xx = _GRAPH_xx[_ind_plot];
#else
        xx = _GRAPH_xx;
#endif
#ifdef __G2LIB_X11
        iw1 = xx[2];
#else
        iw1 = -1;
#endif
    }
    else {
        iw1 = sketch_obj_restr(argv[2], &i1, _GRAPH_PS, flow_interp);
        if (iw1 != _GRAPH_PS) {
            error_mess(flow_interp, _GRAPH_MESS + 1);
            return 1;
        }
        xx = (float *) Obj[iw1 - 1][i1].adresse;
    }
    iw = sketch_obj_restr(argv[3], &i0, _GRAPH_FRAM, flow_interp);
    if (iw != _GRAPH_FRAM) {
        error_mess(flow_interp, _GRAPH_MESS + 3);
        return 1;
    }
    Ix = (float *) Obj[iw - 1][i0].adresse;
    sprintf(h, "xmin_f=%f", Ix[0]);
    convert_float(h, flow_interp);
    memset(h, 0, 200);
    sprintf(h, "xmax_f=%f", Ix[1]);
    convert_float(h, flow_interp);
    memset(h, 0, 200);
    sprintf(h, "ymin_f=%f", Ix[2]);
    convert_float(h, flow_interp);
    memset(h, 0, 200);
    sprintf(h, "ymax_f=%f", Ix[3]);
    convert_float(h, flow_interp);
    xmin = convert_float(argv[4], flow_interp);
    xmax = convert_float(argv[5], flow_interp);
    npoints = convert_float(argv[6], flow_interp);
    if (xmin >= xmax || npoints < 2) {
        error_mess(flow_interp, _FUNC_GRAPH_MESS);
        return 1;
    }
    ax = (Ix[1] - Ix[0]) / (f_clip->xsup_clip - f_clip->xinf_clip) / xx[0];
    bx = Ix[0] - ax * xx[0] * f_clip->xinf_clip;
    dx = (xmax - xmin) / npoints;
    if (iw0 == _RFUNC_F) {
        i = TX_f(c[0]);
        a_f = (funct_f *) c[0];
    }
    else {
        if (iw0 == _RFUNC_D) {
            i = TX_d(c[0]);
            a_d = (funct_d *) c[0];
        }
        else {
            if (iw0 == _CFUNC_F) {
                i = TX_C(c[0]);
                a_C = (funct_C *) c[0];
            }
            else {
                    i = TX_dC(c[0]);
                    a_dC = (funct_dC *) c[0];
            }
        }
    }
    if (i == 0) {
        error_mess(flow_interp, _FUNC_MESS + 19);
        return 1;
    }
    x = xmin;
    if (iw0 == _RFUNC_F)
        y = f_funct_eval(a_f, x);
    else {
        if (iw0 == _RFUNC_D)
            y = d_funct_eval(a_d, x);
        else {
            if (iw0 == _CFUNC_F)
                y = C_funct_eval(a_C, x).r;
            else
                y = dC_funct_eval(a_dC, x).r;
        }
    }
    u = (f_clip->xsup_clip - f_clip->xinf_clip) * xx[0];
    v = (f_clip->ysup_clip - f_clip->yinf_clip) * xx[1];
    ax = (Ix[1] - Ix[0]) / u;
    bx = Ix[0] - ax * xx[0] * f_clip->xinf_clip;
    ay = (Ix[3] - Ix[2]) / v;
    by = Ix[2] - ay * xx[1] * f_clip->yinf_clip;
    bx2 = - f_clip->xinf_clip * xx[0] / u;
    by2 = - f_clip->yinf_clip * xx[1] / v;
    xx[3] = (x - bx) / ax;
    xx[4] = (y - by) / ay;

    for (i = 0; i <= npoints; i++) {
        x = xmin + i * dx;
        if (iw0 == _RFUNC_F)
            y = f_funct_eval(a_f, x);
        else {
            if (iw0 == _RFUNC_D)
                y = d_funct_eval(a_d, x);
            else {
                if (iw0 == _CFUNC_F)
                    y = C_funct_eval(a_C, x).r;
                else
                    y = dC_funct_eval(a_dC, x).r;
            }
        }
        xp = (x - bx) / ax;
        yp = (y - by) / ay;
        x0 = xp / u + bx2;
        y0 = yp / v + by2;
        x1 = xx[3] / u + bx2;
        y1 = xx[4] / v + by2;
        xx[3] = xp;
        xx[4] = yp;
        if (clip_line(x0, x1, y0, y1, X, Y) == 1) {
#ifndef __PLOTLIB_X11
            _FUNCT_SET_LINE_WIDTH(iw1, xx[2], .5, xx);
#endif
            _FUNCT_PLOT(iw1, xx[2], (double) ((X[0] - bx2) * u),
                (double)((Y[0] - by2) * v), xx);
            _FUNCT_LINE_TO(iw1, xx[2], (double)((X[1] - bx2) * u),
                (double)((Y[1] - by2) * v), xx);
        }
    }

    return 0;
}
/*-----------------------------------------------------------------------*/
