/*************************************************************************
** funct-3.1      (command interpreter - funct)                          **
** main.c : main file                                                    **
**                                                                       **
** Copyright (C) 2003  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      UMR 7586 du CNRS                                                 **
**      173, rue du Chevaleret                                           **
**      75013 Paris                                                      **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include "interp.h"
#include "funct_graph.h"
#include "geom.h"

/*---------------------------------------------------------------------------
    Graphic library specific variables
---------------------------------------------------------------------------*/
#ifndef __PLOTG2LIB_X11
int              ind0k_gr;
float            _GRAPH_xx[20];
#endif

#ifdef __GGILIB_X11
#include <ggi/ggi.h>
ggi_mode         s;
ggi_color        white;
ggi_color        black;
int              _nb_ggi_color,
                 ggi_line_width;
ggi_visual_t     ggi_vis;
ggi_color       *ggi_col;
ggi_pixel        color_ggi,
                 color_white,
                 color_black;
#endif
#ifdef __ALLEGROLIB_X11
#include <allegro.h>
int             _nb_allegro_color,
               *allegro_col;
#endif
#ifdef __PLOTLIB_X11
#include <plot.h>
FILE          **plot_fic;
plPlotter     **plotter,
              **plotter2;
int             _nb_plot_color,
                _ind_plot,
                _nb_plot_max,
                _nb_plot_max2,
               *ind0k_gr,
               *plot_color_red,
               *plot_color_green,
               *plot_color_blue;
float         **_GRAPH_xx;
#endif
#ifdef __G2LIB_X11
int             _nb_plot_color,
                _ind_plot,
                _nb_plot_max,
                _nb_plot_max2,
               *ind0k_gr;
float         **_GRAPH_xx;
#endif
/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/


int             _XRANGE_F        = 1;
int             _XRANGE_D        = 2;
int             _RFUNC_F         = 3;
int             _RFUNC_D         = 4;
int             _CFUNC_F         = 5;
int             _CFUNC_D         = 6;
int             _FOUR_TR         = 7;
int             _BESS_PAR        = 8;
int             _FUNC_MESS       = 0;
int             _GRAPH_MESS      = 26;
int             _FUNC_GRAPH_MESS = 36;
int             _GEOM_MESS       = 37;
int             _GRAPH_PS        = 9;
int             _GRAPH_COL       = 10;
int             _GRAPH_FRAM      = 11;
int             _GEOM_POINT      = 12;
int             _GEOM_VECTOR     = 13;
int             _GEOM_LINE       = 14;
int             _GEOM_CIRC       = 15;
int             _GEOM_POLYG      = 16;
int             _GEOM_LINTR      = 17;
int             _GEOM_AFFTR      = 18;
int             _GEOM_GENTR      = 19;
int             _GRAPH_X,
                _GRAPH_Y,
                _nang_circ,
	        i_pl_g2;
double         *cos_circ;
double         *sin_circ;
void            init_prog_graph(flow_data *);

pfi *proc[] =
{
    proc_func,
    proc_graph,
    proc_func_graph,
    proc_geom,
    NULL,
};

FUNCTION    *Funcs;
FUNCTIONC   *Funcs_C;
FUNCTIONGen *Funcs_Gen[] = {
};


/*-------------------------------------------------
    No custom sections of the initialization file
-------------------------------------------------*/
pfib                procb_user[] = {
    NULL,
};
char               *namesb_user[] = {
    "",
};
/*-------------------------------------------------
-------------------------------------------------*/

extern int      int_nb;
extern char     int_txt[];


                    /*--------------------------*/


/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
main(int argc, char *argv[])
{
    Funcs = Funcs_func;
    Funcs_C = Funcs_interp_C;
    _NBFONC = _NBFONC_FUNC;
    _NBFONC_C = _NBFONC0_C;
    User_Init_File = ".funct-3.1";
    prog_c(argc, argv, NULL, int_txt, int_nb, NULL, 0);
    return 0;
}
#ifdef __ALLEGROLIB_X11
END_OF_MAIN();
#endif
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
     Sets the default size of frames
---------------------------------------------------------------------------*/
void
init_prog_graph(flow_data *flow_interp)
{
    funct_clip     *f_clip;

    f_clip = (funct_clip *) flow_interp->extra[2];
    f_clip->xinf_clip = 0.15;
    f_clip->xsup_clip = 0.9;
    f_clip->yinf_clip = 0.1;
    f_clip->ysup_clip = 0.9;
}
/*-------------------------------------------------------------------------*/







/*---------------------------------------------------------------------------
-----------------------------------------------------------------------------
    Functions required by the command interpreter
-----------------------------------------------------------------------------
---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------
    Initializations
---------------------------------------------------------------------------*/
void
init_prog(flow_data *flow_interp)
{
    int             i,
                    j,
                    m;
    double          t,
                    dt;

#ifndef __PLOTG2LIB_X11
    for (i = 0; i < 20; i++)
        _GRAPH_xx[i] = 0.;
    _GRAPH_xx[8] = 1.;
#endif
    init_prog_graph(flow_interp);
    _GRAPH_X = S_convert_int("x_win", flow_interp);
    _GRAPH_Y = S_convert_int("y_win", flow_interp);
    ind0k_gr = 0;
    m = S_convert_int("nbcol", flow_interp);
#ifdef __GGILIB_X11
    white.r = 65500;
    white.g = 65500;
    white.b = 65500;
    black.r = 0;
    black.g = 0;
    black.b = 0;
    _nb_ggi_color = 0;
    ggi_col = (ggi_color *) malloc((size_t) m * sizeof(ggi_color));
#endif
#ifdef __ALLEGROLIB_X11
    _nb_allegro_color = 0;
    allegro_col = (int *) malloc((size_t) m * sizeof(int));
#endif
#ifdef __PLOTLIB_X11
    _nb_plot_color = 0;
    _ind_plot = 0;
    plot_color_red = (int *) malloc((size_t) m * sizeof(int));
    plot_color_green = (int *) malloc((size_t) m * sizeof(int));
    plot_color_blue = (int *) malloc((size_t) m * sizeof(int));
    _nb_plot_max = S_convert_int("nb_win", flow_interp);
    if (_nb_plot_max <= 0) {
        printf("Incorrect maximal number of windows\n");
        printf("check the value of nb_win in the section !var in ~\\.funct\n");
        exit(0);
    }
    plotter = (plPlotter **) malloc((size_t) _nb_plot_max *
        sizeof(plPlotter *));
    _nb_plot_max2 = S_convert_int("nb_win2", flow_interp);
    if (_nb_plot_max2 <= 0) {
        printf("Incorrect maximal number of graphics\n");
        printf("check the value of nb_win2 in the section !var in ~\\.funct\n");
        exit(0);
    }
    plotter2 = (plPlotter **) malloc((size_t) _nb_plot_max2 *
        sizeof(plPlotter *));
    for (i = 0; i < _nb_plot_max2; i++)
        plotter2[i] = NULL;
    plot_fic = (FILE **) malloc((size_t) _nb_plot_max2 * sizeof(FILE *));

    for (i = 0; i < _nb_plot_max2; i++) {
        plotter2[i] = NULL;
        plot_fic[i] = NULL;
    }
#endif

#ifdef __PLOTG2LIB_X11
    _nb_plot_max = S_convert_int("nb_win", flow_interp);
    if (_nb_plot_max <= 0) {
        printf("Incorrect maximal number of windows\n");
        printf("check the value of nb_win in the section !var in ~\\.funct\n");
        exit(0);
    }
    ind0k_gr = (int *) malloc((size_t) _nb_plot_max * sizeof(int));
    for (i = 0; i < _nb_plot_max; i++)
        ind0k_gr[i] = 0;
    _ind_plot = 0;
    _GRAPH_xx = (float **) malloc((size_t) _nb_plot_max * sizeof(float *));

    for (i = 0; i < _nb_plot_max; i++) {
        _GRAPH_xx[i] = (float *) malloc((size_t) 20 * sizeof(float));
        for (j = 0; j < 20; j++)
            _GRAPH_xx[i][j] = 0;
        _GRAPH_xx[i][8] = 1;
    }
#endif
    Obj_typ[_GEOM_VECTOR - 1].X = Oper_Vector;
    Obj_typ[_GEOM_LINTR - 1].X = Oper_LinTransform;

/*-------------------------------------------
    Coordinates of points on the unit circle
-------------------------------------------*/
    _nang_circ = S_convert_int("nang_circ", flow_interp);
    cos_circ = (double *) malloc((size_t) (_nang_circ + 1) * sizeof(double));
    sin_circ = (double *) malloc((size_t) (_nang_circ + 1) * sizeof(double));
    dt = PID / _nang_circ;

    for (i = 0; i <= _nang_circ; i++) {
        t = i * dt;
        cos_circ[i] = cos(t);
        sin_circ[i] = sin(t);
    }
/*-----------------------------------------*/
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
init_thread_param(flow_data *flow_interp)
{
    funct_clip     *f_clip;

    f_clip = (funct_clip *) malloc((size_t) sizeof(funct_clip));
    flow_interp->extra[2] = (char *) f_clip;
    init_prog_graph(flow_interp);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
    No additional expression evaluators here
---------------------------------------------------------------------------*/
void init_expr_GEN(flow_data *flow_interp)
{
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
clean_thread_param(flow_data *flow_interp)
{
    funct_clip     *f_clip;

    f_clip = (funct_clip *) flow_interp->extra[2];
    free(f_clip);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void
exit_prog()
{
#ifdef __GGILIB_X11
    if (ind0k_gr != 0)
        ggiExit();
#endif
#ifdef __ALLEGROLIB_X11
    if (ind0k_gr != 0)
        allegro_exit();
#endif
    free(cos_circ);
    free(sin_circ);
    exit(0);
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
    Destruction of type 7 objects
---------------------------------------------------------------------------*/
void
dest_prop(int typ, int i0, flow_data *flow_interp)
{
    int             N;
    float          *xx;
    Point          *p;
    Line           *lin;
    Circle         *circ;
    Vector         *v;
    Polygon        *s;
    LinTransform   *ltr;
    AffTransform   *atr;
    GenTransform   *gtr;
    char          **e;

    N = typ + 1;

    switch(N) {
        case 9 :
            xx = (float *) Obj[typ][i0].adresse;
            _FUNCT_CLOSE(typ + 1, (int) xx[2]);
            break;
        case 12 :
            e = (char **) Obj[_GEOM_POINT - 1][i0].adresse;
            p = (Point *) e[0];
            free(p);
            break;
        case 13 :
            e = (char **) Obj[_GEOM_VECTOR - 1][i0].adresse;
            v = (Vector *) e[0];
            free(v);
            break;
        case 14 :
            e = (char **) Obj[_GEOM_LINE - 1][i0].adresse;
            lin = (Line *) e[0];
            free(lin);
            break;
        case 15 :
            e = (char **) Obj[_GEOM_CIRC - 1][i0].adresse;
            circ = (Circle *) e[0];
            free(circ);
            break;
        case 16 :
            e = (char **) Obj[_GEOM_POLYG - 1][i0].adresse;
            s = (Polygon *) e[0];
            if (s->vertex != NULL)
                free(s->vertex);
            if (s->tgt != NULL)
                free(s->tgt);
            if (s->d_tgt != NULL)
                free(s->d_tgt);
            if (s->def_tgt != NULL)
                free(s->def_tgt);
            free(s);
            break;
        case 17 :
            e = (char **) Obj[_GEOM_LINTR - 1][i0].adresse;
            ltr = (LinTransform *) e[0];
            free(ltr);
            break;
        case 18 :
            e = (char **) Obj[_GEOM_AFFTR - 1][i0].adresse;
            atr = (AffTransform *) e[0];
            free(atr);
            break;
        case 19 :
            e = (char **) Obj[_GEOM_GENTR - 1][i0].adresse;
            gtr = (GenTransform *) e[0];
            free(gtr->X);
            free(gtr->Y);
            free(gtr);
            break;
        default :
            dest_prop_func(typ, i0, flow_interp);
    }
}
/*-------------------------------------------------------------------------*/








/*---------------------------------------------------------------------------
    Miscellaneous commands
---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------
    Command waiting for a keystroke
---------------------------------------------------------------------------*/
int
wait_cmd(int argc, char *argv[])
{
    getchar();
    return 0;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
Xflush_cmd(int argc, char *argv[])
{
#ifdef __GGILIB_X11
    if (ind0k_gr == 1)
        ggiFlush(ggi_vis);
#endif
    return 0;
}
/*-------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int
sleep_cmd(int argc, char *argv[])
{
    double          x;
    struct timespec t1,
                    t2;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];

    x = convert_float(argv[1], flow_interp);
    t1.tv_sec = (long int) floor(x / 1000.);
    x = x - 1000. * (double) t1.tv_sec;
    t1.tv_nsec = (long int) 1000000. * x;
    nanosleep(&t1, &t2);
    return 0;
}
/*-------------------------------------------------------------------------*/



