#include <qlayout.h>
#include <qpainter.h>
#include <qpushbt.h>
#include <qtooltip.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kseparator.h>

#include "kfunctoolbar.moc"
#include "koverview.h"

RCSTAG( "$Id: kfunctoolbar.cpp,v 1.16 1997/12/24 11:20:29 kde Exp $" );


KFunctionSpinBox::KFunctionSpinBox( QList<KFunction>*& list, QWidget* parent )
  : KSpinBox( parent )
{
  connect( this, SIGNAL( valueIncreased() ), SLOT( slotIncrease() ) );
  connect( this, SIGNAL( valueDecreased() ), SLOT( slotDecrease() ) );

  _list = list;
  setValue( "" );
} // KFunctionSpinBox constructor


void
KFunctionSpinBox::setIndex( uint index )
{ 
  // check if the index is in the valid range
  if ( index < _list->count() ) {
    setValue( _list->at( _index = index )->text );
    emit selected( _list->at( _index ) );
  } // if
} // KFunctionSpinBox::setIndex


void
KFunctionSpinBox::slotIncrease()
{
  if ( _list->count() == 0 ) {
    setValue( "" );
    return;
  } // if

  _index = ( _index < _list->count()-1 ? _index + 1 : 0 );
  setIndex( _index );
} // KFunctionSpinBox::slotIncrease

void
KFunctionSpinBox::slotDecrease()
{
  if ( _list->count() == 0 ) return;
  _index = ( _index > 0 ? _index : _list->count() ) - 1;
  setIndex( _index );
} // KFunctionSpinBox::slotDecrease


KFunctionToolBar::KFunctionToolBar( QWidget* parent ) : KToolBar( parent )
{
  QBoxLayout* l = new QHBoxLayout( this, 2 );
  CHECK_PTR( l );

  sb = new KFunctionSpinBox( functions, this );
  CHECK_PTR( sb );
  l->addSpacing( 10 );
  l->addWidget( sb, 20 );

  fbtn = new KFunctionButton( static_cast<KFunction*>( NULL ), this );
  CHECK_PTR( fbtn );
  QToolTip::add( fbtn,
	 klocale->translate( "change the properties of this expression" ) );
  connect( sb, SIGNAL( selected( KFunction* ) ), fbtn,
	   SLOT( setFunction( KFunction* ) ) );
  connect( fbtn, SIGNAL( clicked() ), SLOT( edit() ) );
  l->addSpacing( 5 );
  l->addWidget( fbtn, 10 );

  QPushButton* btn = new QPushButton( klocale->translate( "new" ), this );
  CHECK_PTR( btn );
  QToolTip::add( btn, klocale->translate( "add a new expression" ) );
  connect( btn, SIGNAL( clicked() ), kapp, SLOT( newExpression() ) );
  l->addSpacing( 10 );
  l->addWidget( btn, 10 );

  btn = new QPushButton( klocale->translate( "delete" ), this );
  CHECK_PTR( btn );
  QToolTip::add( btn, klocale->translate( "delete this expression" ) );
  connect( btn, SIGNAL( clicked() ), this, SLOT( del() ) );
  l->addSpacing( 5 );
  l->addWidget( btn, 10 );

  KSeparator* sep = new KSeparator( VLine, this );
  CHECK_PTR( sep );
  l->addSpacing( 3 );
  l->addWidget( sep, 1 );

  btn = new QPushButton( this );
  CHECK_PTR( btn );
  QToolTip::add( btn, klocale->translate( "unzoom" ) );
  QPixmap pm = kapp->getIconLoader()->loadIcon( "viewmag-.xpm" );
  btn->setFixedSize( pm.width(), pm.height() );
  btn->setPixmap( pm );
  connect( btn, SIGNAL( clicked() ), parent, SIGNAL( unzoom() ) );
  l->addSpacing( 3 );
  l->addWidget( btn, 2 );
  l->addSpacing( 5 );

  connect( kapp, SIGNAL( expressionAdded() ), SLOT( expressionAdded() ) );
  connect( kapp, SIGNAL( expressionDeleted( uint ) ),
	   SLOT( expressionDeleted( uint ) ) );
  connect( this, SIGNAL( delExpression( uint ) ),
	   kapp, SLOT( delExpression( uint ) ) );
} // KFunctionToolBar constructor


void
KFunctionToolBar::edit()
{
  if ( !functions->count() ) return;

  KFunction* f;
  f = functions->at( sb->getIndex() );
  if ( !f ) return;

  KSettingsDialog* dlg = new KSettingsDialog( f, parentWidget() );
  CHECK_PTR( dlg );
  dlg->exec();
  delete dlg;

  // update the toolbar
  sb->setIndex( sb->getIndex() ); // this will also update the button showing
                                  // the linestyle
} // KFunctionToolBar::edit


void
KFunctionToolBar::del()
{
  if ( !functions->count() ) return;

  emit delExpression( sb->getIndex() );
} // KFunctionToolBar::del


void
KFunctionToolBar::expressionAdded()
{
  // first function added?
  if ( functions->count() == 1 ) {
    fbtn->setFunction( functions->at( 0 ) );
    sb->slotIncrease();
  } // if
} // KFunctionToolBar::expressionAdded


void
KFunctionToolBar::expressionDeleted( uint index )
{
  if ( index == sb->getIndex() ) {
    sb->slotIncrease();

    if ( functions->count() == 0 ) fbtn->setFunction(
					     static_cast<KFunction*>( NULL ) );
    else fbtn->setFunction( functions->at( sb->getIndex() ) );
  } // if
} // KFunctionToolBar::expressionDeleted


KFunctionButton::KFunctionButton( KFunction* f, QWidget* parent )
  : QPushButton( "", parent )
{
  _f = f;
} // KFunctionButton constructor


void
KFunctionButton::setFunction( KFunction* f )
{
  _f = f;

  repaint( TRUE );
} // KFunctionButton::setFunction


void
KFunctionButton::drawButtonLabel( QPainter* paint )
{
  if ( !_f ) return;

  paint->setPen( _f->pen );

  if ( isDown() ) {
    paint->moveTo( 7, height() / 2 + 2 );
    paint->lineTo( width() - 3, height() / 2 + 2 );
  }
  else {
    paint->moveTo( 5, height() / 2 );
    paint->lineTo( width() - 5, height() / 2 );
  }
} // KFunctionButton::drawButtonLabel

