#include <qbttngrp.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qtooltip.h>
#include <qvalidator.h>
#include <qpushbt.h>
#include <kapp.h>
#include <kcolordlg.h>
#include <kmsgbox.h>

#include "koverview.moc"

RCSTAG( "$Id: koverview.cpp,v 1.19 1997/12/23 12:34:48 kde Exp $" );

//#define __DEBUG

KOverviewDlg::KOverviewDlg( QWidget* parent ) : QTabDialog( parent,
							 "overviewdlg", TRUE )
{
  setCaption( klocale->translate( "Overview" ) );

  QWidget* w = new KExpressionListDlg( this );
  CHECK_PTR( w );
  addTab( w, w->caption() );

  w = new KCoordinatesDlg( this );
  CHECK_PTR( w );
  addTab( w, w->caption() );
  connect( this, SIGNAL( applyButtonPressed() ), w, SLOT( Ok() ) );

  w = new KGridDialog( this );
  CHECK_PTR( w );
  addTab( w, w->caption() );
  connect( this, SIGNAL( applyButtonPressed() ), w, SLOT( Ok() ) );
} // KOverview constructor


KExpressionListDlg::KExpressionListDlg( QWidget* parent ) : QWidget( parent )
{
  setCaption( klocale->translate( "&Expressions" ) );

  lb = new QListBox( this );
  CHECK_PTR( lb );
  connect( lb, SIGNAL( selected( int ) ), SLOT( settings() ) );
  QToolTip::add( lb, klocale->translate( "The expressions you have entered") );

  QHBoxLayout* hbox = new QHBoxLayout( this );
  CHECK_PTR( hbox );
  hbox->addWidget( lb, 2 );

  QVBoxLayout* vbox = new QVBoxLayout();
  CHECK_PTR( vbox );
  hbox->addSpacing( 5 );
  hbox->addLayout( vbox, 1 );
  
  QPushButton* btn = new QPushButton( klocale->translate( "&Settings" ),
				      this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( settings() ) );
  QToolTip::add( btn, klocale->translate( "Opens a dialog to set e.g. the line"
					  " color" ) );
  vbox->addSpacing( 5 );
  vbox->addWidget( btn, 1 );
  vbox->addStretch( 1 );

  btn = new QPushButton( klocale->translate( "&Delete" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( deleteExpression() ) );
  QToolTip::add( btn, klocale->translate( "Delete the selected expression" ) );
  vbox->addWidget( btn, 1 );
  vbox->addStretch( 1 );
  
  btn = new QPushButton( klocale->translate( "&New" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( newExpression() ) );
  QToolTip::add( btn, klocale->translate( "Add a new expression" ) );
  vbox->addWidget( btn, 1 );

  vbox->addStretch( 3 );

  hbox->addSpacing( 5 );

  // add the current functions to the listbox
  uint n;
  for( n = 0; n < functions->count(); n++ ) {
    lb->insertItem( functions->at( n )->text );
  } // for

  connect( this, SIGNAL( expressionAdded() ), kapp, SIGNAL( expressionAdded() )
	   );
  connect( this, SIGNAL( expressionDeleted( uint ) ), kapp,
	   SIGNAL( expressionDeleted( uint ) ) );
} // KExpressionListDlg constructor


void
KExpressionListDlg::settings()
{
  int n;
  if ( ( n = lb->currentItem() ) != -1 ) {
    KFunction* f = functions->at( n );

    KSettingsDialog* dlg = new KSettingsDialog( f, this );
    CHECK_PTR( dlg );
    dlg->exec();
    delete dlg;
  } // if
} // KExpressionListDlg::settings


void
KExpressionListDlg::deleteExpression()
{
  int n;
  if ( ( n = lb->currentItem() ) != -1 ) {
    lb->removeItem( n );
    functions->remove( n );

    emit expressionDeleted( n );

    // doesn't work !?!
    kapp->mainWidget()->repaint( TRUE );
  } // if
} // KExpressionListDlg::delete

void
KExpressionListDlg::newExpression()
{
  KFunction* f = new KFunction;
  CHECK_PTR( f );
  f->text = "";
  f->pen = black;

  KSettingsDialog* dlg = new KSettingsDialog( f, this );
  if ( dlg->exec() ) {
    functions->append( f );
    lb->insertItem( f->text );

    emit expressionAdded();

    kapp->mainWidget()->repaint( TRUE );
  } // if
  else delete f;
} // KExpressionListDlg::newExpression



KCoordinatesDlg::KCoordinatesDlg( QWidget* parent ) : QWidget( parent )
{
  setCaption( klocale->translate( "&Coordinates" ) );

  QHBoxLayout* hbox1 = new QHBoxLayout( this );
  CHECK_PTR( hbox1 );
  hbox1->addSpacing( 5 );

  QVBoxLayout* vbox1 = new QVBoxLayout();
  CHECK_PTR( vbox1 );
  hbox1->addLayout( vbox1, 4 );
  
  ex = new KCoordExample( this );
  CHECK_PTR( ex );
  vbox1->addSpacing( 5 );
  vbox1->addWidget( ex, 5 );

  QHBoxLayout* hbox2 = new QHBoxLayout();
  CHECK_PTR( hbox2 );
  vbox1->addLayout( hbox2, 2 );
  vbox1->addSpacing( 5 );

  QVBoxLayout* vbox3 = new QVBoxLayout();
  CHECK_PTR( vbox3 );
  hbox2->addLayout( vbox3, 1 );
  
  QLabel* l = new QLabel( "minX", this );
  CHECK_PTR( l );
  vbox3->addWidget( l, 1 );

  leMinX = new KLined( this, "leMinX" );
  CHECK_PTR( leMinX );
  vbox3->addWidget( leMinX, 1 );
  QDoubleValidator* val = new QDoubleValidator( -1000, 1000, 5, leMinX );
  CHECK_PTR( val );
  leMinX->setValidator( val );
  QToolTip::add( leMinX, klocale->translate( "the x-coordinate on the left"
					    " screen border" ) );

  QVBoxLayout* vbox4 = new QVBoxLayout();
  CHECK_PTR( vbox4 );
  hbox2->addSpacing( 5 );
  hbox2->addLayout( vbox4, 1 );
  hbox2->addStretch( 2 );
  
  l = new QLabel( "minY", this );
  CHECK_PTR( l );
  vbox4->addWidget( l, 1 );

  leMinY = new KLined( this, "leMinY" );
  CHECK_PTR( leMinY );
  vbox4->addWidget( leMinY, 1 );
  val = new QDoubleValidator( -1000, 1000, 5, leMinY );
  CHECK_PTR( val );
  leMinY->setValidator( val );
  QToolTip::add( leMinY, klocale->translate( "the y-coordinate on the lower"
					     " screen border" ) );


  QVBoxLayout* vbox5 = new QVBoxLayout();
  CHECK_PTR( vbox5 );
  hbox1->addSpacing( 5 );
  hbox1->addLayout( vbox5, 1 );
  hbox1->addSpacing( 5 );

  l = new QLabel( "maxX", this );
  CHECK_PTR( l );
  vbox5->addWidget( l, 1 );

  leMaxX = new KLined( this, "leMaxX" );
  CHECK_PTR( leMaxX );
  vbox5->addWidget( leMaxX, 1 );
  vbox5->addSpacing( 5 );
  val = new QDoubleValidator( -1000, 1000, 5, leMaxX );
  CHECK_PTR( val );
  leMaxX->setValidator( val );
  QToolTip::add( leMaxX, klocale->translate( "the x-coordninate on the right"
					     " screen border" ) );

  l = new QLabel( "maxY", this );
  CHECK_PTR( l );
  vbox5->addWidget( l, 1 );

  leMaxY = new KLined( this, "leMaxY" );
  CHECK_PTR( leMaxY );
  vbox5->addWidget( leMaxY, 1 );
  val = new QDoubleValidator( -1000, 1000, 5, leMaxY );
  CHECK_PTR( val );
  leMaxY->setValidator( val );
  QToolTip::add( leMaxY, klocale->translate( "the y-coordinate on the upper"
					     " screen border" ) );

  vbox5->addStretch( 4 );

  QString s;
  s.setNum( minX );
  leMinX->setText( s );

  s.setNum( minY );
  leMinY->setText( s );

  s.setNum( maxX );
  leMaxX->setText( s );

  s.setNum( maxY );
  leMaxY->setText( s );
} // KCoordinatesDlg constructor


void
KCoordinatesDlg::Ok()
{
  QString s;
  s = leMinX->text();
  minX = s.toDouble();

  s = leMinY->text();
  minY = s.toDouble();

  s = leMaxX->text();
  maxX = s.toDouble();

  s = leMaxY->text();
  maxY = s.toDouble();

  kapp->mainWidget()->repaint( TRUE );
} // KCoordinatesDlg::Ok


void
KCoordExample::paintEvent( QPaintEvent* e )
{
  QFrame::paintEvent( e );

  QPainter p( this );
  p.setPen( QPen( black, 2 ) );

  p.drawRect( 10, 10, width()-92, height()-35 );
  p.moveTo( 10, ( height()-35 ) / 2 );
  p.lineTo( width()-82, ( height()-35 ) / 2 );

  p.moveTo( ( width()-92 ) / 2, 10 );
  p.lineTo( ( width()-92 ) / 2, height()-25 );

  p.drawText( 5, height() - 7, "(minX|minY)" );
  p.drawText( width()-80, 18, "(maxX|maxY)" );
} // KCoordExample::paintEvent



KSettingsDialog::KSettingsDialog( KFunction* f, QWidget* parent )
  : QDialog( parent, "settingsdlg", TRUE )
{
  setCaption( klocale->translate( "settings" ) );

  _f = f;

  QHBoxLayout* hbox1 = new QHBoxLayout( this );
  CHECK_PTR( hbox1 );
  QVBoxLayout* vbox1 = new QVBoxLayout();
  CHECK_PTR( vbox1 );
  hbox1->addSpacing( 5 );
  hbox1->addLayout( vbox1, 3 );
  vbox1->addSpacing( 5 );

  le = new KLined( this, "f(x)" );
  CHECK_PTR( le );
  QToolTip::add( le, klocale->translate( "the function term" ) );
  QLabel* label = new QLabel( le, "f(&x)=", this );
  CHECK_PTR( label );
  label->setAlignment( AlignCenter | ShowPrefix );
  QBoxLayout* tmp = new QHBoxLayout();
  CHECK_PTR( tmp );
  vbox1->addLayout( tmp, 1 );
  tmp->addWidget( label, 1 );
  tmp->addWidget( le, 5 );
  vbox1->addSpacing( 5 );

  QVBoxLayout* vbox2 = new QVBoxLayout();
  CHECK_PTR( vbox2 );
  hbox1->addSpacing( 8 );
  hbox1->addLayout( vbox2, 1 );
  hbox1->addSpacing( 5 );

  QHBoxLayout* hbox2 = new QHBoxLayout();
  CHECK_PTR( hbox2 );
  vbox1->addLayout( hbox2, 5 );
  vbox1->addSpacing( 5 );
  
  lb = new QListBox( this );
  CHECK_PTR( lb );
  tmp = new QVBoxLayout();
  CHECK_PTR( tmp );
  hbox2->addLayout( tmp, 3 );
  label = new QLabel( lb, klocale->translate( "line &style" ), this );
  CHECK_PTR( label );
  tmp->addWidget( label, 1 );
  tmp->addWidget( lb, 6 );
  hbox2->addSpacing( 5 );
  
  QVBoxLayout* vbox3 = new QVBoxLayout();
  CHECK_PTR( vbox3 );
  hbox2->addLayout( vbox3, 2 );
  
  QPushButton* btn = new QPushButton( klocale->translate( "&Color" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( color() ) );
  vbox3->addWidget( btn, 1 );
  vbox3->addStretch( 3 );

  vbox2->addSpacing( 5 );
  btn = new QPushButton( klocale->translate( "Ok" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( ok() ) );
  btn->setDefault( TRUE );
  vbox2->addWidget( btn, 1 );
  vbox2->addSpacing( 5 );
  btn = new QPushButton( klocale->translate( "Cancel" ), this );
  CHECK_PTR( btn );
  connect( btn, SIGNAL( clicked() ), SLOT( cancel() ) );
  vbox2->addWidget( btn, 1 );
  vbox2->addStretch( 4 );

  resize( 340, 220 );

  // fill the list box
  // later, the line styles will be shown directly by creating a new
  //   QListBoxItem
  lb->insertItem( klocale->translate( "solid" ) );
  lb->insertItem( klocale->translate( "dashes" ) );
  lb->insertItem( klocale->translate( "dots" ) );
  lb->insertItem( klocale->translate( "dash dot" ) );
  lb->insertItem( klocale->translate( "dash dot dot" ) );

  //  lb->setCurrentItem( 0 );
  lb->setCurrentItem( _f->pen.style() - 1 );

  le->setText( _f->text );

  newColor = _f->pen.color();

  le->setFocus();
} // KSettingsDialog constructor


void
KSettingsDialog::color()
{
  KColorDialog::getColor( newColor );
} // KSettingsDialog::color


void
KSettingsDialog::ok()
{
  KExpression* tmp = new KExpression;
  CHECK_PTR( tmp );
  
  int nError = tmp->parse( le->text() );
  delete tmp;

  if ( nError != err_Ok ) {
    QString s = "";
    switch( nError ) {
    case err_TooManyClosingBrackets: {
      s = klocale->translate( "There are too many closing brackets in this "
			      "expression" ); break;
    }
    case err_ClosingBracketMissing: {
      s = klocale->translate( "There is a closing bracket missing in this "
			      "expression" ); break;
    }
    case err_funcCallUnknown: {
      s = klocale->translate( "You're referring to an undefined function" );
      break;
    }
    case err_wrongNumberOfParameters: {
      s = klocale->translate( "You're giving a wrong number of parameters in"
			      " a function call" ); break;
    }
    case err_constantUnknown: {
      s = klocale->translate( "You're reffering to an undefined constant" );
      break;
    }
    case err_notANumber: {
      s = klocale->translate( "Not a number!" ); break;
    }
    case err_expressionEmpty: {
      s = klocale->translate( "A partial expression is an empty string" );
      break;
    }
    } // switch

    KMsgBox::message( this, klocale->translate( "error" ), s,
		      KMsgBox::EXCLAMATION );
    return;
  } // if

  _f->pen.setColor( newColor );
  _f->pen.setStyle( static_cast<PenStyle>( lb->currentItem() + 1 ) );
  _f->text = le->text();
  _f->expression.parse( _f->text );

  done( TRUE );
} // KSettingsDialog::ok


void
KSettingsDialog::cancel()
{
  done( FALSE );
} // KSettingsDialog::cancel


KLineStyleItem::KLineStyleItem( PenStyle style ) : QListBoxItem()
{
  _style = style;
} // KLineStyleItem constructor


void
KLineStyleItem::paint( QPainter* p )
{
  QPen pen( _style );
  p->setPen( pen );
  p->moveTo( 0, 5 );
  p->lineTo( 100, 5 );
} // KLineStyleItem::paint



KGridDialog::KGridDialog( QWidget* parent ): QWidget( parent )
{
  QLabel* lab;

  setCaption( klocale->translate( "&Grid" ) );

  QHBoxLayout* hbox = new QHBoxLayout( this, 5 );
  CHECK_PTR( hbox );

  QVBoxLayout* vbox = new QVBoxLayout();
  CHECK_PTR( vbox );
  hbox->addLayout( vbox );
  hbox->addSpacing( 5 );

  QButtonGroup* btngrp = new QButtonGroup( klocale->translate( "grid" ),
					   this );
  CHECK_PTR( btngrp );
  vbox->addWidget( btngrp, 4 );
  //  vbox->addSpacing( 5 );

  QVBoxLayout* vboxBtns = new QVBoxLayout( btngrp, 20, 5 );
  CHECK_PTR( vboxBtns );

  rb[0] = new QRadioButton( klocale->translate( "off" ), this );
  CHECK_PTR( rb[0] );
  btngrp->insert( rb[0] );
  vboxBtns->addWidget( rb[0] );
  if ( showGrid == grid_Off ) rb[0]->setChecked( TRUE );

  rb[1] = new QRadioButton( klocale->translate( "text on axes" ), this );
  CHECK_PTR( rb[1] );
  btngrp->insert( rb[1] );
  vboxBtns->addWidget( rb[1] );
  if ( showGrid == grid_Axes ) rb[1]->setChecked( TRUE );

  rb[2] = new QRadioButton( klocale->translate( "grid" ), this );
  CHECK_PTR( rb[2] );
  btngrp->insert( rb[2] );
  vboxBtns->addWidget( rb[2] );
  if ( showGrid == grid_Grid ) rb[2]->setChecked( TRUE );

  rb[3] = new QRadioButton( klocale->translate( "dots" ), this );
  CHECK_PTR( rb[3] );
  btngrp->insert( rb[3] );
  vboxBtns->addWidget( rb[3] );
  if ( showGrid == grid_Dots ) rb[3]->setChecked( TRUE );

  
  // the edit lines
  QHBoxLayout* hb = new QHBoxLayout();
  CHECK_PTR( hb );
  vbox->addLayout( hb, 1 );
  leX = new KLined( this, "leX" );
  CHECK_PTR( leX );
  lab = new QLabel( leX, klocale->translate( "grid &width" ), this );
  CHECK_PTR( lab );
  hb->addWidget( lab, 1 );
  hb->addWidget( leX, 2 );
  QDoubleValidator* val = new QDoubleValidator( 0.0000000001, 1000, 5, leX );
  CHECK_PTR( val );
  leX->setValidator( val );

  hb = new QHBoxLayout();
  CHECK_PTR( hb );
  vbox->addLayout( hb, 1 );
  leY = new KLined( this, "leY" );
  CHECK_PTR( leY );
  lab = new QLabel( leY, klocale->translate( "grid &height" ), this );
  CHECK_PTR( lab );
  hb->addWidget( lab, 1 );
  hb->addWidget( leY, 2 );
  val = new QDoubleValidator( 0.0000000001, 1000, 5, leY );
  CHECK_PTR( val );
  leY->setValidator( val );


  QVBoxLayout* vbox2 = new QVBoxLayout();
  CHECK_PTR( vbox2 );
  hbox->addLayout( vbox2 );
  
  lb = new QListBox( this );
  CHECK_PTR( lb );

  lab = new QLabel( lb, klocale->translate( "line &style" ), this );
  CHECK_PTR( lab );
  vbox2->addWidget( lab, 1 );
  vbox2->addWidget( lb, 4 );

  QPushButton* btn = new QPushButton( klocale->translate( "&Color" ), this );
  CHECK_PTR( btn );
  vbox2->addWidget( btn, 2 );
  connect( btn, SIGNAL( clicked() ), SLOT( color() ) );

  lb->insertItem( klocale->translate( "solid" ) );
  lb->insertItem( klocale->translate( "dashes" ) );
  lb->insertItem( klocale->translate( "dots" ) );
  lb->insertItem( klocale->translate( "dash dot" ) );
  lb->insertItem( klocale->translate( "dash dot dot" ) );
  lb->setCurrentItem( gridPenStyle - 1 );

  QString s;
  s.setNum( gridX );
  leX->setText( s );

  s.setNum( gridY );
  leY->setText( s );

  newColor = gridColor;
} // KGridDialog constructor


KGridDialog::~KGridDialog()
{
  int n;
  for ( n = 0; n < 4; n++ ) if ( rb[ n ]->isChecked() ) showGrid = n;
} // KGridDialog destructor


void
KGridDialog::Ok()
{
  QString s;
  s = leX->text();
  gridX = s.toDouble();

  s = leY->text();
  gridY = s.toDouble();

  gridColor = newColor;

  gridPenStyle = static_cast<PenStyle>( lb->currentItem() + 1 );
} // KGridDialog::Ok


void
KGridDialog::color()
{
  KColorDialog::getColor( newColor );
} // KGridDialog::color
