#ifndef _KOVERVIEW_H
#define _KOVERVIEW_H

#include <qlistbox.h>
#include <qpen.h>
#include <qradiobt.h>
#include <qtabdlg.h>
#include <qwidget.h>

#include <klined.h>

#include "kfunction.h"

class KOverviewDlg;

class KCoordinatesDlg;
class KCoordExample;

class KExpressionListDlg;

class KSettingsDialog;
class KLineStyleItem;

class KGridDialog;

/** The main configuration dialog of the application.
  It is derived from QTabDialog and has Tabs for the expressions to plot, the
  syste of coordinates and the grid.

  The tabs are represented by other widgets. */
class KOverviewDlg : public QTabDialog
{
  Q_OBJECT

public:
  /** Constructor.
      Creates the dialog and its tabs. */
  KOverviewDlg( QWidget* parent );
}; // class KOverviewDlg


/** The configuration dialog for the system of coordinates.
    This dialog is shown as a tab in a KOverviewDlg.

    It allows to set the extent of the plot area. */
class KCoordinatesDlg : public QWidget
{
  Q_OBJECT

public:
  /// Constructor.
  KCoordinatesDlg( QWidget* parent );

public slots:
  /** It is connected to KOverviewDlg::apply(). In this slot, the settings made
      in the dialog are applied. */
  void Ok();

private:
  KCoordExample* ex;
  KLined* leMinX, * leMinY, * leMaxX, * leMaxY;
}; // class KCoordinatesDlg


/** A little widget, that shows a simple draft of the plot window and the
    labels I gave the different coordinates (e.g. minX, maxY, ...). */
class KCoordExample : public QFrame
{
  Q_OBJECT

public:
  /// Constructor
  KCoordExample( QWidget* parent ) : QFrame( parent ) {
    setBackgroundColor( white );
    setFrameStyle( Panel | Sunken );
  };

protected:
  virtual void paintEvent( QPaintEvent* );
}; // class KCoordExample void paintEvent( QPaintEvent* );


/** A dialog that shows the expressions the user entered to be plotted and lets
    the user change them. */
class KExpressionListDlg : public QWidget
{
  Q_OBJECT

public:
  /// Constructor
  KExpressionListDlg( QWidget* parent );

public slots:
  /** This slot is connected to the "Settings" button and the signal
      QListbox::selected( int ) of the QListBox lb.

      It opens a KSettingsDialog with the data of the expression that is
      currently selected in the listbox preset. */
  void settings();

 /** This slot is connected to the "Delete" button.
     It deletes the expression that is currently selected in the listbox. */
  void deleteExpression();

  /** This slot is connected to the "New" button.
      It opens an empty KSettingsDialog. */
  void newExpression();

private:
  QListBox* lb;

signals:
  void expressionAdded();
  void expressionDeleted( uint index );
}; // class KExpressionListDlg


/** Dialog to set the properties of a single expression.
    These properties include the expression itself, the line style and the line
    color. */
class KSettingsDialog : public QDialog
{
  Q_OBJECT

public:
  /** Constructor.
      @param f the function to be edited. It will be changed directly! */
  KSettingsDialog( KFunction* f, QWidget* parent );

public slots:
  /** This slot is connected to the "Color" button.
      It opens an KColorDialog to select the color the function is plotted in. */
  void color();

  /** This slot is connected to the "Ok" button.
      It saves the data entered by the user in the KFunction structure passed
      as the first argument of the constructor. */
  void ok();

  /** This slot is connected to the "Cancel" button.
      It closes the dialog without saving the changes. */
  void cancel();

private:
  KFunction* _f;
  KLined*    le;
  QListBox*  lb;

  QColor     newColor;
}; // class KSettingsDialog


class KLineStyleItem : public QListBoxItem
{
public:
  KLineStyleItem( PenStyle style );

  virtual int height( const QListBox* ) const { return 10; };
  virtual int width( const QListBox* lb ) const { return lb->width(); };

protected:
  virtual void paint( QPainter* p );

private:
  PenStyle _style;
}; // class KLineStyleItem


/** A dialog to change the settings of the grid in the plot window.
 */
class KGridDialog : public QWidget
{
  Q_OBJECT

public:
  KGridDialog( QWidget* parent );
 ~KGridDialog();

public slots:
  void Ok();
  void color();

private:
  QRadioButton* rb[4];
  KLined* leX, * leY;
  QListBox* lb;

  QColor newColor;
}; // class KGridDialog

#endif

