#ifndef __ALLDF_H__
#define __ALLDF_H__

#include "expression.h"

const int alldferr_noMem=err_noMem;
const int alldferr_noFile=err_badDataFile;

// This class manages the data for all of the data files that need to
// be opened for one expression.

//TODO
//Might want to add a sort method to use when dealing with y=y(x), but not
// when dealing with y=y(t), x=x(t)
//Don't have a fixed AD_MAXDE.  Size the array according to the data read.

#include <qstrlist.h>

//maximum number of data sets in one expression
const int AD_MAXDS=10;
const int AD_MAXDE=100000;
const int AD_MAXDP=1000;
const int AD_MAXCLMS=100; //max # of columns in a datafile to parse
class KAllDF
{
  struct SDElement 
    {
      double x;
      double y;
  };
  struct SOpts
  {
    int xclm, yclm;
  };
  struct SDatapack
   {
      bool loaded;
      SDElement *data;
      unsigned long max;
   };   
  struct ADFEntry
   {
      QString *qsfilename;
      QString *qsopts;
      int filebase;  //we're only going to load a particular file once
                     //and data [filebase]  contains the data
      SOpts opts;  
   };
  SDatapack *data [AD_MAXDP];
  ADFEntry *entry [AD_MAXDP];

  int n, prevn;
  int extraData [AD_MAXDP];

public:
  KAllDF (void);
  /**
   * Add a dataset from filename with options opts.
   *  The index of the dataset is returned.
   **/
  int addDataSet (char *filename, char *opts);

  /**
   * Call this to load all of the data sets that have been add'ed but
   *  not yet loaded.
   *  Automatic now!
   **/
  bool load (int n);

  /**
   * Get the jth element of the ith data set.
   * If j is out of ranges, getx returns the extremal values,
   * gety returns 0.
   */
  double getx (int i, unsigned long j);
  double gety (int i, unsigned long j);

  /**
   * Get the filename for the nth data set.
   **/
//  char *filename (int n) {return entry [n]->filename->data();}
 
  /**
   * Set/get the extraData pointer for entry i.  datafile2D() finds this
   *  useful.
   **/
   void setExtra (int i, int _extra);

   int extra  (int i);

  /**
   * How many slots were filled in the ith data set?
   **/
   unsigned long maxn (int i);

  /**
   * Is the data set specified by (filename,opts) already recorded?
   *  Returns -1 if not, else returns it's index.
   **/ 
   int search (char *filename, char *opts, int &type);


protected:
   void parseOpts (char *, SOpts *);
   void optsDefaults (SOpts *);
   int compareOpts (SOpts &, int, int);
};



#endif
