#ifndef __KPDATAFILE__
#define __KPDATAFILE__

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include <qfile.h>


#define KPDF_BUFFERsz  2048
class KPDataFile
{
  
public:
  KPDataFile (char *_filename);
  /**
   * Be sure KPDataFile isOk() before using it.
   */
  bool isOk(void) {return ok;}
  /**
   * Read in the next point (line of data).  The number of columns
   * read is returned, or -1 on error.
   **/
  int read (double *data, int maxclm);

  /**
   * Go back to the beginning of the data file.
   * Returns FALSE on error.
   **/
  bool reset (void) {return qf==0 ? FALSE : qf->at(0);}

private:
  const char commentchar='#';
  QFile *qf;
  bool ok;
  char *buffer;
};


#endif
