#ifndef _KPRINTPREVIEW_H
#define _KPRINTPREVIEW_H

#include <qdialog.h>
#include <qpainter.h>
#include <qpdevmet.h>
#include <qprinter.h>
#include <qradiobt.h>
#include <kcombo.h>
#include <kintegerline.h>

class KPrintPreviewDlg : public QDialog
{
  Q_OBJECT

public:
  KPrintPreviewDlg( QWidget* parent, QPrinter* _printer, QPainter** _p );

public slots:
  void update();
  void updateUnits_size_x();
  void updateUnits_size_y();
  void updateUnits_unit_x();
  void updateUnits_unit_y();
  void ok();
  void cancel();

protected:
  bool fSetByProgram;

  KCombo* cbPaperSize;
  QLabel* labelWidth, * labelHeight;
  QRadioButton* rbPortrait, * rbLandscape;
  QRadioButton* rbPrinter, * rbFile;
  KIntegerLine* ilLeft, * ilRight, * ilTop, * ilBottom;
  KIntegerLine* ilUnit_x, * ilUnit_y;

  QPaintDeviceMetrics* pdm;
  QPainter** painter;
  QPrinter* printer;
}; // KPrintPreviewDlg

#endif // _KPRINTPREVIEW_H
