/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

/* Procedure per il disegno di una curva bidimensionale */

#include<cstdio>
#include<cstring>
#include<cmath>
#include<cfloat>
#include"mplot.h"
#include"mathplot.h"

extern double number;

static struct point OnThePlane(struct point2d p)
{
  struct point P;

  if( p.x==DBL_MAX )
    {
      P.x=P.y=P.z=0;
      P.color=127; // This special value is used to signal points
    }              // you must not draw
  else
    {
      P.x=(float)p.x;
      P.y=(float)p.y;
      P.z=0;
      P.color=0;
    }
  return P;
}

static struct point2d Curva2d(double t,short *coderr,short nel1,short nel2)
{
  struct point2d p;

  *coderr=0;
  *coderr=CommExec(t,0,1,nel1);
  if(*coderr)
    {
      p.x=p.y=DBL_MAX;
      return p;
    }
  p.x=number;
  /* */
  *coderr=CommExec(t,0,2,nel2);
  if(*coderr)
    {
      p.x=p.y=DBL_MAX;
      return p;
    }
  p.y=number;
  return p;
}

#define LS 60

char* DsnC2d(mycanvas* cnv, unsigned char ic)
{
  short nel1,nel2;
  double h;
  int i;
  struct point2d p;
  struct point P;
  struct Param2d* par=cnv->get_par2d();
  static char s[LS];
  char *psz;

  if( (psz=Evaluate(1, &nel1, ic)) )
    {
      strcpy(s,"X: ");
      strcat(s,psz); 
      // Do not worry! s is enough long to contain "X: " + psz[]
      clean(1);
      return s;
    }
  if( (psz=Evaluate(2, &nel2, ic)) )
    {
      strcpy(s,"Y: ");
      strcat(s,psz); 
      // Do not worry! s is enough long to contain "Y: " + psz[]
      clean(2);
      return s;
    }
  h=(par->t2 - par->t1)/(par->nnod-1);
  for(i=0;i<par->nnod;i++)
    {
      double t;
      short coderr;

      t=par->t1+i*h;
      p=Curva2d(t,&coderr, nel1, nel2);
      switch( coderr )
	{
	case 24:
	  snprintf(s,LS,"Missing operator or parenthesis");
	  clean(2);
	  return s;
	case 3:
	case 4:
	case 5:
	case 6:
	case 8:
	case 0:
	  /*Nihil*/;
	}
      P=OnThePlane(p);
      cnv->setv(P,ic*par->nnod+i);
      // i=0,...,par->nnod-1 is the index of the vertex
    }
  clean(2);
  return NULL;
}

char* WrtC2d(struct Param2d* par,FILE* pf,unsigned char ic)
{
  short nel1,nel2;
  double h;
  int i;
  struct point2d p;
  struct point P;
  static char s[LS];
  char *psz;

  if( (psz=Evaluate(1, &nel1, ic)) )
    {
      strcpy(s,"X: ");
      strcat(s,psz); 
      // Do not worry! s is enough long to contain "X: " + psz[]
      clean(1);
      return s;
    }
  if( (psz=Evaluate(2, &nel2, ic)) )
    {
      strcpy(s,"Y: ");
      strcat(s,psz); 
      // Do not worry! s is enough long to contain "Y: " + psz[]
      clean(2);
      return s;
    }
  // Every time this function is called she must insert
  // an empty line before the data block
  fprintf(pf,"\n");
  if( ferror(pf) || feof(pf) )
    {
      snprintf(s,LS,"Error in output operation on file");
      clean(2);
      return s;
    }
  h=(par->t2 - par->t1)/(par->nnod-1);
  for(i=0;i<par->nnod;i++)
    {
      double t;
      short coderr;

      t=par->t1+i*h;
      p=Curva2d(t,&coderr, nel1, nel2);
      switch( coderr )
	{
	case 24:
	  snprintf(s,LS,"Missing operator or parenthesis");
	  clean(2);
	  return s;
	case 3:
	case 4:
	case 5:
	case 6:
	case 8:
	  P.x=P.y=FLT_MAX;
	  break;
	case 0:
	  P.x=(float)p.x;
	  P.y=(float)p.y;
	}
      P.z=0;
      P.color=0;
      fprintf(pf,"% 20f\t% 20f\n",P.x,P.y);
      if( ferror(pf) || feof(pf) )
	{
	  snprintf(s,LS,"Error in output operation on file");
	  clean(2);
	  return s;
	}
    } // end for(i=0 ...
  clean(2);
  return NULL;
}


