/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#ifndef _MAKEPS_
#define _MAKEPS_

#include<cstdio>

#define CREATOR "%%%%Creator: Mplot++ version 0.78\n"

#define WRITE_ERROR  10000001
#define INVALID_EPSF 10000002

/* Number of the supported media */
#define PS_NSUPPM         7
/* List of the supported media */
#define PS_A3             0
#define PS_A4             1
#define PS_A5             2
#define PS_B4             3
#define PS_B5             4
#define PS_LETTER         5
#define PS_LEGAL          6
#define PS_AUTOMATIC     -1

#define PS_PORTRAIT       1
#define PS_LANDSCAPE      2

/* Number of the available fonts */
#define PS_NFONTS         10
/* List of the available fonts */
#define PS_HELVETICA       0
#define PS_HELVETICA_BOLD  1
#define PS_COURIER         2
#define PS_COURIER_BOLD    3
#define PS_COURIER_OBLIQUE 4
#define PS_TIMES           5
#define PS_TIMES_BOLD      6
#define PS_TIMES_ITALIC    7
#define PS_TIMES_ROMAN     8
#define PS_SYMBOL          9 
#define PS_NULL           -1

#define PS_NCAPTYPES  3
#define PS_CAP_BUTT   0
#define PS_CAP_ROUND  1
#define PS_CAP_SQUARE 2

#define PS_NJOINTYPES 3
#define PS_JOIN_MITER 0
#define PS_JOIN_ROUND 1
#define PS_JOIN_BEVEL 2

#define PS_SOLID   0
#define PS_DASH    1
#define PS_DOT     2
#define PS_DASHDOT 3

#define PS_EPS          1.0

#define IS_WORKING    0
#define OUT_OF_ORDER -1

struct prmPS {
  int medium, orient, manypages;
  // Bounding Box
  unsigned llx,lly,urx,ury;
};

#define MAX_TITLE_SIZE 30

struct infoPS {
  char title[MAX_TITLE_SIZE]; /* Title of the document */
  int medium,orientation, npage;
  // Bounding Box
  unsigned short llx,lly,urx,ury;
  signed char fontslist[PS_NFONTS];
  int state;
  FILE* file;
};

/* Some explainations about the writing of a PostScript(R) document */

/* PostScript views a page as a rectangular grid onto which  opaque */
/* ink of various colours (including white) may be sprayed, each    */
/* new coat obscuring the underlying ones.                          */
/* Positions on the page are specified by using a coordinate system */
/* which is independent of the resolution of the particular printer */
/* will be used.                                                    */
/* This is a normal cartesian space with the origin at the bottom   */
/* left hand corner of the page and a resolution of 1/72 inches.    */
/* You must remember that 1 inch == 25.4 mm .                       */
/* Coordinates are specified as x and y values, where x  and y are  */
/* real numbers which increase rightwards and upwards respectively. */
/* The position of the origin, orientation of the axes, resolution  */
/* and even the relative direction of the axes can be changed  via  */
/* coordinate transformations.                                      */
/* The informations about the current coordinate system are stored  */
/* in a matrix ( like in OpenGL(R), do you know OpenGL ? ), having  */
/* the shape:                                                       */
/*               | ax ay 0 |                                        */
/*               | bx by 0 |                                        */
/*               | cx cy 1 |                         .              */
/* These informations form, with some others, the (current) graphic */
/* state.                                                           */
/* The graphic state contains among other things the current:       */
/* Transformation Matrix (see before),                              */
/* position of the "virtual pencil",                                */
/* font,                                                            */
/* line width,                                                      */
/* line cap,                                                        */
/* line join,                                                       */
/* dash,                                                            */
/* colour.                                                          */
/* The default values for these objects are:                        */
/*               | 1 0 0 |                                          */
/*               | 0 1 0 |                                          */
/*               | 0 0 1 | for the Transformation Matrix,           */
/* 1 for the line width, black for the color, butt end for the line-*/
/* cap, miter join for the line-join and solid for the dash.        */
/* The position of the "virtual pencil" is initially undefined.     */
/* In PostScript the device coordinates 'xc' and 'yc' are derived   */
/* from the given coordinates x and y according to the following    */
/* equations:                                                       */
/*              xc= ax * x + bx * y + cx                            */
/*              yc= ay * x + by * y + cy.                           */
/* Initially, because (ax,bx,cx) = (1,0,0) and (ay,by,cy) = (0,1,0),*/
/* one has xc = x, yc = y.                                          */
/* The procedures ps_scale(), ps_rotate() and ps_translate() change */
/* the transformation matrix so that you can obtain the wanted  al- */
/* terations in the current coordinate system.                      */ 

/* How must be build a program who use this library.             */
/* FIRST YOU HAVE TO CALL ps_init() to open the file pointed by  */
/* 'path' (see ps_init() declaration); you must remember to tell */
/* ps_init() what orientation you want (Portrait or Landscape)   */
/* and if the document will have or not more pages than 1.       */
/* You must remember that you can specify a title for the docu-  */
/* ment you are going to create and a Bounding Box, which provi- */
/* des informations about the size of the region you are going   */
/* to paint.                                                     */
/* A bounding box is given by the  coordinates of its lower-left */
/* corner and upper-right corner.  These coordinates are expres- */
/* sed in the default PostScript coordinate system. The bounding */
/* box is  the smallest rectangle  that encloses  all  the marks */
/* painted on the page. I suggest you to fix a bounding box only */
/* for single-page documents and only if you know exactly the po-*/
/* sition of the object you will draw and write.                 */
/* Graphics state informations, such as  the current line width, */
/* must be considered when calculating the bounding box.         */
/* IF YOU WANT TO CREATE AN ENCAPSULATED POSTSCRIPT DOCUMENT(R)  */
/* YOU MUST REPLACE THE CALL TO ps_init() WITH THAT TO           */
/* eps_init() (see below for more informations).                 */
/* If the file you want to open does not exist yet you must call */
/* ps_init()/eps_init() with 'mode' set to TO_WRITE, else        */
/* 'mode' must value TO_OVERWRITE.                               */
/* THEN YOU HAVE TO CALL ps_newpage() if you are making a multi- */
/* page document; remember that when you will have FINISHED TO   */
/* WRITE A PAGE YOU WILL ALSO HAVE TO CALL ps_endpage().         */
/* In general, in a multi-page document EVERY PAGE MUST BEGIN    */
/* WITH ps_newpage() and FINISH WITH ps_endpage().               */  
/* AT THE END OF YOUR WRITING/DRAWING OPERATIONS YOU WILL HAVE TO*/
/* CALL ps_done() to signal that you have finished and to close  */
/* the postscript file.                                          */
/* OF COURSE, ps_done() IS REPLACED BY eps_done() IF YOU ARE     */
/* WORKING ON AN ENCAPSULATED POSTSCRIPT DOCUMENT.               */ 
/* Between the couple ps_init() / ps_done() or ps_newpage() /    */
/* ps_endpage() you may perform every writing or drawing         */
/* operation. Have a good work !!!                               */

/* Initializes a static infoPS struct by the following values:   */
/* title  = t (if you do not want to give a title to the docu-   */
/* ment then 't' must be equal to NULL or "")                    */
/* ps.llx= MIN(p.llx,1440)                                       */
/* ps.lly= MIN(p.lly,1440)                                       */
/* ps.urx= MIN(p.urx,1440)                                       */
/* ps.ury= MIN(p.ury,1440)                                       */
/* orientation = p.orient (must be PS_PORTRAIT or PS_LANDSCAPE), */
/* npage  = 0 if p.manypages != 0, else npage= -1,               */
/* fontslist= {-1,-1,-1,-1,-1,-1,-1,-1}                          */
/* state = IS_WORKING,                                           */
/* file   = pointer to the file located in the path "path".      */
/* It tries to open the file pointed by "path" and in case of    */
/* success returns 0, else returns the code of the occurred      */
/* error (which can be WRITE_ERROR or one of the openfile()      */
/* errors, see open_file.h).                                     */
/* If ps_init() returns 0, the file indicated by "path" is open  */
/* in writing-mode and it will receive all your drawing commands.*/
/* manypages must be 0 if you want to make a single-page, else   */
/* it has to be non-zero.                                        */
/* Look out! If you do not want to set any Bounding Box for the  */
/* document you are making, you can obtain this with p.urx(p.ury)*/
/* less than or equal to p.llx (p.lly).     A simple way to have */
/* this is setting  p.llx=p.lly=p.urx=p.ury=0 .                  */ 
int  ps_init(const char* path, int mode, const char* t, const struct prmPS p);

/* You must use the function below when you want to create an   */
/* Encapsulated Postscript Document. This function acts as the  */
/* precedent one but it can return the INVALID_EPSF error too,  */
/* which indicates that you have tried to create an EPS docu-   */
/* ment with an unagreable format.                              */
/* Of course,the eps_init() completely replaces the ps_init()   */
/* for the EPS documents, i.e. you must not use ps_init() if    */
/* you are going to make an EPS file.                           */             
/* In fact, an EPS document must have a title, must be a sin-   */
/* gle-page document and must have an explicit Bounding Box,    */
/* which provides informations about the size of the EPS file.  */
/* A bounding box is given by the coordinates of its lower-left */
/* corner and upper-right corner. These coordinates are expres- */
/* sed in the default PostScript coordinate system. For an EPS  */
/* file, the bounding box is the smallest rectangle that enclo- */
/* ses all the marks painted on the single page of the EPS file.*/
/* Graphics state informations, such as the current line width, */
/* must be considered when calculating the bounding box.        */
/* Look out! An EPS document can not have a particular orienta- */
/* tion so p.orient is simply ignored.                          */
int  eps_init(const char* path, int mode, const char* t, const struct prmPS p);

/* The following procedure is used to end a postscript document.   */ 
/* It tries to close the file opened by ps_init() and returns 0    */
/* in case of success, else returns the code of the occurred       */
/* error (which can be WRITE_ERROR or one of the errno values).    */
/* If ps_done() has returned 0 you may think that everything is ok.*/
int  ps_done(void);

/* The function below replaces ps_done() for EPS documents. It can */
/* return the same values of ps_done() and if it returns 0 you may */
/* think that everything is ok.                                    */
/* But while ps_done() does not require any parameter, eps_done()  */
/* requires an integer parameter, which establishes if a 'showpage'*/
/* operation must be done or not at the end of the EPS document    */
/* you have created. You must know that in a page of a PostScript  */
/* document nothing at all would appear without the invocation of  */
/* this operation. But if you are creating an EPS document, i.e.   */
/* a Postscript document destinated to be encapsulated inside ano- */
/* ther Postscript document, you may let to the importing applica- */
/* tion the responsability to perform the 'showpage' operation.    */
/* Actually, tha Adobe company, which has the Copyright for the    */
/* Postscript language, says that it is fine to perform the 'show- */
/* page' operation at the end of your EPS file, although is not    */
/* necessary if the EPS file will only be imported into another    */
/* documents.                                                      */
/* Officially, it is the responsibility of the importing applica-  */
/* tion to avoid the troubles connected to the possibility that 2  */
/* or more 'showpage' operations are done on the same page.        */
/* Still, in creating EPS files, it would be wise not to perform any */
/* 'showpage' operation unless you want to examine the document by */ 
/* a Postscript previewer like Ghostview or print it separately    */
/* too. The argument of the eps_done() procedure must be 0 if you  */
/* think that it is better not to perform any 'showpage' operation,*/
/* else it must be a non-zero integer.                             */    
int  eps_done(int showpage);

/* This function may be used to force the closure of a postscript */
/* document when ps_done()/eps_done() can not close it.         */
/* But I have decided to give you this f. only for exceptional    */
/* use (see below).                                               */
/* It returns 0 if has success, else returns the errno value.     */
int  ps_close(void);

/* This function return != 0 when you may continue to write and draw      */
/* on the postscript document you have opened, 0 if it is not possible.   */
/* In this case I suggest you to abort the drawing operations by calling  */
/* ps_close() and, if this function fails, to terminate the program after */
/* having called all the usual clean-up procedures.                       */
/* If you try to continue with the drawing operations after you have      */
/* gotten by the function below that the postscript device is OUT OF      */
/* ORDER, the write and draw routines will not do everything, they only   */
/* will print an error message on stderr !                                */
/* Have you time to spend pointlessly ?                                   */
int working_device(void);

/* This function may be used to reset the error indicator of  the  */
/* postscript device. But if working_device() tells you that  the  */
/* device is out of order probably it is better follow my previous */
/* suggestions (see before, I am too lazy to rewrite them here !). */
void clearerr_device(void);

/* ps_newpage() must be called by you whenever you want to start */
/* a new page.                                                   */
void ps_newpage(void);

/* ps_endpage() must be used to terminate a page.                */
void ps_endpage(void);

/* ps_save() must be used whenever you need to save the current   */
/* graphic state before to apply a transformation of coordinates, */
/* before to change the color, the line width, the font, the po-  */
/* sition of the "virtual pencil" and similar or before to make   */
/* a temporary object.                                            */
/* ps_save acts as the glpushmatrix() of the OpenGL library ( if  */
/* you know OpenGL ):                                             */
/* it makes a copy of the current graphic state, which then beco- */
/* mes the current one.                                           */
void ps_save(void);

/* ps_restore, as the name tells, restores the graphic state pre- */
/* viously saved by calling ps_save().  It means that ps_restore  */
/* makes all the change you have done on the graphic state after  */
/* having called ps_save() to be forgotten.                       */
/* ps_restore() acts as the glpopmatrix() of the OpenGL library:  */
/* it discards the current graphic state, revealing the saved     */
/* copy.                                                          */
void ps_restore(void);

/* Shift the origin of the coordinate system to (xt,yt) (measured */
/* in the current system).                                        */
void ps_translate(double xt, double yt);

/* ps_rotate() rotates the current coordinate system trough angle */
/* degrees relative to the current system.      Angle is measured */
/* anti-clockwise.                                                */
void ps_rotate(double angle);

/* ps_scale() expands or shrinks the coordinate system by sx in   */
/* the x-direction and sy in the y-direction.                     */
/* Effectively, after you will have called this procedure, every  */
/* x coordinate will be multiplied by sx, and every y coordinate  */
/* by sy.                                                         */
void ps_scale(double sx, double sy);

/* ps_mirror() can be used to mirror the current  coordinate  system    */
/* respect to the straight line which crosses the axes in the origin    */
/* and forms an angle th with the x-direction. The angle th is measured */
/* counter-clockwise.                                                   */
/* For example, with th=0 you can perform a mirroring of the current    */
/* coordinate system respect to its x-direction, while with  th=-90     */
/* you perform a mirroring respect to the current y-direction.          */
void ps_mirror(double th);

/* You can limit all your drawing and writing operations */
/* to a rectangular region by using  ps_push_clip()  and */
/* put the drawings back by using fl_pop_clip().         */
/* (x,y) is the lower left corner of  the region  to  be */
/* clipped, 'w' and 'h' are  respectively the width  and */
/* the height of the region will be clipped.             */
/* These functions must be used always as a pair.        */    
void ps_push_clip(double x, double y, double w, double h);
void ps_pop_clip(void);

/* ps_graylevel() sets the gray-scale  "color" of the     */
/* "virtual ink" to the value zerotoone, which must be    */
/* comprised between 0 and 1. 0 means black and 1 means   */
/* white. The default value is 0 (black).                 */
void ps_graylevel(double zerotoone);

/* ps_rgbcolor() sets to the (r,g,b) value the color of the */
/* ink of the "virtual pencil".                             */ 
void ps_rgbcolor(unsigned char r, unsigned char g, unsigned char b);

/* ps_hsbcolor() sets to the (h,s,b) value the color of the */
/* ink of the "virtual pencil".                             */
/* h stays for hue, s for saturation, b for bright.         */
/* h,s e b must be taken in the interval [0,1]              */
void ps_hsbcolor(double h, double s, double b); 

/* ps_linewidth() sets the current line width to the value size. */
/* The default value is 1.                                       */
void ps_linewidth(double size);

/* ps_linecap() sets the current linecap. The default value is */
/* PS_CAP_BUTT.                                                */
/* The admissible values for "type" are listed at the begin of */
/* this file.                                                  */
void ps_linecap(unsigned type);

/* ps_linejoin() sets the current linejoin. The default value  */
/* is PS_JOIN_MITER.                                           */
/* The admissible values for "type" are listed at the begin of */
/* this file.                                                  */
void ps_linejoin(unsigned type);

/* ps_linedash() sets the current linedash. The default value */
/* is PS_SOLID.                                               */
/* The admissible values for "type" are listed at the begin of */
/* this file.                                                  */
void ps_linedash(unsigned type);

/* ps_font() sets to type the current font and sets to "size" */
/* its size.                                                  */
/* The admissible values for "type" are those listed at the   */
/* begin of this file.                                        */
void ps_font(int type, double size);

/* ps_write() is used to display a string of text. This procedure  */
/* is only for internal use, do not use it directly, use ps_text() */
/* instead.                                                        */
void ps_write(const char* str, int n);

/* The routines below draw around the point (x,y) a diamond, a box, */
/* a plus (+), a cross (x), a triangle up and down respectively.    */

void ps_diamond(double x, double y);
void ps_box(double x, double y);
void ps_plus(double x, double y);
void ps_cross(double x, double y);
void ps_trup(double x, double y);
void ps_trdown(double x, double y);

/* This routine draws a filled circle around the point  (x,y) with */
/* radius equal to 0.5*clw, where 'clw' is the current line width. */
void ps_point(double x, double y);

/* The routines below are designed to be used in the drawing  */
/* of stroken figures                                         */

/* ps_line() draws a line which starts at (x1,y1) and ends at */
/* (x2,y2).                                                   */
void ps_line(double x1, double y1, double x2, double y2);

/* ps_curve() draws the Bezier curve determined by the points */
/* (x1,y1), (x2,y2), (x3,y3) e (x4,y4).                       */
void ps_curve(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4);

/* ps_polyline() draws a sequence of lines, i.e. the lines    */
/* (x[0],y[0])--->(x[1],y[1]),(x[1],y[1])--->(x[2],y[2]),..., */
/* (x[nvert-2],y[nvert-2])--->(x[nvert-1],y[nvert-1]).        */
void ps_polyline(double x[], double y[], unsigned nvert);

/* ps_rect() draws a stroken rectangle with left lower corner */
/* in (x,y) and dimensions equal to w(width) and h(height).   */
void ps_rect(double x, double y, double w, double h);

/* ps_loop() acts as ps_polyline but closes the sequence of the */
/* drawn lines with the segment (x[nvert-1],y[nvert-1])--->     */
/* (x[0],y[0]). nvert must be >=3 or never will be done.        */
void ps_loop(double x[], double y[], unsigned nvert);

/* ps_arc() draws an arc of ellipse which has  the center  in the */
/* (x,y) point, length of the x-axis equal to w and length of the */
/* y-axis equal to h. a1 and a2 are the start and the end  of the */
/* arc; they are measured in degrees. The arc is drawn from a1 to */
/* a2 in the anti-clockwise sense.                                */
void ps_arc(double x, double y, double w, double h, double a1, double a2);

/* The routines below are designed to be used in the drawing */
/* of filled figures                                         */

/* ps_rectf() draws a filled rectangle with left lower corner */
/* in (x,y) and dimensions equal to w(width) and h(height).   */
void ps_rectf(double x, double y, double w, double h);

/* ps_polygon() draws a filled polygon with vertices in the points */
/* (x[0],y[0]),(x[1],y[1]), ... ,(x[nvert-1],y[nvert-1]).          */
/* nvert must be >=3 or never will be done.                        */ 
void ps_polygon(double x[], double y[], unsigned nvert);

/* ps_pie()  draws a pie of ellipse which has  the center  in the */
/* (x,y) point, length of the x-axis equal to w and length of the */
/* y-axis equal to h. a1 and a2 are the start and the end  of the */
/* pie; they are measured in degrees. The pie is drawn from a1 to */
/* a2 in the anti-clockwise sense.                                */
void ps_pie(double x, double y, double w, double h, double a1, double a2);

/* The routines below allow you to insert some text in a postscript file */

/* The first form of ps_text() allows you to write the content     */
/* of the string pointed by t on the postscript document.          */
/* x and y are the coordinates (in the current system coordinate)  */
/* of the point from which the text will be written.               */
/*       |                                                         */
/*       | Text                                                    */
/*  (x,y)+-------------                                            */
/* The second version permits you to specify the maximum number of */
/* characters will be written.                                     */
/* A value of 'n' less than 0 is equivalent to n=length(t); the    */
/* same is for a value of n greater than length(n).                */ 
void ps_text(const char * t, double x, double y);
void ps_text(const char * t, int n, double x, double y);

#endif
