/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include<cstdlib>
#include<cstring>
#include<cctype>
#include<cmath>
#include"makeps.h"
#include"graphut.h"
#include"mycanvas.h"

#define SIZE 50
#define DIM_DISPLAYAREA 472
/* In the following code DIM_DISPLAYAREA will replace the call to the */
/* mycanvas::w() function.                                            */ 

static unsigned char paint[MAX_NC][3]={{0,0,0},
    {0,120,120},{140,0,120},{100,120,0},
    {196,0,36},{0,196,0},{0,0,160},
    {0,188,188},{196,98,196},{216,160,0}
};

// This function will be used to format the equations
// stored in prm[].x, prm[].y, prm[].z .

static struct __prm* fmteqs(struct __prm eq, int tp)
{
  static struct __prm fmteq;
  int j;

  strncpy(fmteq.x,eq.x,MAX_LUN-1);
  fmteq.x[MAX_LUN-1]='\0';
  strncpy(fmteq.y,eq.y,MAX_LUN-1);
  fmteq.y[MAX_LUN-1]='\0';
  if( tp != C2D )
    {
      strncpy(fmteq.z,eq.z,MAX_LUN-1);
      fmteq.z[MAX_LUN-1]='\0';
    }
  for(j=0 ; fmteq.x[j]!='\0' ; j++)
    {
      switch( fmteq.x[j] )
	{
	case '_':
	case '\'':
	  fmteq.x[j]='-';
	  break;
	case '\"':
	  fmteq.x[j]='+';
	  break;
	case '\?':
	  fmteq.x[j]= (tp==SF) ? 's' : 't';
	  break;
	case '!':
	  fmteq.x[j]='t';
	}
      fmteq.x[j]=tolower(fmteq.x[j]);
    }
  for(j=0 ; fmteq.y[j]!='\0' ; j++)
    {
      switch( fmteq.y[j] )
	{
	case '_':
	case '\'':
	  fmteq.y[j]='-';
	  break;
	case '\"':
	  fmteq.y[j]='+';
	  break;
	case '\?':
	  fmteq.y[j]= (tp==SF) ? 's' : 't';
	  break;
	case '!':
	  fmteq.y[j]='t';
	}
      fmteq.y[j]=tolower(fmteq.y[j]);
    }
  for(j=0 ; fmteq.z[j]!='\0' ; j++)
    {
      switch( fmteq.z[j] )
	{
	case '_':
	case '\'':
	  fmteq.z[j]='-';
	  break;
	case '\"':
	  fmteq.z[j]='+';
	  break;
	case '\?':
	  fmteq.z[j]= (tp==SF) ? 's' : 't';
	  break;
	case '!':
	  fmteq.z[j]='t';
	}
      fmteq.z[j]=tolower(fmteq.z[j]);
    }
  return &fmteq;
}

static int init_prsys(const char* doctitle, int doc_opening_mode, int eps, int medium, int orientation)
{
  int errcode;
  char docpath[50];
  struct prmPS p;

  strncpy(docpath,doctitle,SIZE-4);
  docpath[SIZE-5]='\0';
  if( !eps )
    {
      strcat(docpath,".ps");
      p.medium= medium;
      p.orient= orientation;
      p.manypages= 0;
      p.urx=p.llx=p.ury=p.lly= 0;
      errcode=ps_init(docpath,doc_opening_mode,doctitle,p);
    }
  else
    {
      p.medium= PS_AUTOMATIC;
      p.orient=p.manypages= 0;
      p.llx=p.lly= 0;
      p.urx=p.ury= DIM_DISPLAYAREA+28;
      strcat(docpath,".eps");
      errcode=eps_init(docpath,doc_opening_mode,doctitle,p);
    }
  if( (errcode) )
    return errcode;
  else
    {
      ps_save();
      if(!eps)
	{
	  if(orientation==PS_PORTRAIT)
	    {
	      switch(medium)
		{
		case PS_A3:
		  ps_translate(185,540);
		  break;
		case PS_A4:
		  ps_translate(62,290);
		  break;
		case PS_B4:
		  ps_translate(128,432);
		  break;
		case PS_LETTER:
		  ps_translate(70,260);
		  break;
		case PS_LEGAL:
		  ps_translate(70,460);
		}
	    }
	  else
	    {
	      ps_rotate(90);
	      switch(medium)
		{
		case PS_A3:
		  ps_translate(65,-657);
		  break;
		case PS_A4:
		  ps_translate(40,-534);
		  break;
		case PS_B4:
		  ps_translate(65,-600);
		  break;
		case PS_LETTER:
		case PS_LEGAL:
		  ps_translate(65,-550);
		}
	    }
	}
      else
	ps_translate(14,14);
    }
  if( !working_device() )
    return WRITE_ERROR;
  else
    return 0;
}

int mycanvas::print(const char* doctitle, int doc_opening_mode)
{
  int errcode=0;

  if( (errcode=init_prsys(doctitle, doc_opening_mode, encfmt, medium, orientation)) )
    return errcode;
  else // Ok! this is not an example of art of computer programming
    {
      if( (draw_axes) )
	if( (errcode=_print_axes()) )
	  return errcode;
      if( (draw_grid) )
	if( (errcode=_print_grid()) )
	  return errcode;
      if( (draw_infos) )
	if( (errcode=_print_infos()) )
	  return errcode;
    }
  if( (errcode=_print_center()) )
    return errcode;
  else if( (errcode=_print_header()) )
    return errcode;
  else
    {
      if(cnvtype==C2D)
	errcode=print2d();
      else
	errcode=print3d();
    }
  if(!encfmt)
    errcode=ps_done();
  else
    errcode=eps_done(0);
  if( (errcode) )
    return errcode;
  else
    return 0;
}

int mycanvas::print2d(void)
{
  int i,j;
  double x1,y1,x2,y2;
  short X,Y,S;
  struct point Q1,Q2;
  struct Rect R;

  // Coordinates of the lower-left corner of the drawing area
  X=Y=DIST;   
  // Dimensions of the drawing area (they should be equals)
  S=DIM_DISPLAYAREA-2*DIST;
  // Setting up display area
  R.x0=par2d.x0;
  R.y0=par2d.y0;
  R.a =par2d.w/2.0;
  R.b =par2d.h/2.0;
  for(j=0 ; j<m ; j++) // m is at most 9=MAX_NC-1 
    {
      if( (rainbow) )
	ps_rgbcolor(paint[j][0],paint[j][1],paint[j][2]);
      else
	ps_graylevel(0.09*j);
      if(plotstyle[j]==CONNECTED_PLOT)
	{
	  for(i=0 ; i<n-1 ; i++)
	    {
	      if( (grid[j*n+i].color==127) || (grid[j*n+i+1].color==127) )
		continue;
	      else  if( intersect(grid[j*n+i],grid[j*n+i+1],R,&Q1,&Q2) )
		{
		  x1= X+S/2+S*((Q1.x-par2d.x0)/par2d.w);
		  y1= Y+S/2+S*((Q1.y-par2d.y0)/par2d.h);
		  x2= X+S/2+S*((Q2.x-par2d.x0)/par2d.w);
		  y2= Y+S/2+S*((Q2.y-par2d.y0)/par2d.h);
		}
	      else
		continue;
	      ps_line(x1,y1,x2,y2);
	      if( !working_device() )
		return WRITE_ERROR;
	    } //end for(...) 
	} //end if(plotstyle...)
      else
	{
	  for(i=0 ; i<n ; i++)
	    {
	      if( (grid[j*n+i].color==127) )
		continue;
	      else if( !isout(grid[j*n+i].x, grid[j*n+i].y, R) )
		{
		  x1= X+S/2+S*((grid[j*n+i].x-par2d.x0)/par2d.w);
		  y1= Y+S/2+S*((grid[j*n+i].y-par2d.y0)/par2d.h);
		}
	      else
		continue;
	      switch(plotstyle[j])
		{
		case SQUARES:
		  ps_box(x1,y1);
		  break;
		case DIAMONDS:
		  ps_diamond(x1,y1);
		  break;
		case CROSSES:
		  ps_cross(x1,y1);
		}
	      if( !working_device() )
	        return WRITE_ERROR;
	    } //end for(i...)
	} //end else
    }//end for(j...)
  return 0;
}

int mycanvas::print3d(void)
{
  struct point P,Q,Q1,Q2;
  double x1,y1,x2,y2;
  short X,Y,S;
  int i,j,color=0;
  struct Rect R;

  // Coordinates of the upper-left corner of the drawing area
  X=Y=DIST;
  // Dimensions of the drawing area (they should be equals)
  S=DIM_DISPLAYAREA-2*DIST;
  for(j=0 ; j<m   ; j++) // if m==1 j can be only 0
    {
      for(i=0 ; i<n-1 ; i++)
	{
	  P=Assonometria(&par3d,grid[j*n+i]);
	  Q=Assonometria(&par3d,grid[j*n+i+1]);
	  table[j*(n-1)+i].index=j*n+i;
	  table[j*(n-1)+i].key=(P.color+Q.color)/2;
	  table[j*(n-1)+i].type=0;
	}
    }
  for(i=0 ; i<n ; i++)
    {
      for(j=0 ; j<m-1 ; j++) // if m==1 the instructions below are not
	{                        // executed
	  P=Assonometria(&par3d,grid[j*n+i]);
	  Q=Assonometria(&par3d,grid[(j+1)*n+i]);
	  table[m*(n-1)+i*(m-1)+j].index=j*n+i;
	  table[m*(n-1)+i*(m-1)+j].key=(P.color+Q.color)/2;
	  table[m*(n-1)+i*(m-1)+j].type=1;
	}
    }
  qsort(table, m*(n-1)+n*(m-1), sizeof( struct element ), &colorcmp);
  R.x0=R.y0=0;
  R.a =R.b =par3d.R;
  for(i=0; i<m*(n-1)+n*(m-1) ; i++)
    {
      if(table[i].key > NGRAYS-1) // P.color or Q.color is equal to 127; 
	continue;                 // you must not draw this line !
      else
	j=table[i].index;
      if(table[i].type==0)
	{
	  P=Assonometria(&par3d,grid[(j/n)*n+j%n]);
	  Q=Assonometria(&par3d,grid[(j/n)*n+j%n+1]);
	}
      else
	{
	  P=Assonometria(&par3d,grid[(j/n)*n+j%n]);
	  Q=Assonometria(&par3d,grid[(j/n+1)*n+j%n]);
	}
      if( intersect(P, Q, R, &Q1, &Q2) )
	{
	  x1= X+S/2+S/2*(Q1.x/par3d.R);
	  y1= Y+S/2+S/2*(Q1.y/par3d.R);
	  x2= X+S/2+S/2*(Q2.x/par3d.R);
	  y2= Y+S/2+S/2*(Q2.y/par3d.R);
	}
      else
	continue;
      if( color != (int)((P.color+Q.color)/2) )
	{
	  color=(int)((P.color+Q.color)/2);
	  ps_graylevel((double)color/(NGRAYS-1));
	}
      ps_line(x1,y1,x2,y2);
      if( !working_device() )
	return WRITE_ERROR;
    }
  return 0;
}

extern struct __prm prm[];

int mycanvas::_print_infos(void)
{
  char s[50];
  short X,Y,S;

  if( (rainbow) )
    ps_rgbcolor(110,40,60);
  else
    ps_graylevel(0.1);
  // Coordinates of the upper-left corner of the drawing area
  X=Y=DIST;
  // Dimensions of the drawing area (they should be equals)
  S= DIM_DISPLAYAREA-2*DIST;
  ps_font(PS_COURIER,10);
  if(cnvtype==C2D)
    {
      snprintf(s,50,"   X0= %15.3f",par2d.x0);
      ps_text(s,X,Y+S+1);
      snprintf(s,50,"\t   Y0= %15.3f",par2d.y0);
      ps_text(s,X+S/2,Y+S+1);
      snprintf(s,50,"   W= %10.3f",par2d.w);
      ps_text(s,X,0);
      snprintf(s,50,"\t H= %10.3f",par2d.h);
      ps_text(s,X+S/3,0);
      // If the grid have been requested you have to
      // write the gridstep
      if( (draw_grid) )
	{
	  snprintf(s,50," GRIDSTEP= %6.4f",gridstep);
	  ps_text(s,X+2*S/3,0);
	}
      // Now the equations
      if( !encfmt  && (lpareq) )
	{
	  int i;
	  struct __prm* eq;
	  char num[4];

	  ps_graylevel(0);
	  ps_font(PS_TIMES_ITALIC,8);
	  if( orientation==PS_PORTRAIT )
	    {
	      for(i=0 ; i<m ; i++)
		{
		  eq=fmteqs(prm[i],C2D);
		  snprintf(num,4,"%d.",i+1);
		  if( (rainbow) )
		    {
		      ps_rgbcolor(paint[i][0],paint[i][1],paint[i][2]);
		      ps_text(num,-15,-21*i-19);
		      ps_graylevel(0);
		    }
		  else
		    ps_text(num,-15,-21*i-19);
		  ps_text("x(t)=",0,-21*i-19);
		  ps_text(eq->x,25,-21*i-19);
		  ps_text("y(t)=",0,-21*i-28);
		  ps_text(eq->y,25,-21*i-28);
		}
	    }
	  else
	    {
	      if( medium != PS_LETTER )
		{
		  for(i=0 ; i<m ; i++)
		    {
		      eq=fmteqs(prm[i],C2D);
		      snprintf(num,4,"%d.",i+1);
		      if( (rainbow) )
			{
			  ps_rgbcolor(paint[i][0],paint[i][1],paint[i][2]);
			  ps_text(num,482,-30*i+450);
			  ps_graylevel(0);
			}
		      else
			ps_text(num,482,-30*i+450);
		      ps_text("x(t)=",482,-30*i+441);
		      ps_text(eq->x,507,-30*i+441);
		      ps_text("y(t)=",482,-30*i+432);
		      ps_text(eq->y,507,-30*i+432);
		    }
		}
	    }
	} // end of if( !encfmt )
    } // end of if(cnvtype...)
  else
    {
      snprintf(s,50,"   X0= %15.3f",par3d.x0);
      ps_text(s,X,Y+S+1);
      snprintf(s,50,"\t   Y0= %15.3f",par3d.y0);
      ps_text(s,X+S/3,Y+S+1);
      snprintf(s,50,"\t   Z0= %15.3f",par3d.z0);
      ps_text(s,X+2*S/3,Y+S+1);
      snprintf(s,50,"   R= %10.3f",par3d.R);
      ps_text(s,X,0);
      // If the grid have been requested you have to
      // write the gridstep
      if( (draw_grid) )
	{
	  snprintf(s,50," GRIDSTEP= %6.4f",gridstep);
	  ps_text(s,X+S/2,0);
	}
      // Now the equations
      if( !encfmt  && (lpareq) )
	{
	  struct __prm* eq;

	  ps_graylevel(0);
	  ps_font(PS_TIMES_ITALIC,8);
	  eq=fmteqs(prm[0],cnvtype);
	  if( orientation==PS_PORTRAIT ) 
	    {
	      if(cnvtype==C3D)
		ps_text("x(t)= ",0,-20);
	      else
		ps_text("x(s,t)= ",0,-20);
	      ps_text(eq->x,25,-20);
	      if(cnvtype==C3D)
		ps_text("y(t)= ",0,-30);
	      else
		ps_text("y(s,t)= ",0,-30);
	      ps_text(eq->y,25,-30);
	      if(cnvtype==C3D)
		ps_text("z(t)= ",0,-40);
	      else
		ps_text("z(s,t)= ",0,-40);
	      ps_text(eq->z,25,-40);
	    }
	  else
	    {
	      if( medium != PS_LETTER )
		{
		  if(cnvtype==C3D)
		    ps_text("x(t)= ",482,450);
		  else
		    ps_text("x(s,t)= ",482,450);
		  ps_text(eq->x,507,450);
		  if(cnvtype==C3D)
		    ps_text("y(t)= ",482,440);
		  else
		    ps_text("y(s,t)= ",482,440);
		  ps_text(eq->y,507,440);
		  if(cnvtype==C3D)
		    ps_text("z(t)= ",482,430);
		  else
		ps_text("z(s,t)= ",482,430);
		  ps_text(eq->z,507,430);
		}
	    }
	} // end if( !encfmt )
    } // end of the outer else
  if( !working_device() )
    return WRITE_ERROR;
  else
    return 0;
}

#define PRHEADER "Performed by Mplot++ - version 0.78 - Copyright (C)  2002   Ivano Primi"

int mycanvas::_print_header(void)
{
  if( !encfmt )
    {
      ps_font(PS_HELVETICA,10);
      ps_text(PRHEADER,0,DIM_DISPLAYAREA+8);
    }
  if( !working_device() )
    return WRITE_ERROR;
  else
    return 0;
}

// This function prints the center in the shape of '+' and draws
// the bounding square too
int mycanvas::_print_center(void)
{
  short X,Y,S;

  // Coordinates of the upper-left corner of the drawing area
  X=Y=DIST;
  // Dimensions of the drawing area (they should be equals)
  S=DIM_DISPLAYAREA-2*DIST;
  if( (rainbow) )
    ps_rgbcolor(255,0,0);
  else
    ps_graylevel(0.5);
  ps_line(X+S/2-3,Y+S/2,X+S/2+3,Y+S/2);
  ps_line(X+S/2,Y+S/2-3,X+S/2,Y+S/2+3);
  // Now the bounding square
  ps_graylevel(0);
  ps_linewidth(0);
  ps_rect(-4,-4,DIM_DISPLAYAREA+8,DIM_DISPLAYAREA+8);
  ps_linewidth(1);
  if( !working_device() )
    return WRITE_ERROR;
  else
    return 0;
}

int mycanvas::_print_axes(void)
{
#define EPS 0.000001
  double x1,y1,x2,y2,cx,cy;
  short  X,Y,S;

  // Coordinates of the upper-left corner of the drawing area
  X=Y=DIST;
  // Dimensions of the canvas (they should be equals)
  S=DIM_DISPLAYAREA-2*DIST;
  ps_font(PS_COURIER,10);
  if(cnvtype==C2D)
    {
      if( absv(par2d.y0) <= par2d.h/2.0 )
	{
	  if( (rainbow) )
	    ps_rgbcolor(0,200,255);
	  else
	    ps_graylevel(0.75);
	  x1= X;
	  x2= X+S;
	  y1=y2= Y+S/2-S*(par2d.y0/par2d.h);
	  ps_line(x1,y1,x2,y2);
	  if( (rainbow) )
	    ps_rgbcolor(110,40,60);
	  else
	    ps_graylevel(0.1);
	  cx= X+S-10;
	  cy= Y+S/2-S*(par2d.y0/par2d.h)+2;
	  ps_text("x",cx,cy);
	}
      if( absv(par2d.x0) <= par2d.w/2.0 )
	{
	  if( (rainbow) )
	    ps_rgbcolor(255,0,255);
	  else
	    ps_graylevel(0.75);
	  y1=Y;
	  y2=Y+S;
	  x1=x2= X+S/2-S*(par2d.x0/par2d.w);
	  ps_line(x1,y1,x2,y2);
	  if( (rainbow) )
	    ps_rgbcolor(110,40,60);
	  else
	    ps_graylevel(0.1);
	  cy= Y+S-10;
	  cx= X+S/2-S*(par2d.x0/par2d.w)+2;
	  ps_text("y",cx,cy);
	}
    }
  else
    {
      struct point P1={
	par3d.x0+par3d.R,par3d.y0,par3d.z0,0
      };
      struct point P2={
	par3d.x0,par3d.y0+par3d.R,par3d.z0,0
      };
      struct point P3={
	par3d.x0,par3d.y0,par3d.z0+par3d.R,0
      };

      P1=Assonometria(&par3d,P1);
      P2=Assonometria(&par3d,P2);
      P3=Assonometria(&par3d,P3);
      if( norm(P1.x,P1.y) > EPS)
	{
	  if( (rainbow) )
	    ps_rgbcolor(0,200,255);
	  else
	    ps_graylevel(0.7);
	  x1= X+S/2+S/2*( xsq(P1.x,P1.y,par3d.R)/par3d.R );
	  y1= Y+S/2+S/2*( ysq(P1.x,P1.y,par3d.R)/par3d.R );
	  x2= X+S/2+S/2*( xsq(-P1.x,-P1.y,par3d.R)/par3d.R );
	  y2= Y+S/2+S/2*( ysq(-P1.x,-P1.y,par3d.R)/par3d.R );
	  ps_line(x1,y1,x2,y2);
	  // Now the label
	  if( (rainbow) )
	    ps_rgbcolor(110,40,60);
	  else
	    ps_graylevel(0.1);
	  x1= X+S/2+S/2*( xsq(P1.x,P1.y,0.97*par3d.R)/par3d.R );
	  y1= Y+S/2+S/2*( ysq(P1.x,P1.y,0.97*par3d.R)/par3d.R );
	  ps_text("x",x1,y1);
	}
      if( norm(P2.x,P2.y) > EPS )
	{
	  if( (rainbow) )
	    ps_rgbcolor(255,0,255);
	  else
	    ps_graylevel(0.6);
	  x1= X+S/2+S/2*( xsq(P2.x,P2.y,par3d.R)/par3d.R );
	  y1= Y+S/2+S/2*( ysq(P2.x,P2.y,par3d.R)/par3d.R );
	  x2= X+S/2+S/2*( xsq(-P2.x,-P2.y,par3d.R)/par3d.R );
	  y2= Y+S/2+S/2*( ysq(-P2.x,-P2.y,par3d.R)/par3d.R );
	  ps_line(x1,y1,x2,y2);
	  // Now the label
	  if( (rainbow) )
	    ps_rgbcolor(110,40,60);
	  else
	    ps_graylevel(0.1);
	  x1= X+S/2+S/2*( xsq(P2.x,P2.y,0.97*par3d.R)/par3d.R );
	  y1= Y+S/2+S/2*( ysq(P2.x,P2.y,0.97*par3d.R)/par3d.R );
	  ps_text("y",x1,y1);
	}
      if( norm(P3.x,P3.y) > EPS )
	{
	  if( (rainbow) )
	    ps_rgbcolor(255,255,0);
	  else
	    ps_graylevel(0.8);
	  x1= X+S/2+S/2*( xsq(P3.x,P3.y,par3d.R)/par3d.R );
	  y1= Y+S/2+S/2*( ysq(P3.x,P3.y,par3d.R)/par3d.R );
	  x2= X+S/2+S/2*( xsq(-P3.x,-P3.y,par3d.R)/par3d.R );
	  y2= Y+S/2+S/2*( ysq(-P3.x,-P3.y,par3d.R)/par3d.R );
	  ps_line(x1,y1,x2,y2);
	  // Now the label
	  if( (rainbow) )
	    ps_rgbcolor(110,40,60);
	  else
	    ps_graylevel(0.1);
	  x1= X+S/2+S/2*( xsq(P3.x,P3.y,0.97*par3d.R)/par3d.R );
	  y1= Y+S/2+S/2*( ysq(P3.x,P3.y,0.97*par3d.R)/par3d.R );
	  ps_text("z",x1,y1);
	}
    }
  if( !working_device() )
    return WRITE_ERROR;
  else
    return 0;
}

int mycanvas::_print_grid(void)
{
  int j,k;
  short X,Y,S;
  double x1,y1,x2,y2;
  struct point P1,P2,P3,P4,Q1,Q2,Q3,Q4;

  if( (rainbow) )
    ps_rgbcolor(0,0,255);
  else
    ps_graylevel(0.5);
  // Coordinates of the upper-left corner of the drawing area
  X=Y=DIST;
  // Dimensions of the drawing area (they should be equals)
  S=DIM_DISPLAYAREA-2*DIST; 
  ps_push_clip(X,Y,S,S);
  if(cnvtype==C2D)
    {
      for(j=0 ; j*gridstep <= par2d.h/2.0 ; j++ )
	{
	  y1= Y+S/2-S*((j*gridstep)/par2d.h);
	  y2= Y+S/2+S*((j*gridstep)/par2d.h);
	  for(k=0 ; k*gridstep <= par2d.w/2.0 ; k++ )  
	    {
	      x1= X+S/2+S*((k*gridstep)/par2d.w);
	      x2= X+S/2-S*((k*gridstep)/par2d.w);
	      ps_point(x1,y1);
	      ps_point(x1,y2);
	      ps_point(x2,y1);
	      ps_point(x2,y2);
	      if( !working_device() )
		return WRITE_ERROR;
	    }
	}
    }
  else
    {
      P1.z=P2.z=par3d.z0;
      P3.x=P4.x=par3d.x0+par3d.R; P3.y=P4.y=par3d.y0;
      P1.color=P2.color=P3.color=0;
      for(j=0 ; j*gridstep <= par3d.R ; j++ )
	{
	  P3.z= par3d.z0+j*gridstep;
	  P4.z= par3d.z0-j*gridstep;
	  Q3=Assonometria(&par3d,P3);
	  Q4=Assonometria(&par3d,P4);
	  x1= X+S/2+S/2*(Q3.x/par3d.R);
	  y1= Y+S/2+S/2*(Q3.y/par3d.R);
	  ps_point(x1,y1);
	  if( (rainbow) )
	    ps_rgbcolor(0,160,0);
	  else
	    ps_graylevel(0.35);
	  x2= X+S/2+S/2*(Q4.x/par3d.R);
	  y2= Y+S/2+S/2*(Q4.y/par3d.R);
	  ps_point(x2,y2);
	  if( (rainbow) )
	    ps_rgbcolor(0,0,255);
	  else
	    ps_graylevel(0.5);
	  /* *** */
	  P1.y= par3d.y0+j*gridstep;
	  P2.y= par3d.y0-j*gridstep;
	  P2.x=P1.x= par3d.x0+par3d.R;
	  Q1=Assonometria(&par3d,P1);
	  Q2=Assonometria(&par3d,P2);
	  x1= X+S/2+S/2*(Q1.x/par3d.R);
	  y1= Y+S/2+S/2*(Q1.y/par3d.R);
	  ps_point(x1,y1);
	  x2= X+S/2+S/2*(Q2.x/par3d.R);
	  y2= Y+S/2+S/2*(Q2.y/par3d.R);
	  ps_point(x2,y2);
	  /* *** */
	  P2.x=P1.x= par3d.x0-par3d.R;
	  Q1=Assonometria(&par3d,P1);
	  Q2=Assonometria(&par3d,P2);
	  x1= X+S/2+S/2*(Q1.x/par3d.R);
	  y1= Y+S/2+S/2*(Q1.y/par3d.R);
	  ps_point(x1,y1);
	  x2= X+S/2+S/2*(Q2.x/par3d.R);
	  y2= Y+S/2+S/2*(Q2.y/par3d.R);
	  ps_point(x2,y2);
	  if( !working_device() )
	    return WRITE_ERROR;
	}
      for(k=0 ; k*gridstep <= par3d.R ; k++ )
	{
	  P1.x= par3d.x0+k*gridstep;
	  P2.x= par3d.x0-k*gridstep;
	  /* *** */
	  P2.y=P1.y= par3d.y0+par3d.R;
	  Q1=Assonometria(&par3d,P1);
	  Q2=Assonometria(&par3d,P2);
	  x1= X+S/2+S/2*(Q1.x/par3d.R);
	  y1= Y+S/2+S/2*(Q1.y/par3d.R);
	  ps_point(x1,y1);
	  x2= X+S/2+S/2*(Q2.x/par3d.R);
	  y2= Y+S/2+S/2*(Q2.y/par3d.R);
	  ps_point(x2,y2);
	  /* *** */
	  P2.y=P1.y= par3d.y0-par3d.R;
	  Q1=Assonometria(&par3d,P1);
	  Q2=Assonometria(&par3d,P2);
	  x1= X+S/2+S/2*(Q1.x/par3d.R);
	  y1= Y+S/2+S/2*(Q1.y/par3d.R);
	  ps_point(x1,y1);
	  x2= X+S/2+S/2*(Q2.x/par3d.R);
	  y2= Y+S/2+S/2*(Q2.y/par3d.R);
	  ps_point(x2,y2);
	  if( !working_device() )
	    return WRITE_ERROR;
	}
    } // end else
  ps_pop_clip();
  return 0;
}
