/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include<cmath>
#include"mplot.h"

extern double number;

/*
  La funzione Call_operation restituisce nella var. "number" il risultato
  di op1 # op2,dove # e' il segno operazionale rappresentato da ope-
  razione.
  Ritorna il valore 0 in caso di successo e valori maggiori di 0
  per la segnalazione di eventuali errori.Per il significato di tali
  valori vedi il file ScMain.c.
*/

short
Call_operation(double op1,double op2,short operazione)
{
  double i1,i2;     /* Variabili ausiliarie */

  switch(operazione)
    {
    case 31:
      number=op1+op2;
      break;
    case 32:
      number=op1-op2;
      break;
    case 33:
      number=op1*op2;
      break;
    case 34:
      if(op2==0)
	return 5;
      number=op1/op2;
      break;
    case 35:
      number=op2*(op1/100);
      break;
    case 36:
      op1=round(op1);  /* Se op1 e op2 non sono interi vengono arrotondati */
      op2=round(op2);
      if(op2==0)
	return 5;
      number=fmod(op1,op2);
      number=round(number);
      break;
    case 37:
      op1=round(op1);  /* Se op1 e op2 non sono interi vengono arrotondati */
      op2=round(op2);
      if(op2==0)
	return 5;
      op1-=fmod(op1,op2);
      number=round(op1/op2);
      break;
    case 38:
      if(op1>0)
	number=exp(op2*log(op1));
      if(op1==0)
	{
	  if(op2>0)
	    number=0;
	  else
	    return 4;
	}
      if(op1<0)
	{
	  i1=modf(op2,&i2);
	  if(i1==0)  /* Se op2 e' un numero intero...*/
	    {
	      if(fmod(op2,2)==0)
		number=exp(op2*log(fabs(op1)));
	      else
		number=-exp(op2*log(fabs(op1)));
	    }
	  else
	    return 3;
	}
      if((number==HUGE_VAL) || (number==-HUGE_VAL))
	return 8;                 /* Segnala un Owerflow */
      break;
    }
  return 0;
}


