//
// Node Plot
//
// 3D Data Visualization Program for a structured mesh.
//    The visualization is performed on a node basis,
//    independantly of the spatial distances. 
//

#include <stdio.h>

void OutputHelpInputFile(){

printf(
"\n"
"===========================================================================\n"
"FORTRAN 77 INPUT FILE TEMPLATE                                             \n"
"---------------------------------------------------------------------------\n"
"     open (unit = 3, file = 'floweg.nod', status = 'unknown')              \n"
"       write (3,*) '4'                                                     \n"
"       write (3,*) 'Temperature [k]'                                       \n"
"       write (3,*) 'Pressure [Pa]'                                         \n"
"       write (3,*) 'X-Position [m]'                                        \n"
"       write (3,*) 'Y-Position [m]'                                        \n"
"       write (3,*) is,ie,js,je,ks,ke                                       \n"
"       do k=ks,ke                                                          \n"
"         do i=is,ie                                                        \n"
"           do j=js,je                                                      \n"
"             write (3,*) T(i,j,k),P(i,j,k),posx(i,j,k),posy(i,j,k)         \n"
"           enddo                                                           \n"
"         enddo                                                             \n"
"       enddo                                                               \n"
"     close(unit=3)                                                         \n"
"\n"
"===========================================================================\n"
"PASCAL INPUT FILE TEMPLATE                                                 \n"
"---------------------------------------------------------------------------\n"
"     VAR outfile:text;                                                     \n"                                    
"     rewrite(outfile,'floweg.nod');                                        \n"
"       writeln(outfile,'4');                                               \n"
"       writeln(outfile,'Temperature [K]');                                 \n"
"       writeln(outfile,'Pressure [Pa]');                                   \n"
"       writeln(outfile,'X-Position [m]');                                  \n"
"       writeln(outfile,'Y-Position [m]');                                  \n"
"       writeln(outfile,is,ie,js,je,ks,ke);                                 \n"
"       for k:=ks to ke do                                                  \n"
"         for i:=is to ie do                                                \n"
"           for j:=js to je do                                              \n"
"             writeln(outfile,T[i,j,k],P[i,j,k],posx[i,j,k],posy[i,j,k]);   \n"
"     close(outfile);                                                       \n"
"\n"
"===========================================================================\n"
"C/C++ INPUT FILE TEMPLATE                                                      \n"
"---------------------------------------------------------------------------\n"
"     FILE *outfile;                                                        \n"
"     outfile = fopen(\"floweg.nod\", \"w\");                               \n"
"       fprintf(outfile, \"4\\n\");                                         \n"
"       fprintf(outfile, \"Temperature [K]\\n\");                           \n"
"       fprintf(outfile, \"Pressure [Pa]\\n\");                             \n"
"       fprintf(outfile, \"X-Position [m]\\n\");                            \n"
"       fprintf(outfile, \"Y-Position [m]\\n\");                            \n"
"       fprintf(outfile, \"%%12ld%%12ld%%12ld%%12ld%%12ld%%12ld\\n\",       \n"
"                          is,ie,js,je,ks,ke);                              \n"
"       for (k = ks; k <= ke; k++) {                                        \n"
"         for (i = is; i <= ie; i++) {                                      \n"
"           for (j = js; j <= je; j++)                                      \n"
"             fprintf(outfile, \"%% .5E%% .5E%% .5E%% .5E\\n\",             \n"
"                     T[i][j][k], P[i][j][k], posx[i][j][k], posy[i][j][k]);\n"
"         }                                                                 \n"
"       }                                                                   \n"
"    fclose(outfile);                                                       \n"
"\n"
"===========================================================================\n"
"\n"
"Include one of the above templates in your numerical method to output your \n"
"3D data in nodplot format. Note that the file type must be ascii and make  \n"
"certain that ke!=ks (!= means <is not equal to>) and je!=js and ie!=is.    \n"
"All help needed to operate the software once the nodplot input file is     \n"
"created can be activated from the Help menu in the program.                \n"
"\n"
);


}


#include "nplot.h"


int chkarg(int argc, char **argv, char *arg){
  int cnt,tmp;
  tmp=0;
  for (cnt=1; cnt<argc; cnt++){
   if (strcmp(argv[cnt],arg) == 0) {
     tmp=cnt;
   }
  }  
  return(tmp);
}



int main( int argc, char **argv )
{
#include "fonts2.h"
    long is,ie,js,je,ks,ke,numprop;
    double *data;
    proptitlename *proptitle;
    Transfo transfo;
    bool validOptions;
    long readfile;

    validOptions = FALSE;
    readfile=0;

    if (chkarg(argc,argv,"-help")!=0) {
      validOptions = TRUE;
      readfile=0;
      OutputHelpInputFile();
    }

    if (chkarg(argc,argv,"-i")!=0) {
      validOptions = TRUE;
      readfile=1+chkarg(argc,argv,"-i");
    }
    
    if (validOptions && readfile!=0) {
        transfo.input_data(argv[readfile],
               &is, &ie, &js, &je, &ks, &ke, &numprop, &proptitle, &data);

        QApplication app( argc, argv );
        QApplication::setFont( font5);

        Nplot nplot;
        nplot.init(argv[1],TRUE,is,ie,js,je,ks,ke,numprop,proptitle,data);
        nplot.show();
        app.setMainWidget( &nplot );
        return app.exec();
    }

    if ( !validOptions ) {
      fprintf( stderr, "\nUsage:\n"
                       "\tnodplot -i <filename> \n"
                       "\t        -geometry <pixelsx>x<pixelsy> \n"
                       "\t        -help      \n\n");
      return 1;
    }


}
