#define ITERATIONS 50
#define MAX_REGISTERED 4

typedef struct {
    int                 state_rec, straddling_rec, quadratic_rec;
    int                 i_rec, *error_rec;
    double              extrapolation_limit_rec;
    double              x1_rec, x2_rec, x3_rec;
    double              f1_rec, f2_rec, f3_rec;
    double              d1_rec, d2_rec, d3_rec;
    double              del_rec, dx_rec, slope_rec;
    double             *xp_rec, difference_rec;
    int                 suggestion_cnt;
    double              suggestion[MAX_REGISTERED];
} INVERSION_REC;

/* spline.c */
int main(int argc, char **argv);
void curv0(int n, int requested);
void value(double s, double *q, double *r, double *v, int n);
char *gmem(int n);
void reverse_array(double x[], int n);
void read_data(int argc, char **argv);
int get_parameter(int argc, char **argv);
int get_double(int argc, char **argv, int permitted, double *a, double *b, double *c);
int streq(char *a, char *b);
void gripe_arg(char *s);
void gripe(char **argv);
void help(void);
int numeric(char *s);
void curv1(double *x, double *y, double *yp, int n);
double curv2(double *x, double *y, double *yp, double t, int n);
double mylog(double x);
double tanh(double x);
double atanh(double x);

/* zero.c */
INVERSION_REC *init_zero(double *xp_, INVERSION_REC *former_rec);
void advise_zero(double value, INVERSION_REC *irp);
int zero(double value, INVERSION_REC *irp);
int show_history(INVERSION_REC *irp);
double fun(double x);
int main(int argc, char **argv);
int show_progress(double x, double y, double target);
