/* Simple contour demo*/
plsfile,"demo4.ps";
plsdev,"ps";          //Select device
plinit;
pladv,0;
plfontld,2;             //Load extended fonts
plfont,2;               //Select font
rnum=100;
tnum=100;

z=array(double,rnum,tnum); //Create matrices
x=array(double,rnum,tnum);
y=array(double,rnum,tnum);

r=span(1,rnum,rnum);       //Calculate datapoints
theta=span(0.005,pi/2,tnum);
for (i=1;i<=rnum;i++)      //C-style for loops
  for (j=1;j<=tnum;j++)
     {x(i,j)=r(i)*cos(theta(j));
      y(i,j)=r(i)*sin(theta(j));
      z(i,j)=sin(x(i,j)^2/10)*y(i,j)^2;
     }
clevel=span(min(z),max(z),20);  //Calculate contour levels
plstick,1,1,1,1,2,2,2,3;        //Use whole page, with extra space
plwind,0,rnum/sqrt(2),20,tnum/sqrt(2); //Set up world coordinates
plcol,15;                              //Select colour
plcont,z,clevel,x,y;                   //Draw contours

plbox,"bcnts",10,0,"bcntvs",10,0;      //Draw box
pllab,"X","Y","Contour Demo"           //Draw labels
plend;                                 //End plotting
quit;                                  //End Yorick interpreter
