//Demo 5: 3D Surfaces
plsfile,"demo5.ps";          //Output file
plsdev,"ps";                 //Device
plspage,600,400,800,600,1,1; //Window size on screen
plinit;                      //Starts plotting
pladv,0;
plfontld,2;                  //Load and select the extended fonts
plfont,2;

xnum=40;                     //Calculate some points
ynum=40;
xmin=-2;
ymin=-2;
xmax=2;
ymax=2;

x=span(xmin,xmax,xnum);
y=span(ymin,ymax,xnum);
z=array(double,xnum,ynum);
z1=array(double,xnum,ynum);

for (i=1;i<=xnum;i++)
  for (j=1;j<=ynum;j++)
     { z(i,j)=0;
//       z1(i,j)=x(i)^2+y(j)^2;
       z1(i,j)=(x(i)+y(j))*exp(-(x(i)^2+y(j)^2));
     }

plcol,15;                                 //Sets up the first 2D window
plstick,2,2,1,1,0,0,0,0;                  //in preparation of the 3D window
plwind,-2.5,2.5,-2.5,4;


plw3d,2,2,3,xmin,xmax,ymin,ymax,0,1,50,-30; //Defines the 3D cuboid
plschr,3,1;
plbox3,"bcmniust","X",0.0,0,"bcmnuist","Y",0.0,0,"gbcdmnstuv","Z",0.0,1;
plot3d,x,y,z1,3,1;  //Draws the 3D box and the first surface

plstick,2,2,2,1,0,0,0,0; //Second 2D window...
plwind,-2.5,2.5,-2.5,4;
plbox,"bc",0.0,0,"bc",0.0,0;
plw3d,2,2,3,xmin,xmax,ymin,ymax,0,1,30,-30; //3D cuboid
plschr,3,1;
plbox3,"bcmniust","X",0.0,0,"bcmnuist","Y",0.0,0,"gbcdmnstuv","Z",0.0,1;
plot3d,x,y,z1,1,1;  //Draws the second 3D box and surface


plstick,2,2,1,2,0,0,0,0;
plwind,-2.5,2.5,-2.5,4;
plw3d,2,2,3,xmin,xmax,ymin,ymax,0,1,30,30;
plbox,"bc",0.0,0,"bc",0.0,0;
plschr,3,1;
plbox3,"bcmniust","X",0.0,0,"bcmnuist","Y",0.0,0,"gbcdmnstuv","Z",0.0,1;
plot3d,x,y,z1,2,1;

plstick,2,2,2,2,0,0,0,0;
plwind,-2.5,2.5,-2.5,4;
plw3d,2,2,3,xmin,xmax,ymin,ymax,-0.5,0.5,30,150;
plschr,3,1;

plbox3,"bcmniust","X",0.0,0,"bcmnuist","Y",0.0,0,"gbcdmnstuv","Z",0.0,1;
pllsty,5;          //Line type can still be changed!
plpmesh,x,y,z1,3;  //Draws a mesh with the bottom side visible.
plend;

quit;
