#define DOUBLE
#include <stdio.h> 
#include <stdlib.h> 
#include "yio.h"

/**********************************************************************/
/* Search for char test in string data, return index, -1 if not found */
/* Tested OK */
int in(char test,char data[])
{ int count;
  int data_len;
  data_len=strlen(data);
  for (count=0;(test!=data[count])&&(count<data_len);++count);
  if (count==data_len) count=-1;        /* string not found */
  return(count);
}

/**********************************************************************/
/* Advance file pointer to one after the first one found belonging to
 * test. Returns -1 if none found or index of char in test found */
 /* Tested OK */
int advance_to(FILE *fle,    /* Input file pointer*/
	      char test[],   /* String to test for  */
              int *found)
{ int count;
  char read;
  do { count=fscanf(fle,"%c",&read);
       *found=in(read,test);
     } while ((*found<0)&&(count>0));
  return(count);            /*returns value of last 'in' function */
}

/**********************************************************************/
/* Advance file pointer to one after the first one found belonging to
 * test. Returns -1 if none found or index of char in test found */
 /* Tested OK */
int sadvance_to(char str[],    /* Input string*/
   	        char test[],   /* String to test for  */
                int *found)
{ int count=0;
  char read;
  do { read=str[count++];
       *found=in(read,test);
     } while ((*found<0)&&(count>0));
  return(count);            /*returns value of last 'in' function */
}

/**********************************************************************/
/* Read chars into data until one of chars in test is met. Returns last
 * fscanf value and last int contains last index of test char found.
 * Both should be 0 if error occured
*/
/* Tested OK */
int read_to(FILE *fle,
	    char test[],       /* Test chars */
	    char data[],       /* Return string */
      const int max_len,       /* String with its max. len. */
            int *found)        /* Number of char found in test */
{ int c_count=0,
      t_count=0;
  char read;
  do { t_count=fscanf(fle,"%c",&read);
       if (t_count>0)                      /* A char found */
          { *found=in(read,test);         /* Check if test char found*/
            if ((*found<0)&&(read!='\n'))
	       { data[c_count]=read;
		 ++c_count;
	       }
          }
       else *found=9999;
     } while ((*found<0)&&(c_count<max_len));
  if (c_count>=0)  data[c_count]='\0';       /* Put on last char */
  return (c_count);
}

/**********************************************************************/
/* Read chars into data until one of chars in test is met. Returns last
 * fscanf value and last int contains last index of test char found.
 * Both should be 0 if error occured
*/
/* Tested OK */
int sread_to(char str[],       /*String to be read */
	    char test[],       /* Test chars */
	    char data[],       /* Return string */
      const int max_len,       /* String with its max. len. */
            int *found)        /* Number of char found in test */
{ int c_count=0,
      t_count=0;
  char read;
  do { read=str[c_count];
       *found=in(read,test);         /* Check if test char found*/
       if (*found<0)
        data[c_count++]=read;
     } while ((*found<0)&&(c_count<max_len));
  if (c_count>=0)  data[c_count]='\0';       /* Put on last char */
  return (c_count);
}


/**********************************************************************/
/* Keep only chars present in in_data corresponding to those in keep*/
/* Tested OK */
int include(char in_data[],        /* Input string  */
	    char out_data[],	  /* Output string */
	    char keep[])           /* String of characters to keep */
{ int in_len,o_len,               /* Length of these strings */
      i_count,k_count,o_count=0;
  in_len=(int)strlen(in_data);
  for (i_count=0;i_count<in_len;++i_count)  /*Go through whole inp. string*/
      { if (in(in_data[i_count],keep)>=0)
            { out_data[o_count]=in_data[i_count];
                  ++o_count;
            }
      }
  out_data[o_count]='\0';                  /* Put on last char */
  return(o_count);
}


int read_one(char name[],int line1,
               int xcol,double *x)
{ int i,j,t;
  char eol[2]={" "};
  char inread[160];
  double g;
  FILE *fle;

  fle=fopen(name,"r");
  eol[0]='\n';
  for (i=0;i<line1-1;++i)    /* Lees tot by beginlyn */
     advance_to(fle,eol,&j);
     for (i=1;i<=xcol;++i)
       { advance_to(fle,"=",&j);
       }
       fscanf(fle,"%lf",x);
  return(0);
  fclose(fle);
 }


void write_data(char fname[],double x[],double y[],int n)
{ FILE *fle;
  int i;
  char error[100];
  fle=fopen(fname,"w");
  if (fle==NULL)
   { sscanf(error,"Unable to open file '%s'!");
     YputsErr(error);
   }
  else 
  { for (i=0;i<n;i++)
    fprintf(fle,"%2.5e %2.5e\n",x[i],y[i]/3.2);
    fprintf(fle,"..\n");
    fclose(fle);
  }
}

int read_block(char fname[], int block, char blockstart[],
               int xcol,double x[], int xnum)
{ int i,j,t;
  char eol[2]={" "}, tmpstr[2]={" "} ,valuestr[100];
  char inread[160],rchar,*sptr;
  double g;
  int llen1=0,llen2=0,len,line,blockcount,endofblock=0,inoff=0,count;
  FILE *fle;

 count=0;
 fle=fopen(fname,"r");
 if(fle!=NULL)
 {eol[0]='\n';
  tmpstr[0]=blockstart[0];
  len=strlen(blockstart);
  blockcount=0;
  do
   { inread[0]=blockstart[0];
    inread[1]='\0';
    i=0;
    while (i<=len-1)
      { t=fscanf(fle,"%c",&rchar);
        if (t<0) break;
        if (rchar==blockstart[i]) i++;
        if (rchar==blockstart[0] && blockstart[i]!=blockstart[0]) i=1;
      }
    if (i==len) blockcount++;
    } while (blockcount<block &&t>0);
   if (t>0)
    { advance_to(fle,eol,&j);
   t=1;
   do
   {llen1=llen2;
    llen2=read_to(fle,eol,inread,160,&j);
   if (t==1 || llen2>=llen1/2) 
   {t++;
    sptr=inread;
      i=1;
      while (i<xcol)
       {  sptr+=sadvance_to(sptr,"*.0123456789",&j);
          sptr+=sadvance_to(sptr," ",&j);
          i++;
       }
      sptr+=sadvance_to(sptr,"*.0123456789",&j);
      sptr-=1;
      sptr+=sread_to(sptr," ",valuestr,100,&j);
      count+=sscanf(valuestr,"%lf",&x[count]); /* lees x data */
      if (count==xnum) exit;
   } else endofblock=1;
  } while (!endofblock);
 } /*if (t>0)*/
} /*if fle!=NULL*/
  return(count);
}


int read_data(char fname[],int line1,int line2,
               int xcol,double x[],int xnum)
{ int i,j,t,count,y;
  char eol[2]={" "};
  char inread[160];
  double g;
  FILE *fle;
  
  count=0;
 fle=fopen(fname,"r");
 if(fle!=NULL)
 {eol[0]='\n';
 j=0;
  for (i=0;(i<line1-1)&& (j==0);++i)    /* Lees tot by beginlyn */
     advance_to(fle,eol,&j);
  if (j==0)
  { for (t=0;t<=line2-line1;++t)
    { for (i=1;i<xcol;++i)
       { advance_to(fle,".*0123456789",&j);
         advance_to(fle," ",&j);
       }
      y=fscanf(fle,"%lf",&x[count]); /* lees x data */
      if (count==xnum) break;
      if (y==1) count++;
      advance_to(fle,eol,&j);
    }  
  }
  return(count);
 }
}

int read_matrix(char fname[],int line1,int line2,
               int xcol,double **x,int xnum)
{ int i,j,t,count,y;
  char eol[2]={" "};
  char inread[160];
  double g;
  FILE *fle;
  
  count=0;
 fle=fopen(fname,"r");
 if(fle!=NULL)
 {eol[0]='\n';
 j=0;
  for (i=0;(i<line1-1)&& (j==0);++i)    /* Lees tot by beginlyn */
     advance_to(fle,eol,&j);
  if (j==0)
  { for (t=0;t<=line2-line1;++t)
    { for (i=1;i<xcol;++i)
       { advance_to(fle,"*0123456789",&j);
         advance_to(fle," ",&j);
       }
      for (i=0;i<xnum;++i)
        y=fscanf(fle,"%lf",&x[count][i]); /* lees x data */
      if (y<=0) break;
      count++;
      advance_to(fle,eol,&j);
    }  
  }
  return(count);
 }
}
