/*
 * keys.h: header for keys.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: keys.h.proto,v 1.6 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _KEYS_H_
#define _KEYS_H_

#define MAX_META 39
#define NUM_KEYMAPS MAX_META + 1

enum KEY_TYPES {
	AUTOREPLY,
	AUTOREPLY_BACK,
	BACKSPACE,
	BACKWARD_CHARACTER,
	BACKWARD_HISTORY,
	BACKWARD_WORD,
	BEGINNING_OF_LINE,
	BLINK,
	BOLD,
#ifdef WANT_CDCC
	CDCC_PLIST,
#endif
	CHANNEL_CHOPS,
	CHANNEL_NONOPS,
	CHANGE_TO_SPLIT,
	CHELP,
	CLEAR_SCREEN,
	COMMAND_COMPLETION,
	CPU_SAVER,
	DCC_PLIST,
	DCC_STATS,
	DELETE_CHARACTER,
	DELETE_NEXT_WORD,
	DELETE_PREVIOUS_WORD,
	DELETE_TO_PREVIOUS_SPACE,
	END_OF_LINE,
#if defined(TRANSLATE)
	ENTER_DIGRAPH,
#endif
	ERASE_LINE,
	ERASE_TO_BEG_OF_LINE,
	ERASE_TO_END_OF_LINE,
	FORWARD_CHARACTER,
	FORWARD_HISTORY,
	FORWARD_WORD,
	HIGHLIGHT_OFF,
	IGNORE_NICK,
	JOIN_LAST_INVITE,
	META1_CHARACTER,
	META2_CHARACTER,
	META3_CHARACTER,
	META4_CHARACTER,
	META5_CHARACTER,
	META6_CHARACTER,
	META7_CHARACTER,
	META8_CHARACTER,
	META9_CHARACTER,
	META10_CHARACTER,
	META11_CHARACTER,
	META12_CHARACTER,
	META13_CHARACTER,
	META14_CHARACTER,
	META15_CHARACTER,
	META16_CHARACTER,
	META17_CHARACTER,
	META18_CHARACTER,
	META19_CHARACTER,
	META20_CHARACTER,
	META21_CHARACTER,
	META22_CHARACTER,
	META23_CHARACTER,
	META24_CHARACTER,
	META25_CHARACTER,
	META26_CHARACTER,
	META27_CHARACTER,
	META28_CHARACTER,
	META29_CHARACTER,
	META30_CHARACTER,
	META31_CHARACTER,
	META32_CHARACTER,
	META33_CHARACTER,
	META34_CHARACTER,
	META35_CHARACTER,
	META36_CHARACTER,
	META37_CHARACTER,
	META38_CHARACTER,
	META39_CHARACTER,
/* If they arent, everything will break.  Got it? */
	NEW_BEGINNING_OF_LINE,
	NEW_SCROLL_BACKWARD,
	NEW_SCROLL_END,
	NEW_SCROLL_FORWARD,
	NEXT_WINDOW,
	NICK_COMPLETION,
	NOTHING,
	PARSE_COMMAND,
	PREVIOUS_WINDOW,
	QUIT_IRC,
	QUOTE_CHARACTER,
	REFRESH_INPUTLINE,
	REFRESH_SCREEN,
	REVERSE,
	SCROLL_BACKWARD,
	SCROLL_END,
	SCROLL_FORWARD,
	SCROLL_START,
	SELF_INSERT,
	SEND_LINE,
	SHOVE_TO_HISTORY,
#ifdef ALLOW_STOP_IRC
	STOP_IRC,
#endif
	SWAP_LAST_WINDOW,
	SWAP_NEXT_WINDOW,
	SWAP_PREVIOUS_WINDOW,
	SWITCH_CHANNELS,
	TAB_MSG,
	TAB_MSG_BACK,
	TOGGLE_CLOAK,
	TOGGLE_INSERT_MODE,
	TOGGLE_STOP_SCREEN,
	TRANSPOSE_CHARACTERS,
	TYPE_TEXT,
	UNCLEAR_TEXT,
	UNDERLINE,
	UNSTOP_ALL_WINDOWS,
	WHOLEFT,
	
	WINDOW_BALANCE,
	WINDOW_GROW_ONE,
	WINDOW_HELP,
	WINDOW_HIDE,
	WINDOW_KILL,
	WINDOW_LISTK,
	WINDOW_MOVE,
	WINDOW_SHRINK_ONE,
	
	WINDOW_SWAP_1,
	WINDOW_SWAP_2,
	WINDOW_SWAP_3,
	WINDOW_SWAP_4,
	WINDOW_SWAP_5,
	WINDOW_SWAP_6,
	WINDOW_SWAP_7,
	WINDOW_SWAP_8,
	WINDOW_SWAP_9,
	WINDOW_SWAP_10,
	YANK_FROM_CUTBUFFER,
	NUMBER_OF_FUNCTIONS
};

/* I hate typdefs... */
typedef void (*KeyBinding) (char, char *);

/* KeyMap: the structure of the irc keymaps */
typedef struct
{
	enum KEY_TYPES	key_index;
		char	*stuff;
		char	changed;
}	KeyMap;


/* KeyMapNames: the structure of the keymap to realname array */
typedef struct
{
	char	*name;
	KeyBinding func;
}	KeyMapNames;

typedef KeyMap          *KeyTable[256];

extern	KeyTable	*keys[NUM_KEYMAPS];
extern	KeyMapNames key_names[];

	void		save_bindings 		(FILE *, int);
	void		bindcmd 		(char *, char *, char *, char *);
	void    	rbindcmd 		(char *, char *, char *, char *);
	void    	parsekeycmd 		(char *, char *, char *, char *);
	void    	type 			(char *, char *, char *, char *);
	void		init_keys_1 		(void);
	void            remove_bindings         (void);
	void		disable_stop		(void);	
#endif /* _KEYS_H_ */
