/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __BG_HPP__
#define __BG_HPP__

// Blum-Goldwasser's probabilistic encryption

#include "globals.hpp"
#include "obn.hpp"
#include "blumblumshub.hpp"
#include "der.hpp"
#include "public.hpp"

#define BG_PRIVATE_KEY_VERSION			0

#define BEGIN_BG_PRIVATE_KEY			"-----BEGIN BLUM-GOLDWASSER PRIVATE KEY-----"
#define END_BG_PRIVATE_KEY				"-----END BLUM-GOLDWASSER PRIVATE KEY-----"
#define BEGIN_BG_PUBLIC_KEY			"-----BEGIN BLUM-GOLDWASSER PUBLIC KEY-----"
#define END_BG_PUBLIC_KEY				"-----END BLUM-GOLDWASSER PUBLIC KEY-----"

class SCL_API CBGKey : public CAsymmetricKey, public CBlumBlumShubPRNG
{
	public:
		CBGKey();
		CBGKey(Word);
		CBGKey(const CProbablePrime &, const CProbablePrime &, const CBigNumber &, const CBigNumber &);
		CBGKey(const CBigNumber &);
		CBGKey(const CBGKey &);
	
	public:
		CBigNumber & GetN() { return N; };
		CProbablePrime & GetP() { return P; };
		CProbablePrime & GetQ() { return Q; };
		CBigNumber & GetS() { return S; };
		CBigNumber & GetA() { return A; };
		CBigNumber & GetB() { return B; };
		Word GetBits() { return wBits; };
		void SetS(const CBigNumber &S) { CBGKey::S = S; };

	public:
		bool EncryptOnlyFlag() { return fgEncryptOnly; };
		bool HoldKeyFlag() { return fgHoldKey; };
		virtual void WritePrivateKey(int, bool = true);
		virtual void WritePublicKey(int, bool = true);
		virtual void ReadPrivateKey(int, bool = true);
		virtual void ReadPublicKey(int, bool = true);
		void Next();
		void Dump();
		Word Check();

	private:
		bool fgEncryptOnly;
		bool fgHoldKey;
		CBigNumber A, B;
};

class SCL_API CBGBlock : public CAsymmetricBlock
{
	public:
		CBGBlock(const CBGKey &, void *, Word, const CBigNumber &);
		CBGBlock(const CBGKey &, void *, Word);
		CBGBlock(const CBGKey &, const CBigNumber &, const CBigNumber &);
		CBGBlock(const CBGKey &, const CBigNumber &);
		CBGBlock(const CBGKey &);
	
	public:
		virtual void Encrypt();
		virtual void Decrypt();
		virtual void Write(int);					// write ciphertext to descriptor
		virtual void Read(int);						// read ciphertext from descriptor
		virtual void SetData(Byte *, Word);		// plaintext
		virtual Byte *GetData();					// plaintext
		virtual Word GetDataSize();				// plaintext

	public:
		void Dump();

	private:
		CBigNumber cData;
		CBGKey cKey;
		Byte bBuffer[BLOCK];
		Byte *bData;
		Word wLength;
};

#endif // __BG_HPP__
