/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __DIAMOND_HPP__
#define __DIAMOND_HPP__

#include <string.h>

#include "globals.hpp"
#include "block.hpp"

#define DIAMONDROUNDS 10

typedef Byte DKEYS[DIAMONDROUNDS][16][256];

class SCL_API CDiamondKey : public CBlockKey
{
	public:
		enum { KEYSIZE = 16 };

	public:
		CDiamondKey();
		CDiamondKey(const CDiamondKey &);
		CDiamondKey(const Byte *, Word = KEYSIZE);
		virtual ~CDiamondKey();

	public:
		Byte GetMaster(Word i) const { return bMaster[i]; };
		const DKEYS & GetSBox() const { return bS; };
		const DKEYS & GetTBox() const { return bT; };

	public:
		virtual Word GetKeySize() { return KEYSIZE; };

	private:
		void MakeKeys();

	private:
		Byte bMaster[16];
		DKEYS bS;
		DKEYS bT;
};

class SCL_API CDiamondBlock : public CBlockObject
{
	public:
		enum { BLOCKSIZE = 16 };

	public:
		CDiamondBlock();
		CDiamondBlock(const CDiamondBlock &);
		CDiamondBlock(Byte *);
		CDiamondBlock(const Byte *, Word = BLOCKSIZE);
		virtual ~CDiamondBlock();

	public:
		virtual void Encrypt(const CBlockKey &cKey) { Encrypt((const CDiamondKey &)cKey); };
		virtual void Decrypt(const CBlockKey &cKey) { Decrypt((const CDiamondKey &)cKey); };
		virtual void SetData(const Byte *, Word = BLOCKSIZE);
		virtual Byte *GetData();
		virtual Word GetBlockSize() { return BLOCKSIZE; };

	public:
		void Encrypt(const CDiamondKey &);
		void Decrypt(const CDiamondKey &);
		Byte GetData(Word);

	private:
		Byte bData[16];
};

#endif // __DIAMOND_HPP__
