/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __DSA_HPP__
#define __DSA_HPP__

#include "globals.hpp"
#include "obn.hpp"
#include "primes.hpp"
#include "der.hpp"
#include "public.hpp"

#define DSA_PRIVATE_KEY_VERSION		0

#define BEGIN_DSA_PRIVATE_KEY			"-----BEGIN DSA PRIVATE KEY-----"
#define END_DSA_PRIVATE_KEY			"-----END DSA PRIVATE KEY-----"
#define BEGIN_DSA_PUBLIC_KEY			"-----BEGIN DSA PUBLIC KEY-----"
#define END_DSA_PUBLIC_KEY				"-----END DSA PUBLIC KEY-----"
#define BEGIN_DSA_PARAMS				"-----BEGIN DSA PARAMS-----"
#define END_DSA_PARAMS					"-----END DSA PARAMS-----"

class SCL_API CDSAKey : public CAsymmetricKey
{
	public:
		CDSAKey();
		CDSAKey(Word);
		CDSAKey(const CDSAKey &);
		CDSAKey(const CProbablePrime &, const CProbablePrime &, const CProbablePrime &, const CBigNumber &);
		CDSAKey(const CProbablePrime &, const CProbablePrime &, const CProbablePrime &, const CBigNumber &, const CBigNumber &);
	
	public:
		CBigNumber & GetPublic() { return cPublic; };
		CBigNumber & GetPrivate() { return cPrivate; };
		CBigNumber & GetGenerator() { return cGenerator; };
		CProbablePrime & GetPrime() { return cPrime; };
		CProbablePrime & GetSubPrime() { return cSubPrime; };
		Word GetPrimeSize() { return wPrimeSize; };
		Word GetSubPrimeSize() { return wSubPrimeSize; };
	
	public:
		bool EncryptOnlyFlag() { return fgEncryptOnly; };
		bool HoldKeyFlag() { return fgHoldKey; };
		void GenerateKeys();
		virtual void WritePrivateKey(int, bool = true);
		virtual void WritePublicKey(int, bool = true);
		void WriteParams(int, bool = true);
		void WriteParams(char *, bool = true);
		virtual void ReadPrivateKey(int, bool = true);
		virtual void ReadPublicKey(int, bool = true);
		void ReadParams(int, bool = true);
		void ReadParams(char *, bool = true);
		void Dump();
		Word Check();
	
	private:
		CProbablePrime cPrime, cSubPrime, cGenerator;
		CBigNumber cPublic, cPrivate;
		Word wPrimeSize, wSubPrimeSize;
		bool fgHoldParams;
		bool fgHoldKey;
		bool fgEncryptOnly;
};

class SCL_API CDSABlock
{
	public:
		CDSABlock(const CDSAKey &, void *, Word);
		CDSABlock(const CDSAKey &, const CBigNumber &);
	
	public:
		void Sign();
		void Verify();

	public:
		CBigNumber & GetData() { return cData; };
		CBigNumber & GetCipher1() { return cCipher1; };
		CBigNumber & GetCipher2() { return cCipher2; };
		void Dump();

	private:
		CDSAKey cKey;
		CBigNumber cData;
		CBigNumber cCipher1;
		CBigNumber cCipher2;
};

#endif // __DSA_HPP__
