/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __ELGAMAL_HPP__
#define __ELGAMAL_HPP__

#include "globals.hpp"
#include "obn.hpp"
#include "primes.hpp"
#include "der.hpp"
#include "public.hpp"

#define ELGAMAL_PRIVATE_KEY_VERSION			0

#define BEGIN_ELGAMAL_PRIVATE_KEY			"-----BEGIN ELGAMAL PRIVATE KEY-----"
#define END_ELGAMAL_PRIVATE_KEY				"-----END ELGAMAL PRIVATE KEY-----"
#define BEGIN_ELGAMAL_PUBLIC_KEY				"-----BEGIN ELGAMAL PUBLIC KEY-----"
#define END_ELGAMAL_PUBLIC_KEY				"-----END ELGAMAL PUBLIC KEY-----"
#define BEGIN_ELGAMAL_PARAMS					"-----BEGIN ELGAMAL PARAMS-----"
#define END_ELGAMAL_PARAMS						"-----END ELGAMAL PARAMS-----"

class SCL_API CElGamalKey : public CAsymmetricKey
{
	public:
		CElGamalKey();
		CElGamalKey(Word);
		CElGamalKey(const CElGamalKey &);
		CElGamalKey(const CProbablePrime &, const CProbablePrime &, const CBigNumber &);
		CElGamalKey(const CProbablePrime &, const CProbablePrime &, const CBigNumber &, const CBigNumber &);
	
	public:
		CProbablePrime & GetPrime() { return cPrime; };
		CProbablePrime & GetGenerator() { return cGenerator; };
		CBigNumber & GetPublic() { return cPublic; };
		CBigNumber & GetPrivate() { return cPrivate; };

	public:
		bool EncryptOnlyFlag() { return fgEncryptOnly; };
		bool HoldKeyFlag() { return fgHoldKey; };
		void GenerateKeys();
		virtual void WritePrivateKey(int, bool = true);
		virtual void WritePublicKey(int, bool = true);
		void WriteParams(int, bool = true);
		void WriteParams(char *, bool = true);
		virtual void ReadPrivateKey(int, bool = true);
		virtual void ReadPublicKey(int, bool = true);
		void ReadParams(int, bool = true);
		void ReadParams(char *, bool = true);
		void Dump();
		Word Check();
	
	private:
		CProbablePrime cPrime, cGenerator;
		CBigNumber cPublic, cPrivate;
		Word wPrimeSize;
		bool fgHoldParams;
		bool fgHoldKey;
		bool fgEncryptOnly;
};

class SCL_API CElGamalBlock : public CAsymmetricBlock
{
	public:
		CElGamalBlock(const CElGamalKey &);
		CElGamalBlock(const CElGamalKey &, void *, Word);
		CElGamalBlock(const CElGamalKey &, const CBigNumber &);
		CElGamalBlock(const CElGamalKey &, const CBigNumber &, const CBigNumber &);
	
	public:
		virtual void Encrypt();
		virtual void Decrypt();
		virtual void Write(int);						// ciphertext
		virtual void Read(int);							// ciphertext
		virtual void SetData(Byte *, Word);			// plaintext
		virtual Byte *GetData();						// plaintext
		virtual Word GetDataSize();					// plaintext

	public:
		void Dump();

	private:
		CElGamalKey cKey;
		CBigNumber c, d;
};

#endif // __ELGAMAL_HPP__
