#!/usr/bin/perl -w

# We calc @a and @b to multiply in GF(2 ** 8)
$a[0] = 1;
for (1 .. 255) {
	$a[$_] = $a[$_ - 1] << 1;
	$a[$_] ^= 0x1f5 if ($a[$_] & 0x100);
}
$b[0] = 0;
$b[$a[$_]] = $_ for (1 .. 255);

print <<EOT;
// Automatically generated header.
// See "gf256.pl" for more information.
// Do not edit by hand.

#ifndef __GF256_1F5_HPP__
#define __GF256_1F5_HPP__

static Byte bA[] =
{
EOT

for (0 .. 255) {
	printf("\t") if ($_ % 8 == 0);
	printf("%3d, ", $a[$_]) if (($_ + 1) % 8 != 0);
	printf("%3d,\n", $a[$_]) if (($_ + 1) % 8 == 0);
}

print <<EOT;
};

static Byte bB[] =
{
EOT

for (0 .. 255) {
	printf("\t") if ($_ % 8 == 0);
	printf("%3d, ", $b[$_]) if (($_ + 1) % 8 != 0);
	printf("%3d,\n", $b[$_]) if (($_ + 1) % 8 == 0);
}

print <<EOT;
};

#define gf256_1f5_mul(a, b) (((a) && (b)) ? bA[(bB[a] + bB[b]) % 255] : 0)

#endif // __GF256_1F5_HPP__
EOT
