/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __NR_HPP__
#define __NR_HPP__

// Nyberg-Rueppel's encryption scheme

#include "globals.hpp"
#include "obn.hpp"
#include "primes.hpp"
#include "public.hpp"
#include "der.hpp"

#define NR_PRIVATE_KEY_VERSION			0

#define BEGIN_NR_PRIVATE_KEY			"-----BEGIN NYBERG-RUEPPEL PRIVATE KEY-----"
#define END_NR_PRIVATE_KEY				"-----END NYBERG-RUEPPEL PRIVATE KEY-----"
#define BEGIN_NR_PUBLIC_KEY			"-----BEGIN NYBERG-RUEPPEL PUBLIC KEY-----"
#define END_NR_PUBLIC_KEY				"-----END NYBERG-RUEPPEL PUBLIC KEY-----"

class SCL_API CNRKey
{
	public:
		CNRKey();
		CNRKey(Word);
		CNRKey(const CNRKey &);
		CNRKey(const CProbablePrime &, const CProbablePrime &, const CBigNumber &, const CBigNumber &);
		CNRKey(const CProbablePrime &, const CProbablePrime &, const CBigNumber &, const CBigNumber &, const CBigNumber &);
	
	public:
		CBigNumber & GetPublic() { return cPublic; };
		CBigNumber & GetPrivate() { return cPrivate; };
		CBigNumber & GetGenerator() { return cGenerator; };
		CProbablePrime & GetPrime() { return cPrime; };
		CProbablePrime & GetSubPrime() { return cSubPrime; };
		Word GetPrimeSize() { return wPrimeSize; };
		Word GetSubPrimeSize() { return wSubPrimeSize; };
	
	public:
		void WritePrivateKey(int, bool = true);
		void WritePublicKey(int, bool = true);
		void ReadPrivateKey(int, bool = true);
		void ReadPublicKey(int, bool = true);
		void Dump();
	
	private:
		void GenerateKeys();
	
	private:
		CProbablePrime cPrime, cSubPrime;
		CBigNumber cGenerator, cPublic, cPrivate;
		Word wPrimeSize, wSubPrimeSize;
};

class SCL_API CNRBlock
{
	public:
		CNRBlock(const CNRKey &, void *, Word);
		CNRBlock(const CNRKey &, const CBigNumber &);
	
	public:
		void Sign();
		void Verify();

	public:
		CBigNumber & GetData() { return cData; };
		CBigNumber & GetCipher() { return cCipher; };
		void Dump();

	private:
		CNRKey cKey;
		CBigNumber cData;
		CBigNumber cCipher;
};

#endif // __NR_HPP__
