/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __RC6_HPP__
#define __RC6_HPP__

#include <string.h>

#include "globals.hpp"
#include "block.hpp"

// w = 32
// r = 20
// b = 16
// RC6-32/20/16

class SCL_API CRC6Key : public CBlockKey
{
	public:
		enum { KEYSIZE = 16 };

	public:
		CRC6Key();
		CRC6Key(const CRC6Key &);
		CRC6Key(const Byte *, Word = KEYSIZE);
		virtual ~CRC6Key();

	public:
		const Byte *GetMaster() const { return bMaster; };
		Word GetKey(Word i) const { return wKey[i]; };

	public:
		virtual Word GetKeySize() { return KEYSIZE; };

	private:
		void MakeKeys();

	private:
		Byte bMaster[16];
		Word wKey[44];
};

class SCL_API CRC6Block : public CBlockObject
{
	public:
		enum { BLOCKSIZE = 16 };

	public:
		CRC6Block();
		CRC6Block(const CRC6Block &);
		CRC6Block(Dword, Dword);
		CRC6Block(const Byte *, Word = 16);
		virtual ~CRC6Block();

	public:
		virtual void Encrypt(const CBlockKey &cKey) { Encrypt((const CRC6Key &)cKey); };
		virtual void Decrypt(const CBlockKey &cKey) { Decrypt((const CRC6Key &)cKey); };
		virtual void SetData(const Byte *, Word = BLOCKSIZE);
		virtual Byte *GetData();
		virtual Word GetBlockSize() { return BLOCKSIZE; };

	public:
		void Encrypt(const CRC6Key &);
		void Decrypt(const CRC6Key &);
		void SetData(Dword, Dword);
		Dword GetData(Word);

	private:
		Dword dwData[2];
};

#endif // __RC6_HPP__
