#!/usr/bin/perl -w

$a[0] = 1;
for (1 .. 255) {
	$a[$_] = $a[$_ - 1] ^ ($a[$_ - 1] << 1) % 256;
	$a[$_] ^= 0x1b if ($a[$_ - 1] & 0x80);
}
$b[0] = 0;
$b[$a[$_]] = $_ for (1 .. 255);

$r[0] = 1;
for (1 .. 9) {
	$r[$_] = ($r[$_ - 1] << 1) % 256;
	$r[$_] ^= 0x1b if ($r[$_ - 1] & 0x80);
}

print <<EOT;
// Automatically generated header.
// See "rijndaeltables.pl" for more information.
// Do not edit by hand.

#ifndef __RIJNDAELTABLES_HPP__
#define __RIJNDAELTABLES_HPP__

Word wR[] =
{
EOT

printf("\t");
printf("0x%02x, ", $r[$_]) for (0 .. 8);
printf("0x%02x\n", $r[9]);

print <<EOT;
};

Byte bSt[] =
{
EOT

for (0 .. 255) {
	$p = (($_ != 0) ? $a[255 - $b[$_]] : 0);
	$q = $p;
	for ($t = 0; $t < 4; $t++) {
		$q = (($q >> 7) | ($q << 1)) % 256;
		$p ^= $q;
	}
	$p ^= 0x63;
	$c[$_] = $p;
}

for (0 .. 255) {
	printf("\t") if ($_ % 8 == 0);
	printf("0x%02x,", $c[$_]);
	printf(" ") if (($_ + 1) % 8 != 0);
	printf("\n") if (($_ + 1) % 8 == 0);
}

print <<EOT;
};

Byte bIt[] =
{
EOT

$d[$c[$_]] = $_ for (0 .. 255);

for (0 .. 255) {
	printf("\t") if ($_ % 8 == 0);
	printf("0x%02x,", $d[$_]);
	printf(" ") if (($_ + 1) % 8 != 0);
	printf("\n") if (($_ + 1) % 8 == 0);
}

print <<EOT;
};

Word wF[][256] =
{
EOT

for ($i = 0; $i < 4; $i++) {
	printf("\t{\n");
	for (0 .. 255) {
		$p = $c[$_];
		$t = mul(2, $p) | ($p << 8) | ($p << 16) | (mul(3, $p) << 24);
		$t = ($t << ($i * 8)) | ($t >> (32 - $i * 8));
		printf("\t\t") if ($_ % 4 == 0);
		printf("0x%08xL,", $t);
		printf(" ") if (($_ + 1) % 4 != 0);
		printf("\n") if (($_ + 1) % 4 == 0);
	}
	printf("\t},\n");
}

print <<EOT;
};

Word wI[][256] =
{
EOT

for ($i = 0; $i < 4; $i++) {
	printf("\t{\n");
	for (0 .. 255) {
		$p = $d[$_];
		$t = mul(14, $p) |
		(mul(9, $p) << 8) |
		(mul(13, $p) << 16) |
		(mul(11, $p) << 24);
		$t = ($t << ($i * 8)) | ($t >> (32 - $i * 8));
		printf("\t\t") if ($_ % 4 == 0);
		printf("0x%08xL,", $t);
		printf(" ") if (($_ + 1) % 4 != 0);
		printf("\n") if (($_ + 1) % 4 == 0);
	}
	printf("\t},\n");
}

print <<EOT;
};

#endif // __RIJNDAELTABLES_HPP__
EOT

# Calculates the product of $_[0] and $_[1] in GF(2 ** 8).
sub mul
{
	return 0 if ($_[0] == 0 || $_[1] == 0);
	return $a[($b[$_[0]] + $b[$_[1]]) % 255];
}
