#!/usr/bin/perl -w

print <<EOT;
// Automatically generated header.
// See "safersboxes.pl" for more information.
// Do not edit by hand.

#ifndef __SAFERSBOXES_HPP__
#define __SAFERSBOXES_HPP__

Byte S[] =
{
EOT

$g = 45;
$S[0] = 1;
$T[1] = 0;
for (1 .. 255) {
	$t = ($g * $S[$_ - 1]) % 257;
	$S[$_] = $t;
	$T[$t] = $_;
}
$S[128] = 0;
$T[0] = 128;

printf("\t");
for (0 .. 254) {
	if (($_ + 1) % 16 == 0) {
		printf("%3d,\n\t", $S[$_]);
	} else {
		printf("%3d, ", $S[$_]);
	}
}
printf("%3d\n", $S[255]);

print <<EOT;
};

Byte T[] =
{
EOT

printf("\t");
for (0 .. 254) {
	if (($_ + 1) % 16 == 0) {
		printf("%3d,\n\t", $T[$_]);
	} else {
		printf("%3d, ", $T[$_]);
	}
}
printf("%3d\n", $T[255]);

print <<EOT;
};

Byte B[][8] =
{
EOT
for ($i = 2; $i <= 27; $i++) {
	printf("\t{ ");
	for (1 .. 7) {
		printf("%3d, ", $S[$S[9 * $i + $_]]);
	}
	if ($i == 27) {
		printf("%3d }\n", $S[$S[9 * $i + 8]]);
	} else {
		printf("%3d },\n", $S[$S[9 * $i + 8]]);
	}
}

print <<EOT;
};

#endif // __SAFERSBOXES_HPP__
EOT
