/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SERPENT_HPP__
#define __SERPENT_HPP__

#include <string.h>

#include "globals.hpp"
#include "block.hpp"

class SCL_API CSerpentKey : public CBlockKey
{
	public:
		enum { KEYSIZE = 16, MAXKEYSIZE = 32 };

	public:
		CSerpentKey();
		CSerpentKey(const CSerpentKey &);
		CSerpentKey(const Word *, Word);
		CSerpentKey(const Byte *, Word);
		virtual ~CSerpentKey();

	public:
		const Word *GetMaster() const { return wMaster; };
		Word GetKey(Word i) const { return wKey[i]; };
		const Word *GetKeys() const { return wKey; };
		Word GetKeyLength() const { return wKeyLength; };
	
	public:
		virtual Word GetKeySize() { return wKeyLength * BYTESINWORD; };

	private:
		void MakeKeys();

	private:
		Word wMaster[8];
		Word wKey[140];
		Word wKeyLength;
};

class SCL_API CSerpentBlock : public CBlockObject
{
	public:
		enum { BLOCKSIZE = 16 };

	public:
		CSerpentBlock();
		CSerpentBlock(const CSerpentBlock &);
		CSerpentBlock(Word, Word, Word, Word);
		CSerpentBlock(const Byte *, Word = BLOCKSIZE);
		virtual ~CSerpentBlock();

	public:
		virtual void Encrypt(const CBlockKey &cKey) { Encrypt((const CSerpentKey &)cKey); };
		virtual void Decrypt(const CBlockKey &cKey) { Decrypt((const CSerpentKey &)cKey); };
		virtual void SetData(const Byte *, Word = BLOCKSIZE);
		virtual Byte *GetData();
		virtual Word GetBlockSize() { return BLOCKSIZE; };

	public:
		void Encrypt(const CSerpentKey &);
		void Decrypt(const CSerpentKey &);
		void SetData(Word, Word, Word, Word);
		Word GetData(Word);

	private:
		Word wData[4];
		Word wResult[4];
};

#endif // __SERPENT_HPP__
