#!/usr/bin/perl -w

@t = (0xd6, 0x7b, 0x3d, 0x1f, 0x0f, 0x05, 0x03, 0x01, 0xb1);

print <<EOT;
// Automatically generated header.
// See "sharktables.pl" for more information.
// Do not edit by hand.

#ifndef __SHARKTABLES_HPP__
#define __SHARKTABLES_HPP__

Byte bSHARKE[] =
{
EOT

# We calc @a and @b to multiply in GF(2 ** 8)
$a[0] = 1;
for (1 .. 255) {
	$a[$_] = $a[$_ - 1] << 1;
	$a[$_] ^= 0x1f5 if ($a[$_] & 0x100);
}
$b[0] = 0;
$b[$a[$_]] = $_ for (1 .. 255);

$c[0] = 0;
$c[1] = 1;
$c[$_] = $a[255 - $b[$_]] for (2 .. 255);

for (0 .. 255) {
	$i = $c[$_];
	$c[$_] = 0;
	for ($v = 0; $v < 8; $v++) {
		$u = $i & $t[$v];
		$c[$_] ^= ((($u     ) ^ ($u >> 1) ^ ($u >> 2) ^ ($u >> 3) ^
					   ($u >> 4) ^ ($u >> 5) ^ ($u >> 6) ^ ($u >> 7)) & 1) << (7 - $v);
	}
	$c[$_] ^= $t[8];
	printf("\t") if ($_ % 8 == 0);
	printf("%3d, ", $c[$_]) if (($_ + 1) % 8 != 0);
	printf("%3d,\n", $c[$_]) if (($_ + 1) % 8 == 0);
}

print <<EOT;
};

Byte bSHARKD[] =
{
EOT

$d[$c[$_]] = $_ for (0 .. 255);

for (0 .. 255) {
	printf("\t") if ($_ % 8 == 0);
	printf("%3d, ", $d[$_]) if (($_ + 1) % 8 != 0);
	printf("%3d,\n", $d[$_]) if (($_ + 1) % 8 == 0);
}

@g = (2, 1, 0, 0, 0, 0, 0, 0, 0);
for (2 .. 8) {
	for ($j = 8; $j > 0; $j--) {
		if ($g[$j]) {
			$g[$j] = $g[$j - 1] ^ $a[($_ + $b[$g[$j]]) % 255];
		} else {
			$g[$j] = $g[$j - 1];
		}
	}
	$g[0] = $a[($_ + $b[$g[0]]) % 255];
}

@q = (0, 0, 0, 0, 0, 0, 0, 0, 1);
for($i = 0; $i < 8; $i++) {
	if ($q[8]) {
		$q[8 - $_] ^= mul($q[8], $g[8 - $_]) for (1 .. 8);
	}
	$q[8] = 0;
	$e[7 - $i][7 - $_] = $q[$_] for (0 .. 7);
	$q[9 - $_] = $q[8 - $_] for (1 .. 8);
	$q[0] = 0;
}

#print <<EOT;
#};
#
#BYTE bSHARKG[8][8] =
#{
#EOT
#
#for ($i = 0; $i < 8; $i++) {
#	printf("\t{ ");
#	printf("0x%02x, ", $e[$i][$_]) for (0 .. 6);
#	printf("0x%02x ", $e[$i][7]);
#	printf("},\n");
#}

if (inverse()) {
print <<EOT;
};

#error "Noninvertible matrix G. See sharktables.pl for more information."

#endif // __SHARKTABLES_HPP__
EOT
	exit;
}

print <<EOT;
};

Byte bSHARKI[8][8] =
{
EOT

for ($i = 0; $i < 8; $i++) {
	printf("\t{ ");
	printf("0x%02x, ", $f[$i][$_]) for (0 .. 6);
	printf("0x%02x ", $f[$i][7]);
	printf("},\n");
}

print <<EOT;
};

Dword dwSHARKE[][256] =
{
EOT

for ($i = 0; $i < 8; $i++) {
	printf("\t{\n");
	for ($j = 0; $j < 256; $j++) {
		printf("\t\t") if ($j % 4 == 0);
		printf("DWORDCONST(0x");
		printf("%02x", mul($c[$j], $e[$_][$i])) for (0 .. 7);
		printf("), ") if (($j + 1) % 4 != 0);
		printf("),\n") if (($j + 1) % 4 == 0);
	}
	printf("\t},\n");
}

print <<EOT;
};

Dword dwSHARKD[][256] =
{
EOT

for ($i = 0; $i < 8; $i++) {
	printf("\t{\n");
	for ($j = 0; $j < 256; $j++) {
		printf("\t\t") if ($j % 4 == 0);
		printf("DWORDCONST(0x");
		printf("%02x", mul($d[$j], $f[$_][$i])) for (0 .. 7);
		printf("), ") if (($j + 1) % 4 != 0);
		printf("),\n") if (($j + 1) % 4 == 0);
	}
	printf("\t},\n");
}

print <<EOT;
};

#endif // __SHARKTABLES_HPP__
EOT

# Calculates the product of $_[0] and $_[1] in GF(2 ** 8).
sub mul
{
	return 0 if ($_[0] == 0 || $_[1] == 0);
	return $a[($b[$_[0]] + $b[$_[1]]) % 255];
}

# Calculates the inverse of the matrix @e (with size 8 x 8) in GF(2 ** 8).
# The input matrix is in @e.
# The output matrix is in @f.
# @z is a temp matrix.
# Returns 0 in success and 1 if the matrix is noninvertible.
sub inverse
{
	for($i = 0; $i < 8; $i++) {			# Construct the extended matrix in @z
		$z[$i][$_] = $e[$i][$_] for (0 .. 7);
		$z[$i][$_] = 0 for(8 .. 15);
		$z[$i][$i + 8] = 1;
	}
	for($i = 0; $i < 8; $i++) {			# For each row of the extended matrix
		$p = $z[$i][$i];						# The i-th element of the main diagonal
		if ($p == 0) {							# If we have zero on tha main diagonal
			$t = $i + 1;						# swap the $i-th line with the first which
													# has element distinct from 0 in its $i-th
													# column
			$t++ while (($z[$t][$i] == 0) && ($t < 8));
			return 1 if ($t == 8);			# Noninvertible matrix
			@tmp = $z[$i];
			$z[$i] = $z[$t];
			$z[$t] = @tmp;
			$p = $z[$i][$i];
		}
		for($j = 0; $j < 16; $j++) {		# Divide the i-th row of the extended matrix with $p
			$z[$i][$j] = $a[(255 + $b[$z[$i][$j]] - $b[$p]) % 255] if ($z[$i][$j]);
		}
		for($t = 0; $t < 8; $t++) {		# For each row add the elements of the row $i
			if ($i != $t) {					# multiplied by a constant
				$z[$t][$_] ^= mul($z[$i][$_], $z[$t][$i]) for ($i + 1 .. 15);
				$z[$t][$i] = 0;
			}
		}
	}
	for($i = 0; $i < 8; $i++) {
		$f[$i][$_] = $z[$i][$_ + 8] for (0 .. 7);
	}
	return 0;									# The matrix is inverted
}