#!/usr/bin/perl -w

@t = (0xd6, 0x7b, 0x3d, 0x1f, 0x0f, 0x05, 0x03, 0x01, 0xb1);

print <<EOT;
// Automatically generated header.
// See "squaretables.pl" for more information.
// Do not edit by hand.

#ifndef __SQUARETABLES_HPP__
#define __SQUARETABLES_HPP__

Byte bSquareE[] =
{
EOT

# We calc @a and @b to multiply in GF(2 ** 8)
$a[0] = 1;
for (1 .. 255) {
	$a[$_] = $a[$_ - 1] << 1;
	$a[$_] ^= 0x1f5 if ($a[$_] & 0x100);
}
$b[0] = 0;
$b[$a[$_]] = $_ for (1 .. 255);

$c[0] = 0;
$c[1] = 1;
$c[$_] = $a[255 - $b[$_]] for (2 .. 255);

for (0 .. 255) {
	$i = $c[$_];
	$c[$_] = 0;
	for ($v = 0; $v < 8; $v++) {
		$u = $i & $t[$v];
		$c[$_] ^= ((($u     ) ^ ($u >> 1) ^ ($u >> 2) ^ ($u >> 3) ^
					   ($u >> 4) ^ ($u >> 5) ^ ($u >> 6) ^ ($u >> 7)) & 1) << (7 - $v);
	}
	$c[$_] ^= $t[8];
	printf("\t") if ($_ % 8 == 0);
	printf("%3d, ", $c[$_]) if (($_ + 1) % 8 != 0);
	printf("%3d,\n", $c[$_]) if (($_ + 1) % 8 == 0);
}

print <<EOT;
};

Byte bSquareD[] =
{
EOT

$d[$c[$_]] = $_ for (0 .. 255);

for (0 .. 255) {
	printf("\t") if ($_ % 8 == 0);
	printf("%3d, ", $d[$_]) if (($_ + 1) % 8 != 0);
	printf("%3d,\n", $d[$_]) if (($_ + 1) % 8 == 0);
}

print <<EOT;
};

Word wOffset[] =
{
EOT

# Maximum of 16 rounds
$w = 1;
for (0 .. 15) {
	printf("\t0x%08x,\n", $w << 24);
	$w = ($w == 0 ? 0 : $a[($b[2] + $b[$w]) % 255]);
}

print <<EOT;
};

Byte bSquareG[4][4] =
{
EOT

@g = (2, 1, 1, 3);
for ($i = 0; $i < 4; $i++) {
	$e[$i][$_] = $g[(4 + $_ - $i) % 4] for (0 .. 3);
	printf("\t{ ");
	printf("%d, ", $e[$i][$_]) for (0 .. 2);
	printf("%d ", $e[$i][3]);
	printf("},\n");
}

print <<EOT;
};

Word wSquareE[] =
{
EOT

for (0 .. 255) {
	printf("\t") if ($_ % 4 == 0);
	printf("0x%02x%02x%02x%02xL,",
			 mul($c[$_], $e[0][0]),
			 mul($c[$_], $e[0][1]),
			 mul($c[$_], $e[0][2]),
			 mul($c[$_], $e[0][3]));
	printf(" ") if (($_ + 1) % 4 != 0);
	printf("\n") if (($_ + 1) % 4 == 0);
}

if (inverse()) {
print <<EOT;
};

#error "Noninvertible matrix G. See squaretables.pl for more information."

#endif // __SQUARETABLES_HPP__
EOT
	exit;
}

print <<EOT;
};

Word wSquareD[] =
{
EOT

for (0 .. 255) {
	printf("\t") if ($_ % 4 == 0);
	printf("0x%02x%02x%02x%02xL,",
			 mul($d[$_], $f[0][0]),
			 mul($d[$_], $f[0][1]),
			 mul($d[$_], $f[0][2]),
			 mul($d[$_], $f[0][3]));
	printf(" ") if (($_ + 1) % 4 != 0);
	printf("\n") if (($_ + 1) % 4 == 0);
}

print <<EOT;
};

#endif // __SQUARETABLES_HPP__
EOT

# Calculates the product of $_[0] and $_[1] in GF(2 ** 8).
sub mul
{
	return 0 if ($_[0] == 0 || $_[1] == 0);
	return $a[($b[$_[0]] + $b[$_[1]]) % 255];
}

# Calculates the inverse of the matrix @e (with size 4 x 4) in GF(2 ** 8).
# The input matrix is in @e.
# The output matrix is in @f.
# @z is a temp matrix.
# Returns 0 in success and 1 if the matrix is noninvertible.
sub inverse
{
	for($i = 0; $i < 4; $i++) {			# Construct the extended matrix in @z
		$z[$i][$_] = $e[$i][$_] for(0 .. 3);
		$z[$i][$_] = 0 for(4 .. 7);
		$z[$i][$i + 4] = 1;
	}
	for($i = 0; $i < 4; $i++) {			# For each row of the extended matrix
		$p = $z[$i][$i];						# The i-th element of the main diagonal
		if ($p == 0) {							# If we have zero on tha main diagonal
			$t = $i + 1;						# swap the $i-th line with the first which
													# has element distinct from 0 in its $i-th
													# column
			$t++ while (($z[$t][$i] == 0) && ($t < 4));
			return 1 if ($t == 4);			# Noninvertible matrix
			@tmp = $z[$i];
			$z[$i] = $z[$t];
			$z[$t] = @tmp;
			$p = $z[$i][$i];
		}
		for($j = 0; $j < 8; $j++) {		# Divide the i-th row of the extended matrix with $p
			$z[$i][$j] = $a[(255 + $b[$z[$i][$j]] - $b[$p]) % 255] if ($z[$i][$j]);
		}
		for($t = 0; $t < 4; $t++) {		# For each row add the elements of the row $i
			if ($i != $t) {					# multiplied by a constant
				$z[$t][$_] ^= mul($z[$i][$_], $z[$t][$i]) for ($i + 1 .. 7);
				$z[$t][$i] = 0;
			}
		}
	}
	for($i = 0; $i < 4; $i++) {
		$f[$i][$_] = $z[$i][$_ + 4] for (0 .. 3);
	}
	return 0;									# The matrix is inverted
}