.if n .ds Q \&"
.if t .ds Q ``
.if n .ds U \&"
.if t .ds U ''
.TH "elgamalkeys" 1 
.tr \&
.nr bi 0
.nr ll 0
.nr el 0
.de DS
..
.de DE
..
.de Pp
.ie \\n(ll>0 \{\
.ie \\n(bi=1 \{\
.nr bi 0
.if \\n(t\\n(ll=0 \{.IP \\(bu\}
.if \\n(t\\n(ll=1 \{.IP \\n+(e\\n(el.\}
.\}
.el .sp 
.\}
.el \{\
.ie \\nh=1 \{\
.LP
.nr h 0
.\}
.el .PP 
.\}
..
.SH NAME

.Pp
elgamalkeys - generates a ElGamal keypair for scl+sssl
.SH SYNOPSIS

.Pp
\fIelgamalkeys\fP [ \fI-m bits\fP | \fI-g file\fP ] [ \fI-o file\fP ] [ \fI-p\fP [ \fIfile\fP ] ]
[ \fI-b\fP ]
.Pp
\fIelgamalkeys\fP [ \fI-bc\fP ] [ \fI-i file\fP ] [ \fI-p\fP [ \fIfile\fP ] ] [ \fI-w file\fP ]
.Pp
\fIelgamalkeys -v\fP
.SH DESCRIPTION

.Pp
The \fIelgamalkeys\fP programs generates a ElGamal keypair for use with the
\fIscl+sssl\fP library.
.SH OPTIONS

.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fI-m, --modulus bits\fP"
.nr bi 1
.Pp
Specify an alternative modulus length instead of \fI768\fP which is the
default.
.IP "\fI-g, --get-params file\fP"
.nr bi 1
.Pp
Read public ElGamal parameters from file instead of generating them. This
options if very useful as the generation of the above parameters is slow and
it is not a security threat for these paramters to be world readable.
.IP "\fI-w, --write-params file\fP"
.nr bi 1
.Pp
Export the public ElGamal parameters, read from a secret key.
.IP "\fI-o, --out file\fP"
.nr bi 1
.Pp
Specify the output file for the newly created private key here. If this
option is not supplied the private key will be sent to stdout.
.IP "\fI-p, --public file\fP"
.nr bi 1
.Pp
Specify the output file for the newly created public key here. If this
option is not supplied the public key will be sent to stdout.
.IP "\fI-b, --binary\fP"
.nr bi 1
.Pp
If this flag is specified all keys will be read and written in binary
format. This format is more compact but less portable. Note that the default
format for the \fIsssl\fP library is uuencoded and not binary.
.IP "\fI-c, --check\fP"
.nr bi 1
.Pp
Some parameters in the secret key are computable from others, but are saved
for better performance. Other values have to meet specified criteria as 
prime, congruence, etc. When the \fI-c\fP option is supplied, the key
file specified with the \fI-i, --input\fP option will be checked for 
consistency.
.IP "\fI-i, --input file\fP"
.nr bi 1
.Pp
Read the file supplied as a parameter of the option insted of generating
it. This is useful if you want to check an existing key or if you want to
extract the public key from a secret one. If the \fI-i, --input\fP option
is given with missing file argument, the key will be expected on stdin.
.IP "\fI-v, --version\fP"
.nr bi 1
.Pp
Print version and exit.
.if \n(ll>1 .RE
.nr ll -1
.SH FILES

.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fI/etc/sssl/hostkey.elgamal.sec\fP"
.nr bi 1
.Pp
Secret ElGamal key in uuencoded format for the sssl library.
.IP "\fI/etc/sssl/hostkey.elgamal.pub\fP"
.nr bi 1
.Pp
Public ElGamal key in uuencoded format for the sssl library.
.Pp
.if \n(ll>1 .RE
.nr ll -1
.SH BUGS

.Pp
The program is slow on older machines, especially with long modulus.
.SH AUTHOR

.Pp
Alexander Feldman <alex@varna.net>
.SH SEE ALSO

.Pp
\fIbgkeys\fP(1), \fIrabinkeys\fP(1), \fIdsakeys\fP(1), 
\fIrwkeys\fP(1), \fIrsakeys\fP(1)