/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>

#include "feal.hpp"

CFEALKey::CFEALKey()
{
}

CFEALKey::CFEALKey(const CFEALKey &cFEALKey)
{
	dwMaster = cFEALKey.dwMaster;
	MakeKeys();
}

CFEALKey::CFEALKey(Dword dwFEALKey)
{
	dwMaster = dwFEALKey;
	MakeKeys();
	dwFEALKey = 0;								// Cleanup
}

CFEALKey::CFEALKey(const Byte *pbData, Word wLength)
{
	dwMaster = 0;
	memcpy(&dwMaster, pbData, wLength);
	dwMaster = REVERSEDWORD(dwMaster);
	MakeKeys();
}

CFEALKey::~CFEALKey()
{
	for (int i = 0; i < FEALROUNDS + 8; i++)
		sKey[i] = 0;
	dwMaster = 0;								// Cleanup
}

void CFEALKey::MakeKeys()
{
	Word a = 0, b, c, d, e;
	Byte t1, t2;
	Byte u0, u1, u2, u3;


	b = HiWORD(dwMaster);
	c = LoWORD(dwMaster);
	for (int i = 0; i < ((FEALROUNDS / 2) + 4); i++) {
		e = c ^ a;

		t1 = WBYTE0(b) ^ WBYTE1(b);
		t2 = WBYTE2(b) ^ WBYTE3(b);
	
		u1 = ROT2((t1 + (t2 ^ WBYTE0(e)) + 1));
		u2 = ROT2((t2 + (u1 ^ WBYTE1(e))));
		u0 = ROT2((WBYTE0(b) + (u1 ^ WBYTE2(e))));
		u3 = ROT2((WBYTE3(b) + (u2 ^ WBYTE3(e)) + 1));
		d = MakeWord(u0, u1, u2, u3);
		
		a = b; 
		b = c;
		c = d;
		sKey[i * 2] = HISHORT(d);
		sKey[i * 2 + 1] = LOSHORT(d);
	}
}

CFEALBlock::CFEALBlock()
{
	dwData = 0;									// This is here for definiteness
}

CFEALBlock::CFEALBlock(const CFEALBlock &cFEALBlock)
{
	dwData = cFEALBlock.dwData;
}

CFEALBlock::CFEALBlock(Dword dwValue)
{
	dwData = dwValue;
}

CFEALBlock::CFEALBlock(const Byte *pbData, Word wLength)
{
	dwData = 0;
	memcpy(&dwData, pbData, wLength);
}

CFEALBlock::~CFEALBlock()
{
	dwData = 0;									// Cleanup
}

void CFEALBlock::Encrypt(const CFEALKey &cFEALKey)
{
	Crypt(cFEALKey, false);
}

void CFEALBlock::Decrypt(const CFEALKey &cFEALKey)
{
	Crypt(cFEALKey, true);
}

// fgDirection: true = decrypt
//              false = encrypt
void CFEALBlock::Crypt(const CFEALKey &cFEALKey, bool fgDirection)
{
	Byte t1, t2;
	Byte u0, u1, u2, u3;
	Word l = HiWORD(dwData);
	Word r = LoWORD(dwData);
	Word s;
	Word q = 0;
	Short t;
	
	if (fgDirection)
		q = 4;
	
	l ^= MAKEWORDS(cFEALKey.GetKey(FEALROUNDS + q), cFEALKey.GetKey(FEALROUNDS + 1 + q));	
	r ^= MAKEWORDS(cFEALKey.GetKey(FEALROUNDS + 2 + q), cFEALKey.GetKey(FEALROUNDS + 3 + q));
	r ^= l;
	for (int i = 0; i < FEALROUNDS; i++) {
		s = r;
		t = cFEALKey.GetKey(fgDirection ? (FEALROUNDS - 1) - i : i);

		t1 = (WBYTE0(r) ^ WBYTE1(r)) ^ SBYTE0(t);
		t2 = (WBYTE2(r) ^ WBYTE3(r)) ^ SBYTE1(t);

		u1 = ROT2(t1 + t2 + 1);
		u2 = ROT2(t2 + u1);
		u0 = ROT2(WBYTE0(r) + u1);
		u3 = ROT2(WBYTE3(r) + u2 + 1);

		r = l ^ MakeWord(u0, u1, u2, u3);
		l = s;
	}
	l = l ^ r;
	r ^= MAKEWORDS(cFEALKey.GetKey(FEALROUNDS + 4 - q), cFEALKey.GetKey(FEALROUNDS + 5 - q));
	l ^= MAKEWORDS(cFEALKey.GetKey(FEALROUNDS + 6 - q), cFEALKey.GetKey(FEALROUNDS + 7 - q));

	dwData = (Dword)r << 32 | l;
}

void CFEALBlock::SetValue(Dword dwValue)
{
	dwData = dwValue;
}

Dword CFEALBlock::GetValue()
{
	return dwData;
}

void CFEALBlock::SetData(const Byte *pbData, Word wLength)
{
	dwData = 0;
	memcpy(&dwData, pbData, wLength);
	dwData = REVERSEDWORD(dwData);
}

Byte *CFEALBlock::GetData()
{
	dwResult = REVERSEDWORD(dwData);
	return (Byte *)&dwResult;
}
