/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>

#include "gost.hpp"
#include "gostsboxes.hpp"

#define f(a) (wGOSTS[0][WBYTE3(a)] | wGOSTS[1][WBYTE2(a)] | \
				  wGOSTS[2][WBYTE1(a)] | wGOSTS[3][WBYTE0(a)])

CGOSTKey::CGOSTKey()
{
}

CGOSTKey::CGOSTKey(const CGOSTKey &cGOSTKey)
{
	dwMaster[0] = cGOSTKey.dwMaster[0];
	dwMaster[1] = cGOSTKey.dwMaster[1];
	dwMaster[2] = cGOSTKey.dwMaster[2];
	dwMaster[3] = cGOSTKey.dwMaster[3];
	MakeKeys();
}

CGOSTKey::CGOSTKey(Dword a, Dword b, Dword c, Dword d)
{
	dwMaster[3] = REVERSEDWORD(d);
	dwMaster[2] = REVERSEDWORD(c);
	dwMaster[1] = REVERSEDWORD(b);
	dwMaster[0] = REVERSEDWORD(a);
	MakeKeys();
	a = b = c = d = 0;						// Cleanup
}

CGOSTKey::CGOSTKey(const Byte *pbData, Word wLength)
{
	memcpy((Byte *)dwMaster, pbData, wLength);
	memset((Byte *)dwMaster + wLength, 0, sizeof(dwMaster) - wLength);
	MakeKeys();
}

CGOSTKey::~CGOSTKey()
{
	dwMaster[0] = 0;							// Cleanup
	dwMaster[1] = 0;
	dwMaster[2] = 0;
	dwMaster[3] = 0;
	for (int i = 0; i < 8; i++)
		wKey[i] = 0;
}

void CGOSTKey::MakeKeys()
{
	wKey[0] = LoWORD(dwMaster[0]);
	wKey[1] = HiWORD(dwMaster[0]);
	wKey[2] = LoWORD(dwMaster[1]);
	wKey[3] = HiWORD(dwMaster[1]);
	wKey[4] = LoWORD(dwMaster[2]);
	wKey[5] = HiWORD(dwMaster[2]);
	wKey[6] = LoWORD(dwMaster[3]);
	wKey[7] = HiWORD(dwMaster[3]);
}

CGOSTBlock::CGOSTBlock()
{
	dwData = 0;									// This is here for definiteness
}

CGOSTBlock::CGOSTBlock(const CGOSTBlock &cGOSTBlock)
{
	dwData = cGOSTBlock.dwData;
}

CGOSTBlock::CGOSTBlock(Dword dwValue)
{
	dwData = REVERSEDWORD(dwValue);
}

CGOSTBlock::CGOSTBlock(const Byte *pbData, Word wLength)
{
	dwData = 0;
	memcpy(&dwData, pbData, wLength);
}

CGOSTBlock::~CGOSTBlock()
{
	dwData = 0;									// Cleanup
}

void CGOSTBlock::Encrypt(const CGOSTKey &cGOSTKey)
{
	Word l = HiWORD(dwData);
	Word r = LoWORD(dwData);
	Word i, p;
	for (i = 0; i < 24; i++) {
		p = l;
		l = r;
		r = p ^ f(r + cGOSTKey.GetKey(i % 8));
	}
	for (i = 0; i < 8; i++) {
		p = l;
		l = r;
		r = p ^ f(r + cGOSTKey.GetKey(7 - i));
	}
	dwData = ((Dword)r << 32) | l;
	l = r = p = 0;								// Cleanup
}

void CGOSTBlock::Decrypt(const CGOSTKey &cGOSTKey)
{
	Word l = HiWORD(dwData);
	Word r = LoWORD(dwData);
	Word i, p;
	for (i = 0; i < 8; i++) {
		p = l;
		l = r;
		r = p ^ f(r + cGOSTKey.GetKey(i));
	}
	for (i = 0; i < 24; i++) {
		p = l;
		l = r;
		r = p ^ f(r + cGOSTKey.GetKey(7 - (i % 8)));
	}
	dwData = ((Dword)r << 32) | l;
	l = r = p = 0;								// Cleanup
}

void CGOSTBlock::SetValue(Dword dwValue)
{
	dwData = dwValue;
}

Dword CGOSTBlock::GetValue()
{
	return REVERSEDWORD(dwData);
}

void CGOSTBlock::SetData(const Byte *pbData, Word wLength)
{
	dwData = 0;
	memcpy(&dwData, pbData, wLength);
}

Byte *CGOSTBlock::GetData()
{
	return (Byte *)&dwData;
}
