/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>

#include "loki.hpp"
#include "lokisboxes.hpp"

static Byte bP[] = { 56, 48, 40, 32, 24, 16,  8,  0, 57, 49, 41, 33, 25, 17,  9,  1,
			  			   58, 50, 42, 34, 26, 18, 10,  2, 59, 51, 43, 35, 27, 19, 11,  3,
	  					   60, 52, 44, 36, 28, 20, 12,  4, 61, 53, 45, 37, 29, 21, 13,  5,
			  			   62, 54, 46, 38, 30, 22, 14,  6, 63, 55, 47, 39, 31, 23, 15,  7 };

#define KP(A, B)					((((HiWORD(A) & ~(B)) | (LoWORD(A) & (B))) << 32) | \
										 (((LoWORD(A) & ~(B)) | (HiWORD(A) & (B)))))
#define g(i, K1, K3, K2, R)	f(((K1) + (K3) + DWORDCONST(0x9E3779B97F4A7C15) * (i)), (K2), (R))
#define f(A, B, R)																\
{																						\
	Dword C = KP(A, B);															\
	Dword D = 0;																	\
	STIRBITS(MAKEDWORDB(S1[(C >> 56) | (C << 8) & 0x1FFF],			\
							  S2[(C >> 48) & 0x7FF],							\
							  S1[(C >> 40) & 0x1FFF],							\
							  S2[(C >> 32) & 0x7FF],							\
							  S2[(C >> 24) & 0x7FF],							\
							  S1[(C >> 16) & 0x1FFF],							\
							  S2[(C >> 8) & 0x7FF],								\
							  S1[(C) & 0x1FFF]),									\
				64,																	\
				bP,																	\
				D);																	\
	R = MAKEDWORDB(S2[DWBYTE0(D) | ((HiWORD(B) >> 21) & 0x0700)],	\
						S2[DWBYTE1(D) | ((HiWORD(B) >> 18) & 0x0700)],	\
						S1[DWBYTE2(D) | ((HiWORD(B) >> 13) & 0x1f00)],	\
						S1[DWBYTE3(D) | ((HiWORD(B) >>  8) & 0x1f00)],	\
						S2[DWBYTE4(D) | ((HiWORD(B) >>  5) & 0x0700)],	\
						S2[DWBYTE5(D) | ((HiWORD(B) >>  2) & 0x0700)],	\
						S1[DWBYTE6(D) | ((HiWORD(B) <<  3) & 0x1f00)],	\
						S1[DWBYTE7(D) | ((HiWORD(B) <<  8) & 0x1f00)]);	\
}

CLOKIKey::CLOKIKey()
{
}

CLOKIKey::CLOKIKey(const Byte *pbMaster, Word wKeyLength)
{
	switch (wKeyLength) {
		case 16:
			CLOKIKey::wKeyLength = 16;
			dwMaster[3] = REVERSEDWORD(((Dword *)pbMaster)[0]);
			dwMaster[2] = REVERSEDWORD(((Dword *)pbMaster)[1]);
			f(dwMaster[2], dwMaster[3], dwMaster[1]);
			f(dwMaster[3], dwMaster[2], dwMaster[0]);
			MakeKeys();
		break;
		case 24:
			CLOKIKey::wKeyLength = 16;
			dwMaster[3] = REVERSEDWORD(((Dword *)pbMaster)[0]);
			dwMaster[2] = REVERSEDWORD(((Dword *)pbMaster)[1]);
			dwMaster[1] = REVERSEDWORD(((Dword *)pbMaster)[2]);
			f(dwMaster[3], dwMaster[2], dwMaster[0]);
			MakeKeys();
		break;
		case 32:
			CLOKIKey::wKeyLength = 32;
			dwMaster[3] = REVERSEDWORD(((Dword *)pbMaster)[0]);
			dwMaster[2] = REVERSEDWORD(((Dword *)pbMaster)[1]);
			dwMaster[1] = REVERSEDWORD(((Dword *)pbMaster)[2]);
			dwMaster[0] = REVERSEDWORD(((Dword *)pbMaster)[3]);
			MakeKeys();
		break;
	}
}

CLOKIKey::CLOKIKey(const CLOKIKey &cLOKIKey)
{
	dwMaster[0] = cLOKIKey.dwMaster[0];
	dwMaster[1] = cLOKIKey.dwMaster[1];
	dwMaster[2] = cLOKIKey.dwMaster[2];
	dwMaster[3] = cLOKIKey.dwMaster[3];
	MakeKeys();
}

CLOKIKey::CLOKIKey(Dword a, Dword b)
{
	wKeyLength = 16;
	dwMaster[3] = a;
	dwMaster[2] = b;
	f(b, a, dwMaster[1]);
	f(a, b, dwMaster[0]);
	MakeKeys();
	a = b = 0;									// Cleanup
}

CLOKIKey::CLOKIKey(Dword a, Dword b, Dword c)
{
	wKeyLength = 24;
	dwMaster[3] = a;
	dwMaster[2] = b;
	dwMaster[1] = c;
	f(a, b, dwMaster[0]);
	MakeKeys();
	a = b = c = 0;								// Cleanup
}

CLOKIKey::CLOKIKey(Dword a, Dword b, Dword c, Dword d)
{
	wKeyLength = 32;
	dwMaster[3] = a;
	dwMaster[2] = b;
	dwMaster[1] = c;
	dwMaster[0] = d;
	MakeKeys();
	a = b = c = d = 0;						// Cleanup
}

CLOKIKey::~CLOKIKey()
{
	dwMaster[0] = 0;							// Cleanup
	dwMaster[1] = 0;
	dwMaster[2] = 0;
	dwMaster[3] = 0;
	for (int i = 0; i < 48; i++)
		dwKey[i] = 0;
}

void CLOKIKey::MakeKeys()
{
	Dword q;
	for (int i = 0; i < 48; i++) {
		g(i + 1, dwMaster[0], dwMaster[2], dwMaster[1], q);
		dwKey[i] = dwMaster[3] ^ q;
		dwMaster[3] = dwMaster[2];
		dwMaster[2] = dwMaster[1];
		dwMaster[1] = dwMaster[0];
		dwMaster[0] = dwKey[i];
	}
	q = 0;										// Cleanup
}

CLOKIBlock::CLOKIBlock()
{
	dwData[0] = dwData[1] = 0;				// This is here for definiteness
}

CLOKIBlock::CLOKIBlock(const CLOKIBlock &cLOKIBlock)
{
	dwData[0] = cLOKIBlock.dwData[0];
	dwData[1] = cLOKIBlock.dwData[1];
}

CLOKIBlock::CLOKIBlock(Dword dwValueLeft, Dword dwValueRight)
{
	dwData[0] = dwValueLeft;
	dwData[1] = dwValueRight;
}

CLOKIBlock::CLOKIBlock(const Byte *pbData, Word wLength)
{
	SetData(pbData, wLength);
}

CLOKIBlock::~CLOKIBlock()
{
	dwData[0] = 0;								// Cleanup
	dwData[1] = 0;
}

void CLOKIBlock::Encrypt(const CLOKIKey &cLOKIKey)
{
	Dword p, q;
	for (int i = 0; i < 16; i++) {
		p = dwData[1];
		f(dwData[1] + cLOKIKey.GetKey(3 * i), cLOKIKey.GetKey(3 * i + 1), q);
		dwData[1] = dwData[0] ^ q;
		dwData[0] = p + cLOKIKey.GetKey(3 * i) + cLOKIKey.GetKey(3 * i + 2);
	}
	p = dwData[1];
	q = dwData[0];
	dwData[0] = p;
	dwData[1] = q;
	p = q = 0;									// Cleanup
}

void CLOKIBlock::Decrypt(const CLOKIKey &cLOKIKey)
{
	Dword p, q;
	p = dwData[1];
	q = dwData[0];
	dwData[0] = p;
	dwData[1] = q;
	for (int i = 15; i >= 0; i--) {
		p = dwData[0];
		f(dwData[0] - cLOKIKey.GetKey(3 * i + 2), cLOKIKey.GetKey(3 * i + 1), q);
		dwData[0] = dwData[1] ^ q;
		dwData[1] = p - cLOKIKey.GetKey(3 * i + 2) - cLOKIKey.GetKey(3 * i);
	}
	p = q = 0;									// Cleanup
}

void CLOKIBlock::SetData(Dword dwValueLeft, Dword dwValueRight)
{
	dwData[0] = dwValueLeft;
	dwData[1] = dwValueRight;
}

Dword CLOKIBlock::GetData(Word wWord)
{
	return dwData[wWord];
}

void CLOKIBlock::SetData(const Byte *pbData, Word wLength)
{
	memcpy((Byte *)dwData, pbData, wLength);
	memset((Byte *)dwData + wLength, 0, sizeof(dwData) - wLength);
	dwData[0] = REVERSEDWORD(dwData[0]);
	dwData[1] = REVERSEDWORD(dwData[1]);
}

Byte *CLOKIBlock::GetData()
{
	dwResult[1] = REVERSEDWORD(dwData[1]);
	dwResult[0] = REVERSEDWORD(dwData[0]);
	return (Byte *)dwResult;
}
