/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>

#include "tea.hpp"

#define f(s) y += (z << 4) + k0 ^ z + (s) ^ (z >> 5) + k1; \
				 z += (y << 4) + k2 ^ y + (s) ^ (y >> 5) + k3
#define g(s) z -= (y << 4) + k2 ^ y + s ^ (y >> 5) + k3; \
				 y -= (z << 4) + k0 ^ z + s ^ (z >> 5) + k1

CTEAKey::CTEAKey()
{
}

CTEAKey::CTEAKey(const CTEAKey &cTEAKey)
{
	wKey[0] = cTEAKey.wKey[0];
	wKey[1] = cTEAKey.wKey[1];
	wKey[2] = cTEAKey.wKey[2];
	wKey[3] = cTEAKey.wKey[3];
}

CTEAKey::CTEAKey(const Word *pwKey)
{
	wKey[0] = pwKey[0];
	wKey[1] = pwKey[1];
	wKey[2] = pwKey[2];
	wKey[3] = pwKey[3];
}

CTEAKey::CTEAKey(const Byte *pbKey, Word wLength)
{
	memcpy((Byte *)wKey, pbKey, wLength);
	memset((Byte *)wKey + wLength, 0, sizeof(wKey) - wLength);
}

CTEAKey::~CTEAKey()
{
	wKey[0] = 0;								// Cleanup
	wKey[1] = 0;
	wKey[2] = 0;
	wKey[3] = 0;
}

CTEABlock::CTEABlock()
{
	wData[0] = 0;								// This is here for definiteness
	wData[1] = 0;
}

CTEABlock::CTEABlock(const CTEABlock &cTEABlock)
{
	wData[0] = cTEABlock.wData[0];
	wData[1] = cTEABlock.wData[1];
}

CTEABlock::CTEABlock(Word l, Word r)
{
	wData[0] = l;
	wData[1] = r;
}

CTEABlock::CTEABlock(const Byte *pbData, Word wLength)
{
	SetData(pbData, wLength);
}

CTEABlock::~CTEABlock()
{
	wData[0] = 0;								// Cleanup
	wData[1] = 0;
}

void CTEABlock::Encrypt(const CTEAKey &cTEAKey)
{
	const Word *k = cTEAKey.GetKeys();
	Word k0 = k[0];
	Word k1 = k[1];
	Word k2 = k[2];
	Word k3 = k[3];
	Word y = wData[0];
	Word z = wData[1];
	f(0x9E3779B9L);
	f(0x3C6EF372L);
	f(0xDAA66D2BL);
	f(0x78DDE6E4L);
	f(0x1715609DL);
	f(0xB54CDA56L);
	f(0x5384540FL);
	f(0xF1BBCDC8L);
	f(0x8FF34781L);
	f(0x2E2AC13AL);
	f(0xCC623AF3L);
	f(0x6A99B4ACL);
	f(0x08D12E65L);
	f(0xA708A81EL);
	f(0x454021D7L);
	f(0xE3779B90L);
	f(0x81AF1549L);
	f(0x1FE68F02L);
	f(0xBE1E08BBL);
	f(0x5C558274L);
	f(0xFA8CFC2DL);
	f(0x98C475E6L);
	f(0x36FBEF9FL);
	f(0xD5336958L);
	f(0x736AE311L);
	f(0x11A25CCAL);
	f(0xAFD9D683L);
	f(0x4E11503CL);
	f(0xEC48C9F5L);
	f(0x8A8043AEL);
	f(0x28B7BD67L);
	f(0xC6EF3720L);
	wData[0] = y;
	wData[1] = z;
}

void CTEABlock::Decrypt(const CTEAKey &cTEAKey)
{
	const Word *k = cTEAKey.GetKeys();
	Word k0 = k[0];
	Word k1 = k[1];
	Word k2 = k[2];
	Word k3 = k[3];
	Word y = wData[0];
	Word z = wData[1];
	g(0xC6EF3720L);
	g(0x28B7BD67L);
	g(0x8A8043AEL);
	g(0xEC48C9F5L);
	g(0x4E11503CL);
	g(0xAFD9D683L);
	g(0x11A25CCAL);
	g(0x736AE311L);
	g(0xD5336958L);
	g(0x36FBEF9FL);
	g(0x98C475E6L);
	g(0xFA8CFC2DL);
	g(0x5C558274L);
	g(0xBE1E08BBL);
	g(0x1FE68F02L);
	g(0x81AF1549L);
	g(0xE3779B90L);
	g(0x454021D7L);
	g(0xA708A81EL);
	g(0x08D12E65L);
	g(0x6A99B4ACL);
	g(0xCC623AF3L);
	g(0x2E2AC13AL);
	g(0x8FF34781L);
	g(0xF1BBCDC8L);
	g(0x5384540FL);
	g(0xB54CDA56L);
	g(0x1715609DL);
	g(0x78DDE6E4L);
	g(0xDAA66D2BL);
	g(0x3C6EF372L);
	g(0x9E3779B9L);
	wData[0] = y;
	wData[1] = z;
}

void CTEABlock::SetData(Word l, Word r)
{
	wData[0] = l;
	wData[1] = r;
}

Word CTEABlock::GetData(Word i)
{
	return wData[i];
}

void CTEABlock::SetData(const Byte *pbData, Word wLength)
{
	memcpy((Byte *)wData, pbData, wLength);
	memset((Byte *)wData + wLength, 0, sizeof(wData) - wLength);
}

Byte *CTEABlock::GetData()
{
	return (Byte *)wData;
}