/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SPACE_HPP__
#define __SPACE_HPP__

#include <stdio.h>

#include "globals.hpp"
#include "settings.hpp"
#include "initrnd.hpp"
#include "agree.hpp"

// Request type identifiers. This value is sent (in an octet) from the
// client to the server. If the client knows the public key of the server
// she only needs to know its hash. This fingerprint will be used to match
// the public key on the file system of the client with the "real" public
// key of the server. The connection will not continue if there is a
// the calculated hash of the public key and that, received from the server
// are distinct.
#define GET_KEY		1
#define GET_HASH		2

class CSSSLSocket
{
	public:
		CSSSLSocket(int, Byte, Word, Word, Byte * = NULL, Byte * = NULL);
		~CSSSLSocket();

	public:
		int GetSocket() { return iSocket; };
		Word GetIVSize() { return wIVSize; };
		Word GetKeySize() { return wKeySize; };
		Byte *GetIV() { return pbIV; };
		Byte *GetKey() { return pbKey; };
		CCFBCryptographer *GetCryptographer() { return pCFBCryptographer; };

	private:
		CCFBCryptographer *pCFBCryptographer;
		CBlockObject *pCipherData;
		CBlockKey *pCipherKey;
		Byte *pbKey, *pbIV;
		Word wIVSize, wKeySize;
		int iSocket;
};

class CSSSLSpace
{
	public:
		CSSSLSpace();
		~CSSSLSpace();
	
	public:
		CSSSLSocket *FindSocket(int);
		bool AddSocket(CSSSLSocket *);
		bool DeleteSocket(int);

	private:
		CSSSLSocket **pSSSLSockets;
		int iAllSockets;
};

#endif // __SPACE_HPP__
