#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <getopt.h>
#include "ps.h"
#include "psdata.h"

unsigned long prof_len = 0;
unsigned long _prof_buffer = 0;
unsigned long jiffies = 0;

unsigned long *buffer;

int
main(int argc, char *argv[])
{
    int fd;

    if (open_psdb()) {
	perror("cannot open psdatabase");
	exit(2);
    }
    prof_len = get_kword(k_addr("_prof_len"));
    _prof_buffer = get_kword(k_addr("_prof_buffer"));
    buffer = malloc(prof_len * sizeof(unsigned long));
    if (!buffer) {
    	fprintf(stderr,"out of memory\n");
    	exit(1);
    }
    memset(buffer, 0, 4*prof_len);
    if ((fd = open("/dev/kmem", O_WRONLY)) == -1) {
	perror("/dev/kmem");
	exit(1);
    }
    if (lseek(fd, _prof_buffer, SEEK_SET) == -1) {
	perror("lseek");
	exit(1);
    }
    write(fd, buffer, 4*prof_len);
    exit(0);
}
