/*
* $XConsortium: StripCharP.h,v 1.3 89/11/11 14:53:47 kit Exp $
*/


/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

 * Copyright 1994, Roger Smith for Sterling Software and NASA-Ames Research Center
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of NASA and Sterling Software (collectively 
 * or individually) are not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  NASA and Sterling Software makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * NASA & STERLING SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL NASA & STERLING SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * 1994 Revision
 * Author:           Roger Smith, Sterling Software @ NASA-Ames Research Center
 *                   Moffett Field, California, rsmith@proteus.arc.nasa.gov

******************************************************************/

#ifndef _XawPerfChartP_h
#define _XawPerfChartP_h

#include "StripChart.h"
#include <X11/Xaw/SimpleP.h>

#define NO_GCS 0
#define FOREGROUND 1 << 0
#define HIGHLIGHT  1 << 1
#define ALL_GCS (FOREGROUND | HIGHLIGHT)

/* New fields for the PerfChart widget instance record */

typedef struct {
    double valuedata[2048];	/* record of data points */
    Pixel	fgpixel;	/* color index for graph */
    Pixel	hipixel;	/* color index for lines */
    Pixel       warnColor;
    Pixel       alarmColor;
    Pixel       okColor;
    Pixel       currentBG;
    GC	fgGC;			/* graphics context for fgpixel */
    GC	hiGC;			/* graphics context for hipixel */
    
/* start of graph stuff */
    
    int highWarn;		/* warning alert occurrs above this limit */
    int highAlarm;		/* alarm alert occurrs above this limit */
    int lowWarn;		/* low warning alert occurrs below this limit */
    int lowAlarm;		/* low alarm alert occurrs below this limit */
    Boolean immediate;		/* background is current point */
    Boolean current;		/* if true, print current value labels */
    int	update;			/* update frequence */
    int	scale;			/* scale factor */
    int	min_scale;		/* smallest scale factor */
    int	interval;		/* data point interval */
    XPoint * points ;		/* Poly point for repairing graph lines. */
    Boolean reverse_video;	/* display in reverse video */
    Boolean fillRect;		/* filled graph = TRUE, else line graph */
    double lastValue;		/* value of most recent sample */
    double max_value;		/* Max Value in window */
    double hi_max;		/* all time max value */
    double min_value;		/* Min value in window */
    double lo_min;		/* all time min value */
    XFontStruct *font;		/* font for text */
    unsigned int font_height;	/* height of font */
    XtIntervalId interval_id;
    XtCallbackList get_value;	/* proc to call to fetch load pt */
    int jump_val;		/* Amount to jump on each scroll. */
    char *topLabel;		/* this widgets upper label */
    char *botLabel;		/* this widgets lower label */
} PerfChartPart;

/* Full instance record declaration */
typedef struct _PerfChartRec {
   CorePart core;
   SimplePart simple;
   PerfChartPart strip_chart;
} PerfChartRec;

/* New fields for the PerfChart widget class record */
typedef struct {int dummy;} PerfChartClassPart;

/* Full class record declaration. */
typedef struct _PerfChartClassRec {
   CoreClassPart core_class;
   SimpleClassPart simple_class;
   PerfChartClassPart strip_chart_class;
} PerfChartClassRec;

/* Class pointer. */
extern PerfChartClassRec perfChartClassRec;

#endif /* _XawPerfChartP_h */
