// Forwarding declarations -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 27.2  Forward declarations
//

#ifndef _CPP_IOSFWD
#define _CPP_IOSFWD 1

#include <bits/c++config.h>
#include <bits/std_cstddef.h>
#include <bits/std_cwchar.h>
#include <bits/std_climits.h>

// Should probably figure out a way not to have this included in every file
#ifdef _G_USE_LIBIO
extern "C" {
#include <libio.h>
}
#endif

namespace std {

  // Generic definitions:
  template<class _CharT> struct char_traits;
  template<class _T> class allocator;


  /* Forward declarations.  */

  template<> class char_traits<char>;
  template<> class char_traits<wchar_t>;

  template<class _CharT, class _Traits = char_traits<_CharT> >
  class basic_ios;

  template<class _CharT, class _Traits = char_traits<_CharT> >
  class basic_streambuf;

  template<class _CharT, class _Traits = char_traits<_CharT> >
  class basic_istream;

  template<class _CharT, class _Traits = char_traits<_CharT> >
  class basic_ostream;

  template<class _CharT, class _Traits = char_traits<_CharT> >
  class basic_iostream;

  template<class _CharT, class _Traits = char_traits<_CharT>,
	    class _Allocator = allocator<_CharT> >
  class basic_stringbuf;

  template<class _CharT, class _Traits = char_traits<_CharT>,
	   class _Allocator = allocator<_CharT> >
  class basic_istringstream;

  template<class _CharT, class _Traits = char_traits<_CharT>,
	   class _Allocator = allocator<_CharT> >
  class basic_ostringstream;

  template<class _CharT, class _Traits = char_traits<_CharT>,
	   class _Allocator = allocator<_CharT> >
  class basic_stringstream;

  template<class _CharT, class _Traits = char_traits<_CharT> >
  class basic_filebuf;

  template<class _CharT, class _Traits = char_traits<_CharT> >
  class basic_ifstream;

  template<class _CharT, class _Traits = char_traits<_CharT> >
  class basic_ofstream;

  template<class _CharT, class _Traits = char_traits<_CharT> >
  class basic_fstream;

  template<class _CharT, class _Traits = char_traits<_CharT> >
  class istreambuf_iterator;

  template<class _CharT, class _Traits = char_traits<_CharT> >
  class ostreambuf_iterator;

  class ios_base;

  enum _Ios_Iostate { _S_ios_iostate_end = INT_MAX };
  inline _Ios_Iostate operator& (_Ios_Iostate __a, _Ios_Iostate __b)
    { return _Ios_Iostate(int (__a) & int (__b)); }
  inline _Ios_Iostate operator| (_Ios_Iostate __a, _Ios_Iostate __b)
    { return _Ios_Iostate(int (__a) | int (__b)); }
  inline _Ios_Iostate operator^ (_Ios_Iostate __a, _Ios_Iostate __b)
    { return _Ios_Iostate(int (__a) ^ int (__b)); }
  inline _Ios_Iostate operator|= (_Ios_Iostate& __a, _Ios_Iostate __b)
    { return __a = __a | __b; }
  inline _Ios_Iostate operator&= (_Ios_Iostate& __a, _Ios_Iostate __b)
    { return __a = __a & __b; }
  inline _Ios_Iostate operator^= (_Ios_Iostate& __a, _Ios_Iostate __b)
    { return __a = __a ^ __b; }
  inline _Ios_Iostate operator~ (_Ios_Iostate __a)
    { return _Ios_Iostate (~int (__a)); }

  typedef _Ios_Iostate _Iostate;  // same as ios_base::iostate, declared here
                                  // because is needed where ios_base is not.

  typedef basic_ios<char> ios;
  typedef basic_ios<wchar_t> wios;

  typedef basic_streambuf<char> streambuf;
  typedef basic_istream<char> istream;
  typedef basic_ostream<char> ostream;
  typedef basic_iostream<char> iostream;

  typedef basic_stringbuf<char> stringbuf;
  typedef basic_istringstream<char> istringstream;
  typedef basic_ostringstream<char> ostringstream;
  typedef basic_stringstream<char> stringstream;

  typedef basic_filebuf<char> filebuf;
  typedef basic_ifstream<char> ifstream;
  typedef basic_ofstream<char> ofstream;
  typedef basic_fstream<char> fstream;
  typedef basic_streambuf<wchar_t> wstreambuf;
  typedef basic_istream<wchar_t> wistream;
  typedef basic_ostream<wchar_t> wostream;
  typedef basic_iostream<wchar_t> wiostream;

  typedef basic_stringbuf<wchar_t> wstringbuf;
  typedef basic_istringstream<wchar_t> wistringstream;
  typedef basic_ostringstream<wchar_t> wostringstream;
  typedef basic_stringstream<wchar_t> wstringstream;

  typedef basic_filebuf<wchar_t> wfilebuf;
  typedef basic_ifstream<wchar_t> wifstream;
  typedef basic_ofstream<wchar_t> wofstream;
  typedef basic_fstream<wchar_t> wfstream;

  template<class _State> struct fpos;
  typedef fpos<mbstate_t> streampos;
  typedef fpos<mbstate_t> wstreampos;

} // namespace std

#endif	/* _CPP_IOSFWD */





