/*
 * Decompiled with CFR 0.152.
 */
package Hadoop.CUICollectorMapReduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class ArticleCollector {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration(true);
        conf.set("textinputformat.record.delimiter", "'EOU'.");
        Job job = new Job(conf);
        job.setJarByClass(ArticleCollector.class);
        job.setMapperClass(ArticleMapper.class);
        job.setReducerClass(ArticleReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(args[0]));
        job.setInputFormatClass(TextInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArticleReducer
    extends Reducer<Text, Text, Text, Text> {
        private Text result = new Text();
        public static final Log log = LogFactory.getLog(ArticleMapper.class);
        public static final boolean DEBUG = false;

        public void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            int i;
            StringBuilder articles = new StringBuilder(64);
            HashMap myStrings = new HashMap();
            myStrings.put("ti", new HashMap());
            myStrings.put("tx", new HashMap());
            myStrings.put("ab", new HashMap());
            for (Text val : values) {
                String toParse = val.toString();
                String pattern = "([a-z]{2})::([0-9]*)::(.*)";
                Pattern r = Pattern.compile(pattern);
                Matcher m = r.matcher(toParse);
                m.find();
                try {
                    ((HashMap)myStrings.get(m.group(1))).put(Integer.parseInt(m.group(2)), toParse);
                }
                catch (IllegalStateException e) {
                    log.info((Object)("REDUCER ERROR String: " + toParse));
                }
            }
            for (i = 1; i <= ((HashMap)myStrings.get("ti")).size(); ++i) {
                articles.append((String)((HashMap)myStrings.get("ti")).get(i));
            }
            for (i = 1; i <= ((HashMap)myStrings.get("tx")).size(); ++i) {
                articles.append((String)((HashMap)myStrings.get("tx")).get(i));
            }
            for (i = 1; i <= ((HashMap)myStrings.get("ab")).size(); ++i) {
                articles.append((String)((HashMap)myStrings.get("ab")).get(i));
            }
            articles.append("@@@@@@@");
            this.result.set(articles.toString());
            context.write((Object)key, (Object)this.result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArticleMapper
    extends Mapper<Object, Text, Text, Text> {
        public static final Log log = LogFactory.getLog(ArticleMapper.class);
        public static final boolean DEBUG = false;
        private Text pubmed_id = new Text();
        private Text word = new Text();

        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String thisString = value.toString();
            String pattern = "utterance[(']{2}([0-9]*)\\.([a-z]{2})\\.([0-9]*)',";
            Pattern r = Pattern.compile(pattern);
            Matcher m = r.matcher(thisString);
            StringBuilder newString = new StringBuilder(thisString.length() + 10);
            while (m.find()) {
                newString.append(m.group(2).toString());
                newString.append("::");
                newString.append(m.group(3).toString());
                newString.append("::");
                newString.append(thisString);
                this.word.set(newString.toString());
                this.pubmed_id.set(m.group(1).toString());
                context.write((Object)this.pubmed_id, (Object)this.word);
            }
        }
    }
}

