package App::BPOMUtils::Table::FoodIngredientRBA;

use 5.010001;
use strict 'subs', 'vars';
use utf8;
use warnings;
use Log::ger;

use Exporter 'import';
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-09-03'; # DATE
our $DIST = 'App-BPOMUtils-Table-FoodIngredient'; # DIST
our $VERSION = '0.020'; # VERSION

our @EXPORT_OK = qw(
                       bpom_list_food_ingredients_rba
               );

our %SPEC;

# BEGIN FRAGMENT id=meta-idn_bpom_bahan_baku_pangan_rba varname=meta_idn_bpom_bahan_baku_pangan_rba
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_bahan_baku_pangan_rba/meta.yaml
# src-revision: b611a9d128c23c9252082cf91b450d1899d9961c (Mon Feb 13 19:52:04 2023 +0700)
# generate-date: Mon Feb 13 12:52:13 2023 UTC
# generated-by: update-fragments-in-perl-module
our $meta_idn_bpom_bahan_baku_pangan_rba = {
  "fields" => {
    country_of_origin => {
      "filterable_regex" => "Yes",
      "pos" => 3,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Country of origin",
      "summary.alt.lang.id" => "Negara asal",
      "unique" => "No",
    },
    id => {
      "pos" => 0,
      "schema" => "uint*",
      "sortable" => "Yes",
      "summary" => "ID",
      "summary.alt.lang.id" => "ID",
      "unique" => "Yes",
    },
    name => {
      "filterable_regex" => "Yes",
      "pos" => 1,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Name of ingredient",
      "summary.alt.lang.id" => "Nama bahan",
      "unique" => "No",
    },
    origin => {
      "filterable_regex" => "Yes",
      "pos" => 2,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Country of origin",
      "summary.alt.lang.id" => "Negara asal",
      "unique" => "No",
    },
    status => {
      "filterable_regex" => "No",
      "pos" => 4,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Status",
      "summary.alt.lang.id" => "Status",
      "unique" => "No",
    },
  },
  "pk" => "id",
  "summary" => "Ingredients in BPOM processed food division (RBA version)",
  "summary.alt.lang.id_ID" => "Bahan baku di BPOM pangan olahan (versi RBA)",
};
# END FRAGMENT id=meta-idn_bpom_bahan_baku_pangan_rba

# BEGIN FRAGMENT id=data-idn_bpom_bahan_baku_pangan_rba varname=data_idn_bpom_bahan_baku_pangan_rba
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_bahan_baku_pangan_rba/data.csv
# src-revision: b611a9d128c23c9252082cf91b450d1899d9961c (Mon Feb 13 19:52:04 2023 +0700)
# generate-date: Mon Feb 13 12:52:13 2023 UTC
# generated-by: update-fragments-in-perl-module
our $data_idn_bpom_bahan_baku_pangan_rba = [
  [
    1,
    " ADAS PEDAS BUBUK-ADAS BUBUK-FENNEL POWDER (FOENICULUM VULGARE)",
    "No",
    "No",
    "Aktif",
  ],
  [2, "Abalon (Abalone)", "No", "No", "Aktif"],
  [3, "Abon Ayam (Chicken Floss)", "No", "No", "Aktif"],
  [4, "Abon Babi (Pork Floss)", "No", "No", "Aktif"],
  [5, "ABON CAKALANG (SKIPJACK TUNA FLOSS)", "No", "No", "Aktif"],
  [6, "Abon Sapi  (Beef Floss)", "No", "No", "Aktif"],
  [7, "Abon Sapi Pedas (Hot Beef Floss)", "No", "No", "Aktif"],
  [8, "Acar (Pickles)", "No", "No", "Aktif"],
  [9, "Acar Bawang Putih (Garlic Pickles)", "No", "No", "Aktif"],
  [10, "Acar Cabe (Chili Pickles)", "No", "No", "Aktif"],
  [11, "Acar Jahe (Ginger Pickles)", "No", "No", "Aktif"],
  [
    12,
    "Acar Mentimun-Ketimun (Cucumber Pickles)",
    "No",
    "No",
    "Aktif",
  ],
  [13, "ACEROLA (ACEROLA)", "No", "No", "Nonaktif"],
  [
    14,
    "ACEROLA (MALPIGHIA GLABRA)- BARBADOS CHERRY-WEST INDIAN CHERRY-CEREZA-CERESIER-SEMERUCO-WILD CRAPEMYRTLE",
    "No",
    "No",
    "Aktif",
  ],
  [15, "ACEROLA BUBUK (ACEROLA POWDER)", "No", "No", "Nonaktif"],
  [16, "ACEROLA EKSTRAK (ACEROLA EXTRACT)", "No", "No", "Nonaktif"],
  [17, "ADAS (FENNEL)", "No", "No", "Nonaktif"],
  [
    18,
    "ADAS MANIS BUBUK-ANIS POWDER (PIMPINELLA ANISUM)",
    "No",
    "No",
    "Aktif",
  ],
  [19, "Adas Manis-Anis (Pimpinella anisum)", "No", "No", "Aktif"],
  [
    20,
    "ADAS PEDAS - ADAS - FENNEL (FOENICULUM VULGARE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    21,
    "ADAS SOWA-DILL (ANETHUM GRAVEOLENS L.)",
    "No",
    "No",
    "Aktif",
  ],
  [
    22,
    "ADENOSIN 5-MONOFOSFAT (ADENOSINE 5-MONOPHOSPHATE)",
    "No",
    "No",
    "Aktif",
  ],
  [23, "Adonan (Dough)", "No", "No", "Aktif"],
  [24, "AGAR-AGAR (AGAR)", "No", "No", "Nonaktif"],
  [25, "AGAR-AGAR BUBUK  (AGAR POWDER)", "No", "No", "Aktif"],
  [26, "Air (Water)", "No", "No", "Aktif"],
  [27, "Air Berkarbonat (Carbonated Water)", "No", "No", "Aktif"],
  [28, "Air Dadih (Whey)", "No", "No", "Aktif"],
  [29, "Air Deionisasi (Deionized Water)", "No", "No", "Aktif"],
  [
    30,
    "AIR DEMINERALISASI (DEMINERALIZED WATER)",
    "No",
    "No",
    "Aktif",
  ],
  [31, "Air Es (Cold Water)", "No", "No", "Aktif"],
  [32, "Air Kaldu (Broth)", "No", "No", "Aktif"],
  [
    33,
    "AIR KELAPA (COCONUT WATER-COCONUT JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [34, "Air Mineral (Mineral Water)", "No", "No", "Aktif"],
  [35, "Air Soda (Soda Water)", "No", "No", "Aktif"],
  [36, "Air Suling (Distilled Water)", "No", "No", "Aktif"],
  [37, "AKAR BUNGA TERATAI (LOTUS ROOT)", "No", "No", "Nonaktif"],
  [38, "Akar Chicory (Chicory Root)", "No", "No", "Aktif"],
  [
    39,
    "Akar Ginseng (Panax Ginseng C.A Meyer)",
    "No",
    "No",
    "Aktif",
  ],
  [
    40,
    "Akar Ginseng (Panax Quinquefolius-American Ginseng)",
    "No",
    "No",
    "Aktif",
  ],
  [41, "Akar Ketumbar (Coriander Root)", "No", "No", "Aktif"],
  [
    42,
    "AKAR TERATAI BUBUK -LOTUS ROOT POWDER(NELUMBIUM NELUMBO DRUCE; NELUMBIUM NUCIFERUM) ",
    "No",
    "No",
    "Aktif",
  ],
  [43, "Alanin (Alanine)", "No", "No", "Aktif"],
  [44, "Albumin (Albumine)", "No", "No", "Aktif"],
  [45, "ALFA KAROTEN", "No", "No", "Aktif"],
  [46, "Alfa Laktalbumin (Alpha-Lactalbumin)", "No", "No", "Aktif"],
  [47, "Alfa Tokoferol (Alpha-Tocopherol)", "No", "No", "Aktif"],
  [48, "ALFA-AMILASE (ALPHA-AMYLASE)", "No", "No", "Aktif"],
  [49, "ALFALFA (ALFALFA)", "No", "No", "Nonaktif"],
  [50, "Alga Merah (Red Algae)", "No", "No", "Aktif"],
  [51, "ALGINAT (ALGINATE)", "No", "No", "Aktif"],
  [52, "Alkohol (Alcohol)", "No", "No", "Aktif"],
  [53, "Allulosa (Allulose)", "No", "No", "Aktif"],
  [54, "Almond Bubuk (Almond Powder)", "No", "No", "Aktif"],
  [55, "Almond Butiran (Almond Granules)", "No", "No", "Aktif"],
  [56, "Almond Panggang (Roasted Almond)", "No", "No", "Aktif"],
  [57, "Alpukat (Avocado)", "No", "No", "Aktif"],
  [58, "Alpukat Bubuk (Avocado Powder)", "No", "No", "Aktif"],
  [59, "Alpukat Pasta (Avocado Paste)", "No", "No", "Aktif"],
  [60, "AMONIAK (AMMONIA)", "No", "No", "Nonaktif"],
  [61, "AMONIAK CAIR (LIQUID AMMONIA)", "No", "No", "Nonaktif"],
  [62, "Ampela (Gizzard)", "No", "No", "Aktif"],
  [63, "ANDALIMAN (ZANTHOXYLUM ACANTHOPODIUM)", "No", "No", "Aktif"],
  [
    64,
    "ANDALIMAN BUBUK - ANDALIMAN POWDER (ZANTHOXYLUM ACANTHOPODIUM)",
    "No",
    "No",
    "Aktif",
  ],
  [65, "ANEKA BUAH BERI (MIX BERRIES)", "No", "No", "Aktif"],
  [66, "Anggur (Wine)", "No", "No", "Aktif"],
  [67, "Anggur Beras (Rice Wine)", "No", "No", "Aktif"],
  [68, "Anggur Merah (Red Wine)", "No", "No", "Aktif"],
  [69, "Anggur Putih (White Wine)", "No", "No", "Aktif"],
  [70, "ANGGUR PUTIH BUBUK", "No", "No", "Nonaktif"],
  [71, "Apel Bubuk (Apple Powder)", "No", "No", "Aktif"],
  [72, "Apel Kering (Dried Apple)", "No", "No", "Aktif"],
  [73, "Aprikot (Apricot)", "No", "No", "Aktif"],
  [74, "Aquamin F", "No", "No", "Nonaktif"],
  [75, "Arak Beras (Rice Wine)", "No", "No", "Aktif"],
  [
    76,
    "ARAK BERAS KETAN (GLUTINOUS RICE WINE)",
    "No",
    "No",
    "Aktif",
  ],
  [77, "Arak Masak", "No", "No", "Nonaktif"],
  [78, "ARANG AKTIF (ACTIVATED CARBON)", "No", "No", "Nonaktif"],
  [79, "ARGININ (ARGININE)", "No", "No", "Aktif"],
  [80, "Artichoke (Artichoke)", "No", "No", "Aktif"],
  [81, "Arugula (Eruca Sativa)", "No", "No", "Aktif"],
  [82, "Asafoetida", "No", "No", "Aktif"],
  [
    83,
    "Asam Amino Premiks (Amino Acid Premix)",
    "No",
    "No",
    "Aktif",
  ],
  [
    84,
    "ASAM ARAKHIDONAT -ARA-AA (DARI MINYAK LAIN)",
    "No",
    "No",
    "Aktif",
  ],
  [
    85,
    "ASAM ARAKHIDONAT-ARA-AA (DARI MINYAK SEL TUNGGAL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    86,
    "ASAM ASETAT GLASIAL (GLACIAL ACETIC ACID)",
    "No",
    "No",
    "Aktif",
  ],
  [87, "Asam Folat (Folic Acid)", "No", "No", "Aktif"],
  [88, "Asam Fosfat (Acid Phosphoric)", "No", "No", "Aktif"],
  [89, "ASAM GELUGUR (GARCINIA ATROVIRIDIS)", "No", "No", "Aktif"],
  [
    90,
    "ASAM JAWA BUBUK-TAMARIND POWDER (TAMARINDUS INDICA)",
    "No",
    "No",
    "Aktif",
  ],
  [
    91,
    "ASAM JAWA-TAMARIND (TAMARINDUS INDICA)",
    "No",
    "No",
    "Aktif",
  ],
  [92, "ASAM KANDIS (GARCINIA XANTHOCHYMUS)", "No", "No", "Aktif"],
  [93, "Asam Linoleat (Linoleic Acid)", "No", "No", "Aktif"],
  [
    94,
    "Asam Linoleat Terkonjugasi (Conjugated Linoleic Acid)",
    "No",
    "No",
    "Aktif",
  ],
  [95, "Asam Nukleat (Nucleic Acid)", "No", "No", "Aktif"],
  [96, "Asam Oktanoat (Octanoate Acid)", "No", "No", "Aktif"],
  [97, "ASAM OLEAT (OLEIC ACID)", "No", "No", "Aktif"],
  [98, "Asam Palmitat (Palmitic Acid)", "No", "No", "Aktif"],
  [99, "Asam Stearat (Stearic Acid)", "No", "No", "Aktif"],
  [100, "Asam Sulfat (Sulfic Acid)", "No", "No", "Aktif"],
  [
    101,
    "ASKORBIL PALMITAT (ASCORBYL PALMITATE)",
    "No",
    "No",
    "Aktif",
  ],
  [102, "ASPARAGUS (ASPARAGUS OFFICINALIS)", "No", "No", "Aktif"],
  [103, "Asparagus Laut (Sea Asparagus)", "No", "No", "Aktif"],
  [104, "Asparagus Putih (White Asparagus)", "No", "No", "Aktif"],
  [105, "ASPERGILLUS ORYZAE", "No", "No", "Aktif"],
  [106, "ASTRAGALI", "No", "No", "Nonaktif"],
  [107, "ASTRAGALUS", "No", "No", "Nonaktif"],
  [108, "Ayam Bubuk (Chicken Powder)", "No", "No", "Aktif"],
  [109, "Ayam Suwir", "No", "No", "Aktif"],
  [110, "Babat Sapi", "No", "No", "Aktif"],
  [
    111,
    "BACILLUS COAGULANS GBI-30 6086 (GANEDEN BC30)",
    "No",
    "No",
    "Aktif",
  ],
  [112, "BACILLUS COAGULANS MTCC 5856", "No", "No", "Aktif"],
  [113, "BAHAN HERBAL LAINNYA", "No", "No", "Nonaktif"],
  [
    114,
    "Bahan Perisa (Flavoring Substances)",
    "No",
    "No",
    "Nonaktif",
  ],
  [115, "Bakso Ayam (Chicken Meatball)", "No", "No", "Aktif"],
  [116, "Bakso Ikan (Fish Meatball)", "No", "No", "Aktif"],
  [117, "Bakso Sapi (Beef Meatball)", "No", "No", "Aktif"],
  [118, "BALM (MELISSA OFFICINALIS L)", "No", "No", "Nonaktif"],
  [119, "Barley (Barley)", "No", "No", "Aktif"],
  [120, "BARLEY (KOJI)", "No", "Yes", "Nonaktif"],
  [121, "Barley grass ( Hordeum vulgare L)", "No", "No", "Aktif"],
  [122, "Barley Malt (Barley Malt)", "No", "No", "Aktif"],
  [123, "Barley Panggang (Roasted Barley)", "No", "No", "Aktif"],
  [124, "Barley Serpihan (Barley Flakes)", "No", "No", "Aktif"],
  [125, "BASIL (BASIL)", "No", "No", "Nonaktif"],
  [
    126,
    "BASIL BUBUK-BASIL POWDER (OCIMUM BASILICUM)",
    "No",
    "No",
    "Aktif",
  ],
  [127, "Bawang Bombay (Onion)", "No", "No", "Aktif"],
  [128, "Bawang Bombay Bubuk (Onion Powder)", "No", "No", "Aktif"],
  [129, "Bawang Bombay Kering (Dried Onion)", "No", "No", "Aktif"],
  [130, "BAWANG DAUN (CHIVES)", "No", "No", "Nonaktif"],
  [131, "BAWANG MERAH (RED ONION-SHALLOT)", "No", "No", "Aktif"],
  [
    132,
    "BAWANG MERAH BUBUK  (RED ONION POWDER - SHALLOT POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [
    133,
    "BAWANG MERAH GORENG  (FRIED RED ONION - FRIED SHALLOT)",
    "No",
    "No",
    "Aktif",
  ],
  [134, "Bawang Putih (Garlic)", "No", "No", "Aktif"],
  [135, "Bawang Putih Bubuk (Garlic Powder)", "No", "No", "Aktif"],
  [136, "BAWANG PUTIH GILING (GRINDED GARLIC)", "No", "No", "Aktif"],
  [137, "Bawang Putih Goreng (Fried Garlic)", "No", "No", "Aktif"],
  [138, "Bawang Putih Kering (Dried Garlic)", "No", "No", "Aktif"],
  [
    139,
    "Bawang Putih Serpihan (Garlic Flakes)",
    "No",
    "No",
    "Aktif",
  ],
  [140, "Bayam (Spinach)", "No", "No", "Aktif"],
  [141, "Bayam Bubuk (Spinach Powder)", "No", "No", "Aktif"],
  [142, "BEE POLLEN (KHUSUS MADU)", "No", "No", "Aktif"],
  [143, "Bekatul Beras (Rice Bran)", "No", "No", "Aktif"],
  [144, "BEKICOT (SNAIL)", "No", "No", "Aktif"],
  [145, "BELIMBING WULUH (AVERRHOA BILIMBI)", "No", "No", "Aktif"],
  [146, "Belut (Eel)", "No", "No", "Aktif"],
  [147, "benang sari teratai", "No", "No", "Nonaktif"],
  [148, "Bengkuang - Sengkuang (Yam Bean)", "No", "No", "Aktif"],
  [149, "BERANGAN (MALAYAN CHESTNUT)", "No", "No", "Aktif"],
  [150, "Beras (Rice)", "No", "No", "Aktif"],
  [151, "Beras Butiran (Rice Grains)", "No", "No", "Aktif"],
  [152, "Beras Cokelat (Brown Rice)", "No", "No", "Aktif"],
  [153, "Beras Hitam (Black Rice)", "No", "No", "Aktif"],
  [154, "Beras Instan (Instant Rice)", "No", "No", "Aktif"],
  [155, "BERAS KEPALA", "No", "No", "Aktif"],
  [156, "Beras Ketan (Glutinous Rice)", "No", "No", "Aktif"],
  [
    157,
    "Beras Ketan Hitam (Black Glutinous Rice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    158,
    "Beras Ketan Putih (White Glutinous Rice)",
    "No",
    "No",
    "Aktif",
  ],
  [159, "Beras Merah (Brown Rice)", "No", "No", "Aktif"],
  [
    160,
    "Beras Merah Krispi (Brown Rice Crispy)",
    "No",
    "No",
    "Aktif",
  ],
  [161, "Beras Merah Utuh (Whole Brown Rice)", "No", "No", "Aktif"],
  [162, "Beras Pandan Wangi", "No", "No", "Aktif"],
  [163, "Beras Panggang (Roasted Rice)", "No", "No", "Aktif"],
  [164, "Beras Utuh (Whole Rice)", "No", "No", "Aktif"],
  [165, "BESI FOSFAT (FERROUS PHOSPHATE)", "No", "No", "Aktif"],
  [166, "BESI FUMARAT (FERROUS FUMARATE)", "No", "No", "Aktif"],
  [167, "Besi Glukonat", "No", "No", "Aktif"],
  [168, "BESI LAKTAT (FERROUS LACTATE)", "No", "No", "Aktif"],
  [
    169,
    "BESI ORTOFOSFAT (FERROUS ORTHOPHOSPHATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    170,
    "BESI PIROFOSFAT (FERROUS PYROPHOSPHATE)",
    "No",
    "No",
    "Aktif",
  ],
  [171, "Besi Sitrat (Ferrous Citrate)", "No", "No", "Aktif"],
  [172, "BESI SULFAT  (FERROUS SULPHATE)", "No", "No", "Aktif"],
  [173, "BESI SULFATE (FERROUS SULPHATE)", "No", "No", "Nonaktif"],
  [174, "BESI TRIOKSIDA (FERROUS TRIOXIDE)", "No", "No", "Aktif"],
  [
    175,
    "BETA GLUKAN DARI SACCHAROMYCES CEREVISIAE",
    "No",
    "No",
    "Aktif",
  ],
  [176, "BETA KAROTEN (BETA-CAROTENE)", "No", "No", "Aktif"],
  [177, "Bifidobacterium Animalis", "No", "No", "Aktif"],
  [178, "Bifidobacterium longum NCC 3001", "No", "No", "Aktif"],
  [179, "Bifidobakterium Breve", "No", "No", "Aktif"],
  [180, "Bifidobakterium Laktis", "No", "No", "Aktif"],
  [181, "Bifidobakterium Longum", "No", "No", "Aktif"],
  [182, "Bihun (Vermicelli)", "No", "No", "Aktif"],
  [183, "Bihun Kentang (Potato Vermicelli)", "No", "No", "Aktif"],
  [184, "Biji Amaranthus hypochondriacus", "No", "No", "Aktif"],
  [185, "BIJI ANGGUR (GRAPE SEED)", "No", "No", "Aktif"],
  [186, "Biji Aprikot (Apricot Seed)", "No", "No", "Aktif"],
  [
    187,
    "Biji Blond Grain Husk (Semen Triticum aestivum)",
    "No",
    "No",
    "Aktif",
  ],
  [188, "BIJI BUNCIS (BAKED BEAN)", "No", "No", "Nonaktif"],
  [189, "Biji Bunga Matahari (Sunflower Seed)", "No", "No", "Aktif"],
  [
    190,
    "BIJI BUNGA TERATAI-LOTUS SEED (NELUMBIUM NELUMBO DRUCE; NELUMBIUM NUCIFERUM)",
    "No",
    "No",
    "Aktif",
  ],
  [191, "Biji Cabe (Chili Seed)", "No", "No", "Aktif"],
  [192, "BIJI CARAWAY (CARAWAY SEED)", "No", "No", "Nonaktif"],
  [193, "BIJI CHIA (SALVIA HISPANICA)", "No", "No", "Aktif"],
  [194, "BIJI COKELAT-BIJI KAKAO (COCOA BEAN)", "No", "No", "Aktif"],
  [195, "Biji Delima (Pomegranate Seed)", "No", "No", "Aktif"],
  [196, "Biji Kopi (Coffee Bean)", "No", "No", "Aktif"],
  [
    197,
    "Biji Kopi Arabika (Arabica Coffee Bean)",
    "No",
    "No",
    "Aktif",
  ],
  [198, "Biji Kopi Hijau (Green Coffee Bean)", "No", "No", "Aktif"],
  [
    199,
    "Biji Kopi Panggang (Roasted Coffee Bean)",
    "No",
    "No",
    "Aktif",
  ],
  [
    200,
    "Biji Kopi Robusta (Robusta Coffee Bean)",
    "No",
    "No",
    "Aktif",
  ],
  [201, "Biji Labu (Pumpkin Seed)", "No", "No", "Aktif"],
  [202, "Biji Labu Putih", "No", "No", "Aktif"],
  [203, "Biji Leci (Lychee Seed)", "No", "No", "Aktif"],
  [204, "Biji Lin (Lin Seed)", "No", "No", "Aktif"],
  [205, "BIJI LUPIN (LUPIN BEAN)", "No", "No", "Aktif"],
  [
    206,
    "Biji Melinjo - Belinjo (Gnetum gnemon)",
    "No",
    "No",
    "Aktif",
  ],
  [207, "Biji Melon (Melon Seeds)", "No", "No", "Aktif"],
  [208, "Biji Mustard (Mustard Seed)", "No", "No", "Aktif"],
  [209, "Biji Pala (Nutmeg)", "No", "No", "Aktif"],
  [210, "BIJI PERILLA - PERILLA SEED", "No", "No", "Aktif"],
  [211, "Biji Pinus (Pinecone)", "No", "No", "Aktif"],
  [212, "Biji Plantago", "No", "No", "Aktif"],
  [213, "BIJI POPPY (PAPAVER SOMNIFERUM)", "No", "No", "Nonaktif"],
  [
    214,
    "BIJI QUINOA (CHENOPODIUM QUINOA WILLDENOW)",
    "No",
    "No",
    "Aktif",
  ],
  [215, "Biji Rami (Flaxseed)", "No", "No", "Aktif"],
  [216, "Biji Rami Bubuk (Flaxseed Powder)", "No", "No", "Aktif"],
  [217, "BIJI SAFFLOWER", "No", "No", "Nonaktif"],
  [218, "Biji Sawi (Mustard Green Seed)", "No", "No", "Aktif"],
  [219, "Biji Selasih (Basil Seed)", "No", "No", "Aktif"],
  [220, "Biji Seledri (Celery Seed)", "No", "No", "Aktif"],
  [221, "Biji Semangka (Watermelon Seed)", "No", "No", "Aktif"],
  [222, "Biji Teff (Teff Grain)", "No", "No", "Aktif"],
  [223, "BIJI VANILA (VANILA BEAN)", "No", "No", "Aktif"],
  [224, "BIOTIN", "No", "No", "Nonaktif"],
  [225, "Bir (Beer)", "No", "No", "Aktif"],
  [226, "BISKUIT (BISCUIT)", "No", "No", "Aktif"],
  [227, "Bit (Beetroot)", "No", "No", "Aktif"],
  [228, "Bit Bubuk (Beetroot Powder)", "No", "No", "Aktif"],
  [229, "Bit Merah (Red Beetroot)", "No", "No", "Aktif"],
  [
    230,
    "Bit Merah Bubuk (Red Beetroot Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    231,
    "BLACKCURRANT BUBUK (BLACKCURRANT POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [232, "Blondo / Galendo", "No", "No", "Aktif"],
  [233, "BLUEBERRY KERING (DRIED BLUEBERRY)", "No", "No", "Aktif"],
  [234, "BLUEBERRY PASTA (BLUEBERRY PASTE)", "No", "No", "Aktif"],
  [235, "Bonggol Pisang", "No", "No", "Aktif"],
  [236, "Brandy (Brandy)", "No", "No", "Aktif"],
  [237, "Brem", "No", "No", "Aktif"],
  [238, "Brokoli (Brocoli)", "No", "No", "Aktif"],
  [239, "BROKOLI BUBUK (BROCCOLI POWDER)", "No", "No", "Aktif"],
  [240, "BUAH ACAI BERRY (EUTERPE OLERACEA)", "No", "No", "Aktif"],
  [241, "Buah Anggur (Grape)", "No", "No", "Aktif"],
  [242, "Buah Anggur Bubuk (Grape Powder)", "No", "No", "Aktif"],
  [243, "BUAH ANGGUR KERING (DRIED GRAPES)", "No", "No", "Aktif"],
  [
    244,
    "Buah Anggur Merah Bubuk (Red Grape Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [245, "Buah Apel (Apple)", "No", "No", "Aktif"],
  [246, "Buah Apel Hijau (Green Apple)", "No", "No", "Aktif"],
  [247, "Buah Apel Merah (Red Apple)", "No", "No", "Aktif"],
  [248, "BUAH ARA (BUAH FIG, BUAH TIN)", "No", "No", "Aktif"],
  [
    249,
    "BUAH ARONIA BUBUK - ARONIA BERRY POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [250, "BUAH ATAP", "No", "No", "Nonaktif"],
  [251, "BUAH BAKU", "No", "No", "Nonaktif"],
  [252, "Buah Belimbing (Starfruit)", "No", "No", "Aktif"],
  [253, "Buah Beri (Berry)", "No", "No", "Aktif"],
  [254, "Buah Beri Hitam (Blackberry)", "No", "No", "Aktif"],
  [255, "Buah Beri Merah (Redberry)", "No", "No", "Aktif"],
  [256, "BUAH BILBERRY (BILBERRY)", "No", "No", "Aktif"],
  [257, "Buah Blackcurrant (Blackcurrant)", "No", "No", "Aktif"],
  [258, "BUAH BLUEBERRY (BLUEBERRY)", "No", "No", "Aktif"],
  [259, "Buah Boysenberry (Boysenberry)", "No", "No", "Aktif"],
  [260, "BUAH BUBUK (FRUIT POWDER)", "No", "No", "Aktif"],
  [261, "Buah Ceri (Cherry)", "No", "No", "Aktif"],
  [262, "Buah Ceri Hitam (Black Cherry)", "No", "No", "Aktif"],
  [263, "Buah Ceri Merah (Red Cherry)", "No", "No", "Aktif"],
  [264, "BUAH CRANBERRY (CRANBERRY)", "No", "No", "Aktif"],
  [265, "Buah Delima (Pomegranate)", "No", "No", "Aktif"],
  [266, "BUAH DHAL BUBUK (DHAL POWDER)", "No", "No", "Nonaktif"],
  [267, "Buah Durian (Durian)", "No", "No", "Aktif"],
  [
    268,
    "BUAH DURIAN MONTHONG (DURIAN MONTHONG)",
    "No",
    "No",
    "Nonaktif",
  ],
  [269, "BUAH ELDERBERRY (ELDERBERRY)", "No", "No", "Aktif"],
  [270, "BUAH FRAMBOZEN (FRAMBOZEN)", "No", "No", "Nonaktif"],
  [271, "BUAH GAC (MOMORDICA COCHINCHINENSIS)", "No", "No", "Aktif"],
  [272, "BUAH GOJI BERRY - BARBARY WOLFBERRY", "No", "No", "Aktif"],
  [273, "BUAH HAW (HAWTHORN BERRY)", "No", "No", "Aktif"],
  [274, "BUAH KERING (DRIED FRUIT)", "No", "No", "Aktif"],
  [275, "Buah Kesemek", "No", "No", "Aktif"],
  [276, "Buah Kundur", "No", "No", "Aktif"],
  [277, "Buah Leci (Lychee)", "No", "No", "Aktif"],
  [278, "Buah Leci Bubuk (Lychee Powder)", "No", "No", "Aktif"],
  [279, "Buah Mulberry (Mulberry)", "No", "No", "Aktif"],
  [280, "Buah Naga (Dragonfruit)", "No", "No", "Aktif"],
  [281, "Buah Pala (Myristica Fragran)", "No", "No", "Aktif"],
  [282, "BUAH PAW PAW (ASIMINA TRILOBA)", "No", "No", "Aktif"],
  [283, "Buah Pepaya (Papaya)", "No", "No", "Aktif"],
  [284, "Buah Pepaya Kuning (Golden Papaya)", "No", "No", "Aktif"],
  [285, "Buah Pepaya Merah (Red Papaya)", "No", "No", "Aktif"],
  [286, "Buah Persik (Peach)", "No", "No", "Aktif"],
  [287, "Buah Prune (Prune)", "No", "No", "Aktif"],
  [288, "Buah Prune Kering (Dried Prune)", "No", "No", "Aktif"],
  [289, "BUAH RASPBERRY (FRAMBOZEN)", "No", "No", "Aktif"],
  [290, "Buah Redcurrant (Redcurrant)", "No", "No", "Aktif"],
  [291, "Buah Stroberi (Strawberry)", "No", "No", "Aktif"],
  [
    292,
    "Buah Stroberi Bubuk (Strawberry Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [293, "Buah Sukun (Breadfruit)", "No", "No", "Aktif"],
  [294, "Buah Zaitun (Olive)", "No", "No", "Aktif"],
  [295, "Buah Zaitun Hijau (Green Olive)", "No", "No", "Aktif"],
  [
    296,
    "Buah Zaitun Hijau Tanpa Biji (Seedless Green Olive)",
    "No",
    "No",
    "Aktif",
  ],
  [297, "Buah Zaitun Hitam (Black Olive)", "No", "No", "Aktif"],
  [
    298,
    "Buah Zaitun Hitam Tanpa Biji (Seedless Black Olive)",
    "No",
    "No",
    "Aktif",
  ],
  [
    299,
    "Buah Zaitun Kalamata (Kalamata Olive)",
    "No",
    "No",
    "Aktif",
  ],
  [
    300,
    "Buah Zukini (Zucchini atau Courgette)",
    "No",
    "No",
    "Aktif",
  ],
  [
    301,
    "Bubuk Ayam (maltodextrin, garam, bubuk kaldu ayam)",
    "No",
    "No",
    "Nonaktif",
  ],
  [302, "Bubuk Buih", "No", "No", "Nonaktif"],
  [
    303,
    "Bubuk campuran buah dan sayur (Blend of Fruit and Vegetable Powders)",
    "No",
    "No",
    "Aktif",
  ],
  [
    304,
    "Bubuk Custard (Susu Bubuk, Gula, Lemak Nabati, Pati Tapioka, Maltodekstrin)",
    "No",
    "No",
    "Nonaktif",
  ],
  [305, "Bubuk Ekstrak Pizza ", "No", "No", "Nonaktif"],
  [
    306,
    "Bubuk Ekstrak Tulang Sapi (Ekstrack tulang sapi, Garam)",
    "No",
    "No",
    "Nonaktif",
  ],
  [307, "Bubuk jahe", "No", "No", "Nonaktif"],
  [
    308,
    "Bubuk kecap (kedelai, garam, tepung)",
    "No",
    "No",
    "Nonaktif",
  ],
  [309, "Bubuk Kelapa", "No", "No", "Nonaktif"],
  [310, "Bubuk lada putih ", "No", "No", "Nonaktif"],
  [311, "BUBUK LECI ", "No", "No", "Nonaktif"],
  [312, "Bubuk Salmon (Salmon Powder)", "No", "No", "Aktif"],
  [
    313,
    "Bubuk Sayuran (tomat, wortel, sawi, kentang, paprika hijau, bawang putih, seledri)",
    "No",
    "No",
    "Nonaktif",
  ],
  [314, "Bubuk Teh Hijau", "No", "No", "Nonaktif"],
  [315, "Bubur Beras (Rice Porridge)", "No", "No", "Aktif"],
  [
    316,
    "Bubur Beras Merah (Brown Rice Porridge)",
    "No",
    "No",
    "Aktif",
  ],
  [317, "Bubur Buah Apel (Apple Pulp)", "No", "No", "Aktif"],
  [318, "Bubur Buah Aprikot (Apricot Pulp)", "No", "No", "Aktif"],
  [319, "Bubur Buah Arbei (Arbei Pulp)", "No", "No", "Aktif"],
  [320, "Bubur Buah Jambu (Guava Pulp)", "No", "No", "Aktif"],
  [321, "Bubur Buah Jambu Merah", "No", "No", "Aktif"],
  [322, "Bubur Buah Jeruk (Orange Pulp)", "No", "No", "Aktif"],
  [323, "Bubur Buah Lemon (Lemon Pulp)", "No", "No", "Aktif"],
  [324, "Bubur Buah Mangga (Mango Pulp)", "No", "No", "Aktif"],
  [325, "Bubur Buah Mulberry (Mulberry Pulp)", "No", "No", "Aktif"],
  [326, "Bubur Buah Nanas (Pineapple Pulp)", "No", "No", "Aktif"],
  [327, "Bubur Buah Persik (Peach Pulp)", "No", "No", "Aktif"],
  [328, "Bubur Buah Sirsak (Soursop Pulp)", "No", "No", "Aktif"],
  [
    329,
    "Bubur Buah Stroberi (Strawberry Pulp)",
    "No",
    "No",
    "Aktif",
  ],
  [330, "Bubur Buah Tomat (Tomato Pulp)", "No", "No", "Aktif"],
  [331, "BUBUR GANDUM (WHEAT PORRIDGE)", "No", "No", "Aktif"],
  [332, "BUBUR KACANG (PEANUT PORRIDGE)", "No", "No", "Aktif"],
  [
    333,
    "BUBUR KACANG HIJAU (MUNGBEAN PORRIDGE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    334,
    "Bubur Kacang Merah (Red Bean Porridge)",
    "No",
    "No",
    "Aktif",
  ],
  [335, "Bubur Kentang  (Potato Pulp)", "No", "No", "Aktif"],
  [336, "BUBUR KULIT JERUK (ORANGE PEEL PULP)", "No", "No", "Aktif"],
  [337, "Bubur Labu Kuning (Pumpkin Porridge)", "No", "No", "Aktif"],
  [338, "Bubur Susu (Milk Porridge)", "No", "No", "Aktif"],
  [339, "BUCKWHEAT (BUCKWHEAT)", "No", "No", "Nonaktif"],
  [
    340,
    "BUCKWHEAT (BUCKWHEAT-FAGOPYRUM ESCULENTUM)",
    "No",
    "No",
    "Aktif",
  ],
  [341, "Bulir Jeruk (Orange Pulp)", "No", "No", "Aktif"],
  [
    342,
    "Bulir Jeruk Valencia (Valencia Orange Pulp)",
    "No",
    "No",
    "Aktif",
  ],
  [
    343,
    "BUMBU  RASA KEJU (CHEESE FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    344,
    "BUMBU ABON AYAM (CHICKEN FLOSS SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    345,
    "BUMBU ASAM MANIS (SWEET AND SOUR SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [346, "Bumbu Ayam (Chicken Seasoning)", "No", "No", "Aktif"],
  [
    347,
    "Bumbu Ayam Bawang (Garlic Chicken Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    348,
    "Bumbu Ayam Goreng (Fried Chicken Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    349,
    "Bumbu Ayam Pedas (Spicy Chicken Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [350, "Bumbu Balado (Balado Seasoning)", "No", "No", "Aktif"],
  [351, "Bumbu Barbekiu (Barbeque Seasoning)", "No", "No", "Aktif"],
  [
    352,
    "BUMBU BAWANG PEDAS (SPICY GARLIC SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    353,
    "BUMBU CUMI BAKAR (GRILLED SQUID SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [354, "Bumbu Daging Sapi (Beef Flavor)", "No", "No", "Aktif"],
  [
    355,
    "Bumbu Frankfurter (Frankfurter Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [356, "BUMBU GULAI (GULAI SEASONING)", "No", "No", "Aktif"],
  [
    357,
    "BUMBU IGA SAPI (SPICES OR SEASONING FOR BEEF RIBS)",
    "No",
    "No",
    "Aktif",
  ],
  [358, "BUMBU IKAN TERI (ANCHOVY SEASONING)", "No", "No", "Aktif"],
  [359, "BUMBU JAGUNG (CORN SEASONING)", "No", "No", "Aktif"],
  [
    360,
    "BUMBU JAGUNG BAKAR (ROASTED CORN SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    361,
    "BUMBU KACANG MERAH (RED BEAN SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [362, "BUMBU KARI (CURRY SEASONING)", "No", "No", "Aktif"],
  [
    363,
    "BUMBU KARI DAGING (MEAT CURRY SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    364,
    "BUMBU KARI IKAN (FISH CURRY SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    365,
    "BUMBU KEJU BURGER (CHEESEBURGER SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    366,
    "Bumbu Kentang Barbekiu (Barbeque Potato Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [367, "BUMBU KIMCHI (KIMCHI SEASONING)", "No", "No", "Aktif"],
  [
    368,
    "BUMBU KRIM ASAM (SOUR CREAM SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    369,
    "BUMBU KRIM MENTEGA (BUTTERCREAM SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    370,
    "BUMBU MI GORENG (FRIED NOODLE SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    371,
    "BUMBU MINYAK UDANG (OIL SEASONING SHRIMP)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [372, "BUMBU NGOHIONG (NGOHIONG SEASONING)", "No", "No", "Aktif"],
  [373, "BUMBU OPOR (OPOR SEASONING)", "No", "No", "Aktif"],
  [
    374,
    "BUMBU OTAK-OTAK (OTAK-OTAK SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [375, "Bumbu Pasta (Paste Seasoning)", "No", "No", "Aktif"],
  [376, "Bumbu Pedas (Spicy Seasoning)", "No", "No", "Aktif"],
  [377, "BUMBU PERENDAM (MARINADE SEASONING)", "No", "No", "Aktif"],
  [378, "Bumbu Petis Bubuk", "No", "No", "Aktif"],
  [379, "Bumbu Pizza (Pizza Seasoning)", "No", "No", "Aktif"],
  [380, "BUMBU RASA (FLAVORED SEASONING)", "No", "No", "Aktif"],
  [
    381,
    "BUMBU RASA ASAM PEDAS (SOUR SPICY FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    382,
    "Bumbu Rasa Ayam (Chicken Flavored Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    383,
    "Bumbu Rasa Ayam Bakar (Grilled Chicken Flavor Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    384,
    "Bumbu Rasa Ayam Panggang (Roasted Chicken Flavor Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    385,
    "BUMBU RASA BABI (PORK OR BACON FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    386,
    "BUMBU RASA BALADO (BALADO FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    387,
    "BUMBU RASA BAWANG (ONION FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    388,
    "BUMBU RASA BAWANG PUTIH (GARLIC FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    389,
    "BUMBU RASA COKELAT (CHOCOLATE FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    390,
    "BUMBU RASA DAGING SAPI (BEEF FLAVORED SEASONING )",
    "No",
    "No",
    "Aktif",
  ],
  [
    391,
    "BUMBU RASA DENDENG (JERKY FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    392,
    "BUMBU RASA IKAN (FISH FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [393, "Bumbu Rasa Kacang Polong", "No", "No", "Nonaktif"],
  [
    394,
    "BUMBU RASA KALDU AYAM (CHICKEN BROTH FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    395,
    "BUMBU RASA KARAMEL (CARAMEL FLAVOURED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    396,
    "BUMBU RASA KARAMEL BAWANG (CARAMELIZED ONION FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    397,
    "BUMBU RASA KARI AYAM (CHICKEN CURRY FLAVORED  SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    398,
    "BUMBU RASA KEJU (CHEESE FLAVORED SEASONING)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    399,
    "BUMBU RASA KENTANG GORENG (FRENCH FRIES FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    400,
    "BUMBU RASA LEMON (LEMON FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    401,
    "BUMBU RASA MANIS PEDAS (SWEET AND SPICY FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    402,
    "BUMBU RASA MUSTARD (MUSTARD FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    403,
    "BUMBU RASA PEDAS (SPICY FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    404,
    "BUMBU RASA PEDAS MANIS ASIN (SWEET, SPICY AND SALTY FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    405,
    "BUMBU RASA PEPPERONI PIZZA (PEPPERONI PIZZA FLAVOR)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    406,
    "BUMBU RASA PIZZA (PIZZA FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    407,
    "BUMBU RASA RUMPUT LAUT (SEAWEED FLAVORED SEASONING )",
    "No",
    "No",
    "Aktif",
  ],
  [408, "Bumbu Rasa Salmon Teriyaki", "No", "No", "Nonaktif"],
  [
    409,
    "BUMBU RASA SAPI (SEASONING BEEF FLAVOR)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    410,
    "BUMBU RASA SAPI PANGGANG ( ROASTED BEEF FLAVORED SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    411,
    "Bumbu Rasa Stroberi (Strawberry Flavored Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    412,
    "Bumbu Rasa Tomat (Tomato Flavored Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    413,
    "BUMBU RASA UDANG (SHRIMP FLAVORED SEASONING)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [414, "BUMBU RAWON (RAWON SEASONING)", "No", "No", "Aktif"],
  [415, "BUMBU RENDANG (RENDANG SEASONING)", "No", "No", "Aktif"],
  [
    416,
    "BUMBU RICA- RICA (RICA-RICA SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    417,
    "Bumbu Rumput Laut (Seaweed Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [
    418,
    "BUMBU SAMBAL LIMAU (SAMBAL LIMAU SEASONING)",
    "No",
    "No",
    "Aktif",
  ],
  [
    419,
    "BUMBU SAPI PANGGANG (ROAST BEEF MARINADE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [420, "Bumbu Sate (Satay Seasoning)", "No", "No", "Aktif"],
  [
    421,
    "Bumbu Sate Pedas (Spicy Satay Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [422, "Bumbu Sayuran (Vegetable Seasoning)", "No", "No", "Aktif"],
  [423, "Bumbu Seafood (Seafood Seasoning)", "No", "No", "Aktif"],
  [424, "Bumbu Sosis (Sausage Seasoning)", "No", "No", "Aktif"],
  [425, "Bumbu Soto (Soto Seasoning)", "No", "No", "Aktif"],
  [426, "Bumbu Sup (Soup Seasoning)", "No", "No", "Aktif"],
  [427, "BUMBU TOM YAM (TOM YAM SEASONING)", "No", "No", "Aktif"],
  [428, "Bumbu Tomat (Tomato Seasoning)", "No", "No", "Aktif"],
  [
    429,
    "Bumbu Tomat Pedas (Spicy Tomato Seasoning)",
    "No",
    "No",
    "Aktif",
  ],
  [430, "BUMBU... (SEASONING)", "No", "No", "Aktif"],
  [431, "BUNCIS BUBUK (GREEN BEAN POWDER)", "No", "No", "Aktif"],
  [432, "BUNCIS HIJAU (GREEN BEAN)", "No", "No", "Aktif"],
  [433, "BUNGA CAMOMILE (CHAMOMILE FLOWER)", "No", "No", "Aktif"],
  [
    434,
    "BUNGA CORNFLOWER (CENTAUREA CYANUS LYNN)",
    "No",
    "No",
    "Aktif",
  ],
  [435, "Bunga Elder (Sambucus nigra)", "No", "No", "Aktif"],
  [436, "bunga jagung", "No", "No", "Nonaktif"],
  [
    437,
    "BUNGA JAGUNG (CORN FLOWER - CENTAURA CYANUS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    438,
    "BUNGA JERUK CITRUS AURANTIUM (FLOWERS ORANGE CITRUS AURANTIUM)",
    "No",
    "No",
    "Aktif",
  ],
  [
    439,
    "BUNGA JERUK CITRUS AURANTIUM-JERUK NIPIS (ORANGE BLOSSOMS)",
    "No",
    "No",
    "Aktif",
  ],
  [
    440,
    "Bunga Lavender (Lavandula angustifolia)",
    "No",
    "No",
    "Aktif",
  ],
  [441, "BUNGA MATAHARI", "No", "No", "Nonaktif"],
  [442, "Bunga Matahari (Sunflower)", "No", "No", "Aktif"],
  [
    443,
    "BUNGA MAWAR ROSA CHINENSIS (ROSE BLOSSOMS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    444,
    "BUNGA MAWAR-ROSE BLOSSOM (ROSA CHINENSIS)",
    "No",
    "No",
    "Aktif",
  ],
  [445, "Bunga Pala", "No", "Yes", "Aktif"],
  [446, "BUNGA SAFFLOWER", "No", "No", "Nonaktif"],
  [447, "BUNGA SAKURA", "No", "No", "Nonaktif"],
  [
    448,
    "Bunga Scarlet Bee Balm (Monarda didyma L)",
    "No",
    "No",
    "Aktif",
  ],
  [449, "Bunga Sedap Malam (Lily Flower)", "No", "No", "Aktif"],
  [450, "Bunga Telang (Clitoria Ternatea)", "No", "No", "Aktif"],
  [451, "bunga teratai", "No", "No", "Nonaktif"],
  [452, "Buntut Sapi (Oxtail)", "No", "No", "Aktif"],
  [453, "BURDOCK ROOT", "No", "No", "Nonaktif"],
  [454, "Butiran Coklat", "No", "No", "Nonaktif"],
  [455, "Buttermilk (Buttermilk)", "No", "No", "Aktif"],
  [456, "Buttermilk Bubuk (Buttermilk Powder)", "No", "No", "Aktif"],
  [457, "Cabe (Chili)", "No", "No", "Aktif"],
  [458, "Cabe Bubuk (Chili Powder)", "No", "No", "Aktif"],
  [459, "Cabe Chilli Hijau  ", "No", "No", "Nonaktif"],
  [460, "Cabe Habanero (Habanero Chili)", "No", "No", "Aktif"],
  [461, "Cabe Hijau  ", "No", "No", "Nonaktif"],
  [462, "Cabe Hijau (Green Chili)", "No", "No", "Aktif"],
  [
    463,
    "Cabe Hijau Bubuk (Green Chili Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [464, "Cabe Jalapeno  ", "No", "No", "Nonaktif"],
  [465, "Cabe Jalapeno (Jalapeno Chili)", "No", "No", "Aktif"],
  [
    466,
    "CABE JALAPENO BUBUK (JALAPENO POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [
    467,
    "CABE JAWA (JAVANESE LONG PEPPER, PIPER RETROFRACTUM VAHL.)",
    "No",
    "No",
    "Aktif",
  ],
  [468, "Cabe Kering (Dried Chili)", "No", "No", "Aktif"],
  [469, "Cabe Kuning (Yellow Chili)", "No", "No", "Aktif"],
  [470, "Cabe Merah  ", "No", "No", "Nonaktif"],
  [471, "Cabe Merah (Red Chili)", "No", "No", "Aktif"],
  [472, "CABE MERAH BESAR", "No", "No", "Nonaktif"],
  [473, "Cabe Merah Bubuk (Red Chili Powder)", "No", "No", "Aktif"],
  [474, "Cabe Rawit (Cayenne Pepper)", "No", "No", "Aktif"],
  [
    475,
    "Cabe Rawit Bubuk (Cayenne Pepper Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    476,
    "Cabe Rawit Hijau (Green Cayenne Pepper)",
    "No",
    "No",
    "Aktif",
  ],
  [
    477,
    "Cabe Rawit Merah (Red Cayenne Pepper)",
    "No",
    "No",
    "Aktif",
  ],
  [
    478,
    "Calcium Beta Hydroxy Beta Methylbutyrate (CaHMB)",
    "No",
    "No",
    "Aktif",
  ],
  [
    479,
    "Campuran Buah Tropical Bubuk (Mixed Tropical Fruit Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    480,
    "Campuran Citrus Bubuk (Mixed Citrus Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    481,
    "Campuran Margarin dan Mentega (Blends of butter and margarine)",
    "No",
    "No",
    "Aktif",
  ],
  [482, "camu-camu (Myrciaria dubia)", "No", "No", "Nonaktif"],
  [483, "Cangkang Rajungan (Crab Shells)", "No", "No", "Aktif"],
  [484, "Capers (Capers)", "No", "No", "Aktif"],
  [485, "CARAWAY (CARAWAY)", "No", "No", "Nonaktif"],
  [486, "Carob (Carob)", "No", "No", "Aktif"],
  [487, "Casein Phosphopeptida", "No", "No", "Aktif"],
  [488, "CASSIA OBTUSIFOLIA", "No", "No", "Nonaktif"],
  [489, "CASSIA TORA", "No", "No", "Nonaktif"],
  [490, "Ceker Ayam", "No", "No", "Aktif"],
  [491, "Cempedak (Artocarpus integer)", "No", "No", "Aktif"],
  [492, "Cendol", "No", "No", "Aktif"],
  [493, "Cengkeh (Clove)", "No", "No", "Aktif"],
  [494, "CENGKEH BUBUK (CLOVE POWDER)", "No", "No", "Aktif"],
  [495, "CEPOKAK (COKOWANA, TERONG PIPIT)", "No", "No", "Aktif"],
  [
    496,
    "Ceremai (Phyllanthus acidus (L.) Skeells)",
    "No",
    "No",
    "Aktif",
  ],
  [497, "Ceri Bubuk (Cherry Powder)", "No", "No", "Aktif"],
  [498, "CHAMOMILE", "No", "No", "Nonaktif"],
  [499, "Chicory (Cichorium intybus)", "No", "No", "Aktif"],
  [500, "Chlorella (Chlorella)", "No", "No", "Aktif"],
  [501, "Chutney (Chutney)", "No", "No", "Aktif"],
  [502, "CILANTRO", "No", "No", "Nonaktif"],
  [503, "CINCAU (JELLY GRASS)", "No", "No", "Aktif"],
  [504, "CINCAU HITAM (BLACK JELLY GRASS)", "No", "No", "Aktif"],
  [505, "CITRUS BIOFLAVONOID", "No", "No", "Nonaktif"],
  [506, "Citrus Fiber", "No", "No", "Aktif"],
  [507, "CO2", "No", "No", "Nonaktif"],
  [508, "COCOA BUTTER EQUIVALENT (CBE)", "No", "No", "Aktif"],
  [509, "Cocoa Butter Replacer (CBR)", "No", "No", "Aktif"],
  [510, "Cocoa Butter Substitute (CBS)", "No", "No", "Aktif"],
  [511, "Cognac (Cognac)", "No", "No", "Aktif"],
  [512, "Cokelat (Chocolate)", "No", "No", "Aktif"],
  [513, "Cokelat Batang (Chocolate Bar)", "No", "No", "Aktif"],
  [514, "COKELAT BUBUK (CHOCOLATE POWDER)", "No", "No", "Aktif"],
  [515, "Cokelat Butir (Chocolate Granules)", "No", "No", "Aktif"],
  [516, "COKELAT CAIR (MELTED CHOCOLATE)", "No", "No", "Nonaktif"],
  [517, "Cokelat Chip (Chocolate Chip)", "No", "No", "Aktif"],
  [
    518,
    "COKELAT COMPOUND BUTIR (CHOCOLATE COMPOUND GRANULE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    519,
    "COKELAT COMPOUND PUTIH (WHITE CHOCOLATE COMPOUND)",
    "No",
    "No",
    "Aktif",
  ],
  [
    520,
    "Cokelat Compound Susu (Milk Chocolate Compound)",
    "No",
    "No",
    "Aktif",
  ],
  [
    521,
    "COKELAT HITAM (DARK CHOCOLATE, BITTERSWEET CHOCOLATE))",
    "No",
    "No",
    "Aktif",
  ],
  [
    522,
    "COKELAT HITAM CHIP (DARK CHOCOLATE CHIP)",
    "No",
    "No",
    "Aktif",
  ],
  [
    523,
    "COKELAT HITAM COMPOUND (DARK CHOCOLATE COMPOUND)",
    "No",
    "No",
    "Aktif",
  ],
  [
    524,
    "Cokelat Imitasi/Hasil Olah Gula (Imitation Chocolate/Processed Sugar)",
    "No",
    "No",
    "Aktif",
  ],
  [525, "COKELAT LIQUOR (COCOA LIQUOR)", "No", "No", "Nonaktif"],
  [526, "COKELAT MASSA (CHOCOLATE MASS)", "No", "No", "Nonaktif"],
  [527, "Cokelat Paduan (Compound Chocolate)", "No", "No", "Aktif"],
  [528, "COKELAT PADUAN-COMPOUND", "No", "No", "Nonaktif"],
  [529, "COKELAT PAHIT (BITTER CHOCOLATE)", "No", "No", "Nonaktif"],
  [530, "Cokelat Pasta (Chocolate Paste)", "No", "No", "Aktif"],
  [531, "Cokelat Pelapis (Chocolate Coating)", "No", "No", "Aktif"],
  [532, "Cokelat Putih (White Chocolate)", "No", "No", "Aktif"],
  [
    533,
    "COKELAT RENDAH LEMAK (LOW FAT COCOA)",
    "No",
    "No",
    "Nonaktif",
  ],
  [534, "Cokelat Susu (Milk Chocolate)", "No", "No", "Aktif"],
  [
    535,
    "COKELAT SUSU KOVERTUR (MILK CHOCOLATE COUVERTURE)",
    "No",
    "No",
    "Aktif",
  ],
  [536, "COKLAT MASSA", "No", "No", "Nonaktif"],
  [
    537,
    "Combrang - Kecombrang (Etlingera elatior)",
    "No",
    "No",
    "Aktif",
  ],
  [538, "COMPOUND PUTIH (WHITE COMPOUND)", "No", "No", "Nonaktif"],
  [539, "CORNFLOWER (CENTAURA CYANUS)", "No", "No", "Nonaktif"],
  [540, "CORNFLOWER (CENTAUREA CYANUS)", "No", "No", "Nonaktif"],
  [541, "Couscous", "No", "No", "Aktif"],
  [542, "CRANBERRY BUBUK (CRANBERRY POWDER)", "No", "No", "Aktif"],
  [543, "Cuka Anggur (Grape Vinegar)", "No", "No", "Aktif"],
  [
    544,
    "Cuka Anggur Putih (White Wine Vinegar)",
    "No",
    "No",
    "Aktif",
  ],
  [545, "Cuka Apel (Apple Vinegar)", "No", "No", "Aktif"],
  [546, "Cuka Balsamic (Balsamic Vinegar)", "No", "No", "Aktif"],
  [547, "Cuka Beras (Rice Vinegar)", "No", "No", "Aktif"],
  [548, "Cuka Bubuk (Vinegar Powder)", "No", "No", "Aktif"],
  [549, "CUKA FERMENTASI (VINEGAR)", "No", "No", "Aktif"],
  [550, "Cuka Lemon (Lemon Vinegar)", "No", "No", "Aktif"],
  [551, "Cuka Makan (Vinegar)", "No", "No", "Aktif"],
  [552, "Cuka Plum (Plum Vinegar)", "No", "No", "Aktif"],
  [553, "Cumi-Cumi (Squid)", "No", "No", "Aktif"],
  [554, "CUMI-CUMI BUBUK (SQUID POWDER)", "No", "No", "Aktif"],
  [555, "cupuacu (theobroma grandiflorum)", "No", "No", "Nonaktif"],
  [556, "Custard (Custard)", "No", "No", "Aktif"],
  [557, "Custard Bubuk (Custard Powder)", "No", "No", "Aktif"],
  [558, "D-XILOSA (D-XYLOSE)", "No", "No", "Aktif"],
  [559, "Dada Ayam (Chicken Breast)", "No", "No", "Aktif"],
  [560, "Dadih", "No", "No", "Aktif"],
  [561, "Dadih Bubuk (Buttermilk Powder)", "No", "No", "Aktif"],
  [562, "DAGING AYAM (CHICKEN MEAT)", "No", "No", "Aktif"],
  [
    563,
    "DAGING AYAM ASAP (SMOKE CHICKEN MEAT)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [564, "Daging Ayam Bubuk (Chicken Powder)", "No", "No", "Aktif"],
  [
    565,
    "Daging Ayam Cincang (Minced Chiken)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [566, "Daging Ayam Fillet (Chicken Fillet)", "No", "No", "Aktif"],
  [567, "Daging Ayam Irisan (Chicken Strips)", "No", "No", "Aktif"],
  [
    568,
    "DAGING AYAM SERPIHAN (CHICKEN FLAKES)",
    "No",
    "No",
    "Aktif",
  ],
  [569, "Daging Babi (Pork)", "No", "No", "Aktif"],
  [570, "DAGING BABI ASAP (SMOKE PORK)", "No", "No", "Aktif"],
  [571, "Daging Babi Bubuk (Pork Powder)", "No", "No", "Aktif"],
  [572, "Daging Bebek (Duck Meat)", "No", "No", "Aktif"],
  [573, "Daging Burung Puyuh/Dara/.....", "No", "No", "Aktif"],
  [574, "Daging Domba (Lamb)", "No", "No", "Aktif"],
  [575, "Daging Kalkun (Turkey Meat)", "No", "No", "Aktif"],
  [576, "Daging Kambing (Mutton)", "No", "No", "Aktif"],
  [577, "DAGING KERBAU (BUFFALO MEAT)", "No", "No", "Aktif"],
  [578, "Daging Paha Babi (Ham)", "No", "No", "Aktif"],
  [579, "Daging Rusa (Deer Meat)", "No", "No", "Aktif"],
  [580, "Daging Sapi (Beef)", "No", "No", "Aktif"],
  [581, "DAGING SAPI ASAP (SMOKE BEEF)", "Yes", "Yes", "Aktif"],
  [582, "Daging Sapi Bubuk (Beef Powder)", "No", "No", "Aktif"],
  [583, "Daging Sapi Cincang (Minced Beef)", "Yes", "Yes", "Aktif"],
  [
    584,
    "Dandelion Root Powder (Taraxacum officinale)",
    "No",
    "No",
    "Aktif",
  ],
  [585, "DAUN ANGGUR (GRAPE LEAF)", "No", "No", "Nonaktif"],
  [
    586,
    "Daun Apple Mint (Mentha suaveolens Ehrh)",
    "No",
    "No",
    "Aktif",
  ],
  [587, "Daun Asam Jawa (Tamarindus indica)", "No", "No", "Aktif"],
  [588, "Daun Basil (Basil Leaf)", "No", "No", "Aktif"],
  [589, "Daun Basil Bubuk (Basil Leaf Powder)", "No", "No", "Aktif"],
  [590, "Daun Basil Kering (Dried Basil Leaf)", "No", "No", "Aktif"],
  [591, "DAUN BAWANG (SCALLION)", "No", "No", "Aktif"],
  [592, "DAUN BAWANG BUBUK (LEEK POWDER)", "No", "No", "Aktif"],
  [593, "DAUN BAWANG KERING (DRIED SCALLION)", "No", "No", "Aktif"],
  [594, "Daun Beluntas (Pluchea Folium)", "No", "No", "Aktif"],
  [595, "Daun Bergamot (Monarda didyma)", "No", "No", "Aktif"],
  [596, "Daun Blackberry (Blackberry Leaf)", "No", "No", "Aktif"],
  [597, "Daun Blackcurrant", "No", "No", "Aktif"],
  [598, "Daun Cengkeh (Clove Leaf)", "No", "No", "Aktif"],
  [
    599,
    "Daun Citrus Thyme (Thymus citriodorus)",
    "No",
    "No",
    "Aktif",
  ],
  [600, "DAUN GANDUM (WHEATGRASS)", "No", "No", "Nonaktif"],
  [
    601,
    "Daun Gedi (Abelmoschus manihot (L.) Medik)",
    "No",
    "No",
    "Aktif",
  ],
  [602, "DAUN JAMBU BIJI (GUAVA LEAF)", "No", "No", "Aktif"],
  [
    603,
    "DAUN JATI BELANDA (GUAZUMA ULMIFOLIA)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    604,
    "DAUN JERUK (CITRUS LEAF ATAU LIME LEAF)",
    "No",
    "No",
    "Aktif",
  ],
  [605, "Daun Jeruk Purut (Kaffir Lime Leaf)", "No", "No", "Aktif"],
  [606, "Daun Kari (Curry Leaf)", "No", "No", "Aktif"],
  [607, "Daun Katuk", "No", "No", "Aktif"],
  [608, "Daun Kelor (Moringa oleifera L.)", "No", "No", "Aktif"],
  [609, "DAUN KEMANGI (LEMON BASIL LEAF)", "No", "No", "Aktif"],
  [
    610,
    "DAUN KETUMBAR (CILANTRO- CORIANDER LEAF)",
    "No",
    "No",
    "Aktif",
  ],
  [611, "DAUN KOPI (COFFEE LEAF)", "No", "No", "Aktif"],
  [612, "DAUN KUCAI (GARLIC LEAF CHIVES)", "No", "No", "Aktif"],
  [613, "Daun Kunyit (Turmeric Leaf)", "No", "No", "Aktif"],
  [614, "DAUN LAKSA (LAKSA LEAF)", "No", "No", "Aktif"],
  [615, "Daun Lobak (Radish Leaf)", "No", "No", "Aktif"],
  [616, "Daun Marjoram (Marjoram Leaf)", "No", "No", "Aktif"],
  [617, "DAUN MELINJO (MELINJO LEAF)", "No", "No", "Aktif"],
  [618, "Daun Mint (Mint Leaf)", "No", "No", "Aktif"],
  [619, "DAUN MOLOKHIA (MOLOKHIA LEAF)", "No", "No", "Aktif"],
  [620, "DAUN MULBERRY (MULBERRY LEAF)", "No", "No", "Nonaktif"],
  [621, "Daun Oregano (Oregano Leaf)", "No", "No", "Aktif"],
  [
    622,
    "Daun Oregano Kering (Dried Oregano Leaf)",
    "No",
    "No",
    "Aktif",
  ],
  [
    623,
    "Daun Pakis / Paku Sayur (Vegetable Fern)",
    "No",
    "No",
    "Aktif",
  ],
  [624, "Daun Pandan (Pandan Leaf)", "No", "No", "Aktif"],
  [625, "Daun Pepaya (Papaya Leaf)", "No", "No", "Aktif"],
  [626, "Daun Peppermint (Peppermint Leaf)", "No", "No", "Aktif"],
  [627, "DAUN PERILLA (PERILLA LEAF)", "No", "No", "Aktif"],
  [
    628,
    "DAUN PERILLA BUBUK (PERILLA LEAF POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [
    629,
    "DAUN PETERSELI (PETROSELINUM CRISPUM)",
    "No",
    "No",
    "Nonaktif",
  ],
  [630, "Daun Raspberry (Raspberry Leaf)", "No", "No", "Aktif"],
  [631, "DAUN RHUBARB (RHEUM RHABARBARUM)", "No", "No", "Nonaktif"],
  [632, "Daun Rosemarry (Rosemarry Leaf)", "No", "No", "Aktif"],
  [633, "DAUN SAGA (JEQUIRITY LEAF)", "No", "No", "Aktif"],
  [634, "Daun Salam (Bay Leaf)", "No", "No", "Aktif"],
  [635, "Daun Salam Bubuk (Bay Leaf Powder)", "No", "No", "Aktif"],
  [636, "Daun Seledri (Celery Leaf)", "No", "No", "Aktif"],
  [
    637,
    "Daun Seledri Kering (Dried Celery Leaf)",
    "No",
    "No",
    "Aktif",
  ],
  [638, "DAUN SEMBUNG (SAMBONG LEAF)", "No", "No", "Aktif"],
  [639, "DAUN SERUNI (CHRYSANTHEMUM LEAF)", "No", "No", "Aktif"],
  [640, "DAUN SINGKONG (CASSAVA LEAF)", "No", "No", "Aktif"],
  [641, "DAUN SIRIH (BETEL LEAF)", "No", "No", "Nonaktif"],
  [642, "DAUN SIRSAK (SOURSOP LEAF)", "No", "No", "Aktif"],
  [643, "DAUN STEVIA (STEVIA LEAF)", "No", "No", "Nonaktif"],
  [644, "Daun Stroberi (Strawberry Leaf)", "No", "No", "Aktif"],
  [
    645,
    "DAUN SWISS CHARD (FOLIUM BETA VULGARIS)",
    "No",
    "No",
    "Aktif",
  ],
  [646, "DAUN TARRAGON (TARRAGON LEAF)", "No", "No", "Aktif"],
  [647, "daun teratai ", "No", "No", "Nonaktif"],
  [648, "Daun Teratai (Lotus Leaf)", "No", "No", "Aktif"],
  [
    649,
    "Daun Ubi Merah (Red Sweet Potato Leaf)",
    "No",
    "No",
    "Aktif",
  ],
  [650, "Dekstrin (Dextrin)", "No", "No", "Aktif"],
  [651, "Dekstrosa (Dextrose)", "No", "No", "Aktif"],
  [
    652,
    "Dekstrosa Anhidrat (Anhydrous Dextrose)",
    "No",
    "No",
    "Aktif",
  ],
  [653, "Dekstrosa Bubuk (Dextrose Powder)", "No", "No", "Aktif"],
  [654, "Dekstrosa monohidrat", "No", "No", "Nonaktif"],
  [
    655,
    "DEKSTROSA MONOHIDRAT (DEXTROSE MONOHYDRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [656, "Dextrosa", "No", "No", "Nonaktif"],
  [657, "DHA (dari Minyak Ikan)", "No", "No", "Aktif"],
  [658, "DHA (dari Minyak Sel Tunggal)", "No", "No", "Aktif"],
  [659, "DHA (DOCOSAHEXAENOIC ACID )", "No", "No", "Aktif"],
  [
    660,
    "DI-KALIUM HIDROGEN FOSFAT (DI-POTASSIUM HYDOGEN PHOSPAT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    661,
    "DIKALIUM FOSFAT (DIPOTASSIUM PHOSPHATE-DIPOTASSIUM ORTHOPHOSPHATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    662,
    "DIKALSIUM FOSFAT (KALSIUM HIDROGEN FOSFAT, KALSIUM MONOHIDROGEN FOSFAT, KALSIUM HIDROGEN ORTOFOSFAT))",
    "No",
    "No",
    "Aktif",
  ],
  [
    663,
    "Dinatrium 5 Inosinat (disodium 5 Inosinate)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    664,
    "Dinatrium 5 ribonukleotida (Disodium 5 ribonucleotides)",
    "No",
    "No",
    "Nonaktif",
  ],
  [665, "DInatrium 5-Monofosfat", "No", "No", "Aktif"],
  [
    666,
    "Dinatrium fosfat (Disodium Orthophosphate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    667,
    "Dinatrium Fosfat Anhidrat (Disodium Phosphate Anhydrous)",
    "No",
    "No",
    "Aktif",
  ],
  [668, "Dinatrium Guanosin 5-Monofosfat", "No", "No", "Aktif"],
  [
    669,
    "DINATRIUM SUKSINAT (DISODIUM SUCCINATE)",
    "No",
    "No",
    "Aktif",
  ],
  [670, "Dinatrium Uridin 5-Monofosfat", "No", "No", "Aktif"],
  [
    671,
    "Duckweed / water lentils (Lemna gibba / Lemna minor complex dan Wolffia globosa)",
    "No",
    "No",
    "Aktif",
  ],
  [672, "Dulse (Palmaria palmata)", "No", "No", "Aktif"],
  [673, "DURIAN BUBUK (DURIAN POWDER)", "No", "No", "Aktif"],
  [
    674,
    "ECHINACEAE; CONEFLOWERS; PURPLE CONEFLOWER",
    "No",
    "No",
    "Nonaktif",
  ],
  [675, "EGCG (EPIGALLOCATECHIN GALLATE)", "No", "No", "Aktif"],
  [
    676,
    "EKSTRA VIRGIN OLIVE OIL (VIRGIN OLIVE OIL EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [677, "EKSTRAK .....", "No", "No", "Aktif"],
  [
    678,
    "EKSTRAK AIR KELAPA (COCONUT WATER EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    679,
    "Ekstrak Akar Kolesom (Talinum triangulare Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [680, "EKSTRAK ANGGUR (GRAPE EXTRACT)", "No", "No", "Nonaktif"],
  [681, "EKSTRAK ASAM JAWA (TAMARIND EXTRACT)", "No", "No", "Aktif"],
  [682, "Ekstrak Ayam (Chicken Extract)", "No", "No", "Aktif"],
  [683, "Ekstrak Barley  (Barley Extract)", "No", "No", "Aktif"],
  [
    684,
    "Ekstrak Barley Malt (Barley Malt Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [685, "Ekstrak Basil (Basil Extract)", "No", "No", "Aktif"],
  [
    686,
    "EKSTRAK BAWANG BOMBAY (ONION EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    687,
    "Ekstrak Bawang Goreng (Dried Onion Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    688,
    "Ekstrak Bawang Putih (Garlic Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [689, "Ekstrak Bengkuang (Yambean Extract)", "No", "No", "Aktif"],
  [690, "Ekstrak Beras (Rice Extract)", "No", "No", "Aktif"],
  [
    691,
    "EKSTRAK BERAS KENCUR (BERAS KENCUR EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    692,
    "EKSTRAK BERAS MERAH (BROWN RICE EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    693,
    "EKSTRAK BIJI ANGGUR (GRAPE SEED EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    694,
    "EKSTRAK BIJI BUNGA MATAHARI (SUNFLOWER SEED EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [695, "EKSTRAK BILBERRY (BILBERY EXTRACT)", "No", "No", "Aktif"],
  [696, "Ekstrak Blewah (Cantaloupe Extract)", "No", "No", "Aktif"],
  [697, "Ekstrak Bonito (Bonito Extract)", "No", "No", "Aktif"],
  [698, "EKSTRAK BROKOLI (BROCCOLI EXTRACT)", "No", "No", "Aktif"],
  [
    699,
    "EKSTRAK BUAH ACAI BERRY (ACAI BERRY EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    700,
    "EKSTRAK BUAH ALPUKAT (AVOCADO EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [701, "Ekstrak Buah Anggur (Grape Extract)", "No", "No", "Aktif"],
  [702, "EKSTRAK BUAH APEL (APPLE EXTRACT)", "No", "No", "Aktif"],
  [
    703,
    "EKSTRAK BUAH APEL HIJAU (GREEN  APPLE EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    704,
    "Ekstrak Buah Belimbing (Starfruit Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [705, "EKSTRAK BUAH BIT (BEETROOT EXTRACT)", "No", "No", "Aktif"],
  [
    706,
    "Ekstrak Buah Blackberry (Blackberry Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    707,
    "Ekstrak Buah Blackcurrant (Blackcurrant Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    708,
    "Ekstrak Buah Blueberry (Blueberry Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [709, "Ekstrak Buah Ceri (Cherry Extract)", "No", "No", "Aktif"],
  [
    710,
    "Ekstrak Buah Delima (Pomegranate Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [711, "Ekstrak Buah Durian (Durian Extract)", "No", "No", "Aktif"],
  [
    712,
    "EKSTRAK BUAH KELENGKENG (LONGAN EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    713,
    "Ekstrak Buah Kesemek (Persimmon Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [714, "EKSTRAK BUAH KIWI (KIWI EXTRACT)", "No", "No", "Aktif"],
  [
    715,
    "Ekstrak Buah Kundur (Benincasa hispida Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [716, "Ekstrak Buah Leci (Lychee Extract)", "No", "No", "Aktif"],
  [717, "Ekstrak Buah Lemon (Lemon Extract)", "No", "No", "Aktif"],
  [718, "Ekstrak Buah Mangga (Mango Extract)", "No", "No", "Aktif"],
  [
    719,
    "Ekstrak Buah Mangga Manalagi (Manalagi Mango Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    720,
    "Ekstrak Buah Markisa (Passionfruit Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [721, "Ekstrak Buah Melon (Melon Extract)", "No", "No", "Aktif"],
  [
    722,
    "EKSTRAK BUAH MURBEI (MULBERRY EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    723,
    "Ekstrak Buah Nangka (Jackfruit Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [724, "Ekstrak Buah Persik (Peach Extract)", "No", "No", "Aktif"],
  [725, "Ekstrak Buah Pisang (Banana Extract)", "No", "No", "Aktif"],
  [726, "Ekstrak Buah Plum (Plum Extract)", "No", "No", "Aktif"],
  [727, "Ekstrak Buah Prune (Prune Extract)", "No", "No", "Aktif"],
  [
    728,
    "Ekstrak Buah Raspberry (Raspberry Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    729,
    "Ekstrak Buah Semangka (Watermelon Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    730,
    "Ekstrak Buah Sirsak (Soursop Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    731,
    "Ekstrak Buah Stroberi (Strawberry Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    732,
    "Ekstrak Buah Tangkwa (Tangkwa Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    733,
    "EKSTRAK BUAH TIN ATAU BUAH ARA (FIG EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    734,
    "Ekstrak Buah Ume (Japanesse Plum Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    735,
    "Ekstrak Bumbu (bawang bombay,bawang putih, paprika dan annato)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    736,
    "EKSTRAK BUNGA CHAMOMILE (CHAMOMILE FLOS EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    737,
    "EKSTRAK BUNGA ELDER (ELDER FLOS EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    738,
    "Ekstrak Bunga Jeruk (Orange Flos Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    739,
    "EKSTRAK BUNGA KRISAN (CHRYSANTHEMUM EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    740,
    "EKSTRAK BUNGA MAWAR (ROSE FLOS EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    741,
    "EKSTRAK BUNGA SAFFLOWER (CARTHAMUS TINCTORIUS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [742, "Ekstrak Cabe (Chili Extract)", "No", "No", "Aktif"],
  [
    743,
    "Ekstrak Campuran Buah Beri (Mixberry Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [744, "Ekstrak Chicory (Chicory Extract)", "No", "No", "Aktif"],
  [745, "Ekstrak Cincau (Grass Jelly Extract)", "No", "No", "Aktif"],
  [746, "EKSTRAK COCOPANDAN", "No", "No", "Nonaktif"],
  [747, "Ekstrak Cumi-cumi", "No", "No", "Nonaktif"],
  [
    748,
    "Ekstrak Daging Ayam (Chicken Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [749, "Ekstrak Daging Babi (Pork Extract)", "No", "No", "Aktif"],
  [750, "Ekstrak Daging Sapi (Beef Extract)", "No", "No", "Aktif"],
  [
    751,
    "Ekstrak Daun Katuk (Sauropus androgynus Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    752,
    "EKSTRAK DAUN MESONA (MESONA LEAF EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    753,
    "EKSTRAK DAUN PANDAN (PANDANUS LEAF EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    754,
    "Ekstrak Daun Salam (Bay Leaf Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    755,
    "EKSTRAK DAUN SIRIH (PIPER BETLE EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    756,
    "Ekstrak Daun Wasabi (Wasabi Leaf Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [757, "EKSTRAK DEDAK (RICE BRAN EXTRACT)", "No", "No", "Aktif"],
  [
    758,
    "EKSTRAK FRAMBOZEN (FRAMBOZEN EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [759, "Ekstrak Gandum (Wheat Extract)", "No", "No", "Aktif"],
  [
    760,
    "Ekstrak Ginseng (Panax Ginseng C.A Meyer)",
    "No",
    "No",
    "Aktif",
  ],
  [
    761,
    "Ekstrak Ginseng (Panax Quinquefolius-American Ginseng)",
    "No",
    "No",
    "Aktif",
  ],
  [
    762,
    "EKSTRAK GUARANA - PAULLINIA CUPANA(GUARANA EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    763,
    "EKSTRAK GUARANA BUBUK (GUARANA POWDER EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    764,
    "Ekstrak Gula Tebu (Cane Sugar Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    765,
    "Ekstrak Gurita Bubuk (Octopus Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [766, "EKSTRAK HOP (HOP EXTRACT)", "No", "No", "Aktif"],
  [767, "Ekstrak Ikan (Fish Extract)", "No", "No", "Aktif"],
  [
    768,
    "Ekstrak Ikan Bonito (Bonito Fish Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    769,
    "Ekstrak Ikan Sardin (Sardines Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [770, "Ekstrak Ikan Teri (Anchovy Extract)", "No", "No", "Aktif"],
  [771, "Ekstrak Jagung (Corn Extract)", "No", "No", "Aktif"],
  [772, "Ekstrak Jahe (Ginger Extract)", "No", "No", "Aktif"],
  [773, "Ekstrak Jambu Biji (Guava Extract)", "No", "No", "Aktif"],
  [774, "Ekstrak Jamur (Mushroom Extract)", "No", "No", "Aktif"],
  [
    775,
    "EKSTRAK JAMUR BUBUK (MUSHROOM EXTRACT POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [
    776,
    "Ekstrak Jamur Shitake (Shitake Mushroom Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [777, "Ekstrak Jeruk (Orange Extract)", "No", "No", "Aktif"],
  [778, "EKSTRAK JERUK ........", "No", "No", "Nonaktif"],
  [779, "Ekstrak Jeruk Lemon (Lemon Extract)", "No", "No", "Aktif"],
  [780, "Ekstrak Jeruk Limau (Citrus Extract)", "No", "No", "Aktif"],
  [
    781,
    "EKSTRAK JERUK LIMAU BUBUK (LIME EXTRACT POWDER)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [782, "Ekstrak Jeruk Nipis (Lime Extract)", "No", "No", "Aktif"],
  [
    783,
    "Ekstrak Kacang Hazel (Hazelnut Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    784,
    "Ekstrak Kacang Hijau (Mungben Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    785,
    "Ekstrak Kacang Kedelai (Soybean Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    786,
    "EKSTRAK KACANG TANAH (PEANUT EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [787, "Ekstrak Kawis (Kawis Extract)", "No", "No", "Aktif"],
  [
    788,
    "Ekstrak Kayu Manis (Cinnamon Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [789, "Ekstrak Kecambah (Sprouts Extract)", "No", "No", "Aktif"],
  [790, "EKSTRAK KEDELAI (SOY EXTRACT)", "No", "No", "Nonaktif"],
  [791, "Ekstrak Kelapa (Coconut Extract)", "No", "No", "Aktif"],
  [
    792,
    "EKSTRAK KELAPA MUDA (YOUNG COCONUT EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [793, "Ekstrak Kelp (Kelp Extract)", "No", "No", "Aktif"],
  [794, "EKSTRAK KENCUR (GALANGAL EXTRACT)", "No", "No", "Aktif"],
  [795, "Ekstrak Kepiting (Crab Extract)", "No", "No", "Aktif"],
  [796, "Ekstrak Kerang (Clam Extract)", "No", "No", "Aktif"],
  [797, "Ekstrak Kimchi (Kimchi Extract)", "No", "No", "Aktif"],
  [798, "Ekstrak Kola (Coke Extract)", "No", "No", "Aktif"],
  [799, "Ekstrak Kolesom (Kolesom Extract)", "No", "No", "Aktif"],
  [800, "Ekstrak Kopi (Coffee Extract)", "No", "No", "Aktif"],
  [
    801,
    "Ekstrak Kopi Hijau (Green Coffee Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    802,
    "Ekstrak Krisantemum (Chrysantemum Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    803,
    "Ekstrak Kubis Merah (Red Cabbage Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [804, "EKSTRAK KUNING TELUR (YOLK EXTRACT)", "No", "No", "Aktif"],
  [805, "Ekstrak Kunyit (Turmeric Extract)", "No", "No", "Aktif"],
  [806, "Ekstrak Lada (Pepper Extract)", "No", "No", "Aktif"],
  [
    807,
    "EKSTRAK LICORICE-LIQUORICE- SUCCUS LIQUIRITIAE (GLYCYRRHIZA GLABRA)",
    "No",
    "No",
    "Aktif",
  ],
  [
    808,
    "Ekstrak Lidah Buaya (Aloe Vera Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [809, "Ekstrak Lobak (Radish Extract)", "No", "No", "Aktif"],
  [810, "Ekstrak Madu (Honey Extract)", "No", "No", "Aktif"],
  [811, "Ekstrak Malt (Malt Extract)", "No", "No", "Aktif"],
  [812, "Ekstrak Mangga (Mango Extract)", "No", "No", "Aktif"],
  [813, "Ekstrak Manggis (Mangosteen Extract)", "No", "No", "Aktif"],
  [814, "Ekstrak Melati (Jasmine Extract)", "No", "No", "Aktif"],
  [815, "Ekstrak Melon (Melon Extract)", "No", "No", "Aktif"],
  [816, "Ekstrak Mint (Mint Extract)", "No", "No", "Aktif"],
  [
    817,
    "Ekstrak Minyak Ikan (Fish Oil Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [818, "Ekstrak Muscat (Muscat Extract)", "No", "No", "Aktif"],
  [819, "Ekstrak Mustard (Mustard Extract)", "No", "No", "Aktif"],
  [820, "Ekstrak Nanas (Pineapple Extact)", "No", "No", "Aktif"],
  [821, "Ekstrak Nangka (Jackfruit Extract)", "No", "No", "Aktif"],
  [822, "Ekstrak Pala (Nutmeg Extract)", "No", "No", "Aktif"],
  [823, "EKSTRAK PANDAN", "No", "No", "Nonaktif"],
  [824, "Ekstrak Paprika (Paprika Extract)", "No", "No", "Aktif"],
  [
    825,
    "EKSTRAK PEGAGAN (PENNYWORTH EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [826, "EKSTRAK PEPAYA (PAPAYA EXTRACT)", "No", "No", "Aktif"],
  [827, "ekstrak perilla seed", "No", "No", "Nonaktif"],
  [828, "Ekstrak Pir (Pear Extract)", "No", "No", "Aktif"],
  [829, "Ekstrak Protein.... (Asal Bahan...)", "No", "No", "Aktif"],
  [830, "EKSTRAK QUILLAILA", "No", "No", "Nonaktif"],
  [831, "Ekstrak Ragi (Yeast Extract)", "No", "No", "Aktif"],
  [832, "Ekstrak Remis (Mussels Extract)", "No", "No", "Aktif"],
  [833, "Ekstrak Ricola (Ricola Extract)", "No", "No", "Aktif"],
  [
    834,
    "EKSTRAK ROSELLA (HIBISCUS SABDARIFFA EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    835,
    "EKSTRAK ROSEMARY (ROSMARINUS OFFICINALIS EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [836, "Ekstrak Rum (Rhum Extract)", "No", "No", "Aktif"],
  [
    837,
    "Ekstrak Rumput Laut (Seaweed Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    838,
    "EKSTRAK SARSAPARILA - SARSI (SARSAPARILLA EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [839, "Ekstrak Sayuran (Vegetable Extract)", "No", "No", "Aktif"],
  [840, "Ekstrak Seafood (Seafood Extract)", "No", "No", "Aktif"],
  [841, "EKSTRAK SEREALIA (CEREALS EXTRACT)", "No", "No", "Aktif"],
  [842, "Ekstrak Sereh (Lemongrass Extract)", "No", "No", "Aktif"],
  [843, "EKSTRAK STEVIA (STEVIA EXTRACT)", "No", "No", "Nonaktif"],
  [844, "Ekstrak Tebu (Cane Extract)", "No", "No", "Aktif"],
  [845, "Ekstrak Teh (Tea Extract)", "No", "No", "Aktif"],
  [
    846,
    "Ekstrak Teh Hijau (Green Tea Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    847,
    "Ekstrak Teh Hitam (Black Tea Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    848,
    "EKSTRAK TEMU HITAM (CURCUMA AERUGINOSA EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [
    849,
    "Ekstrak Temulawak (Curcuma xanthorrhiza Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [850, "Ekstrak Tiram (Oyster Extract)", "No", "No", "Aktif"],
  [
    851,
    "Ekstrak Tulang Babi (Pig Bone Extract)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [
    852,
    "Ekstrak Tulang Sapi (Beef Bone Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [853, "Ekstrak Udang (Shrimp Extract)", "No", "No", "Aktif"],
  [854, "ekstrak vanillin", "No", "No", "Nonaktif"],
  [855, "Ekstrak Wasabi (Wasabi Extract)", "No", "No", "Aktif"],
  [
    856,
    "Ekstrak Wildberry (Wildberry Extract)",
    "No",
    "No",
    "Aktif",
  ],
  [
    857,
    "EKSTRAK WOLFBERRY (WOLFBERRY EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [858, "Ekstrak Wortel (Carrot Extract)", "No", "No", "Aktif"],
  [
    859,
    "EKSTRAK WORTEL UNGU/WORTEL HITAM (PURPLE/BLACK CARROTS EXTRACT)",
    "No",
    "No",
    "Aktif",
  ],
  [860, "ELDERBERRY (SAMBUCUS EBULUS)", "No", "No", "Aktif"],
  [861, "ELDERBERRY (SAMBUCUS NIGRA)", "No", "No", "Aktif"],
  [862, "EMPING BARLEY ", "No", "No", "Aktif"],
  [863, "EMPING JAGUNG (CORN FLAKES)", "No", "No", "Aktif"],
  [864, "EMPING MELINJO - GNETUM GNEMON ", "No", "No", "Aktif"],
  [865, "ENZIM AMILASE (AMILASE ENZYME)", "No", "No", "Nonaktif"],
  [866, "Enzim Beta - Fruktofuranosidase ", "No", "No", "Aktif"],
  [
    867,
    "ENZIM BROMELAIN (BROMELAINE ENZYME)",
    "No",
    "No",
    "Nonaktif",
  ],
  [868, "ENZIM LAKTASE (LACTASE ENZYME)", "No", "No", "Aktif"],
  [
    869,
    "Enzim Laktoperoksidase (Lactoperoxidase Enzyme)",
    "No",
    "No",
    "Aktif",
  ],
  [870, "ENZIM LIPASE (LIPASE ENZYME)", "No", "No", "Aktif"],
  [871, "ENZIM PAPAIN (PAPAIN ENZYME)", "No", "No", "Nonaktif"],
  [872, "ENZIM PROTEASE (PROTEASE ENZYME)", "No", "No", "Aktif"],
  [873, "Enzim Transglutaminase", "No", "No", "Aktif"],
  [874, "EPA (EICOSAPENTAENOIC ACID)", "No", "No", "Aktif"],
  [875, "Es (Ice)", "No", "No", "Aktif"],
  [876, "Es Batu (Ice Cube)", "No", "No", "Aktif"],
  [877, "Ester Sterol", "No", "No", "Aktif"],
  [878, "EUCOMMIA ULMOIDES", "No", "No", "Nonaktif"],
  [
    879,
    "Feijoa / Pineapple Guava (Acca sellowiana)",
    "No",
    "No",
    "Aktif",
  ],
  [880, "Fenilalanin (Phenilalanin)", "No", "No", "Aktif"],
  [881, "FITOMENADION (VIT K1)", "No", "No", "Nonaktif"],
  [882, "FITOSTANOL (PHYTOSTANOL)", "No", "No", "Nonaktif"],
  [883, "Fitosterol (Phytosterol)", "No", "No", "Aktif"],
  [884, "FONDAN (FONDANT)", "No", "No", "Aktif"],
  [885, "Fosfolipid (Phospholipids)", "No", "No", "Aktif"],
  [886, "FRUKTO OLIGOSAKARIDA (FOS)", "No", "No", "Aktif"],
  [887, "Fruktosa (Fructose)", "No", "No", "Aktif"],
  [888, "GABAH PADI (RICE GRAIN)", "No", "No", "Aktif"],
  [889, "Galakto Oligosakarida (GOS)", "No", "No", "Aktif"],
  [890, "GAMA KAROTEN", "No", "No", "Aktif"],
  [891, "Gambir (Uncaria gambir)", "No", "No", "Aktif"],
  [892, "Gandum (Wheat)", "No", "No", "Aktif"],
  [
    893,
    "GANDUM DURUM SEMOLINA (DURUM SEMOLINA WHEAT)",
    "No",
    "No",
    "Aktif",
  ],
  [894, "GANDUM HITAM (RYE)", "No", "No", "Aktif"],
  [895, "GANDUM MALT (WHEAT MALT)", "No", "No", "Aktif"],
  [896, "Gandum Merah (Red Wheat)", "No", "No", "Aktif"],
  [897, "Gandum Panggang (Roasted Wheat)", "No", "No", "Aktif"],
  [898, "Gandum Semolina (Semolina Wheat)", "No", "No", "Aktif"],
  [899, "Gandum Serpihan (Wheat Flakes)", "No", "No", "Aktif"],
  [900, "Gandum Utuh (Whole Wheat)", "No", "No", "Aktif"],
  [901, "Ganggang Laut (Sea Algae)", "No", "No", "Aktif"],
  [902, "GANGLIOSIDA (GANGLIOSIDE)", "No", "No", "Nonaktif"],
  [903, "Garam (Salt)", "No", "No", "Aktif"],
  [904, "GARAM BERIODIUM (IODIZED SALT)", "No", "No", "Nonaktif"],
  [905, "Garam Halus (Refined Salt)", "No", "No", "Aktif"],
  [906, "Garam Hitam (Black Salt)", "No", "No", "Aktif"],
  [907, "Garam Inggris (Epsom Salt)", "No", "No", "Aktif"],
  [908, "Garam Laut (Sea Salt)", "No", "No", "Aktif"],
  [909, "GARAM RAFINASI (REFINED SALT)", "No", "No", "Nonaktif"],
  [910, "GARCINIA CAMBOGIA", "No", "No", "Nonaktif"],
  [911, "GARDENIA BLUE", "No", "No", "Nonaktif"],
  [912, "GELATIN (GELATINE)", "Yes", "No", "Aktif"],
  [913, "GENMAICHA (ROASTED RICE TEA)", "No", "No", "Aktif"],
  [914, "GIN (GIN)", "No", "No", "Aktif"],
  [915, "GINKGO BILOBA", "No", "No", "Nonaktif"],
  [916, "GLISERIN", "No", "No", "Nonaktif"],
  [917, "GLISEROL (GLYCEROL)", "No", "No", "Nonaktif"],
  [918, "GLISIN (GLYCINE)", "No", "No", "Aktif"],
  [919, "Glukosa (Glucose)", "No", "No", "Aktif"],
  [920, "Glukosa Anhidrat (Glucose Anhydrate)", "No", "No", "Aktif"],
  [921, "Glukosa Bubuk (Glucose Powder)", "No", "No", "Aktif"],
  [922, "Glukosamin (Glucosamine)", "No", "No", "Aktif"],
  [
    923,
    "Glukosamin Hidroklorida (Glucosamine Hydrochloride)",
    "No",
    "No",
    "Aktif",
  ],
  [
    924,
    "Glukosamin Sulfat (Glucosamine Sulphate)",
    "No",
    "No",
    "Aktif",
  ],
  [925, "GLUTEN (GLUTEN)", "No", "No", "Nonaktif"],
  [926, "GLYCYRRHIZA GLABRA (LICORICE)", "No", "No", "Aktif"],
  [927, "GOBO", "No", "No", "Nonaktif"],
  [928, "GOBO BUBUK (GOBO POWDER)", "No", "No", "Nonaktif"],
  [929, "GOJI (LYCIUM BARBARUM)", "No", "No", "Nonaktif"],
  [930, "GOJI BERRY (LYCIUM BARBARUM)", "No", "No", "Aktif"],
  [931, "GOJI BERRY - WOLBERRY", "No", "No", "Aktif"],
  [932, "Great Northern Beans", "No", "No", "Aktif"],
  [933, "GUARANA (PAULLINIA CUPANA)", "No", "No", "Aktif"],
  [934, "GULA AREN (PALM SUGAR)", "No", "No", "Aktif"],
  [935, "Gula Batu (Rock Sugar)", "No", "No", "Aktif"],
  [936, "Gula Bit (Sugar Beet)", "No", "No", "Aktif"],
  [937, "Gula Cair (Liquid Sugar)", "No", "No", "Aktif"],
  [938, "Gula Cokelat (Brown Sugar-Demerara)", "No", "No", "Aktif"],
  [939, "Gula Halus (Refined Sugar)", "No", "No", "Aktif"],
  [940, "Gula Hitam (Raw Cane Sugar)", "No", "No", "Aktif"],
  [941, "Gula Icing (Icing Sugar)", "No", "No", "Aktif"],
  [942, "Gula Invert (Invert Sugar)", "No", "No", "Aktif"],
  [943, "Gula Jawa (Palm Sugar)", "No", "No", "Aktif"],
  [
    944,
    "GULA KASTOR (CASTOR SUGAR ATAU CASTER SUGAR)",
    "No",
    "No",
    "Aktif",
  ],
  [945, "GULA KELAPA (COCONUT SUGAR)", "No", "No", "Aktif"],
  [946, "Gula Kristal (Sugar Crystals)", "No", "No", "Aktif"],
  [947, "Gula Merah (Brown Sugar)", "No", "No", "Aktif"],
  [948, "Gula Palem (Palm Sugar)", "No", "No", "Aktif"],
  [949, "Gula Pasir (Granulated Sugar)", "No", "No", "Aktif"],
  [950, "GULA SIWALAN (PALM SUGAR)", "No", "No", "Aktif"],
  [951, "Gula Tebu (Cane Sugar)", "No", "No", "Aktif"],
  [952, "Gula Terfermentasi (Fermented Sugar)", "No", "No", "Aktif"],
  [953, "GUM BASE", "No", "No", "Aktif"],
  [954, "Gurita (Octopus)", "No", "No", "Aktif"],
  [955, "HALBA (HALBA)", "No", "No", "Nonaktif"],
  [956, "Halia (Halia)", "No", "No", "Aktif"],
  [
    957,
    "Hancuran Permen/ Butiran Permen (Crushed candy)",
    "No",
    "No",
    "Aktif",
  ],
  [
    958,
    "Hasil Destilasi Minyak Peppermint (Peppermint Oil Distillation)",
    "No",
    "No",
    "Aktif",
  ],
  [
    959,
    "HASIL DISTILASI FERMENTASI ANGGUR (DISTILLED FERMENTED GRAPE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    960,
    "HASIL DISTILASI FERMENTASI ANGGUR HIJAU (DISTILLED FERMENTED GREEN GRAPE) ",
    "No",
    "No",
    "Aktif",
  ],
  [
    961,
    "Hasil Distilasi Fermentasi Beras (Distilled Fermented Rice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    962,
    "Hasil Distilasi Fermentasi Jambu Mente (Distilled Fermented Cashew)",
    "No",
    "No",
    "Aktif",
  ],
  [
    963,
    "Hasil Distilasi Fermentasi Malt-Gandum-....... (Distilled Fermented Malt-Wheat-.....)",
    "No",
    "No",
    "Aktif",
  ],
  [
    964,
    "HASIL FERMENTASI .....(SEREALIA, BUAH, ....)",
    "No",
    "No",
    "Aktif",
  ],
  [
    965,
    "Hasil Fermentasi Apel (Fermented Apple)",
    "No",
    "No",
    "Aktif",
  ],
  [
    966,
    "Hasil Fermentasi Arbei (Fermented Berries)",
    "No",
    "No",
    "Aktif",
  ],
  [
    967,
    "Hasil Fermentasi Beras (Fermented Rice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    968,
    "Hasil Fermentasi Beras Ketan Hitam (Fermented Black Glutinous Rice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    969,
    "Hasil Fermentasi Beras Ketan Putih (Fermented White Glutinous Rice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    970,
    "Hasil Fermentasi Buah Agave (Fermented Agave)",
    "No",
    "No",
    "Aktif",
  ],
  [
    971,
    "Hasil Fermentasi Buah Anggur Hijau (Fermented Green Grape)",
    "No",
    "No",
    "Aktif",
  ],
  [
    972,
    "Hasil Fermentasi Buah Anggur Merah (Fermented Red Grape)",
    "No",
    "No",
    "Aktif",
  ],
  [
    973,
    "Hasil Fermentasi Buah Lontar (Fermented Palmyra) ",
    "No",
    "No",
    "Aktif",
  ],
  [
    974,
    "Hasil Fermentasi Gandum (Fermented Wheat)",
    "No",
    "No",
    "Aktif",
  ],
  [
    975,
    "Hasil Fermentasi Gula Merah (Fermented Brown Sugar)",
    "No",
    "No",
    "Aktif",
  ],
  [
    976,
    "Hasil Fermentasi Jagung (Fermented Corn)",
    "No",
    "No",
    "Aktif",
  ],
  [
    977,
    "Hasil Fermentasi Jeruk (Fermented Orange)",
    "No",
    "No",
    "Aktif",
  ],
  [
    978,
    "HASIL FERMENTASI KEDELAI (FERMENTED SOYBEAN)",
    "No",
    "No",
    "Aktif",
  ],
  [
    979,
    "Hasil Fermentasi Kedelai Hitam (Fermented Black Soybeans)",
    "No",
    "No",
    "Aktif",
  ],
  [
    980,
    "HASIL FERMENTASI KETAN HITAM (FERMENTED BLACK GLUTINOUS RICE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    981,
    "Hasil Fermentasi Malt (Fermented Malt)",
    "No",
    "No",
    "Aktif",
  ],
  [
    982,
    "Hasil Fermentasi Markisa (Fermented Passion Fruit)",
    "No",
    "No",
    "Aktif",
  ],
  [
    983,
    "Hasil Fermentasi Molases (Fermented Molases)",
    "No",
    "No",
    "Aktif",
  ],
  [
    984,
    "Hasil Fermentasi Nanas (Fermented Pineapple)",
    "No",
    "No",
    "Aktif",
  ],
  [
    985,
    "Hasil Fermentasi Nira (Fermented Sap)",
    "No",
    "No",
    "Aktif",
  ],
  [
    986,
    "Hasil Fermentasi Pepaya (Fermented Papaya)",
    "No",
    "No",
    "Aktif",
  ],
  [
    987,
    "Hasil Fermentasi Salak (Fermented Salak)",
    "No",
    "No",
    "Aktif",
  ],
  [
    988,
    "Hasil Fermentasi Sawo (Fermented Sapodilla)",
    "No",
    "No",
    "Aktif",
  ],
  [
    989,
    "Hasil Fermentasi Singkong (Fermented Cassava)",
    "No",
    "No",
    "Aktif",
  ],
  [
    990,
    "Hasil Fermentasi Tepung Rye (Fermented Rye Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    991,
    "Hasil Fermentasi Tomat (Fermented Tomato)",
    "No",
    "No",
    "Aktif",
  ],
  [992, "Hati Ayam  (Chicken Liver)", "No", "No", "Aktif"],
  [
    993,
    "Hati Ayam Bubuk (Chicken Liver Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [994, "Hati Babi (Pig Liver)", "No", "No", "Aktif"],
  [995, "Hati Sapi (Cow Liver)", "No", "No", "Aktif"],
  [996, "HEATHER (ERICA VULGARIS)", "No", "No", "Aktif"],
  [997, "Hemiselulase (Hemicellulase)", "No", "No", "Aktif"],
  [
    998,
    "Hidrolisat Kasein Protein (Hydrolysed Casein Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [
    999,
    "Hidrolisat Protein (Hydrolyzed Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1000,
    "Hidrolisat Protein Ikan (Hydrolyzed Fish Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1001,
    "Hidrolisat Protein Kedelai (Hydrolyzed Soy Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1002,
    "Hidrolisat Protein Nabati (Hydrolyzed Vegetable Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1003,
    "HIDROLISAT PROTEIN WHEY (HYDROLIZED WHEY PROTEIN)",
    "No",
    "Yes",
    "Aktif",
  ],
  [1004, "Histidin (Histidine)", "No", "No", "Aktif"],
  [1005, "Hojicha Bubuk (Hojicha Powder)", "No", "No", "Aktif"],
  [1006, "honeybush (cyclopia maculate)", "No", "No", "Nonaktif"],
  [
    1007,
    "Honeybush (Cyclopia maculate, Cyclopia genistoides, Cyclopia sessiliflora (\"Heidelbergtee\")",
    "No",
    "No",
    "Aktif",
  ],
  [1008, "HONEYSUCKLE", "No", "No", "Nonaktif"],
  [1009, "HOPS", "No", "No", "Aktif"],
  [1010, "HUPERSZINE (HUPERZINE SERRATA)", "No", "No", "Nonaktif"],
  [1011, "HYDRATED DEXTRATES", "No", "No", "Nonaktif"],
  [1012, "ICE STRUCTURING PROTEIN", "No", "No", "Aktif"],
  [1013, "Iga Babi (Pork Ribs)", "No", "No", "Aktif"],
  [1014, "IGA SAPI (BEEF RIBS)", "No", "No", "Aktif"],
  [1015, "Ikan (Fish)", "No", "No", "Aktif"],
  [
    1016,
    "Ikan Asap Bubuk (Smoked Fish Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1017, "Ikan Asin (Salted Fish)", "No", "No", "Aktif"],
  [1018, "Ikan Bandeng (Milkfish)", "No", "No", "Aktif"],
  [1019, "IKAN BELIDA (BELIDA FISH)", "No", "No", "Aktif"],
  [1020, "IKAN BILIS", "No", "No", "Aktif"],
  [1021, "IKAN BONITO (BONITO FISH)", "No", "No", "Aktif"],
  [
    1022,
    "IKAN BONITO BUBUK (BONITO FISH POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [1023, "Ikan Bubuk (Fish Powder)", "No", "No", "Aktif"],
  [1024, "IKAN CAKALANG (SKIPJACK TUNA FISH)", "No", "No", "Aktif"],
  [1025, "IKAN DACE (DACE FISH)", "No", "No", "Aktif"],
  [1026, "Ikan Fillet (FISH FILLET)", "No", "No", "Aktif"],
  [1027, "Ikan Gindara", "No", "No", "Aktif"],
  [1028, "IKAN HARING (HERRING FISH)", "No", "No", "Aktif"],
  [
    1029,
    "IKAN HARING FILLET (HERRING FISH FILLET)",
    "No",
    "No",
    "Aktif",
  ],
  [1030, "IKAN KAKAP (SNAPPER FISH)", "No", "No", "Aktif"],
  [1031, "IKAN KISU (KISU FISH)", "No", "No", "Aktif"],
  [1032, "Ikan Kod (Cod Fish)", "No", "No", "Aktif"],
  [1033, "Ikan Kod Bubuk (Cod Fish Powder)", "No", "No", "Aktif"],
  [
    1034,
    "IKAN KORVINA KUNING (YELLOW CORVINA FISH)",
    "No",
    "No",
    "Aktif",
  ],
  [1035, "Ikan Layar (Sailfish)", "No", "No", "Aktif"],
  [1036, "IKAN LAYUR (LAYUR FISH)", "No", "No", "Aktif"],
  [1037, "Ikan Lele (Catfish)", "No", "No", "Aktif"],
  [1038, "Ikan Lemuru (Sardine)", "No", "No", "Aktif"],
  [1039, "IKAN MAKAREL (MACKEREL FISH)", "No", "No", "Aktif"],
  [1040, "IKAN MARLIN (MARLIN FISH)", "No", "No", "Aktif"],
  [1041, "Ikan Nila (Tilapia Fish)", "No", "No", "Aktif"],
  [1042, "Ikan Patin", "No", "No", "Aktif"],
  [1043, "IKAN POLLOCK (POLLOCK FISH)", "No", "No", "Aktif"],
  [1044, "IKAN SALMON (SALMON FISH)", "No", "No", "Aktif"],
  [1045, "IKAN SARDIN (SARDINES FISH)", "No", "No", "Aktif"],
  [
    1046,
    "IKAN SARDIN BUBUK (SARDINES FISH POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [1047, "IKAN SLENGSENG (MACKEREL FISH)", "No", "No", "Aktif"],
  [1048, "IKAN TEMBANG (SARDINELLA)", "No", "No", "Aktif"],
  [1049, "Ikan Tenggiri (Mackerel)", "No", "No", "Aktif"],
  [1050, "Ikan Teri (Anchovy)", "No", "No", "Aktif"],
  [1051, "IKAN TUNA (TUNA FISH)", "No", "No", "Aktif"],
  [1052, "INOSITOL (INOSITOL)", "No", "No", "Nonaktif"],
  [1053, "Inulin (Inulin)", "No", "No", "Aktif"],
  [1054, "Iodium ( Kalium Iodat- Kio3 )", "No", "No", "Nonaktif"],
  [1055, "Iodium (Kalium Iodat - KIO3)", "No", "No", "Aktif"],
  [1056, "Isian berbasis susu", "Yes", "Yes", "Aktif"],
  [
    1057,
    "Isolat Protein Kedelai (Soy Protein Isolate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1058,
    "ISOLAT PROTEIN NABATI (VEGETABLE PROTEIN ISOLATE)",
    "No",
    "No",
    "Aktif",
  ],
  [1059, "Isolat Protein Pea", "No", "No", "Aktif"],
  [
    1060,
    "Isolat Protein Pea (Pea Protein Isolate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1061,
    "ISOLAT PROTEIN SUSU (MILK PROTEIN ISOLATE)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    1062,
    "ISOLAT PROTEIN WHEY (WHEY PROTEIN ISOLATE)",
    "No",
    "Yes",
    "Aktif",
  ],
  [1063, "Isoleusin (Isoleucine)", "No", "No", "Aktif"],
  [
    1064,
    "ISOMALTO OLIGOSAKARIDA (ISOMALTOOLIGOSACCHARIDE)",
    "No",
    "No",
    "Aktif",
  ],
  [1065, "Isomaltodekstrin (IMD)", "No", "No", "Aktif"],
  [1066, "Isomaltulosa (Isomaltulose)", "No", "No", "Aktif"],
  [1067, "Jagung", "No", "No", "Nonaktif"],
  [1068, "Jagung (Corn)", "No", "No", "Aktif"],
  [1069, "JAGUNG BAKAR (ROASTED CORN)", "No", "No", "Aktif"],
  [
    1070,
    "Jagung Bakar Bubuk (Roasted Corn Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1071, "Jagung Berondong (Pop Corn)", "No", "No", "Aktif"],
  [1072, "Jagung Butiran (Corn Grain)", "No", "No", "Aktif"],
  [1073, "Jagung Kering (Dried Corn)", "No", "No", "Aktif"],
  [
    1074,
    "Jagung Kernel Utuh (Whole Kernel Corn)",
    "No",
    "No",
    "Aktif",
  ],
  [1075, "Jagung Manis (Sweet Corn)", "No", "No", "Aktif"],
  [
    1076,
    "Jagung Manis Bubuk (Sweet Corn Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1077, "Jagung Muda (Baby Corn)", "No", "No", "Aktif"],
  [1078, "JAGUNG SEMOLINA (MAIZE SEMOLINA)", "No", "No", "Aktif"],
  [1079, "Jagung Serpihan (Corn Flakes)", "No", "No", "Aktif"],
  [1080, "Jahe (Ginger)", "No", "No", "Aktif"],
  [1081, "Jahe Bubuk (Ginger Powder)", "No", "No", "Aktif"],
  [1082, "Jahe Giling (Milled Ginger)", "No", "No", "Aktif"],
  [1083, "Jahe Kering (Dried Ginger)", "No", "No", "Aktif"],
  [
    1084,
    "JAHE MERAH- ZINGIBER OFFICINALE VAR RUBRU (RED GINGER)",
    "No",
    "No",
    "Aktif",
  ],
  [1085, "JALI (COIX LACRYMA-JOBI)", "No", "No", "Aktif"],
  [1086, "JAMBU AIR (ROSE APPLE)", "No", "No", "Aktif"],
  [1087, "Jambu Biji (Guava)", "No", "No", "Aktif"],
  [1088, "Jambu Biji Bubuk (Guava Powder)", "No", "No", "Aktif"],
  [1089, "Jambu Mete (Cashew)", "No", "No", "Aktif"],
  [1090, "Jamur (Mushroom)", "No", "No", "Aktif"],
  [1091, "Jamur Boletes Kuning", "No", "No", "Aktif"],
  [1092, "Jamur Bubuk (Mushroom Powder)", "No", "No", "Aktif"],
  [1093, "Jamur Geotrichum candidum", "No", "No", "Aktif"],
  [1094, "Jamur Kancing (Champignon)", "No", "No", "Aktif"],
  [1095, "Jamur Kering (Dried Mushroom)", "No", "No", "Aktif"],
  [1096, "Jamur Kuping (Auricularia auricula)", "No", "No", "Aktif"],
  [
    1097,
    "JAMUR KUPING HITAM (AURICULARIA POLYTRICHA)",
    "No",
    "No",
    "Aktif",
  ],
  [1098, "Jamur ling zhi (Lingzhi mushroom)", "No", "No", "Aktif"],
  [
    1099,
    "JAMUR MADU (ARMILLARIA OSTOYAE, HONEY MUSHROOM)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1100,
    "JAMUR MERAH BUBUK (RED MUSHROOM POWDER)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1101, "Jamur Merang (Volvariella volvacea)", "No", "No", "Aktif"],
  [
    1102,
    "JAMUR MESHAMA- JAMUR SANGHWANG, MESHIMAKOBU; SONG GEN (PHELLINUS LINTEUS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1103,
    "JAMUR SALJU - ENOKITAKE (FLAMMULINA VELUTIPES)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1104,
    "JAMUR SANGHWANG (PHELLINUS LINTEUS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1105, "JAMUR SHIITAKE (LENTINULA EDODES)", "No", "No", "Aktif"],
  [
    1106,
    "Jamur Shiitake Bubuk (Shiitake Mushroom Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1107, "Jamur Tempe", "No", "No", "Aktif"],
  [
    1108,
    "JAMUR TEROMPET - JAMUR SARANG BURUNG",
    "No",
    "No",
    "Aktif",
  ],
  [1109, "Jamur Tiram (Pleurotus ostreatus)", "No", "No", "Aktif"],
  [1110, "Jantung Pisang (Banana Heart)", "No", "No", "Aktif"],
  [1111, "Jantung Sapi (Beef Heart)", "No", "No", "Aktif"],
  [1112, "Jeli (Jelly)", "No", "No", "Aktif"],
  [1113, "Jeli Bubuk (Jelly Powder)", "No", "No", "Aktif"],
  [1114, "JENGKOL (DJENKOL)", "No", "No", "Aktif"],
  [1115, "Jeruk (Orange)", "No", "No", "Aktif"],
  [1116, "Jeruk Asam-Pahit (Seville Orange)", "No", "No", "Aktif"],
  [1117, "Jeruk Bali (Grapefruit- Pomelo)", "No", "No", "Aktif"],
  [1118, "JERUK BALI MERAH (GRAPEFRUIT)", "No", "No", "Aktif"],
  [1119, "JERUK BERGAMOT (CITRUS BERGAMIA)", "No", "No", "Aktif"],
  [1120, "Jeruk Besar (Grapefruit- Pomelo)", "No", "No", "Aktif"],
  [1121, "Jeruk Bubuk (orange powder)", "No", "No", "Aktif"],
  [
    1122,
    "Jeruk Citron-Jeruk Sukade (Citrus medica)",
    "No",
    "No",
    "Aktif",
  ],
  [1123, "JERUK KEPROK (CITRUS RETICULATA)", "No", "No", "Aktif"],
  [1124, "JERUK LEMON (CITRUS LIMON)", "No", "No", "Aktif"],
  [1125, "Jeruk Lemon Bubuk (Lemon Powder)", "No", "No", "Aktif"],
  [1126, "JERUK LIMAU (CITRUS AMBLYCARPA)", "No", "No", "Aktif"],
  [1127, "Jeruk Mandarin (Mandarin Orange)", "No", "No", "Aktif"],
  [1128, "JERUK NIPIS (CITRUS AURANTIFOLIA)", "No", "No", "Aktif"],
  [1129, "Jeruk Nipis Bubuk (Lime Powder)", "No", "No", "Aktif"],
  [
    1130,
    "JERUK PURUT (KAFFIR LIME - CITRUS HYSTRIX)",
    "No",
    "No",
    "Aktif",
  ],
  [1131, "JERUK TANGERINE (CITRUS TANGERINA)", "No", "No", "Aktif"],
  [1132, "JINTAN HITAM (NIGELLA SATIVA)", "No", "No", "Aktif"],
  [1133, "JINTAN-JINTEN (CARAWAY)", "No", "No", "Aktif"],
  [
    1134,
    "JINTAN-JINTEN BUBUK (CARAWAY POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [1135, "JINTAN-JINTEN HITAM (HABBATUSSAUDA)", "No", "No", "Aktif"],
  [1136, "JINTAN-JINTEN MANIS (ANISE)", "No", "No", "Aktif"],
  [
    1137,
    "JINTAN-JINTEN PUTIH-CUNICUM CYMINUM (CUMIN)",
    "No",
    "No",
    "Aktif",
  ],
  [1138, "JUNIPER BERRIES", "No", "No", "Aktif"],
  [1139, "Kacang Alas/ Biji Sengon", "No", "No", "Aktif"],
  [1140, "KACANG ALMOND (ALMOND)", "No", "No", "Aktif"],
  [
    1141,
    "KACANG ARAB - GARBANZO (CHICKPEA - CICER ARIETINUM)",
    "No",
    "No",
    "Aktif",
  ],
  [1142, "Kacang Atom ", "No", "No", "Aktif"],
  [
    1143,
    "KACANG AZUKI - KACANG MERAH KECIL - KACANG TOLO MERAH (AZUKI BEANS) ",
    "No",
    "No",
    "Aktif",
  ],
  [1144, "Kacang Blackeye (Blackeye Beans)", "No", "No", "Aktif"],
  [
    1145,
    "KACANG BOGOR (BAMBARA GROUNDNUTS - VIGNA SUBTERRANEA)",
    "No",
    "No",
    "Aktif",
  ],
  [1146, "Kacang Brazil (Brazil Nut)", "No", "No", "Aktif"],
  [1147, "KACANG BUNCIS (COMMON BEAN)", "No", "No", "Aktif"],
  [1148, "KACANG DAL (DHAL PEANUTS) ", "No", "No", "Aktif"],
  [1149, "KACANG DAL URAD (DHAL URAD PEANUTS)", "No", "No", "Aktif"],
  [
    1150,
    "Kacang Flageolet (Flageolet Bean)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1151, "KACANG GARBANZO (GARBANZO BEANS)", "No", "No", "Nonaktif"],
  [1152, "KACANG GINKGO (GINKGO NUTS)", "No", "No", "Aktif"],
  [1153, "Kacang Hazel (Hazelnut)", "No", "No", "Aktif"],
  [
    1154,
    "Kacang Hazel Panggang (Roasted Hazelnut)",
    "No",
    "No",
    "Aktif",
  ],
  [1155, "KACANG HIJAU (MUNG BEAN)", "No", "No", "Aktif"],
  [
    1156,
    "KACANG HIJAU BUBUK (MUNG BEAN POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1157,
    "KACANG HIJAU TANPA KULIT (SPLIT MUNG BEANS)",
    "No",
    "No",
    "Aktif",
  ],
  [1158, "KACANG HITAM", "No", "No", "Aktif"],
  [1159, "KACANG KAPRI (PEAS)", "No", "No", "Aktif"],
  [1160, "KACANG KASTANYE (CHESTNUTS)", "No", "No", "Aktif"],
  [1161, "Kacang Kedelai (Soybean)", "No", "No", "Aktif"],
  [
    1162,
    "Kacang Kedelai Bubuk (Soybean Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1163,
    "KACANG KEDELAI HITAM (BLACK SOYBEAN)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1164,
    "Kacang Kedelai Hitam Bubuk (Black Soybean Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1165, "Kacang Kedelai Muda (Edamame)", "No", "No", "Aktif"],
  [1166, "KACANG KENARI (WALNUTS)", "No", "No", "Aktif"],
  [1167, "Kacang Koro (Broad Bean) ", "No", "No", "Aktif"],
  [1168, "KACANG KRANBERI (BORLOTTI BEANS)", "No", "No", "Aktif"],
  [1169, "Kacang Kuning (Yellow Beans)", "No", "No", "Aktif"],
  [1170, "KACANG LENTIL (LENTILS)", "No", "No", "Aktif"],
  [
    1171,
    "KACANG LENTIL COKLAT (BROWN LENTILS)",
    "No",
    "No",
    "Aktif",
  ],
  [1172, "KACANG LENTIL MERAH (RED LENTILS)", "No", "No", "Aktif"],
  [1173, "KACANG LIMA (LIMA BEANS)", "No", "No", "Aktif"],
  [1174, "Kacang Macadamia (Macadamia Nut)", "No", "No", "Aktif"],
  [1175, "Kacang Mede (Cashewnut)", "No", "No", "Aktif"],
  [1176, "Kacang Merah (Red Bean-Kidney Bean)", "No", "No", "Aktif"],
  [
    1177,
    "KACANG NAVY - KACANG PUTIH (NAVY BEANS - WHITE PEA)",
    "No",
    "No",
    "Aktif",
  ],
  [1178, "KACANG PANJANG (YARDLONG BEAN)", "No", "No", "Aktif"],
  [1179, "KACANG PARANG (JACK BEAN)", "No", "No", "Aktif"],
  [1180, "KACANG PIKAN (PECAN)", "No", "No", "Aktif"],
  [1181, "KACANG PINUS (PINE NUTS)", "No", "No", "Aktif"],
  [1182, "KACANG PISTACHIO (PISTACHIO NUTS)", "No", "No", "Aktif"],
  [
    1183,
    "KACANG PISTACHIO PANGGANG (ROASTED PISTACHIO)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1184,
    "KACANG POLONG HIJAU (GREEN SPLIT PEAS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1185,
    "Kacang Polong Kering (Dried Greenpeas)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1186,
    "KACANG POLONG KUNING (YELLOW GREENPEAS)",
    "No",
    "No",
    "Aktif",
  ],
  [1187, "Kacang Polong-Ercis (Greenpeas)", "No", "No", "Aktif"],
  [1188, "KACANG PUTIH ", "No", "No", "Nonaktif"],
  [1189, "Kacang Tanah (Peanut)", "No", "No", "Aktif"],
  [
    1190,
    "Kacang Tanah Kupas (Shelled Peanuts)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1191,
    "Kacang Tanah Panggang (Roasted Peanut)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1192,
    "KACANG TOLO-KACANG TUNGGAK-KACANG DADAP",
    "No",
    "No",
    "Nonaktif",
  ],
  [1193, "KACANG WALNUT (WALNUT)", "No", "No", "Nonaktif"],
  [1194, "KAFEIN (CAFFEIN)", "No", "No", "Aktif"],
  [1195, "Kailan (Kai-lan-Chinese Broccoli)", "No", "No", "Aktif"],
  [1196, "KAKAO (COCOA)", "No", "No", "Aktif"],
  [1197, "KAKAO BUBUK (COCOA POWDER)", "No", "No", "Aktif"],
  [1198, "KAKAO LIQUOR", "No", "No", "Nonaktif"],
  [
    1199,
    "KAKAO MASSA (COCOA MASS - COCOA LIQUOR)",
    "No",
    "No",
    "Aktif",
  ],
  [1200, "KAKAO PASTA (COCOA PASTE)", "No", "No", "Aktif"],
  [1201, "Kaki Babi (Pigs Feet)", "No", "No", "Aktif"],
  [1202, "Kalamansi (Calamansi)", "No", "No", "Aktif"],
  [1203, "Kaldu Ayam (Chicken Broth)", "No", "No", "Aktif"],
  [1204, "Kaldu Babi (Pork Broth)", "No", "No", "Aktif"],
  [1205, "Kaldu Ikan (Fish Broth)", "No", "No", "Aktif"],
  [1206, "Kaldu Kalkun (Turkey Broth)", "No", "No", "Aktif"],
  [1207, "Kaldu Kerang (Scallop Broth)", "No", "No", "Aktif"],
  [1208, "Kaldu Sapi (Beef Broth)", "No", "No", "Aktif"],
  [1209, "Kaldu Sayuran (Vegetable Broth)", "No", "No", "Aktif"],
  [1210, "Kaldu Udang", "No", "No", "Aktif"],
  [1211, "Kalium Bikarbonat", "No", "No", "Aktif"],
  [
    1212,
    "Kalium fluorida (Potassium fluoride)",
    "No",
    "No",
    "Aktif",
  ],
  [1213, "Kalium Fosfat ", "No", "No", "Nonaktif"],
  [1214, "Kalium Hidroksida", "No", "No", "Aktif"],
  [
    1215,
    "KALIUM IODIDA (POTASSIUM IODIDA-KIO3)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1216,
    "Kalium Karbonat (Potassium carbonate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1217,
    "Kalium Kaseinat (Potassium Caseinate)",
    "No",
    "No",
    "Aktif",
  ],
  [1218, "KALIUM KLORIDA (POTASSIUM CHLORIDE)", "No", "No", "Aktif"],
  [1219, "Kalium Sitrat", "No", "No", "Aktif"],
  [
    1220,
    "KALSIUM DARI GANGGANG LAUT (CALCAREOUS MARINE ALGAE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1221,
    "Kalsium Gliserofosfat (Calcium Glycerophosphate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1222,
    "Kalsium Hidrogen Fosfat Anhidrat (Calsium Hydrogen Phosphate Anhydrous)",
    "No",
    "No",
    "Aktif",
  ],
  [1223, "Kalsium hidroksida", "No", "No", "Aktif"],
  [1224, "KALSIUM KARBONAT", "No", "No", "Aktif"],
  [
    1225,
    "Kalsium Kaseinat (Calcium caseinate)",
    "No",
    "No",
    "Aktif",
  ],
  [1226, "Kalsium Klorida", "No", "No", "Aktif"],
  [
    1227,
    "Kalsium L-5-metil tetrahidrofolat (Calcium L-5- methyl tetrahydrofolate)",
    "No",
    "No",
    "Aktif",
  ],
  [1228, "Kalsium Laktat (Calcium Laktate)", "No", "No", "Aktif"],
  [
    1229,
    "Kalsium Natrium Kaseinat (Calcium Sodium Caseinate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1230,
    "KALSIUM PANTOTENAT (CALCIUM PANTOTHENATE)",
    "No",
    "No",
    "Aktif",
  ],
  [1231, "KALSIUM PANTOTENAT (VIT B5)", "No", "No", "Nonaktif"],
  [1232, "Kalsium Pidolat (Calcium Pidolate)", "No", "No", "Aktif"],
  [1233, "Kalsium Susu (Milk Calcium)", "No", "No", "Aktif"],
  [1234, "Kalsium Tulang Ikan", "No", "No", "Aktif"],
  [
    1235,
    "KALSIUM-D-PANTOTENAT (CALCIUM-D-PANTOTHENATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1236, "Kamaboko", "No", "No", "Aktif"],
  [1237, "Kangkung", "No", "No", "Aktif"],
  [1238, "Kapulaga (Cardamon)", "No", "No", "Aktif"],
  [1239, "Kapulaga Bubuk (Cardamon Powder)", "No", "No", "Aktif"],
  [1240, "Karagenan", "No", "No", "Nonaktif"],
  [1241, "Karagenan (Caragenan)", "No", "No", "Aktif"],
  [1242, "Karamel  ", "No", "No", "Nonaktif"],
  [1243, "Karamel (Caramel)", "No", "No", "Aktif"],
  [1244, "Karamel Bubuk (Caramel Powder)", "No", "No", "Aktif"],
  [1245, "KARAMEL CAIR (LIQUID CARAMEL)", "No", "No", "Nonaktif"],
  [1246, "KARBONDIOKSIDA (CARBONDIOXIDE)", "No", "No", "Nonaktif"],
  [1247, "Kari Bubuk (Curry Powder)", "No", "No", "Aktif"],
  [1248, "Kasein (Casein)", "No", "No", "Aktif"],
  [1249, "Kayu Manis (Cinnamon)", "No", "No", "Aktif"],
  [1250, "Kayu Manis Bubuk", "No", "No", "Nonaktif"],
  [
    1251,
    "KAYU SECANG (SAPPAN WOOD - CAESALPINIAE SAPPANIS LIGNUM)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1252,
    "Kayumanis-Keningar Bubuk (Cinnamon Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1253, "Kecap (Soy Sauce)", "No", "No", "Aktif"],
  [1254, "KECAP ASIN (SALTY SOY SAUCE)", "No", "No", "Aktif"],
  [1255, "Kecap Bubuk (Soy Sauce Powder)", "No", "No", "Aktif"],
  [1256, "Kecap Ikan (Fish Sauce)", "No", "No", "Aktif"],
  [
    1257,
    "Kecap Inggris (Worcestershire Sauce)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1258,
    "KECAP KEDELAI MANIS (SWEET SOY SAUCE)",
    "No",
    "No",
    "Aktif",
  ],
  [1259, "Kedelai", "No", "No", "Nonaktif"],
  [1260, "KEDONDONG (AMBARELLA)", "No", "No", "Aktif"],
  [1261, "Kefir (Keffir)", "No", "No", "Aktif"],
  [1262, "Keju ", "No", "No", "Nonaktif"],
  [1263, "Keju (Cheese)", "No", "No", "Aktif"],
  [1264, "Keju Biru (Blue Cheese)", "No", "No", "Aktif"],
  [1265, "Keju Bubuk  ", "No", "No", "Nonaktif"],
  [1266, "Keju Bubuk (Cheese Powder)", "No", "No", "Aktif"],
  [1267, "Keju Cheddar (Cheddar Cheese)", "No", "No", "Aktif"],
  [1268, "Keju Edam (Edam Cheese)", "No", "No", "Aktif"],
  [1269, "Keju Feta (Feta Cheese)", "No", "No", "Aktif"],
  [1270, "Keju Gouda (Gouda Cheese)", "No", "No", "Aktif"],
  [
    1271,
    "Keju Grana Padano (Grana Padano Cheese)",
    "No",
    "No",
    "Aktif",
  ],
  [1272, "Keju Krim (Cream Cheese)", "No", "No", "Aktif"],
  [1273, "Keju Mascarpone (Mascarpone Cheese)", "No", "No", "Aktif"],
  [1274, "Keju Mozzarella (Mozzarella Cheese)", "No", "No", "Aktif"],
  [1275, "Keju Myzithra (Mizithra Cheese)", "No", "No", "Aktif"],
  [1276, "Keju Parmesan (Parmesan Cheese)", "No", "No", "Aktif"],
  [1277, "Keju Pecorino (Pecorino Cheese)", "No", "No", "Aktif"],
  [
    1278,
    "Keju Pecorino Romano (Pecorino Romano Cheese)",
    "No",
    "No",
    "Aktif",
  ],
  [1279, "Keju Ricota (Richotta Cheese)", "No", "No", "Aktif"],
  [
    1280,
    "Keju Ricotta (susu sapi, susu domba)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1281, "Keju Romano (Romano Cheese)", "No", "No", "Aktif"],
  [1282, "KEJU WHEY", "No", "No", "Nonaktif"],
  [1283, "KELABAT (FENUGREEK)(HALBA)", "No", "No", "Aktif"],
  [1284, "Kelabat Bubuk (Fenugreek Powder)", "No", "No", "Aktif"],
  [1285, "Keladi - Talas (Taro-Caladium)", "No", "No", "Aktif"],
  [1286, "Kelapa (Coconut)", "No", "No", "Aktif"],
  [1287, "Kelapa Bubuk (Coconut Powder)", "No", "No", "Aktif"],
  [1288, "Kelapa Kering (Dried Coconut)", "No", "No", "Aktif"],
  [1289, "Kelapa Muda (Young Coconut)", "No", "No", "Aktif"],
  [1290, "Kelapa Parut (Desiccated Coconut)", "No", "No", "Aktif"],
  [
    1291,
    "Kelapa Parut Kering (Dried Desiccated Coconut)",
    "No",
    "No",
    "Aktif",
  ],
  [1292, "Kelapa Sawit (Palm)", "No", "No", "Aktif"],
  [1293, "Kelengkeng (Longan)", "No", "No", "Aktif"],
  [1294, "Kelp Bubuk (Kelp Powder)", "No", "No", "Aktif"],
  [1295, "Kemangi (Basil)", "No", "No", "Aktif"],
  [1296, "Kembang Kol (Cauliflower)", "No", "No", "Aktif"],
  [1297, "KEMBANG PALA (MYRISTICA FRAGRAN)", "No", "No", "Nonaktif"],
  [
    1298,
    "KEMBANG SEPATU (HIBISCUS ROSA SINENSIS)",
    "No",
    "No",
    "Aktif",
  ],
  [1299, "Kembang Tahu (Beancurd)", "No", "No", "Aktif"],
  [1300, "KEMIRI (CANDLENUT)", "No", "No", "Aktif"],
  [1301, "KEMIRI BUBUK (CANDLENUT POWDER)", "No", "No", "Aktif"],
  [1302, "KENCUR ( KAEMPFERIA GALANGA )", "No", "No", "Aktif"],
  [1303, "Kenikir (Marigolds)", "No", "No", "Aktif"],
  [1304, "KENTANG", "No", "No", "Nonaktif"],
  [1305, "Kentang (Potato)", "No", "No", "Aktif"],
  [1306, "Kentang Bubuk (Potato Powder)", "No", "No", "Aktif"],
  [1307, "Kentang Kering (Dried Potatoes)", "No", "No", "Aktif"],
  [1308, "Kentang Merah (Red Potato)", "No", "No", "Aktif"],
  [
    1309,
    "Kentang Panggang Bubuk (Roasted Potato Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1310, "Keong (Snail)", "No", "No", "Aktif"],
  [1311, "Kepah (Mussel)", "No", "No", "Aktif"],
  [1312, "Kepiting (Crab)", "No", "No", "Aktif"],
  [1313, "Kerang (Scallops)", "No", "No", "Aktif"],
  [1314, "Kerang Bubuk (Scallops Powder)", "No", "No", "Aktif"],
  [1315, "Keripik Pisang (Banana Chips)", "No", "No", "Aktif"],
  [1316, "Keripik Singkong (Cassava Chips)", "No", "No", "Aktif"],
  [1317, "KERTAS BERAS", "Yes", "Yes", "Aktif"],
  [1318, "Kerupuk", "No", "No", "Aktif"],
  [1319, "Kerupuk Beras (Rice Crackers)", "No", "No", "Aktif"],
  [1320, "Kerupuk Ikan", "No", "No", "Aktif"],
  [1321, "KERUPUK KEPITING ( CRAB CHIPS )", "No", "No", "Aktif"],
  [1322, "Kerupuk Udang (Prawn Crackers)", "No", "No", "Aktif"],
  [1323, "Ketam (Crab)", "No", "No", "Aktif"],
  [1324, "Ketan Hitam (Black Sticky Rice)", "No", "No", "Aktif"],
  [1325, "KETUMBAR (CORIANDER)", "No", "No", "Aktif"],
  [1326, "Ketumbar Bubuk (Coriander Powder)", "No", "No", "Aktif"],
  [1327, "Kimchi (Kimchi)", "No", "No", "Aktif"],
  [1328, "Kimchi Kering (Kimchi Powder)", "No", "No", "Aktif"],
  [1329, "KININ (KININE)", "No", "No", "Aktif"],
  [1330, "Kismis (Raisin)", "No", "No", "Aktif"],
  [1331, "Kismis Merah (Red Raisin)", "No", "No", "Aktif"],
  [1332, "Kitosan (Chitosan)", "No", "No", "Aktif"],
  [1333, "Kiwi (Kiwi)", "No", "No", "Aktif"],
  [1334, "KLEMBAK (RHEUM OFFICINALE)", "No", "No", "Aktif"],
  [1335, "KLOROFIL (CHLOROPHYL)", "No", "No", "Nonaktif"],
  [1336, "Kluwek-Keluwek", "No", "No", "Aktif"],
  [1337, "KOJI", "No", "No", "Aktif"],
  [1338, "KOJI (SWEET POTATO KOJI)", "No", "Yes", "Nonaktif"],
  [1339, "KOJI BERAS (RICE KOJI)", "No", "Yes", "Nonaktif"],
  [1340, "Kol - Kubis (Cabbage)", "No", "No", "Aktif"],
  [1341, "Kol - Kubis Kering (Dried Cabbage)", "No", "No", "Aktif"],
  [1342, "Kolagen (Collagen)", "No", "No", "Aktif"],
  [
    1343,
    "KOLANG KALING ( BUAH ATAP, SUGAR PALM FRUIT )",
    "No",
    "No",
    "Aktif",
  ],
  [1344, "KOLEKALSIFEROL (VIT D3)", "No", "No", "Aktif"],
  [1345, "Kolin (Choline)", "No", "No", "Aktif"],
  [1346, "Kolin Bitartrat (Choline Bitartrat)", "No", "No", "Aktif"],
  [1347, "Kolin Klorida (Choline Chloride)", "No", "No", "Aktif"],
  [1348, "Kolostrum Bubuk (Colostrum Powder)", "No", "No", "Aktif"],
  [1349, "Kondroitin (Chondroitin)", "No", "No", "Aktif"],
  [
    1350,
    "Kondroitin Sulfat (Chondroitin Sulfate)",
    "No",
    "No",
    "Aktif",
  ],
  [1351, "Konsentrat acerola", "No", "No", "Aktif"],
  [
    1352,
    "Konsentrat Agave (Agave Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1353,
    "Konsentrat Air Kelapa (Coconut Water Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1354,
    "Konsentrat Akar Bunga Balon (Balloon Flower Root Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1355,
    "KONSENTRAT ANGGUR MERAH (RED GRAPE CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1356, "KONSENTRAT APEL (APPLE CONCENTRATE)", "No", "No", "Aktif"],
  [
    1357,
    "KONSENTRAT ARONIA BERRY (CHOKEBERRY CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1358,
    "Konsentrat Asam Jawa (Tamarind Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1359,
    "Konsentrat Bawang Putih (Garlic Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1360,
    "Konsentrat Blewah (Cantaloupe Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1361, "KONSENTRAT BUAH ......", "No", "No", "Aktif"],
  [
    1362,
    "Konsentrat Buah Anggur (Grape Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1363, "Konsentrat Buah Apel", "No", "No", "Nonaktif"],
  [
    1364,
    "Konsentrat Buah Blueberry (Blueberry Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1365,
    "KONSENTRAT BUAH ELDERBERRY (ELDERBERRY CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1366,
    "KONSENTRAT BUNGA ELDERBERI (ELDERFLOWER CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1367,
    "KONSENTRAT CAMPURAN SARI BUAH (MIXTURE OF FRUIT JUICE CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1368,
    "KONSENTRAT COCOPANDAN (COCOPANDAN CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1369,
    "KONSENTRAT COKELAT SUSU (MILK CHOCOLATE CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1370, "KONSENTRAT COLA (COLA CONCENTRATE)", "No", "No", "Aktif"],
  [
    1371,
    "KONSENTRAT DAUN ASAM MUDA (TAMARIND LEAVES CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1372,
    "Konsentrat Daun Mint (Mint Leaves Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1373,
    "KONSENTRAT DAUN PANDAN (PANDAN LEAVES CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1374,
    "KONSENTRAT DAUN TEH (TEA LEAVES CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1375,
    "Konsentrat Gula Tebu (Sugar Cane Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1376,
    "Konsentrat Jahe (Ginger Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1377,
    "Konsentrat Jeruk (Orange Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1378, "Konsentrat Jus Apel", "No", "No", "Nonaktif"],
  [
    1379,
    "Konsentrat Kacang Kedelai (Soybean Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1380,
    "Konsentrat Kacang Merah (Red Beans Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1381,
    "KONSENTRAT KELAPA KOPYOR (KOPYOR CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1382,
    "Konsentrat Kepiting (Crab Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1383,
    "Konsentrat Kopi (Coffee Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1384,
    "KONSENTRAT LECI (LYCHEES CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1385,
    "Konsentrat Lemon (Lemon Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1386,
    "Konsentrat Lidah Buaya (Aloe Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1387,
    "Konsentrat Lobak Merah (Red Radish Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1388,
    "Konsentrat Loofah (Loofah Concentrate) (Kecuali Pangan Untuk Keperluan Gizi Khusus)",
    "No",
    "No",
    "Aktif",
  ],
  [1389, "Konsentrat Madu (Honey Concentrate)", "No", "No", "Aktif"],
  [
    1390,
    "Konsentrat Mangga (Mango Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1391,
    "Konsentrat Mentimun (Cucumber Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1392,
    "Konsentrat Nanas (Pineapple Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1393,
    "Konsentrat Peppermint (Peppermint Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1394, "Konsentrat Pir (Pears Concentrate)", "No", "No", "Aktif"],
  [
    1395,
    "Konsentrat Protein Kedelai (Soy Protein Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1396,
    "Konsentrat Protein Susu (Milk Protein Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1397,
    "KONSENTRAT PROTEIN WHEY (WHEY PROTEIN CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1398,
    "Konsentrat Santan (Coconut Milk Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1399,
    "Konsentrat Sari Buah Acai Berry (Acai Berry Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1400,
    "Konsentrat Sari Buah Anggur (Grape Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1401,
    "Konsentrat Sari Buah Anggur Merah (Red Grape Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1402,
    "Konsentrat Sari Buah Apel (Apple Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1403,
    "Konsentrat Sari Buah Aprikot (Apricots Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1404,
    "KONSENTRAT SARI BUAH ARONIA BERRY (ARONIABERRY JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1405,
    "Konsentrat Sari Buah Bit (Bit Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1406,
    "Konsentrat Sari Buah Bit Merah (Red Bit Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1407,
    "Konsentrat Sari Buah Blackberry (Blackberry Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1408,
    "Konsentrat Sari Buah Blackcurrant (Blackcurrant Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1409,
    "Konsentrat Sari Buah Blueberry (Blueberry Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1410,
    "KONSENTRAT SARI BUAH CAMPURAN (MIXED FRUIT JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1411,
    "Konsentrat Sari Buah Ceri (Cherry Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1412,
    "Konsentrat Sari Buah Delima (Pomegranate Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1413,
    "Konsentrat Sari Buah Durian (Durian Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1414,
    "KONSENTRAT SARI BUAH ELDERBERRY (ELDERBERRY JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1415,
    "KONSENTRAT SARI BUAH GOJI BERRY (GOJI BERRY JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1416,
    "KONSENTRAT SARI BUAH JAMBU MERAH (GUAVA JUICE CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1417,
    "KONSENTRAT SARI BUAH JERUK (ORANGE JUICE CONCENTRATE)",
    "Yes",
    "No",
    "Aktif",
  ],
  [
    1418,
    "Konsentrat Sari Buah Jeruk Bali Merah (grapefruit juice concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1419,
    "Konsentrat Sari Buah Jeruk Florida (Florida Orange Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1420,
    "KONSENTRAT SARI BUAH JERUK NIPIS (LIME JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1421,
    "Konsentrat Sari Buah Kawista (Kawista Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1422,
    "Konsentrat Sari Buah Kiwi (Kiwi Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1423,
    "KONSENTRAT SARI BUAH KRANBERI (CRANBERRY JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1424,
    "KONSENTRAT SARI BUAH KURMA (DATES JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1425,
    "KONSENTRAT SARI BUAH LABU AIR (CALABASH JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1426,
    "KONSENTRAT SARI BUAH LECI (LYCHEE JUICE CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1427,
    "Konsentrat Sari Buah Leci (Lychees Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1428,
    "Konsentrat Sari Buah Lemon (Lemon Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1429,
    "Konsentrat Sari Buah Mangga (Mango Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1430,
    "Konsentrat Sari Buah Markisa (Passion Fruit Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1431,
    "Konsentrat Sari Buah Melon (Honeydew Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1432,
    "Konsentrat Sari Buah Merah (Red Fruit Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1433,
    "Konsentrat Sari Buah Nanas (Pineapple Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1434,
    "Konsentrat Sari Buah Nangka (Jackfruit Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1435,
    "Konsentrat Sari Buah Pepaya (Papaya Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1436,
    "KONSENTRAT SARI BUAH PERSIK (PEACH JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1437,
    "KONSENTRAT SARI BUAH PIR (PEAR JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1438,
    "Konsentrat Sari Buah Pisang (Banana Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1439,
    "Konsentrat Sari Buah Plum (Plum Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1440,
    "Konsentrat Sari Buah Prune (Prune Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1441,
    "Konsentrat Sari Buah Quince (Quince Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1442,
    "Konsentrat Sari Buah Raspberry (Raspberry Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1443,
    "Konsentrat Sari Buah Redcurrant (Redcurrant Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1444,
    "KONSENTRAT SARI BUAH SALAK (SNAKE FRUIT JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1445,
    "Konsentrat Sari Buah Semangka (Watermelon Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1446,
    "Konsentrat Sari Buah Sirsak (Soursop Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1447,
    "KONSENTRAT SARI BUAH STROBERI (STRAWBERRY JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1448,
    "KONSENTRAT SARI BUAH TOMAT (TOMATO JUICE CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1449,
    "Konsentrat Sari Kelapa (Coconut Juice Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1450, "konsentrat sayur .....", "No", "No", "Aktif"],
  [
    1451,
    "Konsentrat Spirulina (Spirulina Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1452, "KONSENTRAT SUSU (MILK CONCENTRATE)", "No", "No", "Aktif"],
  [1453, "Konsentrat Talas (Taro Concentrate)", "No", "No", "Aktif"],
  [
    1454,
    "KONSENTRAT VANILA (VANILLA CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1455,
    "KONSENTRAT WHEY PROTEIN (WHEY PROTEIN CONCENTRATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1456,
    "Konsentrat Wortel (Carrot Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1457,
    "KONSENTRAT WORTEL UNGU/WORTEL HITAM (PURPLE/BLACK CARROT CONCENTRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [1458, "Konyaku Bubuk", "No", "No", "Nonaktif"],
  [1459, "Kopi (Coffee)", "No", "No", "Aktif"],
  [1460, "KOPI ARABIKA (ARABICA COFFEE)", "No", "No", "Aktif"],
  [1461, "Kopi Bubuk (Coffee Powder)", "No", "No", "Aktif"],
  [
    1462,
    "Kopi Bubuk Instan (Instant Coffee Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1463, "Kopi Pasta (Coffee Paste)", "No", "No", "Aktif"],
  [1464, "Kopi Putih Bubuk", "No", "No", "Nonaktif"],
  [1465, "Kopi Robusta (Robusta Coffee)", "No", "No", "Aktif"],
  [1466, "Kopra (Copra)", "No", "No", "Aktif"],
  [
    1467,
    "KORIANDER BUBUK (CORIANDER POWDER)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1468, "Kranberi (Cranberry)", "No", "No", "Aktif"],
  [1469, "Kranberi Kering (Dried Cranberry)", "No", "No", "Aktif"],
  [1470, "Kratom (Mitragyna speciosa)", "No", "No", "Nonaktif"],
  [
    1471,
    "KREATIN MONOHIDRAT (CREATINE MONOHYDRATE)",
    "No",
    "No",
    "Aktif",
  ],
  [1472, "KRECEK (KRECHEK)", "No", "No", "Aktif"],
  [1473, "Krekers Beras (Rice Crackers)", "No", "No", "Aktif"],
  [1474, "Krill Oil (Eupausia Superba)", "No", "No", "Aktif"],
  [1475, "Krim (Cream)", "No", "No", "Aktif"],
  [1476, "Krim Asam (Sour Cream)", "No", "No", "Aktif"],
  [1477, "Krim Bubuk (Cream Powder)", "No", "No", "Aktif"],
  [1478, "Krim Kacang Hazel (Hazelnut Cream)", "No", "No", "Aktif"],
  [1479, "KRIM KAPUCINO (CAPPUCCINO CREAM)", "No", "No", "Aktif"],
  [1480, "Krim Karamel (Caramel Cream)", "No", "No", "Aktif"],
  [1481, "Krim Kelapa (Coconut Cream)", "No", "No", "Aktif"],
  [1482, "Krim Kopi (Coffee Cream)", "No", "No", "Aktif"],
  [1483, "Krim Nabati (Vegetable Cream) ", "No", "No", "Aktif"],
  [1484, "Krim Nabati Bubuk", "No", "No", "Nonaktif"],
  [
    1485,
    "Krim Nabati Bubuk (Vegetable Cream Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1486,
    "Krim Pasteurisasi (Pasteurized Cream)",
    "No",
    "No",
    "Aktif",
  ],
  [1487, "KRIM RASA VANILA (VANILLA CREAM)", "No", "No", "Aktif"],
  [1488, "KRIM SAYUR (VEGETABLE CREAM)", "No", "No", "Nonaktif"],
  [1489, "Krim Stroberi (Strawberry Cream)", "No", "No", "Aktif"],
  [1490, "KRIM SUSU (MILK CREAM)", "No", "No", "Nonaktif"],
  [1491, "Krim Susu Bubuk (Milk Cream Powder)", "No", "No", "Aktif"],
  [1492, "Krim Tiramisu (Tiramisu Cream)", "No", "No", "Aktif"],
  [1493, "Krimer", "No", "No", "Nonaktif"],
  [1494, "KRIMER (CREAMER)", "No", "No", "Nonaktif"],
  [
    1495,
    "Krimer Kental Manis (Sweetened Condensed Creamer)",
    "No",
    "No",
    "Aktif",
  ],
  [1496, "KRIMER MINUMAN (NON DAIRY CREAMER)", "No", "No", "Aktif"],
  [1497, "Krimer Nabati", "No", "No", "Nonaktif"],
  [
    1498,
    "KRIMER NABATI (NON DAIRY CREAMER)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1499, "KRISANTEMUM (CHRYSANTHEMUM)", "No", "No", "Nonaktif"],
  [
    1500,
    "KRISANTEMUM BUBUK (CHRYSANTEMUM POWDER) ",
    "No",
    "No",
    "Nonaktif",
  ],
  [1501, "Krispi ", "No", "No", "Nonaktif"],
  [1502, "Krispi Beras (Rice Crispy)", "No", "No", "Aktif"],
  [1503, "Krispi Kedelai (Soy Crispy)", "No", "No", "Aktif"],
  [1504, "KROMIUM KLORIDA (CHROMIUM CHLORIDE)", "No", "No", "Aktif"],
  [
    1505,
    "Kromium Pikolinat (Chromium Picolinate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1506,
    "KROMIUM POLINIKOTINAT (CHROMIUM POLYNICOTINATE)",
    "No",
    "No",
    "Aktif",
  ],
  [1507, "Kuaci (Sunflower Seed)", "No", "No", "Aktif"],
  [1508, "Kubis ", "No", "No", "Nonaktif"],
  [1509, "Kubis Brussel (Brussels Sprouts)", "No", "No", "Aktif"],
  [1510, "KUCAI (GARLIC CHIVES)", "No", "No", "Aktif"],
  [1511, "KUCAI KERING (DRIED GARLIC CHIVES)", "No", "No", "Aktif"],
  [1512, "KUE BROWNIES (BROWNIE CAKE)", "No", "No", "Aktif"],
  [1513, "KUE BUSA (MERINGUE)", "No", "No", "Aktif"],
  [1514, "Kue Ikan (Fish Cake)", "No", "No", "Aktif"],
  [1515, "KUKIS (COOKIES)", "No", "No", "Aktif"],
  [1516, "Kulit Ayam (Chicken Skin)", "No", "No", "Aktif"],
  [1517, "Kulit Babi (Pork Rind)", "No", "No", "Aktif"],
  [1518, "Kulit Bergamot (Bergamot Peels)", "No", "No", "Aktif"],
  [1519, "KULIT BIJI PALA (NUTMEG MACE)", "No", "No", "Aktif"],
  [1520, "Kulit Buah Manggis ", "No", "No", "Aktif"],
  [1521, "Kulit Domba (Sheepskin)", "No", "No", "Aktif"],
  [1522, "Kulit Gandum (Wheat Bran)", "No", "No", "Aktif"],
  [1523, "Kulit Ikan (Fish Skin)", "No", "No", "Aktif"],
  [1524, "KULIT IKAN PATIN (PANGASIUS SKIN)", "No", "No", "Aktif"],
  [1525, "Kulit Ikan Salmon (Salmon Skin)", "No", "No", "Aktif"],
  [1526, "Kulit Ikan Tenggiri (Mackerel)", "No", "No", "Aktif"],
  [1527, "Kulit Jagung (Corn Bran)", "No", "No", "Aktif"],
  [1528, "Kulit Jeruk (Orange Peel)", "No", "No", "Aktif"],
  [1529, "KULIT JERUK ........", "No", "No", "Nonaktif"],
  [
    1530,
    "Kulit Jeruk Bubuk (Orange Peel Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1531, "Kulit Jeruk Lemon (Orange Peels)", "No", "No", "Aktif"],
  [
    1532,
    "KULIT JERUK MANDARIN (MANDARIN ORANGE PEELS)",
    "No",
    "No",
    "Aktif",
  ],
  [1533, "KULIT JERUK NIPIS (LIME PEELS)", "No", "No", "Aktif"],
  [1534, "Kulit Kebab/Tortilla", "No", "No", "Aktif"],
  [1535, "Kulit Lumpia (Spring Roll Skin)", "No", "No", "Aktif"],
  [1536, "Kulit Oats Bubuk (Oats Bran Powder)", "No", "No", "Aktif"],
  [1537, "Kulit Pangsit (Dumpling Skin)", "No", "No", "Aktif"],
  [
    1538,
    "KULIT POHON PINUS EKSTRAK (PINE BARK EXTRACT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1539, "Kulit Sapi", "No", "No", "Aktif"],
  [1540, "KULIT SIOMAY (DUMPLING WRAPPER)", "No", "No", "Aktif"],
  [
    1541,
    "KULIT TAHU (GOHYONG, BEAN CURD SHEET, BEAN CURD ROBES, BEAN CURD SKIN, TOFU SKIN)",
    "No",
    "No",
    "Aktif",
  ],
  [1542, "KULIT TELUR (EGGSHELL)", "No", "No", "Nonaktif"],
  [
    1543,
    "KULTUR BAKTERI (BACTERIAL CULTURE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1544,
    "KULTUR BAKTERI ASAM LAKTAT (LACTIC ACID BACTERIAL CULTURE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1545, "KULTUR STARTER (STARTER CULTURE)", "No", "No", "Nonaktif"],
  [1546, "KUNING TELUR (EGG YOLK)", "No", "Yes", "Aktif"],
  [
    1547,
    "KUNING TELUR ASIN (SALTED EGG YOLK)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    1548,
    "KUNING TELUR BUBUK (EGG YOLK POWDER)",
    "No",
    "Yes",
    "Aktif",
  ],
  [1549, "KUNYIT (TURMERIC)", "No", "No", "Nonaktif"],
  [
    1550,
    "KUNYIT (TURMERIC-CURCUMA LONGA RHIZOME)",
    "No",
    "No",
    "Aktif",
  ],
  [1551, "KUNYIT ASAM (TURMERIC AND TAMARIND)", "No", "No", "Aktif"],
  [1552, "Kunyit Bubuk (Turmeric Powder)", "No", "No", "Aktif"],
  [
    1553,
    "KUPANG KERING (DRY GREENSHELL MUSSELS",
    "No",
    "No",
    "Aktif",
  ],
  [1554, "Kurma (Dates)", "No", "No", "Aktif"],
  [1555, "Kurma Bubuk (Dates Powder)", "No", "No", "Aktif"],
  [1556, "Kurma Merah (Red Dates)", "No", "No", "Aktif"],
  [1557, "L - GLUTATION (L - GLUTATHIONE)", "No", "No", "Aktif"],
  [1558, "L-Glutamin (L-Glutamine)", "Yes", "Yes", "Aktif"],
  [1559, "L-KARNITIN (L-CARNITINE)", "No", "No", "Aktif"],
  [
    1560,
    "L-ORNITIN (L-ORNITHINE) (KATEGORI PANGAN 13)",
    "No",
    "No",
    "Aktif",
  ],
  [1561, "L-Prolin", "No", "No", "Aktif"],
  [1562, "L-Serin", "No", "No", "Aktif"],
  [1563, "L-Theanine", "No", "No", "Aktif"],
  [1564, "Labu (Pumpkin)", "No", "No", "Aktif"],
  [1565, "Labu Bubuk (Pumpkin Powder)", "No", "No", "Aktif"],
  [1566, "LABU KUNING", "No", "No", "Nonaktif"],
  [1567, "LABU SIAM (CHAYOTE)", "No", "No", "Aktif"],
  [1568, "LACTOBACILLUS ACIDOPHILUS", "No", "No", "Aktif"],
  [1569, "Lactobacillus bulgaricus", "No", "No", "Aktif"],
  [1570, "Lactobacillus casei", "No", "No", "Aktif"],
  [1571, "Lactobacillus Fermentum", "No", "No", "Aktif"],
  [1572, "Lactobacillus helveticus ", "No", "No", "Aktif"],
  [1573, "Lactobacillus kefiri ", "No", "No", "Aktif"],
  [
    1574,
    "Lactobacillus lactis subsp. cremoris",
    "No",
    "No",
    "Aktif",
  ],
  [1575, "Lactobacillus lactis subsp. lactis", "No", "No", "Aktif"],
  [1576, "LACTOBACILLUS PARACASEI", "Yes", "Yes", "Aktif"],
  [1577, "Lactobacillus Plantarum", "No", "No", "Aktif"],
  [1578, "Lactobacillus Reuteri", "No", "No", "Aktif"],
  [1579, "LACTOBACILLUS RHAMNOSUS LGG (L+)", "No", "No", "Aktif"],
  [1580, "Lactobacillus rhamnosus NCC 4007", "No", "No", "Aktif"],
  [1581, "Lactococcus lactis", "No", "No", "Aktif"],
  [1582, "LADA (PEPPER)", "No", "No", "Aktif"],
  [1583, "LADA HIJAU (GREEN PEPPERCORN)", "No", "No", "Aktif"],
  [1584, "Lada Hitam", "No", "No", "Nonaktif"],
  [1585, "Lada Hitam (Black Pepper)", "No", "No", "Aktif"],
  [
    1586,
    "Lada Hitam Bubuk (Black Pepper Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1587, "Lada Jalapeno", "No", "No", "Nonaktif"],
  [1588, "LADA MERAH (RED PEPPER)", "No", "No", "Aktif"],
  [1589, "Lada Putih (White Pepper)", "No", "No", "Aktif"],
  [
    1590,
    "LADA PUTIH BUBUK (WHITE PEPPER POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [1591, "LAKTOFERIN (LACTOFERRIN)", "No", "Yes", "Aktif"],
  [1592, "Laktosa", "No", "No", "Nonaktif"],
  [1593, "LAKTOSA (LACTOSE)", "No", "Yes", "Aktif"],
  [1594, "LAKTOSA BUBUK (LACTOSE POWDER)", "No", "Yes", "Aktif"],
  [1595, "LAKTULOSA (LACTULOSE)", "No", "Yes", "Aktif"],
  [
    1596,
    "LAPACHO (TABEBULA IMPETIGINOSA ATAU HANDROANTHUS IMPETIGINOSUS)",
    "No",
    "No",
    "Aktif",
  ],
  [1597, "LARUTAN GULA (SUGAR SOLUTION)", "No", "No", "Aktif"],
  [
    1598,
    "lavender (lavandula angustifolia)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1599, "Lemak Ayam (Chicken Fat)", "No", "No", "Aktif"],
  [1600, "Lemak Babi (Lard)", "No", "No", "Aktif"],
  [1601, "LEMAK COKLAT  (CHOCOLATE FAT)", "No", "No", "Aktif"],
  [1602, "Lemak Hewani (Tallow)", "No", "No", "Aktif"],
  [
    1603,
    "Lemak Inti Sawit Terhidrogenasi (Refined Hydrogenated Palm Kernel Fat)",
    "No",
    "No",
    "Aktif",
  ],
  [1604, "Lemak Kakao ", "No", "No", "Nonaktif"],
  [1605, "Lemak Kakao (Cocoa Butter)", "No", "No", "Aktif"],
  [1606, "LEMAK MENTEGA (BUTTER FAT)", "No", "No", "Aktif"],
  [
    1607,
    "LEMAK NABATI (MARGARIN DAN LEMAK REROTI)",
    "No",
    "No",
    "Aktif",
  ],
  [1608, "Lemak Nabati (Vegetable Fat)", "No", "No", "Aktif"],
  [
    1609,
    "Lemak Nabati Terhidrogenasi (Hydrogenated Vegetable Fat)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1610,
    "Lemak Nabati tidak hidrogenasi (Unhydrogenated Vegetable Fat)",
    "No",
    "No",
    "Aktif",
  ],
  [1611, "Lemak Reroti (Shortening)", "No", "No", "Aktif"],
  [1612, "Lemak Sapi (Beef Fat)", "No", "No", "Aktif"],
  [1613, "Lemak Susu (Fat Milk)", "No", "No", "Aktif"],
  [
    1614,
    "Lemak Susu Anhidrat (Anhydrous Milk Fat)",
    "No",
    "No",
    "Aktif",
  ],
  [1615, "Lemak Susu Sapi (Cow's Milk Fat)", "No", "No", "Aktif"],
  [
    1616,
    "Lemak Trigliserida Rantai Sedang (MCT) (Medium Chain Triglyceride Fat)",
    "No",
    "No",
    "Aktif",
  ],
  [1617, "Lembaga Gandum (Wheat Germ)", "No", "No", "Aktif"],
  [1618, "Lemon Verbena (Lippia citriodora)", "Yes", "No", "Aktif"],
  [1619, "Lempuyang", "No", "No", "Aktif"],
  [1620, "Lempuyang Wangi ", "No", "No", "Aktif"],
  [1621, "Lengkuas - Laos (Galangal)", "No", "No", "Aktif"],
  [1622, "Lengkuas Bubuk (Galangal Powder)", "No", "No", "Aktif"],
  [1623, "Lentil (Lens Culinaris)", "No", "No", "Aktif"],
  [1624, "LEPTOSPERPUM CITRATEM", "No", "No", "Nonaktif"],
  [1625, "Leuconostoc citreum", "No", "No", "Aktif"],
  [1626, "Leuconostoc cremoris", "No", "No", "Aktif"],
  [1627, "Leusin (Leusin)", "No", "No", "Aktif"],
  [
    1628,
    "LICORICE - LIQUORICE (GLYCYRRHIZA GLABRA)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1629,
    "Licorice Root-Akar Licorice (Glycyrrhiza Uralensis)",
    "No",
    "No",
    "Aktif",
  ],
  [1630, "Lidah Buaya (Aloe Vera)", "No", "No", "Aktif"],
  [
    1631,
    "Lidah Buaya Bubuk (Aloe Vera Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [1632, "Lidah Buaya Gel (Aloe Vera Gel)", "No", "No", "Aktif"],
  [
    1633,
    "LIDAH SAPI (BEEF ATAU COW ATAU OX TONGUE)",
    "No",
    "No",
    "Aktif",
  ],
  [1634, "Likopen (Lycopene)", "No", "No", "Aktif"],
  [1635, "LINGZHI (GANODERMA LUCIDUM)", "No", "No", "Nonaktif"],
  [1636, "LIQUEUR", "No", "No", "Aktif"],
  [1637, "LIQUIORICE", "No", "No", "Nonaktif"],
  [1638, "Lisin (Lysine)", "No", "No", "Aktif"],
  [
    1639,
    "Lisin Monohidrat (Lysine Monohydrate)",
    "No",
    "No",
    "Aktif",
  ],
  [1640, "LO HAN GUO (LO HAN GUO)", "No", "No", "Nonaktif"],
  [1641, "Lobak (Radish)", "No", "No", "Aktif"],
  [1642, "Lobak Bubuk (Radish Powder)", "No", "No", "Aktif"],
  [1643, "Lobak Hijau (Turnip Greens)", "No", "No", "Aktif"],
  [
    1644,
    "Lobak Hijau Kering (Dried Turnip Greens)",
    "No",
    "No",
    "Aktif",
  ],
  [1645, "Lobak Merah (Red Radish)", "No", "No", "Aktif"],
  [1646, "LOBI - LOBI  (BATOKO PLUM)", "No", "No", "Aktif"],
  [1647, "Lobster", "No", "No", "Aktif"],
  [1648, "LOKIO KERING (DRIED CHIVES)", "No", "No", "Aktif"],
  [1649, "LOKIO-BAWANG BATAK (CHIVES)", "No", "No", "Aktif"],
  [1650, "LONICERA JAPONICA", "No", "No", "Nonaktif"],
  [
    1651,
    "LONTAR  (LONTAR PALM ATAU BORASSUS FLABELLIFER)",
    "No",
    "No",
    "Aktif",
  ],
  [1652, "Lucuma (Pouteria lucuma)", "No", "No", "Aktif"],
  [1653, "LUTEIN", "No", "No", "Nonaktif"],
  [1654, "Madu (Honey)", "No", "No", "Aktif"],
  [1655, "Madu Agave (Agave Honey)", "No", "No", "Aktif"],
  [1656, "Madu Akasia (Acacia Honey)", "No", "No", "Aktif"],
  [1657, "Madu Bubuk (Honey Powder)", "No", "No", "Aktif"],
  [1658, "MADU HUTAN (FOREST HONEY)", "No", "No", "Aktif"],
  [1659, "Madu Kelengkeng (Longan Honey)", "No", "No", "Aktif"],
  [1660, "MADU RANDU (KAPOK HONEY)", "No", "No", "Aktif"],
  [
    1661,
    "Madu Sarang (Comb Honey) (Khusus Madu)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1662,
    "MAGNESIUM ASETAT (MAGNESIUM ACETATE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1663,
    "Magnesium hidrogen fosfat (Magnesium hydrogen phosphate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1664,
    "Magnesium hidroksida (Magnesium hydroxide)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1665,
    "MAGNESIUM KARBONAT (MAGNESIUM CARBONATE)",
    "No",
    "No",
    "Aktif",
  ],
  [1666, "Magnesium Kaseinat", "No", "No", "Aktif"],
  [
    1667,
    "magnesium klorida (magnesium chloride)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1668,
    "Magnesium L-Aspartat (Magnesium L-Aspartate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1669,
    "Magnesium laktat (Magnesium lactate)",
    "No",
    "No",
    "Aktif",
  ],
  [1670, "MAGNESIUM OKSIDA (MAGNESIUM OXIDE)", "No", "No", "Aktif"],
  [1671, "Magnesium Sulfat", "No", "No", "Aktif"],
  [1672, "MAIZENA (CORNSTARCH)", "No", "No", "Nonaktif"],
  [1673, "Makaroni (Macaroni)", "No", "No", "Aktif"],
  [1674, "MALT (BARLEY MALT)", "No", "No", "Nonaktif"],
  [1675, "Malt (Malt)", "No", "No", "Aktif"],
  [1676, "Malt Barley (Barley Malt)", "No", "No", "Aktif"],
  [1677, "Malt Bubuk (Malt Powder)", "No", "No", "Aktif"],
  [
    1678,
    "Malto Oligosakarida (Malto Oligosaccharide)",
    "No",
    "No",
    "Aktif",
  ],
  [1679, "Maltodekstrin", "No", "No", "Nonaktif"],
  [1680, "Maltodekstrin (Maltodextrine)", "No", "No", "Aktif"],
  [1681, "Maltodekstrin Resisten", "No", "No", "Aktif"],
  [1682, "Maltosa (Maltose)", "No", "No", "Aktif"],
  [1683, "Maltotriose (Maltotriose)", "No", "No", "Aktif"],
  [
    1684,
    "MANGAN (II) GLUKONAT (MANGANESE (II) GLUCONATE) ",
    "No",
    "No",
    "Aktif",
  ],
  [
    1685,
    "Mangan (II) Klorida (Manganese (II) Chloride)",
    "No",
    "No",
    "Aktif",
  ],
  [1686, "MANGAN SITRAT (MANGANESE CITRATE)", "No", "No", "Aktif"],
  [1687, "Mangan Sulfat (Manganese Sulphate)", "No", "No", "Aktif"],
  [1688, "Mangga (Manggo)", "No", "No", "Aktif"],
  [1689, "Mangga Bubuk (Mango Powder)", "No", "No", "Aktif"],
  [1690, "Mangga Kering (Dried Mango)", "No", "No", "Aktif"],
  [1691, "Manggis (Mangosteen)", "No", "No", "Aktif"],
  [
    1692,
    "MANISAN CRANBERRY (CANDIED CRANBERRY)",
    "No",
    "No",
    "Aktif",
  ],
  [1693, "Manisan Jeruk (Candied Orange)", "No", "No", "Aktif"],
  [
    1694,
    "Manisan Kulit Jeruk (Candied Orange Peel)",
    "No",
    "No",
    "Aktif",
  ],
  [1695, "Manisan Mangga (Candied Mango)", "No", "No", "Aktif"],
  [1696, "Manisan Nanas (Candied Pineapple)", "No", "No", "Aktif"],
  [1697, "Manisan Pepaya (Candied Papaya)", "No", "No", "Aktif"],
  [
    1698,
    "MAQUI BERRY (ARISTOTELIA CHILENSIS) ",
    "No",
    "No",
    "Nonaktif",
  ],
  [1699, "Margarin (Margarine)", "No", "No", "Aktif"],
  [1700, "MARGARIN OLES (MARGARINE SPREAD)", "No", "No", "Aktif"],
  [1701, "Marjoram", "No", "No", "Aktif"],
  [1702, "Markisa (Passion Fruit)", "No", "No", "Aktif"],
  [1703, "Marmalad (Marmalade)", "No", "No", "Aktif"],
  [1704, "MARSHMALLOW (MARSHMALLOW)", "No", "No", "Aktif"],
  [1705, "MARSMALLOW", "No", "No", "Nonaktif"],
  [1706, "MARZIPAN (MARZIPAN)", "No", "No", "Aktif"],
  [1707, "Massa Kakao", "No", "No", "Nonaktif"],
  [1708, "mate green (illex paraguarienis)", "No", "No", "Nonaktif"],
  [1709, "Mate Green (Illex Paraguariensis)", "No", "No", "Aktif"],
  [
    1710,
    "MAXIMOWICZIA (SCHISANDRA CHINENSIS)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1711, "Mayonais (Mayonnaise)", "No", "No", "Aktif"],
  [1712, "Melati (Jasmine)", "No", "No", "Aktif"],
  [1713, "MELINJO (GNETUM GNEMON L.)", "No", "No", "Aktif"],
  [
    1714,
    "MELISASA OFFICINALIS (HERBA LEMON BALM)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1715, "Melon (Melon)", "No", "No", "Aktif"],
  [1716, "Melon Bubuk ( Melon Powder)", "No", "No", "Aktif"],
  [1717, "Mengkudu (Morinda citrifolia)", "No", "No", "Aktif"],
  [1718, "Mentega ", "No", "No", "Nonaktif"],
  [1719, "Mentega (Butter)", "No", "No", "Aktif"],
  [1720, "MENTEGA ASIN (SALTED BUTTER)", "No", "No", "Aktif"],
  [1721, "Mentega Bubuk (Butter Powder)", "No", "No", "Aktif"],
  [1722, "Mentega Kacang (Peanut Butter)", "No", "No", "Aktif"],
  [1723, "Mentega Tawar (Unsalted Butter)", "No", "No", "Aktif"],
  [1724, "Mentimun - Ketimun (Cucumber)", "No", "No", "Aktif"],
  [1725, "Mentimun Hijau (Green Cucumber)", "No", "No", "Aktif"],
  [1726, "Mentimun Suri", "No", "No", "Aktif"],
  [1727, "MENTOL (MENTHOL)", "No", "No", "Nonaktif"],
  [
    1728,
    "Merica Sichuan (Zanthoxylum peperitum - Szechuan pepper)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1729,
    "MESES (CHOCOLATE SPRINKLES-CHOCOLATE VERMICELLI-STREUSEL)",
    "No",
    "No",
    "Aktif",
  ],
  [1730, "MESHIMAKOBU", "No", "No", "Nonaktif"],
  [1731, "Mesoyi", "No", "No", "Aktif"],
  [1732, "Metionin (Methionine)", "No", "No", "Aktif"],
  [1733, "Mi (Noodle)", "No", "No", "Aktif"],
  [1734, "Mi Telur (Egg Noodles)", "No", "No", "Aktif"],
  [1735, "Microcos paniculata", "No", "No", "Aktif"],
  [1736, "Millet (Millet)", "No", "No", "Aktif"],
  [1737, "Millet Serpih (Millet Flakes)", "No", "No", "Aktif"],
  [1738, "MINUMAN BERALKOHOL", "No", "No", "Nonaktif"],
  [1739, "Minuman Sari Buah ....", "No", "No", "Aktif"],
  [1740, "Minyak  Almond (Almond Oil)", "No", "No", "Aktif"],
  [1741, "Minyak Adas Manis (Anise Oil)", "No", "No", "Aktif"],
  [1742, "Minyak Alpukat (Avocado Oil)", "No", "No", "Aktif"],
  [1743, "MINYAK ANGGUR (GRAPE OIL)", "No", "No", "Nonaktif"],
  [1744, "MINYAK ANIS (ANISE OIL)", "No", "No", "Nonaktif"],
  [
    1745,
    "Minyak Atsiri Adas Manis (Anise Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1746,
    "MINYAK ATSIRI BAWANG BOMBAY (ONION ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1747,
    "Minyak Atsiri Bunga Matahari (Sunflower Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1748,
    "Minyak Atsiri Cabai (Chili Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1749,
    "Minyak Atsiri Cengkeh (Clove Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1750,
    "Minyak Atsiri Chamomile (Chammomile Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1751,
    "Minyak Atsiri Durian (Durian Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1752,
    "MINYAK ATSIRI JAHE (GINGER OLEORESIN-GINGER ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1753,
    "Minyak Atsiri Jeruk (Orange Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1754,
    "MINYAK ATSIRI JERUK BALI (GRAPEFRUIT ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1755,
    "Minyak Atsiri Jeruk Bergamot (Bergamot Orange Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1756,
    "Minyak Atsiri Jeruk Lemon (Lemon Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1757,
    "Minyak Atsiri Jeruk Nipis (Lime Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1758,
    "MINYAK ATSIRI JERUK PURUT (KAFFIR LIME ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1759,
    "Minyak Atsiri Jintan Hitam (Black Cumin Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1760,
    "MINYAK ATSIRI JUNIPER BERRY (JUNIPER BERRY ESSENTIAL OIL)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1761,
    "Minyak Atsiri Kayu Manis (Cinnamon Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1762,
    "Minyak Atsiri Kemukus (Cubeb Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1763,
    "Minyak Atsiri Kunyit (Turmeric Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1764,
    "Minyak Atsiri Lada (Pepper Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1765,
    "Minyak Atsiri Leci (Lychee Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1766,
    "MINYAK ATSIRI LEMON (LEMON ESSENTIAL OIL)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1767,
    "MINYAK ATSIRI LOBAK (RADISH ESSENTIAL OIL-TURNIP ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1768,
    "Minyak Atsiri Mangga (Mango Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1769,
    "Minyak Atsiri Mint (Mint Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1770,
    "MINYAK ATSIRI MUSTARD (MUSTARDSEED ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1771,
    "MINYAK ATSIRI NANAS (PINEAPPLE ESSENTIAL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1772,
    "Minyak Atsiri Nangka (Jackfruit Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1773,
    "Minyak Atsiri Pala (Nutmeg Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1774,
    "Minyak Atsiri Pandan (Pandan Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1775,
    "MINYAK ATSIRI PAPRIKA (PAPRIKA OLEORESIN)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1776,
    "Minyak Atsiri Peppermint (Peppermint Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1777,
    "MINYAK ATSIRI PERILLA (PERILLA ESSENTIAL OIL)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1778,
    "Minyak Atsiri Pisang (Banana Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1779,
    "MINYAK ATSIRI ROSEMARY (ROSEMARY OLEORESIN)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1780,
    "Minyak Atsiri Sereh (Lemongrass Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1781,
    "Minyak Atsiri Spearmint (Spearmint Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1782,
    "Minyak Atsiri Stroberi (Strawberry Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1783,
    "Minyak Atsiri Tarragon (Tarragon Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1784,
    "Minyak Atsiri Wortel (Carrot Essential Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [1785, "Minyak Ayam (Chicken Oil)", "No", "No", "Aktif"],
  [1786, "Minyak Babi (Pork Oil)", "No", "No", "Aktif"],
  [1787, "Minyak Barley (Barley Oil)", "No", "No", "Aktif"],
  [1788, "Minyak Bawang Merah (Shallot Oil)", "No", "No", "Aktif"],
  [1789, "MINYAK BAWANG PUTIH (GARLIC OIL)", "No", "No", "Aktif"],
  [1790, "MINYAK BERAS (RICE BRAN OIL)", "No", "No", "Aktif"],
  [1791, "Minyak Biji Anggur (Grapeseed Oil)", "No", "No", "Aktif"],
  [
    1792,
    "MINYAK BIJI APRIKOT (APRICOT KERNEL OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1793,
    "MINYAK BIJI BUNGA MATAHARI (REFINED BLEACHED DEODORIZED SUNFLOWER OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1794,
    "MINYAK BIJI KAPAS (REFINED BLEACHED DEODORIZED COTTONSEED OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1795, "Minyak Biji Rami (Flaxseed Oil)", "No", "No", "Aktif"],
  [
    1796,
    "MINYAK BIJI SAWI (MUSTARDSEED OIL - REFINED BLEACHED DEODORIZED MUSTARDSEED OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1797,
    "MINYAK BUNGA MATAHARI (SUNFLOWER OIL)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1798, "MINYAK CABAI (CAPSICUM OLEORESIN)", "No", "No", "Aktif"],
  [
    1799,
    "MINYAK DAUN JERUK PURUT (KAFFIR LIME LEAF OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1800, "Minyak Durian (Durian Oil)", "No", "No", "Aktif"],
  [1801, "MINYAK FRAMBOZEN (FRAMBOZEN OIL)", "No", "No", "Nonaktif"],
  [1802, "MINYAK GORENG (FRYING OIL)", "No", "No", "Aktif"],
  [
    1803,
    "MINYAK GORENG KEDELAI (SOYBEAN FRYING OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1804,
    "Minyak Goreng Kelapa Sawit (Palm Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [1805, "MINYAK IKAN (FISH OIL)", "No", "No", "Aktif"],
  [
    1806,
    "Minyak Inti Kelapa Sawit Terhidrogenasi (Refined Hydrogenated Palm Kernel Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1807,
    "MINYAK JAGUNG (REFINED BLEACHED DEODORIZED CORN OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1808, "MINYAK JERUK (CITRUS OIL)", "No", "No", "Aktif"],
  [1809, "MINYAK KACANG (PEANUT OIL)", "No", "No", "Aktif"],
  [
    1810,
    "Minyak Kacang Macadamia (Macadamia Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1811,
    "MINYAK KACANG TANAH (REFINED BLEACHED DEODORIZED PEANUT OIL - REFINED BLEACHED DEODORIZED GROUNDNUT OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1812, "MINYAK KACANG WALNUT (WALNUT OIL)", "No", "No", "Aktif"],
  [1813, "Minyak Kanola (Canola Oil)", "No", "No", "Aktif"],
  [1814, "Minyak Kari (Curry Oil)", "No", "No", "Aktif"],
  [1815, "MINYAK KAYU MANIS (CINNAMON OIL)", "No", "No", "Aktif"],
  [1816, "MINYAK KAYU PUTIH (EUCALYPTUS OIL)", "No", "No", "Aktif"],
  [1817, "Minyak Kedelai", "No", "No", "Nonaktif"],
  [
    1818,
    "MINYAK KEDELAI (REFINED BLEACHED DEODORIZED SOYBEAN OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1819,
    "Minyak Kedelai Terhidrogenasi Parsial (Partially Hydrogenated Soybean Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1820,
    "MINYAK KELAPA (REFINED BLEACHED DEODORIZED COCONUT OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1821,
    "Minyak Kelapa Bubuk (Coconut Oil Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1822,
    "Minyak Kelapa Mentah (Unrefined Coconut Oil-Crude Coconut Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1823,
    "Minyak Kelapa Murni (Virgin Coconut Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1824,
    "MINYAK KELAPA SAWIT (REFINED BLEACHED DEODORIZED PALM OIL-RBDPO) ",
    "No",
    "No",
    "Aktif",
  ],
  [
    1825,
    "Minyak Kelapa Sawit Terhidrogenasi (Refined Hydrogenated Palm Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1826,
    "Minyak Kelapa Terhidrogenasi (Hydogenated Coconut Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1827,
    "Minyak Kulit Ari Beras (Rice Husk Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [1828, "Minyak LC-PUFA (Oil Mix LC-PUFA)", "No", "No", "Aktif"],
  [1829, "Minyak Melon (Melon Oil)", "No", "No", "Aktif"],
  [1830, "minyak mentega", "No", "No", "Nonaktif"],
  [1831, "Minyak Mentega (Butter Oil)", "No", "No", "Aktif"],
  [1832, "MINYAK MUSTARD", "No", "No", "Nonaktif"],
  [1833, "Minyak Nabati ", "No", "No", "Nonaktif"],
  [1834, "Minyak Nabati (Vegetable Oil)", "No", "No", "Aktif"],
  [
    1835,
    "Minyak Nabati Terhidrogenasi (Hydrogenated Vegetable Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [1836, "Minyak Nanas (Pineapple Oil)", "No", "No", "Aktif"],
  [1837, "Minyak Nangka (Jackfruit Oil)", "No", "No", "Aktif"],
  [
    1838,
    "MINYAK OLEIN KELAPA SAWIT (REFINED BLEACHED DEODORIZED PALM OLEIN OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1839, "Minyak Pandan (Pandan Oil)", "No", "No", "Aktif"],
  [1840, "Minyak Peppermint (Peppermint Oil)", "No", "No", "Aktif"],
  [1841, "MINYAK PERILLA (PERILLA OIL)", "No", "No", "Aktif"],
  [
    1842,
    "Minyak Primrose (Evening Primrose Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1843,
    "MINYAK RAPESEED (RAPESEED OIL-TURNIP RAPE OIL-COLZA OIL-RAVISON OIL-SARSON OIL-TORIA OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1844, "Minyak Raspberry (Raspberry Oil)", "No", "No", "Aktif"],
  [1845, "Minyak Reroti (Shortening Oil)", "No", "No", "Aktif"],
  [
    1846,
    "MINYAK ROS ESENSIAL (ROSE ESSENTIAL OIL)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1847,
    "Minyak Sacha Inchi (Plukenetiva Volubilis L)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1848,
    "MINYAK SAFFLOWER (REFINED BLEACHED DEODORIZED SAFFLOWER OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1849, "Minyak Salad (Salad Oil)", "No", "No", "Aktif"],
  [
    1850,
    "MINYAK SAMIN ATAU VANASPATI (VEGETABLE GHEE)",
    "No",
    "No",
    "Aktif",
  ],
  [1851, "Minyak Sapi (Beef Oil)", "No", "No", "Aktif"],
  [
    1852,
    "Minyak Sarsaparila (Sarsaparilla Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [1853, "Minyak Sawit Olein", "No", "No", "Nonaktif"],
  [1854, "MINYAK SAYUR (COOKING OIL)", "No", "No", "Aktif"],
  [1855, "MINYAK SAYUR PADAT (COOKING FAT)", "No", "No", "Aktif"],
  [1856, "Minyak Sekam Oat (Oat Bran Oil)", "No", "No", "Aktif"],
  [1857, "Minyak Spearmint (Spearmint Oil)", "No", "No", "Aktif"],
  [1858, "Minyak Spinkenard (Spinkenard Oil)", "No", "No", "Aktif"],
  [
    1859,
    "Minyak Stearin Inti Kelapa Sawit Terhidrogenasi (Hydrogenated Palm Kernel Stearin Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1860,
    "MINYAK STEARIN KELAPA SAWIT (REFINED BLEACHED DEODORIZED PALM STEARIN OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1861,
    "MINYAK TRIGLISERIDA RANTAI SEDANG (MCT) (MEDIUM CHAIN TRIGLYCERIDES OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [1862, "minyak vanila", "No", "No", "Nonaktif"],
  [1863, "Minyak Wijen (Sesame Oil)", "No", "No", "Aktif"],
  [
    1864,
    "MINYAK ZAITUN (REFINED BLEACHED DEODORIZED OLIVE OIL)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1865,
    "MINYAK ZAITUN EXTRA VIRGIN (EXTRA VIRGIN OLIVE OIL)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1866,
    "Minyak Zaitun Pomace (Pomace Olive Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1867,
    "Minyak Zaitun Virgin (Virgin Olive Oil)",
    "No",
    "No",
    "Aktif",
  ],
  [1868, "Mirin", "No", "No", "Aktif"],
  [1869, "Miso", "No", "No", "Aktif"],
  [1870, "MISO BUBUK (MISO POWDER)", "No", "No", "Aktif"],
  [1871, "Mocaf (Tepung Singkong Fermentasi)", "No", "No", "Aktif"],
  [1872, "Molibdenum", "No", "No", "Aktif"],
  [
    1873,
    "Mono Dan Digliserida (mono- And Di-glycerides)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1874, "Monogliserida (monoglycerides)", "No", "No", "Nonaktif"],
  [
    1875,
    "Monokalium fosfat (Potassium phosphate, monobasic) ",
    "No",
    "No",
    "Aktif",
  ],
  [1876, "MULUKHIYAH", "No", "No", "Aktif"],
  [1877, "MUNG DHAL (MOONG DAL)", "No", "No", "Aktif"],
  [1878, "Muscat (Muscat)", "No", "No", "Aktif"],
  [1879, "Mustard (Mustard)", "No", "No", "Aktif"],
  [1880, "Mustard Bubuk (Mustard Powder)", "No", "No", "Aktif"],
  [1881, "Mustard Kuning (Yellow Mustard)", "No", "No", "Aktif"],
  [1882, "Mustard Pasta (Mustard Paste)", "No", "No", "Aktif"],
  [1883, "Myo-Inositol", "No", "No", "Aktif"],
  [1884, "Naget (Nugget)", "No", "No", "Aktif"],
  [1885, "Nanas (Pineapple)", "No", "No", "Aktif"],
  [1886, "NANAS BUBUK (PINEAPPLE POWDER)", "No", "No", "Aktif"],
  [1887, "Nangka (Jackfruit)", "No", "No", "Aktif"],
  [1888, "Nasi (Rice)", "No", "No", "Aktif"],
  [1889, "Nata De Coco (Nata De Coco)", "No", "No", "Aktif"],
  [1890, "NATRIUM ASKORBAT (SODIUM ASCORBATE)", "No", "No", "Aktif"],
  [
    1891,
    "NATRIUM BENZOAT (SODIUM BENZOATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1892,
    "Natrium dihidrogen fosfat (Sodium dihydrogen phosphate) ",
    "No",
    "No",
    "Aktif",
  ],
  [1893, "Natrium fluorida (Sodium fluoride)", "No", "No", "Aktif"],
  [
    1894,
    "NATRIUM HIDROGEN KARBONAT (SODIUM BICARBONATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    1895,
    "Natrium Hidroksida (Sodium Hydroxide) (Kecuali MP ASI)",
    "No",
    "No",
    "Aktif",
  ],
  [1896, "NATRIUM IODIDA (SODIUM IODIDE)", "No", "No", "Aktif"],
  [
    1897,
    "NATRIUM KARBOKSIMETIL SELULOSA (SODIUM CARBOXYMETHYL CELLULOSE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1898, "NATRIUM KARBONAT (SODIUM CARBONATE)", "No", "No", "Aktif"],
  [1899, "Natrium Kaseinat (Sodium Caseinate)", "No", "No", "Aktif"],
  [1900, "natrium klorida (sodium chloride)", "No", "No", "Aktif"],
  [1901, "NATRIUM MOLIBDAT (SODIUM MOLYBDATE)", "No", "No", "Aktif"],
  [
    1902,
    "NATRIUM POLIFOSFAT (SODIUM POLYPHOSPHATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1903, "NATRIUM SELENAT (SODIUM SELENATE)", "No", "No", "Aktif"],
  [1904, "NATRIUM SELENIT (SODIUM SELENITE)", "No", "No", "Aktif"],
  [
    1905,
    "NATRIUM TRIPOLIFOSFAT (SODIUM TRIPOLYPHOSPHATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1906, "Nektar Agave (Agave Nectar)", "No", "No", "Aktif"],
  [1907, "Nektar Lontar", "No", "No", "Aktif"],
  [
    1908,
    "NETTLE LEAF POWDER (URTICA DIOCA)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1909, "NIASIN (NIACIN)", "No", "No", "Nonaktif"],
  [1910, "NIKOTINAMIDA (NICOTINAMIDE)", "No", "No", "Aktif"],
  [1911, "NIRA KELAPA (COCONUT SAP)", "No", "No", "Aktif"],
  [1912, "Nira Lontar (Siwalan)", "No", "No", "Aktif"],
  [
    1913,
    "Non-Dairy Toppings, Fillings, Frostings",
    "Yes",
    "No",
    "Aktif",
  ],
  [1914, "Nori Goreng (Fried Seawed)", "No", "No", "Aktif"],
  [1915, "Nougat (Nougat)", "No", "No", "Aktif"],
  [1916, "Nukleotida (Nucleotide)", "No", "No", "Aktif"],
  [
    1917,
    "NUKLEOTIDA PREMIKS (PREMIX NUCLEOTIDE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1918, "Oat (Oat)", "No", "No", "Aktif"],
  [1919, "OAT BUBUK (OAT POWDER)", "No", "No", "Aktif"],
  [1920, "OAT SERPIHAN (OAT FLAKES)", "No", "No", "Aktif"],
  [1921, "OATMEAL (OATMEAL)", "No", "No", "Aktif"],
  [1922, "OKSIGEN (OXYGEN)", "No", "No", "Aktif"],
  [1923, "OLIGOFRUKTOSA (OLIGOFRUCTOSE)", "No", "No", "Aktif"],
  [1924, "OLIGOSAKARIDA (OLIGOSACCHARIDES)", "No", "No", "Aktif"],
  [1925, "Omega 3 (Omega 3)", "No", "No", "Aktif"],
  [1926, "Oregano (Oregano)", "No", "No", "Aktif"],
  [1927, "Oregano Bubuk (Oregano Powder)", "No", "No", "Aktif"],
  [1928, "PADATAN SUSU (MILK SOLIDS)", "No", "No", "Aktif"],
  [
    1929,
    "PADATAN SUSU TANPA LEMAK (NON FAT MILK SOLIDS)",
    "No",
    "No",
    "Aktif",
  ],
  [1930, "PAHA AYAM (CHICKEN THIGHS)", "No", "No", "Aktif"],
  [
    1931,
    "Pakcoy atau Pokcoy (Brassica Rapa L)",
    "No",
    "No",
    "Aktif",
  ],
  [1932, "Pala (Nutmeg)", "No", "No", "Aktif"],
  [1933, "Pala Bubuk (Nutmeg Powder)", "No", "No", "Aktif"],
  [1934, "Pandan (Pandan)", "No", "No", "Aktif"],
  [1935, "PANGSIT (DUMPLINGS)", "No", "No", "Aktif"],
  [1936, "PAPRIKA (PAPRIKA)", "No", "No", "Aktif"],
  [1937, "PAPRIKA BUBUK (PAPRIKA POWDER)", "No", "No", "Aktif"],
  [1938, "PAPRIKA HIJAU (GREEN PAPRIKA)", "No", "No", "Aktif"],
  [
    1939,
    "PAPRIKA HIJAU MANIS (SWEET GREEN PAPRIKA)",
    "No",
    "No",
    "Aktif",
  ],
  [1940, "PAPRIKA KUNING (YELLOW PAPRIKA)", "No", "No", "Aktif"],
  [1941, "PAPRIKA MERAH (RED PAPRIKA)", "No", "No", "Aktif"],
  [
    1942,
    "PAPRIKA MERAH MANIS (SWEET RED PAPRIKA)",
    "No",
    "No",
    "Aktif",
  ],
  [
    1943,
    "PAPRIKA OLEORESIN (PAPRIKA OLEORESIN)",
    "No",
    "No",
    "Nonaktif",
  ],
  [1944, "PARE (PARE)", "No", "No", "Aktif"],
  [1945, "PARE KERING (DRY PARE)", "No", "No", "Aktif"],
  [1946, "PARSLEY", "No", "No", "Nonaktif"],
  [1947, "PARSNIP (PASTINACA SATIVA)", "No", "No", "Aktif"],
  [1948, "PARU SAPI (PULMONARY COW)", "No", "No", "Aktif"],
  [1949, "PARUTAN KELAPA (GRATED COCONUT)", "No", "No", "Aktif"],
  [1950, "Parutan Kelapa Kering", "No", "No", "Nonaktif"],
  [1951, "PASAK BUMI (EURYCOMA LONGIFOLIA)", "No", "No", "Nonaktif"],
  [
    1952,
    "Pasta (Fettucini, Lasagna, Macaroni, Spaghetti, dll)",
    "No",
    "No",
    "Aktif",
  ],
  [1953, "Pasta Almond (Almond Paste)", "No", "No", "Aktif"],
  [1954, "Pasta Apel (Apple Paste)", "No", "No", "Aktif"],
  [1955, "Pasta Ayam (Chicken Paste)", "No", "No", "Aktif"],
  [1956, "Pasta Bawang Bombay (Onion Paste)", "No", "No", "Aktif"],
  [1957, "Pasta Bawang Putih (Garlic Paste)", "No", "No", "Aktif"],
  [
    1958,
    "Pasta Biji Wijen (Sesame Seed Paste)",
    "No",
    "No",
    "Aktif",
  ],
  [1959, "Pasta Bluberi (Blueberry Paste)", "No", "No", "Aktif"],
  [1960, "PASTA BUAH, DLL (FRUITS PASTE, ETC)", "No", "No", "Aktif"],
  [1961, "Pasta Bumbu Kari (Curry Paste)", "No", "No", "Aktif"],
  [1962, "Pasta Cabe (Chili Paste)", "No", "No", "Aktif"],
  [
    1963,
    "Pasta Cokelat Malt (Chocolate Malt Paste)",
    "No",
    "No",
    "Aktif",
  ],
  [1964, "Pasta Coklat (Chocolate Paste)", "No", "No", "Aktif"],
  [1965, "Pasta Durian (Durian Paste)", "No", "No", "Aktif"],
  [1966, "Pasta Ikan  (Fish Paste)", "No", "No", "Aktif"],
  [1967, "Pasta Ikan Anchovy (Anchovy Paste)", "No", "No", "Aktif"],
  [
    1968,
    "Pasta Jagung Manis (Sweet Corn Paste)",
    "No",
    "No",
    "Aktif",
  ],
  [1969, "Pasta Jeruk (Orange Paste)", "No", "No", "Aktif"],
  [1970, "Pasta Jeruk Lemon (Lemon Paste)", "No", "No", "Aktif"],
  [1971, "Pasta Kacang (Nut Paste)", "No", "No", "Aktif"],
  [1972, "Pasta Kacang Hazel (Hazelnut Paste)", "No", "No", "Aktif"],
  [1973, "Pasta Kacang Hijau (Mungbean Paste)", "No", "No", "Aktif"],
  [
    1974,
    "Pasta Kacang Kedelai (Soybean Paste)",
    "No",
    "No",
    "Aktif",
  ],
  [1975, "PASTA KACANG MERAH (RED BEAN PASTE)", "No", "No", "Aktif"],
  [1976, "Pasta Keju (Cheese Paste)", "No", "No", "Aktif"],
  [1977, "Pasta Kelapa (Coconut Paste)", "No", "No", "Aktif"],
  [
    1978,
    "PASTA KETAN HITAM (BLACK STICKY RICE PASTE)",
    "No",
    "No",
    "Aktif",
  ],
  [1979, "Pasta Kismis (Raisin Paste)", "No", "No", "Aktif"],
  [1980, "Pasta Kopi", "No", "No", "Nonaktif"],
  [1981, "Pasta Kurma (Datess Paste)", "No", "No", "Aktif"],
  [1982, "PASTA LADA MERAH (RED PEPPER PASTE)", "No", "No", "Aktif"],
  [1983, "Pasta Leci (Lychee Paste)", "No", "No", "Aktif"],
  [1984, "Pasta Mangga (Mango Paste)", "No", "No", "Aktif"],
  [1985, "Pasta Nanas (Pineapple Paste)", "No", "No", "Aktif"],
  [1986, "Pasta Pear (Pear Paste)", "No", "No", "Aktif"],
  [1987, "Pasta Pepaya (Papaya Paste)", "No", "No", "Aktif"],
  [1988, "Pasta Persik (Peach Paste)", "No", "No", "Aktif"],
  [1989, "Pasta Pisang (Banana Paste)", "No", "No", "Aktif"],
  [1990, "Pasta Plum (Plum Paste)", "No", "No", "Aktif"],
  [1991, "PASTA RASPBERI (RASPBERRY PASTE)", "No", "No", "Aktif"],
  [1992, "PASTA SARIKAYA (SARIKAYA PASTE)", "No", "No", "Aktif"],
  [1993, "Pasta Srikaya (Soursop Paste)", "No", "No", "Aktif"],
  [1994, "Pasta Stroberi (Strawberry Paste)", "No", "No", "Aktif"],
  [1995, "Pasta Tomat (Tomato Paste)", "No", "No", "Aktif"],
  [1996, "Pasta Udang (Shrimp Paste)", "No", "No", "Aktif"],
  [1997, "Pasta Wijen (Sesame Paste)", "No", "No", "Aktif"],
  [1998, "Pastri Samosa  (Samosa Pastry)", "No", "No", "Aktif"],
  [1999, "Pati (Starch)", "No", "No", "Aktif"],
  [2000, "Pati Beras (Rice Starch)", "No", "No", "Aktif"],
  [2001, "Pati Gandum (Wheat Starch)", "No", "No", "Aktif"],
  [2002, "Pati Jagung (Corn Starch)", "No", "No", "Aktif"],
  [
    2003,
    "Pati Jagung Terhidrolisa (Hydrolized Corn Starch)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2004,
    "PATI JAGUNG TERMODIFIKASI (MODIFIED CORN STARCH)",
    "No",
    "No",
    "Aktif",
  ],
  [2005, "Pati Kacang Hijau (Mungbean Starch)", "No", "No", "Aktif"],
  [2006, "PATI KACANG POLONG (PEAS STARCH)", "No", "Yes", "Aktif"],
  [
    2007,
    "Pati Kedelai Terhidrolisa ((Hydrolized Soy Starch)",
    "No",
    "No",
    "Aktif",
  ],
  [2008, "Pati Kentang (Potato Starch)", "No", "No", "Aktif"],
  [
    2009,
    "PATI KENTANG TERMODIFIKASI (MODIFIED POTATO STARCH)",
    "No",
    "No",
    "Aktif",
  ],
  [2010, "PATI MODIFIKASI (MODIFIED STARCH)", "No", "No", "Aktif"],
  [2011, "Pati Sagu (Sago Starch)", "No", "No", "Aktif"],
  [2012, "PATI SINGKONG (TAPIOCA STARCH) ", "No", "No", "Nonaktif"],
  [2013, "PATI TAPIOKA", "No", "No", "Aktif"],
  [
    2014,
    "PATI TAPIOKA TERMODIFIKASI (MODIFIED TAPIOCA STARCH)",
    "No",
    "No",
    "Aktif",
  ],
  [2015, "Pati terModifikasi", "No", "No", "Nonaktif"],
  [2016, "Pati Ubi (Cassava Starch)", "No", "No", "Aktif"],
  [
    2017,
    "PATI UBI JALAR (SWEET POTATO STARCH)",
    "No",
    "No",
    "Aktif",
  ],
  [2018, "PECAHAN JAGUNG (CORN GRITS)", "No", "No", "Aktif"],
  [2019, "Pedada (Sonneratia caseolaris)", "No", "No", "Aktif"],
  [
    2020,
    "Pekak (Bunga Lawang-Kembang Lawang-Star Anise) (Star Anise)",
    "No",
    "No",
    "Aktif",
  ],
  [2021, "Pekak Bubuk (Star Anise Powder)", "No", "No", "Aktif"],
  [2022, "pektin", "No", "No", "Nonaktif"],
  [2023, "Pektin (Pectin)", "No", "No", "Aktif"],
  [2024, "Pelapis Gula (Sugar Coating)", "No", "No", "Aktif"],
  [2025, "Pelet (Pellet)", "No", "No", "Nonaktif"],
  [
    2026,
    "Pengganti Lemak Kakao (Cacao Butter Substitute)",
    "No",
    "No",
    "Aktif",
  ],
  [2027, "PENGGANTI MENTEGA", "Yes", "No", "Nonaktif"],
  [
    2028,
    "PENGGANTI MINYAK MENTEGA (BUTTER OIL SUBSTITUTE)",
    "No",
    "No",
    "Aktif",
  ],
  [2029, "Penicillium camemberti", "No", "No", "Aktif"],
  [2030, "Penicillium candidum", "No", "No", "Aktif"],
  [2031, "PENICILLIUM CASEICOLUM", "No", "No", "Aktif"],
  [2032, "Penicillium roqueforti", "No", "No", "Aktif"],
  [2033, "penyangga bunga teratai", "No", "No", "Nonaktif"],
  [2034, "Pepaya Gunung/Karika", "No", "No", "Aktif"],
  [2035, "Pepermint (Peppermint)", "No", "No", "Aktif"],
  [2036, "Pepermint Bubuk (Peppermint Powder)", "No", "No", "Aktif"],
  [2037, "Peptida Kolagen (Collagen Peptide)", "Yes", "No", "Aktif"],
  [2038, "Perasan Air Jeruk (Lemon Juice)", "No", "No", "Aktif"],
  [2039, "Perisa Test", "No", "No", "Nonaktif"],
  [2040, "PETAI (BITTER BEAN)", "No", "No", "Aktif"],
  [2041, "PETAI CINA (WHITE LEADTREE)", "No", "No", "Aktif"],
  [2042, "Peterseli (Parsley)", "No", "No", "Aktif"],
  [2043, "Peterseli Bubuk (Parsley Powder)", "No", "No", "Aktif"],
  [2044, "Pilus", "No", "No", "Aktif"],
  [2045, "Pimenta (Pimenta)", "No", "No", "Aktif"],
  [2046, "Pimento (Allspice)", "No", "No", "Aktif"],
  [2047, "Pimento Bubuk (Allspice Powder)", "No", "No", "Aktif"],
  [2048, "PINANG (ARECA NUT)", "No", "No", "Nonaktif"],
  [2049, "Pinto Beans (Kacang Pinto)", "No", "No", "Aktif"],
  [2050, "PIR (PEAR)", "No", "No", "Aktif"],
  [
    2051,
    "PIRIDOKSIN HIDROKLORIDA (VITAMIN B6)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2052, "Pisang (Banana)", "No", "No", "Aktif"],
  [2053, "Pisang Bubuk (Banana Powder)", "No", "No", "Aktif"],
  [2054, "Pizza Bubuk Ekstrak", "No", "No", "Nonaktif"],
  [
    2055,
    "PLANT STANOL ESTER-FITOSTANOL (PHYTOSTANOL)",
    "No",
    "No",
    "Aktif",
  ],
  [2056, "Polidekstrosa (Polydextrose)", "No", "No", "Aktif"],
  [2057, "Polifruktosa (Polyfructose)", "No", "No", "Aktif"],
  [2058, "Polisakarida (Polysaccharides)", "No", "No", "Aktif"],
  [2059, "POTONGAN BUAH APEL (APPLE SLICES)", "No", "No", "Aktif"],
  [2060, "POTONGAN KENTANG (POTATO SLICES)", "No", "No", "Aktif"],
  [2061, "Pottasium Aspartate", "No", "No", "Aktif"],
  [2062, "Praline (Praline)", "No", "No", "Aktif"],
  [2063, "PREM (PLUM)", "No", "No", "Aktif"],
  [2064, "PREM ASIN (SALTED PLUM)", "No", "No", "Aktif"],
  [2065, "PREMIKS MINERAL (MINERAL PREMIX)", "No", "No", "Aktif"],
  [2066, "Premiks Vitamin (Vitamin Premix)", "No", "No", "Aktif"],
  [
    2067,
    "PREMIKS VITAMIN DAN  MINERAL (VITAMIN AND MINERAL PREMIX)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2068,
    "Preparat Perisa (Flavoring Preparation)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2069, "PROPOLIS (PROPOLLIS)", "No", "No", "Nonaktif"],
  [2070, "Protein Gandum (Wheat Protein)", "No", "No", "Aktif"],
  [
    2071,
    "Protein Jagung Terhidrolisa (Hydrolized Corn Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [2072, "Protein Kedelai (Soy Protein)", "No", "No", "Aktif"],
  [
    2073,
    "PROTEIN KEDELAI TERHIDROLISA (HYDROLIZED SOY PROTEIN)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2074, "PROTEIN NABATI (VEGETABLE PROTEIN)", "No", "No", "Aktif"],
  [2075, "Protein Nabati Terhidrolisa", "No", "No", "Nonaktif"],
  [2076, "protein nabati terhirolisa", "No", "No", "Nonaktif"],
  [2077, "Protein nabati tertekstur", "No", "No", "Nonaktif"],
  [2078, "Protein Susu (Milk Protein)", "No", "No", "Aktif"],
  [
    2079,
    "Protein Susu Fermentasi (Fermented Milk Protein)",
    "No",
    "No",
    "Aktif",
  ],
  [2080, "PRUNELLA VULGARIS", "No", "No", "Nonaktif"],
  [2081, "PSYLLIUM HUSK", "No", "No", "Aktif"],
  [2082, "Puff Gandum (Wheat Puffed)", "No", "No", "Aktif"],
  [2083, "Puree Apel (Apple Puree)", "No", "No", "Aktif"],
  [2084, "PUREE BAWANG PUTIH (GARLIC PUREE)", "No", "No", "Aktif"],
  [2085, "PUREE BLACKBERRY (BLACKBERRY PUREE)", "No", "No", "Aktif"],
  [
    2086,
    "Puree Blackcurrant (Blackcurrant Puree)",
    "No",
    "No",
    "Aktif",
  ],
  [2087, "PUREE BLUBERI (BLUEBERRY PUREE)", "No", "No", "Aktif"],
  [2088, "PUREE BUAH LAINNYA (FRUIT PUREE)", "No", "No", "Aktif"],
  [2089, "Puree Ceri (Cherry Puree)", "No", "No", "Aktif"],
  [2090, "Puree Jambu Biji (Guava Puree)", "No", "No", "Aktif"],
  [2091, "PUREE JAMBU MERAH", "No", "No", "Nonaktif"],
  [2092, "Puree Kurma", "No", "No", "Aktif"],
  [2093, "Puree Leci (Lyche Puree)", "No", "No", "Aktif"],
  [2094, "Puree Mangga (Mango Puree)", "No", "No", "Aktif"],
  [2095, "PUREE MIX BERRY (MIX BERRY PUREE)", "No", "No", "Aktif"],
  [2096, "Puree Persik (Peach Puree)", "No", "No", "Aktif"],
  [2097, "PUREE PIR (PEAR PUREE)", "No", "No", "Aktif"],
  [2098, "Puree Sirsak (Soursop Puree)", "No", "No", "Aktif"],
  [2099, "Puree Stroberi (Strawberry Puree)", "No", "No", "Aktif"],
  [2100, "Puree Tomat (Tomato Puree)", "No", "No", "Aktif"],
  [2101, "PUTIH TELUR (EGG WHITE)", "No", "No", "Aktif"],
  [
    2102,
    "PUTIH TELUR BUBUK (EGG WHITE POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [2103, "PUTIH TELUR PADAT (EGG WHITE SOLID)", "No", "No", "Aktif"],
  [
    2104,
    "QUERCETIN (BERUPA ISOLAT DARI BANYAK TANAMAN)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2105, "Rafinosa (Raffinose)", "No", "No", "Aktif"],
  [2106, "Ragi (Yeast)", "No", "No", "Aktif"],
  [2107, "Ragi Bubuk (Yeast Powder)", "No", "No", "Aktif"],
  [2108, "Ragi Instan (Instant Yeast)", "No", "No", "Aktif"],
  [2109, "Ragi Kering (Dried Yeast)", "No", "No", "Aktif"],
  [2110, "Ragi Padat (Solid Yeast)", "No", "No", "Aktif"],
  [2111, "Ragi Roti", "No", "No", "Nonaktif"],
  [2112, "RAGI ROTI (BAKER YEAST)", "No", "No", "Aktif"],
  [2113, "Ragi Tape", "No", "No", "Aktif"],
  [2114, "Rajungan", "No", "No", "Aktif"],
  [2115, "Rambutan (Rambutan)", "No", "No", "Aktif"],
  [
    2116,
    "REBUNG (BAMBOO SPROUTS-BAMBOO SHOOTS)",
    "No",
    "No",
    "Aktif",
  ],
  [2117, "Rebung Kelapa Sawit (Palm Heart)", "No", "No", "Aktif"],
  [
    2118,
    "red currant leaves (ribes rubrum)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2119,
    "REHMANNIA GLUTINOSA (REHMANNIA GLUTINOSE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2120, "REMAHAN BAWANG HIJAU", "No", "No", "Aktif"],
  [2121, "REMAHAN BISKUIT (BISCUIT CRUMB)", "No", "No", "Aktif"],
  [
    2122,
    "REMAHAN HOKEY POKEY (HOKEY POKEY CRUMB)",
    "No",
    "No",
    "Aktif",
  ],
  [2123, "REMAHAN TELUR", "No", "No", "Aktif"],
  [2124, "Remahan wafer", "No", "No", "Aktif"],
  [2125, "Remis Bubuk (Mussel Powder)", "No", "No", "Aktif"],
  [2126, "Remis Kering (Dried Mussel)", "No", "No", "Aktif"],
  [2127, "Rempah (Spices)", "No", "No", "Aktif"],
  [2128, "Rennet (Rennet)", "No", "No", "Aktif"],
  [2129, "Resin Gum (Gum Resin)", "No", "No", "Aktif"],
  [2130, "Retinil Asetat (Retinyl Acetate)", "No", "No", "Aktif"],
  [
    2131,
    "Retinil Palmitat (Retinyl Palmitate)",
    "No",
    "No",
    "Aktif",
  ],
  [2132, "Rhodopseudomonas palustris", "No", "No", "Aktif"],
  [
    2133,
    "rhubarb batang (rheum rhabarbarum)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2134, "Riboflavin (vitamin B2)", "No", "No", "Nonaktif"],
  [2135, "RIMPANG TERATAI (LOTUS ROOT)", "No", "No", "Nonaktif"],
  [2136, "Rolled Oats", "No", "No", "Aktif"],
  [
    2137,
    "rooibos-rooibush-rooibosh (asphalatus linearis)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2138, "Roombutter (Roombutter)", "No", "No", "Aktif"],
  [2139, "ROOT BEER BASE", "Yes", "Yes", "Aktif"],
  [2140, "ROSEHIP PEELS (ROSA CANINA)", "No", "No", "Aktif"],
  [2141, "ROSELA (HIBISCUS SABDARIFFA)", "No", "No", "Aktif"],
  [2142, "ROSEMARI (ROSEMARY)", "No", "No", "Nonaktif"],
  [2143, "Roti (Bread)", "No", "No", "Aktif"],
  [2144, "Roti Kering (Crusty Bread)", "No", "No", "Aktif"],
  [2145, "ROYAL JELLY (KHUSUS MADU)", "No", "No", "Aktif"],
  [2146, "Rum (Rum)", "No", "No", "Aktif"],
  [2147, "Rumput Laut (Seaweed)", "No", "No", "Aktif"],
  [2148, "Rumput Laut Bubuk (Seaweed Powder)", "No", "No", "Aktif"],
  [2149, "Rumput Laut Kering (Dried Seaweed)", "No", "No", "Aktif"],
  [2150, "SAFRON (SAFFRON)", "No", "No", "Aktif"],
  [2151, "SAGE (SALVIA OFFICINALIS)", "No", "No", "Nonaktif"],
  [2152, "Sagu (Sago)", "No", "No", "Aktif"],
  [2153, "Sake (Sake)", "No", "No", "Aktif"],
  [2154, "Salak", "No", "No", "Aktif"],
  [
    2155,
    "Salicornia herbacea L (Salicornia europaea L)",
    "No",
    "No",
    "Aktif",
  ],
  [2156, "SAMBAL (SAUCE)", "No", "No", "Aktif"],
  [2157, "Sambal Seafood (Seafood Sauce)", "No", "No", "Aktif"],
  [
    2158,
    "SAMBILOTO (ANDROGRAPHIS PANICULATA)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2159, "SAMBUCUS NIGRA", "No", "No", "Nonaktif"],
  [2160, "Santan Kelapa (Coconut Milk)", "No", "No", "Aktif"],
  [
    2161,
    "Santan Kelapa Bubuk (Coconut Milk Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2162,
    "SANTAN KELAPA MURNI (PURE COCONUT MILK)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2163,
    "Sarang Burung Walet (Swallow's Nest)",
    "No",
    "No",
    "Aktif",
  ],
  [2164, "Sari Asam (Tamarind Juice)", "No", "No", "Aktif"],
  [2165, "Sari Asam Jawa (Tamarind Juice)", "No", "No", "Aktif"],
  [2166, "SARI AYAM (CHICKEN ESSENCE)", "No", "No", "Nonaktif"],
  [2167, "Sari Bawang Bombay (Onion Juice)", "No", "No", "Aktif"],
  [2168, "Sari Beras (Grains of Rice)", "No", "No", "Aktif"],
  [2169, "SARI BERAS MERAH (BROWN RICE JUICE)", "No", "No", "Aktif"],
  [2170, "Sari Buah ...... Rekonstitusi", "No", "No", "Aktif"],
  [2171, "Sari Buah Anggur (Grape Juice)", "No", "No", "Aktif"],
  [2172, "SARI BUAH ANGGUR BUBUK", "No", "No", "Aktif"],
  [
    2173,
    "Sari Buah Anggur Hijau  (Green Grape Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2174,
    "Sari Buah Anggur Merah (Red Grape Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2175,
    "Sari Buah Anggur Muscat (Muscat Grape Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2176,
    "Sari Buah Anggur Putih  (White Grape Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2177,
    "SARI BUAH ANGGUR REKONSTITUSI (GRAPE JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [2178, "Sari Buah Apel (Apple Juice)", "No", "No", "Aktif"],
  [
    2179,
    "SARI BUAH APEL REKONSTITUSI (APPLE JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [2180, "Sari Buah Apricot (Apricot Juice)", "No", "No", "Aktif"],
  [2181, "SARI BUAH ARBEI (ARBEI JUICE)", "No", "No", "Aktif"],
  [2182, "Sari Buah Aren", "No", "No", "Aktif"],
  [2183, "Sari Buah Aronia (Aronia Juice)", "No", "No", "Aktif"],
  [
    2184,
    "SARI BUAH ASAM JAWA (TAMARIND JUICE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2185,
    "Sari Buah Belimbing (Starfruit Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [2186, "Sari Buah Bilberry (Bilberry Juice)", "No", "No", "Aktif"],
  [
    2187,
    "Sari Buah Blackberry (Blackberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2188,
    "Sari Buah Blackcurant (Blackcurrant Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2189,
    "Sari Buah Blackcurrant Bubuk (blackcurrant juice powder)",
    "No",
    "No",
    "Aktif",
  ],
  [2190, "Sari Buah Blewah (Cantaloupe Juice)", "No", "No", "Aktif"],
  [
    2191,
    "Sari Buah Blueberry (Blueberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [2192, "Sari Buah Ceri (Cherry Juice)", "No", "No", "Aktif"],
  [
    2193,
    "Sari Buah Chokeberry (Chokeberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2194,
    "Sari Buah Cranberry (Cranberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2195,
    "SARI BUAH CRANBERRY REKONSTITUSI (CRANBERRY JUICE RECONSTITUTION) ",
    "No",
    "No",
    "Aktif",
  ],
  [
    2196,
    "Sari Buah Delima (Pomegranate Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2197,
    "SARI BUAH FRAMBOZEN (FRAMBOZEN JUICE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2198,
    "SARI BUAH GOJIBERRY (GOJIBERRY JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2199,
    "Sari Buah Gooseberry (Gooseberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [2200, "Sari Buah Jambu", "No", "No", "Aktif"],
  [2201, "Sari Buah Jambu Biji (Guava Juice)", "No", "No", "Aktif"],
  [2202, "SARI BUAH JAMBU MERAH", "No", "No", "Nonaktif"],
  [2203, "Sari Buah Jeruk (Orange Juice)", "No", "No", "Aktif"],
  [
    2204,
    "SARI BUAH JERUK BUBUK (ORANGE JUICE POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [2205, "Sari Buah Jeruk Florida-Jeruk .....", "No", "No", "Aktif"],
  [2206, "Sari Buah Jeruk Kalamansi", "No", "No", "Aktif"],
  [2207, "Sari Buah Jeruk Lemon (Lemon Juice)", "No", "No", "Aktif"],
  [2208, "SARI BUAH JERUK LIMAU (LIMAU JUICE)", "No", "No", "Aktif"],
  [2209, "Sari Buah Jeruk Mandarin", "No", "No", "Aktif"],
  [2210, "Sari Buah Jeruk Nipis", "No", "No", "Aktif"],
  [
    2211,
    "SARI BUAH JERUK REKONSTITUSI (ORANGE JUICE RECONSTITUTION) ",
    "No",
    "No",
    "Aktif",
  ],
  [2212, "SARI BUAH KELAPA (COCONUT JUICE)", "No", "No", "Aktif"],
  [2213, "Sari Buah Kiwi (Kiwi Juice)", "No", "No", "Aktif"],
  [
    2214,
    "Sari Buah Kranberi (Cranberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2215,
    "SARI BUAH KUNDUR (BENINCASA HISPIDA JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [2216, "SARI BUAH KURMA (DATES JUICE)", "No", "No", "Aktif"],
  [2217, "Sari Buah Labu (Pumpkin Juice)", "No", "No", "Aktif"],
  [2218, "Sari Buah Leci (Lychee Juice)", "No", "No", "Aktif"],
  [2219, "Sari Buah Mangga (Mango Juice)", "No", "No", "Aktif"],
  [
    2220,
    "SARI BUAH MANGGA BUBUK (MANGO JUICE POWDER)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [
    2221,
    "Sari Buah Manggis (Mangosteen Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2222,
    "Sari Buah Markisa (Passion Fruit Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2223,
    "SARI BUAH MARKISA REKONSTITUSI (PASSION FRUIT JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [2224, "SARI BUAH MELON (MELON JUICE)", "No", "No", "Aktif"],
  [2225, "Sari Buah Nanas (Pineapple Juice)", "No", "No", "Aktif"],
  [
    2226,
    "SARI BUAH NANAS REKONSTITUSI (PINEAPPLE JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [2227, "Sari Buah Nangka (Jackfruit Juice)", "No", "No", "Aktif"],
  [2228, "Sari Buah Pala (Nutmeg Juice)", "No", "No", "Aktif"],
  [
    2229,
    "SARI BUAH PEAR REKONSTITUSI (PEAR JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [2230, "Sari Buah Pepaya (Papaya Juice)", "No", "No", "Aktif"],
  [2231, "Sari Buah Persik (Peach Juice)", "No", "No", "Aktif"],
  [2232, "Sari Buah Pir (Pear Juice)", "No", "No", "Aktif"],
  [2233, "Sari Buah Pisang (Banana Juice)", "No", "No", "Aktif"],
  [2234, "Sari Buah Plum (Plum Juice)", "No", "No", "Aktif"],
  [2235, "Sari Buah Prune (Prune Juice)", "No", "No", "Aktif"],
  [
    2236,
    "Sari Buah Raspberi (Raspberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2237,
    "SARI BUAH RASPBERI REKONSTITUSI (RASPBERRY JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2238,
    "Sari Buah Redcurrant (Redcurrant Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2239,
    "Sari Buah Semangka (Watermelon Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [2240, "Sari Buah Sirsak (Soursop Juice)", "No", "No", "Aktif"],
  [
    2241,
    "SARI BUAH SIWALAN (PALMYRA FRUIT JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2242,
    "Sari Buah Stroberi (Strawberry Juice)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2243,
    "SARI BUAH STROBERI REKONSTITUSI (STRAWBERRY JUICE RECONSTITUTION)",
    "No",
    "No",
    "Aktif",
  ],
  [2244, "Sari Buah Terong (Eggplant Juice)", "No", "No", "Aktif"],
  [
    2245,
    "SARI BUAH TERONG BELANDA (TAMARILLO JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [2246, "Sari Buah Tomat (Tomato Juice)", "No", "No", "Aktif"],
  [2247, "SARI BUNGA MAWAR (ROSE JUICE)", "No", "No", "Nonaktif"],
  [2248, "SARI DAGING AYAM", "No", "No", "Nonaktif"],
  [2249, "SARI DAGING SAPI", "No", "No", "Nonaktif"],
  [
    2250,
    "SARI DAUN CINCAU (GRASS JELLY JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [2251, "SARI DAUN KATUK (KATUK JUICE)", "No", "No", "Aktif"],
  [2252, "SARI DAUN PANDAN (PANDAN JUICE)", "No", "No", "Aktif"],
  [2253, "Sari Jagung (Corn Juice)", "No", "No", "Aktif"],
  [2254, "Sari Jahe (Ginger Juice)", "No", "No", "Aktif"],
  [2255, "SARI JAHE MERAH (RED GINGER JUICE)", "No", "No", "Aktif"],
  [2256, "Sari Kacang Almond (Almond Juice)", "No", "No", "Aktif"],
  [2257, "Sari Kacang Kedelai (Soy Juice)", "No", "No", "Aktif"],
  [
    2258,
    "SARI KACANG KEDELAI BUBUK (SOY JUICE POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2259,
    "SARI KACANG KEDELAI HITAM (BLACK SOYBEAN JUICE)",
    "No",
    "No",
    "Aktif",
  ],
  [2260, "Sari Kelapa (Coconut Juice)", "No", "No", "Aktif"],
  [2261, "SARI KERANG ABALONE (ABALONE JUICE)", "No", "No", "Aktif"],
  [2262, "Sari Kopi (Coffee Juice)", "No", "No", "Aktif"],
  [2263, "Sari Kunyit (Turmeric Juice)", "No", "No", "Aktif"],
  [2264, "Sari Lidah Buaya (Aloe Vera Juice)", "No", "No", "Aktif"],
  [2265, "Sari Malt (Malt Juice)", "No", "No", "Aktif"],
  [2266, "Sari Rosella (Rosella Juice)", "No", "No", "Aktif"],
  [2267, "Sari Rumput Laut (Seaweed Juice)", "No", "No", "Aktif"],
  [2268, "Sari Sayuran (Vegetable Juice)", "No", "No", "Aktif"],
  [2269, "Sari Seledri (Celery Juice)", "No", "No", "Aktif"],
  [2270, "SARI TAPE (TAPAI JUICE)", "No", "No", "Aktif"],
  [2271, "Sari Tebu (Sugar Cane Juice)", "No", "No", "Aktif"],
  [2272, "Sari Tiram (Oyster Juice)", "No", "No", "Aktif"],
  [2273, "Sari Wortel (Carrot Juice)", "No", "No", "Aktif"],
  [2274, "SAUS (SAUCE)", "Yes", "No", "Aktif"],
  [2275, "SAUS BARBEKUE (BARBEQUE SAUCE)", "No", "No", "Aktif"],
  [2276, "SAUS BUAH (FRUIT SAUCE)", "No", "No", "Aktif"],
  [
    2277,
    "Saus Buah Blueberry (Blueberry Sauce)",
    "No",
    "No",
    "Aktif",
  ],
  [2278, "Saus Buah Jambu (Guava Sauce)", "No", "No", "Aktif"],
  [
    2279,
    "Saus Buah Markisa (Passion Fruit Sauce)",
    "No",
    "No",
    "Aktif",
  ],
  [2280, "Saus Buah Pepaya (Papaya Sauce)", "No", "No", "Aktif"],
  [2281, "Saus Buah Pisang (Banana Sauce)", "No", "No", "Aktif"],
  [
    2282,
    "SAUS BUAH STROBERI (STRAWBERRY SAUCE)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2283,
    "Saus Buffalo Style (Buffalo Style Sauce)",
    "No",
    "No",
    "Aktif",
  ],
  [2284, "Saus Cabe (Chili Sauce)", "No", "No", "Aktif"],
  [2285, "Saus Coklat (Chocolate Sauce)", "No", "No", "Aktif"],
  [2286, "Saus Durian (Durian Sauce)", "No", "No", "Aktif"],
  [2287, "Saus Ikan (Fish Sauce)", "No", "No", "Aktif"],
  [2288, "Saus Ikan Teri (Anchovy Sauce)", "No", "No", "Aktif"],
  [2289, "Saus Kacang (Peanut Sauce)", "No", "No", "Aktif"],
  [2290, "SAUS KACANG KEDELAI (SOYBEAN SAUCE)", "No", "No", "Aktif"],
  [2291, "SAUS KAPUCINO (CAPPUCINNO SAUCE)", "No", "No", "Aktif"],
  [2292, "SAUS KEJU (CHEESE SAUCE)", "Yes", "Yes", "Aktif"],
  [2293, "SAUS KOPI (COFFEE SAUCE)", "No", "No", "Aktif"],
  [2294, "SAUS TAR TAR (TAR TAR SAUCE)", "No", "No", "Aktif"],
  [2295, "Saus Teriyaki (Teriyaki Sauce)", "No", "No", "Aktif"],
  [2296, "Saus Tiram (Oyster Sauce)", "No", "No", "Aktif"],
  [2297, "Saus Tomat (Tomato Sauce)", "No", "No", "Aktif"],
  [2298, "Saus/ Topping/ Olesan/ Pasta Manis", "No", "No", "Aktif"],
  [2299, "Sawi (Mustard Greens)", "No", "No", "Aktif"],
  [2300, "SAWI PUTIH (CHINESE CABBAGE)", "No", "No", "Aktif"],
  [2301, "Sawo (Sapodilla)", "No", "No", "Aktif"],
  [2302, "Sayap Ayam (Chicken Wing)", "No", "No", "Aktif"],
  [2303, "SAYUR BUBUK (VEGETABLE POWDER)", "No", "No", "Aktif"],
  [2304, "Sayuran Beku (Frozen Vegetable)", "No", "No", "Aktif"],
  [2305, "SAYURAN KERING (DRY VEGETABLE)", "No", "No", "Aktif"],
  [
    2306,
    "Sayuran kering (Kubis, protein nabati tertekstur, bawang putih goreng, wortel)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2307,
    "Sayuran Okra (Abelmoschus esculentus)",
    "No",
    "No",
    "Aktif",
  ],
  [2308, "Scoby", "No", "No", "Aktif"],
  [
    2309,
    "SCUTELLARIA BAICALENSIS (ASIAN SKULLCAP, BAIKAL SKULLCAP, GOLDEN ROOT)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2310,
    "Seabuckthorn (Hippophae Rhamnoides L)",
    "No",
    "No",
    "Aktif",
  ],
  [2311, "SEAFOOD KERING (DRY SEAFOOD)", "No", "No", "Aktif"],
  [2312, "Selada (Lettuce)", "No", "No", "Aktif"],
  [
    2313,
    "SELADA AIR (WATERCRESS) (FOLIUM NOSTURTIUM OFFICINALE)",
    "No",
    "No",
    "Aktif",
  ],
  [2314, "SELAI (JAM)", "No", "No", "Aktif"],
  [2315, "Selai Anggur (Grape Jam)", "No", "No", "Aktif"],
  [2316, "Selai Apel (Apple Jam)", "No", "No", "Aktif"],
  [2317, "Selai Aprikot (Apricot Jam)", "No", "No", "Aktif"],
  [2318, "Selai Belimbing (Starfruit Jam)", "No", "No", "Aktif"],
  [2319, "SELAI BLUBERI (BLUEBERRY JAM)", "No", "No", "Aktif"],
  [2320, "Selai Buah-Buahan (Fruits Jam)", "No", "No", "Aktif"],
  [2321, "Selai Ceri (Cherry Jam)", "No", "No", "Aktif"],
  [2322, "SELAI COKELAT (CHOCOLATE JAM)", "No", "No", "Aktif"],
  [2323, "Selai Durian (Durian Jam)", "No", "No", "Aktif"],
  [2324, "Selai Jeruk (Orange Jam)", "No", "No", "Aktif"],
  [2325, "Selai Kacang (Peanut Jam)", "No", "No", "Aktif"],
  [2326, "Selai Kelapa (Coconut Jam)", "No", "No", "Aktif"],
  [2327, "Selai Kiwi (Kiwi Jam)", "No", "No", "Aktif"],
  [2328, "Selai Kurma (Dates Jam)", "No", "No", "Aktif"],
  [2329, "Selai Nanas (Pineapple Jam)", "No", "No", "Aktif"],
  [2330, "Selai Nangka (Jackfruit Jam)", "No", "No", "Aktif"],
  [2331, "Selai Pisang (Banana Jam)", "No", "No", "Aktif"],
  [2332, "Selai Rasberi (Raspberry Jam)", "No", "No", "Aktif"],
  [2333, "SELAI SRIKAYA (SWEETSOP JAM)", "No", "No", "Aktif"],
  [2334, "Selai Stroberi (Strawberry Jam)", "No", "No", "Aktif"],
  [2335, "Selasih (Basil)", "No", "No", "Aktif"],
  [2336, "Seledri (Celery)", "No", "No", "Aktif"],
  [2337, "Seledri Bubuk (Celery Powder)", "No", "No", "Aktif"],
  [2338, "Selenium (Selenium)", "No", "No", "Aktif"],
  [2339, "SELONGSONG SOSIS (SAUSAGE SLEEVE)", "No", "No", "Aktif"],
  [2340, "Selulosa (Cellulose)", "No", "No", "Aktif"],
  [2341, "Semangka Merah (Red Watermelon)", "No", "No", "Aktif"],
  [2342, "SEMOLINA", "No", "No", "Aktif"],
  [2343, "Seng", "No", "No", "Nonaktif"],
  [2344, "Seng Laktat (Zinc Lactate)", "No", "No", "Aktif"],
  [2345, "Seng Oksida (Zinc Oxide)", "No", "No", "Aktif"],
  [2346, "Seng Sulfat (Zinc Sulphate)", "No", "No", "Aktif"],
  [2347, "SERAT GANDUM (WHEAT FIBER)", "No", "No", "Aktif"],
  [2348, "SERAT LARUT (SOLUBLE FIBER)", "No", "No", "Nonaktif"],
  [
    2349,
    "Serat Larut dari Jagung (Soluble Corn Fiber atau Gluco Fibre)",
    "No",
    "No",
    "Aktif",
  ],
  [2350, "Serat Pangan", "No", "No", "Nonaktif"],
  [2351, "Serat Pangan (Dietary Fiber)", "No", "No", "Aktif"],
  [2352, "Serat Sayuran (Vegetable Fiber)", "No", "No", "Aktif"],
  [2353, "Serbu Sari Buah Raspberi", "No", "No", "Nonaktif"],
  [
    2354,
    "Serbuk Kale (Brassica Oleracea L.var. acephala)",
    "No",
    "No",
    "Aktif",
  ],
  [2355, "Serbuk Minuman", "No", "No", "Aktif"],
  [2356, "Serbuk Sari (Pollen)", "No", "No", "Aktif"],
  [2357, "Sereal (Cereal)", "No", "No", "Aktif"],
  [2358, "Sereal Beras (Rice Cereal)", "No", "No", "Aktif"],
  [2359, "Sereal Gandum (Wheat Cereal)", "No", "No", "Aktif"],
  [
    2360,
    "Sereal Gandum Utuh (Whole Wheat Cereal)",
    "No",
    "No",
    "Aktif",
  ],
  [2361, "Sereal Jagung (Corn Cereal)", "No", "No", "Aktif"],
  [2362, "Serealia (Cerealia)", "No", "No", "Aktif"],
  [
    2363,
    "SEREH (LEMON GRASS-CYMBOPOGON NARDUS)",
    "No",
    "No",
    "Aktif",
  ],
  [2364, "Sereh Bubuk (Lemongrass Powder)", "No", "No", "Aktif"],
  [2365, "SERPIHAN KENTANG (POTATO FLAKES)", "No", "No", "Aktif"],
  [2366, "Serundeng Ikan (Fish Serundeng)", "No", "No", "Aktif"],
  [2367, "Silver Needle-yingzhen (white tea)", "No", "No", "Aktif"],
  [2368, "SINGKONG - UBI KAYU (CASSAVA)", "No", "No", "Aktif"],
  [2369, "Singkong Bubuk (Cassava Powder)", "No", "No", "Aktif"],
  [2370, "SIOMAY", "Yes", "No", "Nonaktif"],
  [2371, "SIRIH (BETEL)", "No", "No", "Nonaktif"],
  [2372, "SIRIH EKSTRAK (PIPER BETLE L.)", "No", "No", "Nonaktif"],
  [2373, "Sirip Ikan Hiu (Shark Fins)", "No", "No", "Aktif"],
  [2374, "Sirsak (Soursop)", "No", "No", "Aktif"],
  [2375, "Sirup (Syrup)", "No", "No", "Aktif"],
  [2376, "Sirup Agave (Agave Syrup)", "No", "No", "Aktif"],
  [2377, "Sirup Anggur (Grape Syrup)", "No", "No", "Aktif"],
  [
    2378,
    "Sirup Barley Malt (Barley Malt Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [2379, "Sirup Beras (Rice Syrup)", "No", "No", "Aktif"],
  [
    2380,
    "Sirup Beras Merah (Brown Rice Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2381,
    "Sirup Cokelat Malt (Chocolate Malt Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [2382, "Sirup Fruktosa (Fructose Syrup)", "No", "No", "Aktif"],
  [
    2383,
    "SIRUP FRUKTOSA JAGUNG (FRUCTOSE CORN SYRUP)",
    "No",
    "No",
    "Aktif",
  ],
  [2384, "Sirup Glukosa", "No", "No", "Nonaktif"],
  [2385, "Sirup Glukosa (Glucose Syrup)", "No", "No", "Aktif"],
  [
    2386,
    "SIRUP GLUKOSA - FRUKTOSA (GLUCOSE - FRUCTOSE SYRUP)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2387,
    "SIRUP GLUKOSA BUBUK (GLUCOSE POWDER SYRUP)",
    "No",
    "No",
    "Aktif",
  ],
  [2388, "Sirup Grenadine (Grenadine Syrup)", "No", "No", "Aktif"],
  [2389, "Sirup Gula (Sugar Syrup)", "No", "No", "Aktif"],
  [
    2390,
    "Sirup Gula Invert (Invert Sugar Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2391,
    "SIRUP GULA JAGUNG (CORN SUGAR SYRUP)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2392,
    "Sirup Gula Merah (Brown Sugar Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2393,
    "SIRUP GULA TERKARAMELISASI (CARAMELIZED SUGAR SYRUP)",
    "No",
    "No",
    "Aktif",
  ],
  [2394, "Sirup Jagung (Corn Syrup)", "No", "No", "Aktif"],
  [
    2395,
    "Sirup Jagung Fruktosa (Fructose Corn Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2396,
    "Sirup Jagung Padat (Corn Syrup Solid)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2397,
    "Sirup Jagung Tinggi Fruktosa (High Fructose Corn Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2398,
    "Sirup Jagung Tinggi Maltosa (High Maltose Corn Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [2399, "Sirup Jahe (Ginger Syrup)", "No", "No", "Aktif"],
  [2400, "Sirup Karamel (Caramel Syrup)", "No", "No", "Aktif"],
  [2401, "Sirup Kelengkeng (Longan Syrup)", "No", "No", "Aktif"],
  [2402, "Sirup Kiwi (Kiwi Syrup)", "No", "No", "Aktif"],
  [2403, "Sirup Kurma (Dates Syrup)", "No", "No", "Aktif"],
  [2404, "Sirup Malt (Malt Syrup)", "No", "No", "Aktif"],
  [2405, "SIRUP MAPEL (MAPLE SYRUP)", "No", "No", "Aktif"],
  [2406, "Sirup Melon (Melon Syrup)", "No", "No", "Aktif"],
  [2407, "Sirup Semangka (Watermelon Syrup)", "No", "No", "Aktif"],
  [2408, "Sirup Stroberi (Strawberry Syrup)", "No", "No", "Aktif"],
  [2409, "Sirup Sukrosa (Sucrose Syrup)", "No", "No", "Aktif"],
  [2410, "SIRUP TAPIOKA (TAPIOCA SYRUP)", "No", "No", "Aktif"],
  [
    2411,
    "Sirup Tinggi Fruktosa (High Fructose Syrup)",
    "No",
    "No",
    "Aktif",
  ],
  [2412, "Sistein (Cysteine)", "No", "No", "Aktif"],
  [2413, "Sistin (Cystine)", "No", "No", "Aktif"],
  [
    2414,
    "SITIDIN 5'-MONOFOSFAT (CYTIDINE 5'-MONOPHOSPHATE)",
    "No",
    "No",
    "Aktif",
  ],
  [2415, "Sitrulin Malat", "No", "No", "Aktif"],
  [2416, "SIWALAN (SIWALAN)", "No", "No", "Aktif"],
  [2417, "SOBA (BUCKWHEAT)", "No", "No", "Nonaktif"],
  [2418, "Soda (Soda)", "No", "No", "Aktif"],
  [2419, "SODA BUBUK (SODA POWDER)", "No", "No", "Nonaktif"],
  [2420, "Soda Krim (Cream Soda)", "No", "No", "Aktif"],
  [2421, "Sohun-Soun (Vermicelli)", "No", "No", "Aktif"],
  [2422, "Sorgum (Sorghum)", "No", "No", "Aktif"],
  [2423, "Sosis Ayam (Chicken Sausage)", "No", "No", "Aktif"],
  [2424, "Sosis Babi (Pork Sausage)", "No", "No", "Aktif"],
  [2425, "Sosis Ikan (Fish Sausage)", "No", "No", "Aktif"],
  [2426, "Sosis Sapi (Beef Sausage)", "No", "No", "Aktif"],
  [2427, "Sotong (Cuttlefish)", "No", "No", "Aktif"],
  [2428, "Sotong Bubuk (Cuttlefish Powder)", "No", "No", "Aktif"],
  [2429, "Spagheti (Spaghetti)", "No", "No", "Aktif"],
  [2430, "Spearmint (Spearmint)", "No", "No", "Aktif"],
  [2431, "Spelt (Triticum spelta)", "No", "No", "Aktif"],
  [2432, "SPINGOMIELIN (SPHINGOMYELIN)", "No", "No", "Nonaktif"],
  [2433, "Spirit (Spirit)", "No", "No", "Aktif"],
  [2434, "Spirit Air Nira (Sap Water Spirit)", "No", "No", "Aktif"],
  [2435, "Spirit Anggur (Grape Spirit)", "No", "No", "Aktif"],
  [2436, "Spirit Beras (Rice Spirit)", "No", "No", "Aktif"],
  [
    2437,
    "Spirit Beras Ketan (Glutinous Rice Spirit)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2438,
    "Spirit Buah Nanas (Pineapple Spirit)",
    "No",
    "No",
    "Aktif",
  ],
  [2439, "Spirit Buah Pepaya (Papaya Spirit)", "No", "No", "Aktif"],
  [2440, "Spirit Buah Tomat (Tomato Spirit)", "No", "No", "Aktif"],
  [2441, "Spirit Gula (Sugar Spirit)", "No", "No", "Aktif"],
  [
    2442,
    "Spirit Gula Merah (Brown Sugar Spirit)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2443,
    "SPIRIT HASIL FERMENTASI MOLASES (FERMENTED MOLASES SPIRIT)",
    "No",
    "No",
    "Aktif",
  ],
  [2444, "Spirit Jeruk (Orange Spirit)", "No", "No", "Aktif"],
  [2445, "Spirit Lontar (Palmyra Spirit)", "No", "No", "Aktif"],
  [2446, "Spirulina (Spirulina)", "No", "No", "Aktif"],
  [2447, "Spirulina Bubuk (Spirulina Powder)", "No", "No", "Aktif"],
  [
    2448,
    "SQUASH BERPERISA ANGGUR (GRAPE FLAVOUR SQUASH)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2449,
    "SQUASH BERPERISA JERUK (ORANGE FLAVOUR SQUASH)",
    "No",
    "No",
    "Aktif",
  ],
  [2450, "Squash Berperisa Kelapa ", "No", "No", "Aktif"],
  [
    2451,
    "SQUASH BERPERISA LECI (LYCHEE FLAVOUR SQUASH)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2452,
    "SQUASH BERPERISA STROBERI  (STRAWBERRY FLAVOUR SQUASH)",
    "No",
    "No",
    "Aktif",
  ],
  [2453, "SRIKAYA (ANNONA SQUAMOSA)", "No", "No", "Aktif"],
  [
    2454,
    "STARTER YOGHURT (YOGHURT STARTER)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2455, "Stearin (Stearine)", "No", "No", "Aktif"],
  [
    2456,
    "Stearin Inti Buah Rafinasi (Refined Kernel Stearine)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2457,
    "Stearin Inti Kelapa Sawit Hidrogenasi (Hydrogenated Palm Kernel Stearine)",
    "No",
    "No",
    "Aktif",
  ],
  [2458, "STEVIA (STEVIA)", "No", "No", "Nonaktif"],
  [2459, "Streptococcus cremoris", "No", "No", "Aktif"],
  [2460, "Streptococcus lactis", "No", "No", "Aktif"],
  [2461, "Streptococcus thermophilus", "No", "No", "Aktif"],
  [2462, "SUCCUS LIQUIRITIAE", "No", "No", "Nonaktif"],
  [2463, "succus liquirities", "No", "No", "Nonaktif"],
  [2464, "SUJI (DRACAENA ANGUSTIFOLIA)", "No", "No", "Aktif"],
  [2465, "Sukade (Sukade)", "No", "No", "Aktif"],
  [2466, "Sukade Pepaya (Papaya Sukade)", "No", "No", "Aktif"],
  [2467, "Sukromalt (sucromalt)", "No", "No", "Aktif"],
  [2468, "Sukrosa (Sucrose)", "No", "No", "Aktif"],
  [2469, "Sultana (Sultana)", "No", "No", "Aktif"],
  [2470, "Sup (Soup)", "No", "No", "Aktif"],
  [2471, "Sup Apel (Apple Soup)", "No", "No", "Aktif"],
  [2472, "Sup Daging (Meat Soup)", "No", "No", "Aktif"],
  [2473, "Surimi (Surimi)", "No", "No", "Aktif"],
  [2474, "SUSU (MILK)", "No", "No", "Nonaktif"],
  [2475, "SUSU BUBUK (MILK POWDER)", "No", "Yes", "Aktif"],
  [
    2476,
    "SUSU BUBUK FULL CREAM (FULL CREAM MILK POWDER)",
    "No",
    "Yes",
    "Aktif",
  ],
  [2477, "Susu Bubuk Lemak/Minyak Nabati", "No", "No", "Aktif"],
  [
    2478,
    "SUSU BUBUK RENDAH LEMAK (LOW FAT MILK POWDER)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    2479,
    "SUSU BUBUK TANPA LEMAK ATAU SUSU SKIM BUBUK (SKIMMED MILK POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [2480, "SUSU CAIR (LIQUID MILK)", "No", "Yes", "Aktif"],
  [2481, "SUSU COKLAT (CHOCOLATE MILK)", "No", "Yes", "Aktif"],
  [
    2482,
    "SUSU COKLAT BUBUK (CHOCOLATE MILK POWDER)",
    "No",
    "Yes",
    "Aktif",
  ],
  [2483, "SUSU EVAPORASI (EVAPORATED MILK)", "No", "Yes", "Aktif"],
  [2484, "SUSU FERMENTASI (FERMENTED MILK)", "No", "Yes", "Aktif"],
  [2485, "Susu Full Cream (Full Cream Milk)", "No", "No", "Aktif"],
  [2486, "Susu Kambing (Goat's Milk)", "No", "No", "Aktif"],
  [
    2487,
    "Susu Kambing Bubuk (Goat's Milk Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2488,
    "SUSU KAMBING FULL CREAM BUBUK (FULL CREAM GOAT'S MILK POWDER)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    2489,
    "SUSU KAMBING SKIM BUBUK (SKIM GOAT'S MILK POWDER)",
    "No",
    "Yes",
    "Aktif",
  ],
  [2490, "SUSU KENTAL  (CONDENSED MILK)", "No", "Yes", "Aktif"],
  [
    2491,
    "SUSU KENTAL MANIS (SWEETENED CONDENSED MILK)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    2492,
    "SUSU KENTAL TIDAK MANIS (UNSWEETENED CONDENSED MILK)",
    "No",
    "Yes",
    "Aktif",
  ],
  [2493, "SUSU KERBAU (BUFFALO MILK)", "No", "Yes", "Aktif"],
  [2494, "SUSU KUDA (HORSE MILK)", "No", "Yes", "Aktif"],
  [
    2495,
    "Susu Lemak Nabati-Susu Minyak Nabati (Filled Milk)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2496,
    "SUSU PASTEURISASI (PASTEURIZED MILK)",
    "No",
    "Yes",
    "Aktif",
  ],
  [2497, "SUSU RENDAH LEMAK (LOW FAT MILK)", "No", "Yes", "Aktif"],
  [2498, "Susu Sapi (Cow's Milk)", "No", "No", "Aktif"],
  [2499, "SUSU SEGAR (FRESH MILK)", "No", "Yes", "Aktif"],
  [2500, "SUSU SKIM (SKIM MILK)", "No", "Yes", "Aktif"],
  [
    2501,
    "SUSU SKIM BUBUK (SKIMMED MILK POWDER)",
    "No",
    "Yes",
    "Nonaktif",
  ],
  [
    2502,
    "SUSU SKIM COKLAT (SKIM MILK CHOCOLATE)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    2503,
    "SUSU SKIM KENTAL MANIS (SWEETENED CONDENSED SKIMMED MILK)",
    "No",
    "Yes",
    "Aktif",
  ],
  [
    2504,
    "SUSU TANPA LEMAK ATAU SUSU SKIM (SKIMMED MILK)",
    "No",
    "Yes",
    "Aktif",
  ],
  [2505, "SUSU UHT (UHT MILK)", "No", "Yes", "Aktif"],
  [2506, "Tahini (Tahini)", "No", "No", "Aktif"],
  [2507, "Tahu (Tofu)", "No", "No", "Aktif"],
  [2508, "Tahu Goreng (Fried Tofu)", "No", "No", "Aktif"],
  [2509, "TAHU KERING (DRIED TOFU)", "No", "No", "Aktif"],
  [2510, "TAHU MATANG", "No", "No", "Nonaktif"],
  [2511, "TALAS (TARO)", "No", "No", "Nonaktif"],
  [2512, "TANGKAI TERATAI (LOTUS STEM)", "No", "No", "Nonaktif"],
  [2513, "TAOGE (BEAN SPROUTS)", "No", "No", "Aktif"],
  [2514, "TAPAI BERAS (FERMENTED RICE)", "No", "No", "Aktif"],
  [2515, "TAPAI KETAN (FERMENTED STILKY RICE)", "No", "No", "Aktif"],
  [2516, "tapioka ", "No", "No", "Nonaktif"],
  [2517, "Tarako Bubuk (Tarako Powder)", "No", "No", "Aktif"],
  [2518, "Tartazine (cl.19140)", "No", "No", "Nonaktif"],
  [2519, "TAUCO (TAUCO)", "No", "No", "Aktif"],
  [2520, "TAURIN (TAURINE)", "No", "No", "Aktif"],
  [2521, "Tebu", "No", "No", "Nonaktif"],
  [2522, "Tebu (Cane)", "No", "No", "Aktif"],
  [2523, "TEH (TEA)", "No", "No", "Nonaktif"],
  [2524, "Teh Bubuk", "No", "No", "Nonaktif"],
  [2525, "Teh Bubuk (Tea Powder)", "No", "No", "Aktif"],
  [2526, "Teh Earl Grey (Earl Grey Tea)", "No", "No", "Aktif"],
  [2527, "Teh Hijau (Green Tea)", "No", "No", "Aktif"],
  [2528, "Teh Hijau Bubuk (Green Tea Powder)", "No", "No", "Aktif"],
  [
    2529,
    "Teh Hijau Melati (Green Tea Jasmine)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2530,
    "Teh Hijau Panggang (Roasted Green Tea)",
    "No",
    "No",
    "Aktif",
  ],
  [2531, "Teh Hitam (Black Tea Leaf)", "No", "No", "Aktif"],
  [2532, "Teh Hitam Ceylon (Black Tea Ceylon)", "No", "No", "Aktif"],
  [
    2533,
    "Teh Hitam Melati (Jasmine Black Tea)",
    "No",
    "No",
    "Aktif",
  ],
  [2534, "Teh Instan (Instant Tea)", "No", "No", "Aktif"],
  [
    2535,
    "TEH JAWA (ORTHOSIPHON STAMINEUS; ORTHOSIPHON ARISTATUS; ORTHOSIPHON SPICATUS; ORTHOSIPHONBLAETTER; JAVATEE, INDISCHER NIERENTEE, FEUILLES DE BARBIFLORE; DE JAVA)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2536, "TEH KERING (DRIED TEA)", "No", "No", "Nonaktif"],
  [2537, "Teh Melati (Jasmine Tea)", "No", "No", "Aktif"],
  [2538, "Teh Oolong (Oolong Tea)", "No", "No", "Aktif"],
  [2539, "Teh Putih (White Tea)", "No", "No", "Aktif"],
  [
    2540,
    "TEH ROOIBOSA\\xA0(ASPHALATUS LINEARIS)",
    "No",
    "No",
    "Aktif",
  ],
  [2541, "Telur", "No", "No", "Nonaktif"],
  [2542, "TELUR (EGG)", "No", "Yes", "Aktif"],
  [2543, "TELUR ASIN (SALTED EGG)", "No", "No", "Aktif"],
  [2544, "TELUR AYAM (CHICKEN EGG)", "No", "No", "Aktif"],
  [2545, "TELUR AYAM NEGERI UTUH", "No", "No", "Nonaktif"],
  [2546, "TELUR BEBEK (DUCK EGG)", "No", "No", "Aktif"],
  [2547, "Telur Bubuk (Whole Egg Powder)", "No", "No", "Aktif"],
  [2548, "Telur Ikan (Fish Egg)", "No", "No", "Aktif"],
  [2549, "Telur Puyuh (Quail Egg)", "No", "No", "Aktif"],
  [2550, "TEMBAGA GLUKONAT (COPPER GLUCONAT)", "No", "No", "Aktif"],
  [2551, "Tembaga Sulfat (Copper Sulfate)", "No", "No", "Aktif"],
  [2552, "Tempe", "No", "No", "Aktif"],
  [2553, "Tempe Goreng (Fried Tempe)", "No", "No", "Aktif"],
  [2554, "TEMPE MATANG", "No", "No", "Nonaktif"],
  [2555, "Tempura (Tempura)", "No", "No", "Aktif"],
  [
    2556,
    "TEMU KUNCI (CURCUMA ROTUNDA, BOESENBERGIA ROTUNDA (L) MANSF)",
    "No",
    "No",
    "Aktif",
  ],
  [2557, "TEMULAWAK (CURCUMA XANTHORRHIZA)", "No", "No", "Aktif"],
  [
    2558,
    "TEPUNG AGAR-AGAR (AGAR-AGAR POWDER)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2559, "Tepung Amaranth", "No", "No", "Aktif"],
  [
    2560,
    "TEPUNG ARARUT/TEPUNG GARUT (ARROWROOT FLOUR)",
    "No",
    "No",
    "Aktif",
  ],
  [2561, "Tepung Aren (Sugar Palm Powder)", "No", "No", "Aktif"],
  [2562, "Tepung Barley (Barley Flour)", "No", "No", "Aktif"],
  [
    2563,
    "Tepung Barley Malt (Barley Malt Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2564, "TEPUNG BATTER", "No", "No", "Aktif"],
  [2565, "Tepung Beras", "No", "No", "Nonaktif"],
  [2566, "Tepung Beras (Rice Flour)", "No", "No", "Aktif"],
  [
    2567,
    "Tepung Beras Cokelat (Brown Rice Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2568, "Tepung Beras Hitam", "No", "No", "Aktif"],
  [
    2569,
    "Tepung Beras Ketan (Glutinous Rice Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2570,
    "Tepung Beras Merah (Brown Rice Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2571, "Tepung Biji Rami (Flaxseed Flour)", "No", "No", "Aktif"],
  [
    2572,
    "Tepung Bran Gandum (Wheat Bran Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2573, "Tepung Breader", "No", "No", "Aktif"],
  [2574, "Tepung Buckwheat (Buckwheat Flour)", "No", "No", "Aktif"],
  [2575, "Tepung Bumbu (Seasoning Powder)", "No", "No", "Aktif"],
  [
    2576,
    "Tepung Bumbu Ayam Goreng (Fried Chicken Seasoning Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [2577, "TEPUNG DHAL (HUSKED DEW GRAM FLOUR)", "No", "No", "Aktif"],
  [2578, "TEPUNG DURUM ", "No", "No", "Aktif"],
  [2579, "Tepung Gandum (Wheat Flour)", "No", "No", "Aktif"],
  [2580, "Tepung Gandum Hitam (Rye Flour)", "No", "No", "Aktif"],
  [
    2581,
    "Tepung Gandum Hitam Terfermentasi (Fermented Rye Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2582, "Tepung Gandum Semolina ", "No", "No", "Nonaktif"],
  [
    2583,
    "Tepung Gandum Semolina (Semolina Wheat Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2584,
    "Tepung Gandum Utuh (Whole Wheat Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2585, "Tepung Gaplek (Cassava Flour)", "No", "No", "Aktif"],
  [2586, "Tepung Gluten (Gluten Flour)", "No", "No", "Aktif"],
  [2587, "Tepung Iles-Iles", "No", "No", "Aktif"],
  [2588, "Tepung Jagung (Corn Flour)", "No", "No", "Aktif"],
  [
    2589,
    "Tepung Jagung Modifikasi (Modified Corn Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2590,
    "Tepung Jagung Ungu (Purple Corn Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2591, "Tepung Jamur (Mushroom Flour)", "No", "No", "Aktif"],
  [2592, "Tepung Kacang (Peanut Flour)", "No", "No", "Aktif"],
  [
    2593,
    "TEPUNG KACANG ARAB - TEPUNG GARBANZO (CHICKPEA - GARBANZO FLOUR)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2594,
    "Tepung Kacang Chena (Chena Bean Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2595,
    "Tepung Kacang Hijau (Mungbean Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2596,
    "Tepung Kacang Kedelai (Soybean Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2597,
    "Tepung Kacang Koro (Broad Bean Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2598,
    "Tepung Kacang Merah (Red Bean Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2599,
    "Tepung Kacang Mete (Cashew Nut Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2600, "Tepung Kacang Polong (Pea Flour)", "No", "No", "Aktif"],
  [2601, "TEPUNG KAMUT", "No", "No", "Nonaktif"],
  [2602, "Tepung Kanji (Starch)", "No", "No", "Aktif"],
  [2603, "TEPUNG KEDELAI (SOY FLOUR)", "No", "No", "Nonaktif"],
  [2604, "Tepung Kelapa (Coconut Flour)", "No", "No", "Aktif"],
  [
    2605,
    "Tepung Kencur (Kaempferia galanga Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2606, "Tepung Kentang (Potato Flour)", "No", "No", "Aktif"],
  [2607, "Tepung Kerang (Shell Flour)", "No", "No", "Aktif"],
  [
    2608,
    "TEPUNG KETAN (GLUTINOUS RICE FLOUR)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2609,
    "Tepung Ketan Hitam (Black Glutinous Rice Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2610,
    "Tepung Ketan Putih (White Glutinous Rice Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2611, "TEPUNG KONJAC", "Yes", "No", "Nonaktif"],
  [2612, "TEPUNG KONNYAKU (KONJAC FLOUR)", "No", "No", "Aktif"],
  [2613, "TEPUNG KONYAKU (KONYAKU FLOUR)", "No", "No", "Nonaktif"],
  [2614, "Tepung Kue (Cake Flour)", "No", "No", "Aktif"],
  [2615, "Tepung Lobak (Rapeseed Flour)", "No", "No", "Aktif"],
  [2616, "Tepung Maizena", "No", "No", "Nonaktif"],
  [2617, "Tepung Malt (Malt Flour)", "No", "No", "Aktif"],
  [2618, "Tepung mazena", "No", "No", "Nonaktif"],
  [2619, "Tepung Muffin (Muffin Flour)", "No", "No", "Aktif"],
  [
    2620,
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    "No",
    "No",
    "Aktif",
  ],
  [2621, "Tepung Olahan Pra\\xA0Masak", "No", "No", "Aktif"],
  [2622, "Tepung Panir (Panir Flour)", "No", "No", "Aktif"],
  [2623, "Tepung Premiks (Premix Flour)", "No", "No", "Aktif"],
  [
    2624,
    "Tepung Premiks Es Krim (Ice Cream Base)",
    "Yes",
    "Yes",
    "Aktif",
  ],
  [2625, "Tepung Quinoa (Quinoa Flour)", "No", "No", "Aktif"],
  [2626, "Tepung Roti (Bread Crumb)", "No", "No", "Aktif"],
  [2627, "Tepung Roti (Bread Flour)", "No", "No", "Aktif"],
  [2628, "Tepung Rumput laut", "No", "No", "Nonaktif"],
  [2629, "Tepung Rye (Rye Flour)", "No", "No", "Aktif"],
  [2630, "Tepung Sagu (Sago Flour)", "No", "No", "Aktif"],
  [2631, "Tepung Semolina (Semolina Flour)", "No", "No", "Aktif"],
  [2632, "Tepung Singkong (Cassava Flour)", "No", "No", "Aktif"],
  [2633, "Tepung Sorgum (Sorghum Flour)", "No", "No", "Aktif"],
  [2634, "Tepung Spelt (Spelt flour)", "No", "No", "Aktif"],
  [2635, "Tepung Talas (Taro Powder)", "No", "No", "Aktif"],
  [2636, "TEPUNG TAPIOKA", "No", "No", "Nonaktif"],
  [2637, "TEPUNG TELUR", "No", "Yes", "Aktif"],
  [2638, "Tepung Tempura (Tempura Flour)", "No", "No", "Aktif"],
  [2639, "TEPUNG TERIGU (WHEAT FLOUR)", "No", "No", "Aktif"],
  [
    2640,
    "Tepung Terigu Diperkaya (Enriched Flour)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2641,
    "Tepung Terigu Protein Rendah (Low Protein Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2642,
    "Tepung Terigu Protein Sedang (Cake Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2643,
    "Tepung Terigu Protein Tinggi (High Protein Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2644,
    "TEPUNG TERIGU SEMOLINA (SEMOLINA FLOUR)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2645,
    "Tepung Terigu Terfermentasi (Fermented Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [2646, "TEPUNG UBI (CASSAVA FLOUR)", "No", "No", "Nonaktif"],
  [
    2647,
    "Tepung Ubi Jalar (Sweet Potato Flour)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2648,
    "Tepung Ubi Jalar Ungu (Violet Sweet Potato Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [2649, "Tequila (Tequilla)", "No", "No", "Aktif"],
  [2650, "Terasi - Belacan (Paste)", "No", "No", "Aktif"],
  [
    2651,
    "Terasi - Belacan Udang (Shrimp Paste)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2652,
    "TERIPANG LAUT (SEA CUCUMBERS - HOLOTHUROIDEA)",
    "No",
    "No",
    "Aktif",
  ],
  [2653, "Terong (Eggplant)", "No", "No", "Aktif"],
  [2654, "TESTING", "Yes", "No", "Aktif"],
  [2655, "TETES TEBU (MOLASES, TREACLE)", "No", "No", "Aktif"],
  [2656, "THIAMIN MONONITRAT", "No", "No", "Nonaktif"],
  [2657, "Thixogums", "No", "No", "Nonaktif"],
  [2658, "TIAMIN MONONITRAT (VIT B1)", "No", "No", "Nonaktif"],
  [2659, "TIMI (THYME - THYMUS VULGARIS)", "No", "No", "Aktif"],
  [
    2660,
    "TIMI BUBUK (THYME - THYMUS VULGARIS POWDER)",
    "No",
    "No",
    "Aktif",
  ],
  [2661, "Tinta Cumi (Squid Ink)", "No", "No", "Aktif"],
  [2662, "Tiram (Oyster)", "No", "No", "Aktif"],
  [2663, "Tiramisu (Tiramisu)", "No", "No", "Aktif"],
  [2664, "Tirosin (Thyrosin)", "No", "No", "Aktif"],
  [2665, "TOFFEE", "No", "No", "Nonaktif"],
  [2666, "Tomat (Tomato)", "No", "No", "Aktif"],
  [2667, "Tomat Bubuk  (Tomato Powder)", "No", "No", "Aktif"],
  [2668, "Tomat Cincang (Chopped Tomato)", "No", "No", "Aktif"],
  [2669, "Tomat Hijau (Green Tomato)", "No", "No", "Aktif"],
  [2670, "Tomat Kering (Dried Tomato)", "No", "No", "Aktif"],
  [2671, "Tomat Kupas (Peeled Tomato)", "No", "No", "Aktif"],
  [
    2672,
    "TONGKAT ALI BUBUK (EURYCOMA LONGIFOLIA POWDER)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2673, "TOPPING", "No", "No", "Aktif"],
  [2674, "Torbangun (Mexican mint)", "No", "No", "Aktif"],
  [2675, "TREHALOSA (TREHALOSE DIHYDRATE)", "No", "No", "Aktif"],
  [2676, "TREONIN (THREONINE)", "No", "No", "Aktif"],
  [2677, "TRIBULUS", "No", "No", "Nonaktif"],
  [
    2678,
    "Trikalium fosfat (Tripotassium orthophosphate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2679,
    "trikalium sitrat (tripotassium citrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2680,
    "Trikalium Sitrat Monohidrat (Tripotassium Citrate Monohydrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2681,
    "Trikalsium Fosfat (Tricalcium Phosphate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2682,
    "trikalsium sitrat (Tricalcium citrate)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2683,
    "Trimagnesium sitrat anhidrat (Trimagnesium Citrate Anhydrous)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2684,
    "TRINATRIUM FOSFAT (TRISODIUM ORTHOPHOSPHATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2685,
    "TRINATRIUM FOSFAT (TRISODIUM OTRHOPHOSPHATE)",
    "No",
    "No",
    "Nonaktif",
  ],
  [
    2686,
    "TRINATRIUM SITRAT  (TRISODIUM CITRATE) (KECUALI MP ASI)",
    "No",
    "No",
    "Aktif",
  ],
  [2687, "Triptofan (Triptophan)", "No", "No", "Aktif"],
  [2688, "Triticale", "No", "No", "Aktif"],
  [2689, "Truffle (Truffle)", "No", "No", "Aktif"],
  [2690, "Tulang Ayam (Chicken Bone)", "No", "No", "Aktif"],
  [2691, "Tulang Babi (Pig Bone)", "No", "No", "Aktif"],
  [2692, "Tulang Ikan Salmon (Salmon Bone)", "No", "No", "Aktif"],
  [
    2693,
    "Tulang Muda Ikan Hiu Bubuk (Cartilage Shark Powder)",
    "No",
    "No",
    "Aktif",
  ],
  [2694, "Tulang Sapi (Cow's Bone)", "No", "No", "Aktif"],
  [2695, "Tuna Bubuk (Tuna Powder)", "No", "No", "Aktif"],
  [2696, "TVP (Texturized Vegetable Protein)", "No", "No", "Aktif"],
  [2697, "UBI JALAR (SWEET POTATO)", "No", "No", "Aktif"],
  [2698, "Ubi Jepang (Japanese Yam)", "No", "No", "Aktif"],
  [2699, "UBI KAYU (CASSAVA)", "No", "No", "Nonaktif"],
  [2700, "UBI MADU (SWEET HONEY POTATO)", "No", "No", "Aktif"],
  [2701, "Ubi Merah ", "No", "No", "Aktif"],
  [2702, "UBI RAMBAT (YAM)", "No", "No", "Nonaktif"],
  [2703, "UBI UNGU (PURPLE SWEET POTATO)", "No", "No", "Aktif"],
  [2704, "Ubur-Ubur (Jellyfish)", "No", "No", "Aktif"],
  [2705, "Udang  Bubuk (Shrimp Powder)", "No", "No", "Aktif"],
  [2706, "UDANG (FRESH PRAWN)", "No", "No", "Aktif"],
  [2707, "Udang (Shrimp)", "No", "No", "Aktif"],
  [2708, "Udang Kering - Ebi (Dried Shrimp)", "No", "No", "Aktif"],
  [2709, "Udang Rebon (Shrimp Rebon)", "No", "No", "Aktif"],
  [2710, "UMBI KONNYAKU (KONJAC)", "No", "No", "Aktif"],
  [2711, "Usus Ayam", "No", "No", "Aktif"],
  [2712, "Usus Babi", "No", "No", "Aktif"],
  [2713, "Usus Kambing", "No", "No", "Aktif"],
  [2714, "Usus Sapi (Cow Intestines)", "No", "No", "Aktif"],
  [
    2715,
    "UVA URSI POWDER (ARCTISTAPHYLOS UVA URSI)",
    "No",
    "No",
    "Nonaktif",
  ],
  [2716, "Valin", "Yes", "Yes", "Aktif"],
  [2717, "VANILA", "No", "No", "Nonaktif"],
  [2718, "VANILIN", "No", "No", "Nonaktif"],
  [2719, "Vitamin A (Retinal)", "No", "No", "Aktif"],
  [2720, "VITAMIN A ASETAT", "No", "No", "Aktif"],
  [2721, "Vitamin A Palmitat", "No", "No", "Aktif"],
  [2722, "VITAMIN B", "No", "No", "Nonaktif"],
  [2723, "Vitamin B1 (Thiamine)", "No", "No", "Aktif"],
  [2724, "VITAMIN B10", "No", "No", "Nonaktif"],
  [2725, "Vitamin B12 (Cyanocobalamin)", "No", "No", "Aktif"],
  [2726, "Vitamin B2 (Riboflavin)", "No", "No", "Aktif"],
  [
    2727,
    "VITAMIN B3 (NIACINAMIDE)(NICOTINAMIDE)",
    "No",
    "No",
    "Aktif",
  ],
  [2728, "Vitamin B5 (Pantothenic Acid)", "No", "No", "Aktif"],
  [
    2729,
    "Vitamin B6 (Pyridoxine Hydrochloride)",
    "No",
    "No",
    "Aktif",
  ],
  [2730, "Vitamin B7 (Biotin)", "No", "No", "Aktif"],
  [2731, "VITAMIN B8 (INOSITOL)", "No", "No", "Aktif"],
  [2732, "Vitamin B9 (Folic Acid)", "No", "No", "Aktif"],
  [2733, "Vitamin C (Ascorbic Acid)", "No", "No", "Aktif"],
  [2734, "VITAMIN D ", "No", "No", "Nonaktif"],
  [2735, "VITAMIN D1", "No", "No", "Nonaktif"],
  [2736, "Vitamin D2 (Ergocalciferol)", "No", "No", "Aktif"],
  [2737, "Vitamin D3 (Cholecalciferol)", "No", "No", "Aktif"],
  [2738, "Vitamin E (Tocopherol)", "No", "No", "Aktif"],
  [2739, "VITAMIN E ASETAT", "No", "No", "Aktif"],
  [2740, "VITAMIN H (BIOTIN)", "No", "No", "Nonaktif"],
  [2741, "VITAMIN K", "No", "No", "Nonaktif"],
  [2742, "Vitamin K1 (Phytomenadione)", "No", "No", "Aktif"],
  [2743, "VITAMIN K2 (MENAQUINONE)", "No", "No", "Aktif"],
  [2744, "Vodka (Vodka)", "No", "No", "Aktif"],
  [2745, "WAFER", "No", "No", "Aktif"],
  [2746, "WAFER CONE", "No", "No", "Aktif"],
  [2747, "Wakame (Wakame)", "No", "No", "Aktif"],
  [2748, "WALNUT (WALNUT)", "No", "No", "Nonaktif"],
  [2749, "Wasabi (Wasabi)", "No", "No", "Aktif"],
  [2750, "Wasabi Bubuk (Wasabi Powder)", "No", "No", "Aktif"],
  [2751, "WATER CHESNUT", "Yes", "Yes", "Aktif"],
  [2752, "WAX (WAX)", "No", "No", "Nonaktif"],
  [2753, "Waxberry (Waxberry)", "No", "No", "Aktif"],
  [2754, "Wheat grass (Triticum aestirum)", "No", "No", "Aktif"],
  [2755, "Whey (Whey)", "No", "No", "Aktif"],
  [2756, "Whey Bubuk (Whey Powder)", "No", "No", "Aktif"],
  [
    2757,
    "Whey Demineralisasi (Whey Demineralization)",
    "No",
    "No",
    "Aktif",
  ],
  [2758, "Whey Protein (Whey Protein)", "No", "No", "Aktif"],
  [
    2759,
    "Whey Protein Demineralisasi (Whey Protein Demineralization)",
    "No",
    "No",
    "Aktif",
  ],
  [
    2760,
    "Whey Protein Konsentrat (Whey Protein Concentrate)",
    "No",
    "No",
    "Aktif",
  ],
  [2761, "Whipping Cream (Whipping Cream)", "No", "No", "Aktif"],
  [2762, "Wijen (Sesame)", "No", "No", "Aktif"],
  [2763, "Wijen Bubuk (Sesame Powder)", "No", "No", "Aktif"],
  [2764, "Wijen Hitam (Black Sesame)", "No", "No", "Aktif"],
  [2765, "Wijen Putih (White Sesame)", "No", "No", "Aktif"],
  [2766, "WISKI (WHISKY)", "No", "No", "Aktif"],
  [2767, "Wortel (Carrot)", "No", "No", "Aktif"],
  [2768, "Wortel Bubuk (Carrot Powder)", "No", "No", "Aktif"],
  [2769, "Wortel Kering (Dried Carrot)", "No", "No", "Aktif"],
  [
    2770,
    "Yerbamate Ekstrak (Ilex paraguariensis)",
    "No",
    "No",
    "Aktif",
  ],
  [2771, "Yoghurt (Yoghurt)", "No", "No", "Aktif"],
  [2772, "Yoghurt Bubuk (Yoghurt Powder)", "No", "No", "Aktif"],
  [2773, "ZAT BESI (IRON)", "No", "No", "Aktif"],
  [2774, "ZEASANTIN", "No", "No", "Nonaktif"],
  [2775, "Zink Glukonat (Zinc Gluconate)", "No", "No", "Aktif"],
  [
    2776,
    "Zink Laktat Dihidrat (Zink Lactate Dihydrate)",
    "No",
    "No",
    "Aktif",
  ],
  [2777, "Zink Oksida (Zinc Oxide)", "No", "No", "Aktif"],
  [2778, "Zink Pikolinat (Zinc Picolinate)", "No", "No", "Aktif"],
  [
    2779,
    "zink Sitrat Dihidrat (Zink Citrate Dihydrate)",
    "No",
    "No",
    "Aktif",
  ],
  [2780, "Zink Sulfat (Zinc Sulphate)", "No", "No", "Aktif"],
];
# END FRAGMENT id=data-idn_bpom_bahan_baku_pangan_rba

my $res = gen_read_table_func(
    name => 'bpom_list_food_ingredients_rba',
    summary => 'List ingredients in BPOM processed food division (RBA version)',
    table_data => $data_idn_bpom_bahan_baku_pangan_rba,
    table_spec => $meta_idn_bpom_bahan_baku_pangan_rba,
    description => <<'_',
_
    extra_props => {
        examples => [
        ],
    },
    hooks => {
        before_return => sub {
            my %args = @_;
            # XXX adjust other properties e.g. table.field_formats etc
            $args{_func_res}[3]{'table.fields'} = ['status'];
            1;
        },
    },
);
die "Can't generate function: $res->[0] - $res->[1]" unless $res->[0] == 200;

1;
# ABSTRACT: List ingredients in BPOM processed food division (RBA version)

__END__

=pod

=encoding UTF-8

=head1 NAME

App::BPOMUtils::Table::FoodIngredientRBA - List ingredients in BPOM processed food division (RBA version)

=head1 VERSION

This document describes version 0.020 of App::BPOMUtils::Table::FoodIngredientRBA (from Perl distribution App-BPOMUtils-Table-FoodIngredient), released on 2023-09-03.

=head1 FUNCTIONS


=head2 bpom_list_food_ingredients_rba

Usage:

 bpom_list_food_ingredients_rba(%args) -> [$status_code, $reason, $payload, \%result_meta]

List ingredients in BPOM processed food division (RBA version).

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<country_of_origin> => I<str>

Only return records where the 'country_of_origin' field equals specified value.

=item * B<country_of_origin.contains> => I<str>

Only return records where the 'country_of_origin' field contains specified text.

=item * B<country_of_origin.in> => I<array[str]>

Only return records where the 'country_of_origin' field is in the specified values.

=item * B<country_of_origin.is> => I<str>

Only return records where the 'country_of_origin' field equals specified value.

=item * B<country_of_origin.isnt> => I<str>

Only return records where the 'country_of_origin' field does not equal specified value.

=item * B<country_of_origin.matches> => I<str>

Only return records where the 'country_of_origin' field matches specified regular expression pattern.

=item * B<country_of_origin.max> => I<str>

Only return records where the 'country_of_origin' field is less than or equal to specified value.

=item * B<country_of_origin.min> => I<str>

Only return records where the 'country_of_origin' field is greater than or equal to specified value.

=item * B<country_of_origin.not_contains> => I<str>

Only return records where the 'country_of_origin' field does not contain specified text.

=item * B<country_of_origin.not_in> => I<array[str]>

Only return records where the 'country_of_origin' field is not in the specified values.

=item * B<country_of_origin.not_matches> => I<str>

Only return records where the 'country_of_origin' field does not match specified regular expression.

=item * B<country_of_origin.xmax> => I<str>

Only return records where the 'country_of_origin' field is less than specified value.

=item * B<country_of_origin.xmin> => I<str>

Only return records where the 'country_of_origin' field is greater than specified value.

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<exclude_fields> => I<array[str]>

Select fields to return.

=item * B<fields> => I<array[str]>

Select fields to return.

=item * B<id> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.in> => I<array[int]>

Only return records where the 'id' field is in the specified values.

=item * B<id.is> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.isnt> => I<int>

Only return records where the 'id' field does not equal specified value.

=item * B<id.max> => I<int>

Only return records where the 'id' field is less than or equal to specified value.

=item * B<id.min> => I<int>

Only return records where the 'id' field is greater than or equal to specified value.

=item * B<id.not_in> => I<array[int]>

Only return records where the 'id' field is not in the specified values.

=item * B<id.xmax> => I<int>

Only return records where the 'id' field is less than specified value.

=item * B<id.xmin> => I<int>

Only return records where the 'id' field is greater than specified value.

=item * B<name> => I<str>

Only return records where the 'name' field equals specified value.

=item * B<name.contains> => I<str>

Only return records where the 'name' field contains specified text.

=item * B<name.in> => I<array[str]>

Only return records where the 'name' field is in the specified values.

=item * B<name.is> => I<str>

Only return records where the 'name' field equals specified value.

=item * B<name.isnt> => I<str>

Only return records where the 'name' field does not equal specified value.

=item * B<name.matches> => I<str>

Only return records where the 'name' field matches specified regular expression pattern.

=item * B<name.max> => I<str>

Only return records where the 'name' field is less than or equal to specified value.

=item * B<name.min> => I<str>

Only return records where the 'name' field is greater than or equal to specified value.

=item * B<name.not_contains> => I<str>

Only return records where the 'name' field does not contain specified text.

=item * B<name.not_in> => I<array[str]>

Only return records where the 'name' field is not in the specified values.

=item * B<name.not_matches> => I<str>

Only return records where the 'name' field does not match specified regular expression.

=item * B<name.xmax> => I<str>

Only return records where the 'name' field is less than specified value.

=item * B<name.xmin> => I<str>

Only return records where the 'name' field is greater than specified value.

=item * B<origin> => I<str>

Only return records where the 'origin' field equals specified value.

=item * B<origin.contains> => I<str>

Only return records where the 'origin' field contains specified text.

=item * B<origin.in> => I<array[str]>

Only return records where the 'origin' field is in the specified values.

=item * B<origin.is> => I<str>

Only return records where the 'origin' field equals specified value.

=item * B<origin.isnt> => I<str>

Only return records where the 'origin' field does not equal specified value.

=item * B<origin.matches> => I<str>

Only return records where the 'origin' field matches specified regular expression pattern.

=item * B<origin.max> => I<str>

Only return records where the 'origin' field is less than or equal to specified value.

=item * B<origin.min> => I<str>

Only return records where the 'origin' field is greater than or equal to specified value.

=item * B<origin.not_contains> => I<str>

Only return records where the 'origin' field does not contain specified text.

=item * B<origin.not_in> => I<array[str]>

Only return records where the 'origin' field is not in the specified values.

=item * B<origin.not_matches> => I<str>

Only return records where the 'origin' field does not match specified regular expression.

=item * B<origin.xmax> => I<str>

Only return records where the 'origin' field is less than specified value.

=item * B<origin.xmin> => I<str>

Only return records where the 'origin' field is greater than specified value.

=item * B<queries> => I<array[str]>

Search.

This will search all searchable fields with one or more specified queries. Each
query can be in the form of C<-FOO> (dash prefix notation) to require that the
fields do not contain specified string, or C</FOO/> to use regular expression.
All queries must match if the C<query_boolean> option is set to C<and>; only one
query should match if the C<query_boolean> option is set to C<or>.

=item * B<query_boolean> => I<str> (default: "and")

Whether records must match all search queries ('and') or just one ('or').

If set to C<and>, all queries must match; if set to C<or>, only one query should
match. See the C<queries> option for more details on searching.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<sort> => I<array[str]>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<status> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.contains> => I<str>

Only return records where the 'status' field contains specified text.

=item * B<status.in> => I<array[str]>

Only return records where the 'status' field is in the specified values.

=item * B<status.is> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.isnt> => I<str>

Only return records where the 'status' field does not equal specified value.

=item * B<status.matches> => I<str>

Only return records where the 'status' field matches specified regular expression pattern.

=item * B<status.max> => I<str>

Only return records where the 'status' field is less than or equal to specified value.

=item * B<status.min> => I<str>

Only return records where the 'status' field is greater than or equal to specified value.

=item * B<status.not_contains> => I<str>

Only return records where the 'status' field does not contain specified text.

=item * B<status.not_in> => I<array[str]>

Only return records where the 'status' field is not in the specified values.

=item * B<status.not_matches> => I<str>

Only return records where the 'status' field does not match specified regular expression.

=item * B<status.xmax> => I<str>

Only return records where the 'status' field is less than specified value.

=item * B<status.xmin> => I<str>

Only return records where the 'status' field is greater than specified value.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hashE<sol>associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).


=back

Returns an enveloped result (an array).

First element ($status_code) is an integer containing HTTP-like status code
(200 means OK, 4xx caller error, 5xx function error). Second element
($reason) is a string containing error message, or something like "OK" if status is
200. Third element ($payload) is the actual result, but usually not present when enveloped result is an error response ($status_code is not 2xx). Fourth
element (%result_meta) is called result metadata and is optional, a hash
that contains extra information, much like how HTTP response headers provide additional metadata.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-BPOMUtils-Table-FoodIngredient>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-BPOMUtils-Table-FoodIngredient>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-BPOMUtils-Table-FoodIngredient>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
