/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.impl.load.LoadError;

class ControlInfo {
    static final String ESCAPE = "Escape";
    static final String DEFAULT_ESCAPE = "\\";
    static final String QUOTE = "Quote";
    static final String DEFAULT_QUOTE = "'";
    static final String COMMIT_COUNT = "CommitCount";
    static final String DEFAULT_COMMIT_COUNT = "0";
    static final String START_ROW = "StartRow";
    static final String DEFAULT_START_ROW = "1";
    static final String STOP_ROW = "StopRow";
    static final String DEFAULT_STOP_ROW = "0";
    static final String FIELD_SEPARATOR = "FieldSeparator";
    static final String DEFAULT_FIELD_SEPARATOR = ",";
    static final String RECORD_SEPARATOR = "RecordSeparator";
    static final String DEFAULT_RECORD_SEPARATOR = System.getProperty("line.separator");
    static final String COLUMN_DEFINITION = "ColumnDefinition";
    static final String DEFAULT_COLUMN_DEFINITION = "FALSE";
    static final String NULL_STRING = "Null";
    static final String DEFAULT_NULL_STRING = "NULL";
    static final String FORMAT = "Format";
    static final String DEFAULT_FORMAT = "ASCII_DELIMITED";
    static final String DB2_DELIMITED_FORMAT = "DB2_DELIMITED";
    static final String FIELD_START_DELIMITER = "FieldStartDelimiter";
    static final String DEFAULT_FIELD_START_DELIMITER = "\"";
    static final String FIELD_END_DELIMITER = "FieldEndDelimiter";
    static final String DEFAULT_FIELD_END_DELIMITER = "\"";
    static final String COLUMN_WIDTHS = "ColumnWidths";
    static final String MESSAGE_FILE = "MessageFile";
    static final String DEFAULT_VERSION = "1";
    static final String VERSION = "Version";
    static final String NEWLINE = "\n";
    static final String COMMA = ",";
    static final String SPACE = " ";
    static final String TAB = "\t";
    static final String CR = "\r";
    static final String LF = "\n";
    static final String CRLF = "\r\n";
    static final String LFCR = "\n\r";
    static final String FF = "\f";
    static final String EMPTY_LINE = "\n\n";
    static final String SEMICOLON = ";";
    static final String DATA_CODESET = "DataCodeset";
    static final String HAS_DELIMETER_AT_END = "HasDelimeterAtEnd";
    static final String INTERNAL_NONE = "None";
    static final String INTERNAL_TRUE = "True";
    static final String INTERNAL_FALSE = "False";
    static final String INTERNAL_TAB = "Tab";
    static final String INTERNAL_SPACE = "Space";
    static final String INTERNAL_CR = "CR";
    static final String INTERNAL_LF = "LF";
    static final String INTERNAL_CRLF = "CR-LF";
    static final String INTERNAL_LFCR = "LF-CR";
    static final String INTERNAL_COMMA = "Comma";
    static final String INTERNAL_SEMICOLON = "Semicolon";
    static final String INTERNAL_NEWLINE = "New Line";
    static final String INTERNAL_FF = "FF";
    static final String INTERNAL_EMPTY_LINE = "Empty line";
    private Properties currentProperties;

    public ControlInfo() throws Exception {
        this.getCurrentProperties();
        if (this.getFieldSeparator().indexOf(this.getRecordSeparator()) != -1) {
            throw LoadError.fieldAndRecordSeparatorsSubset();
        }
    }

    String getPropertyValue(String string) throws Exception {
        return this.getCurrentProperties().getProperty(string);
    }

    private void loadDefaultValues() {
        this.currentProperties = new Properties();
        this.currentProperties.put(FIELD_SEPARATOR, ",");
        this.currentProperties.put(RECORD_SEPARATOR, DEFAULT_RECORD_SEPARATOR);
        this.currentProperties.put(COLUMN_DEFINITION, DEFAULT_COLUMN_DEFINITION);
        this.currentProperties.put(NULL_STRING, DEFAULT_NULL_STRING);
        this.currentProperties.put(FORMAT, DEFAULT_FORMAT);
        this.currentProperties.put(FIELD_START_DELIMITER, "\"");
        this.currentProperties.put(FIELD_END_DELIMITER, "\"");
        this.currentProperties.put(VERSION, "1");
        String string = new InputStreamReader(System.in).getEncoding();
        this.currentProperties.put(DATA_CODESET, string);
        this.currentProperties.put(HAS_DELIMETER_AT_END, INTERNAL_FALSE);
    }

    String getCurrentVersion() throws Exception {
        return "1";
    }

    String getFormat() throws Exception {
        return this.getCurrentProperties().getProperty(FORMAT);
    }

    int[] getColumnWidths() {
        return null;
    }

    String getFieldSeparator() throws Exception {
        String string = this.getCurrentProperties().getProperty(FIELD_SEPARATOR);
        string = this.mapFromUserFriendlyFieldDelimiters(string);
        return string;
    }

    String getFieldStartDelimiter() throws Exception {
        return this.getCurrentProperties().getProperty(FIELD_START_DELIMITER);
    }

    String getFieldEndDelimiter() throws Exception {
        return this.getCurrentProperties().getProperty(FIELD_END_DELIMITER);
    }

    String getRecordSeparator() throws Exception {
        String string = this.getCurrentProperties().getProperty(RECORD_SEPARATOR);
        string = this.mapFromUserFriendlyRecordDelimiters(string);
        return string;
    }

    boolean getHasDelimiterAtEnd() throws Exception {
        String string = this.getCurrentProperties().getProperty(HAS_DELIMETER_AT_END);
        return string.equals(INTERNAL_TRUE);
    }

    String getHasDelimeterAtEndString() throws Exception {
        String string = this.getCurrentProperties().getProperty(HAS_DELIMETER_AT_END);
        return string;
    }

    String getNullString() throws Exception {
        return this.getCurrentProperties().getProperty(NULL_STRING);
    }

    String getColumnDefinition() throws Exception {
        return this.getCurrentProperties().getProperty(COLUMN_DEFINITION);
    }

    private String mapFromUserFriendlyFieldDelimiters(String string) {
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_TAB.toUpperCase(Locale.ENGLISH))) {
            return TAB;
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_SPACE.toUpperCase(Locale.ENGLISH))) {
            return SPACE;
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_CR.toUpperCase(Locale.ENGLISH))) {
            return CR;
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_LF.toUpperCase(Locale.ENGLISH))) {
            return "\n";
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_CRLF.toUpperCase(Locale.ENGLISH))) {
            return CRLF;
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_LFCR.toUpperCase(Locale.ENGLISH))) {
            return LFCR;
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_COMMA.toUpperCase(Locale.ENGLISH))) {
            return ",";
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_SEMICOLON.toUpperCase(Locale.ENGLISH))) {
            return SEMICOLON;
        }
        string = this.commonToFieldAndRecordDelimiters(string, "\\n", '\n');
        string = this.commonToFieldAndRecordDelimiters(string, "\\t", '\t');
        string = this.commonToFieldAndRecordDelimiters(string, "\\r", '\r');
        string = this.commonToFieldAndRecordDelimiters(string, "\\f", '\f');
        return string;
    }

    private String commonToFieldAndRecordDelimiters(String string, String string2, char c) {
        while (string.indexOf(string2) != -1) {
            int n = string.indexOf(string2);
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 2);
            string = string3 + c + string4;
        }
        return string;
    }

    private String mapFromUserFriendlyRecordDelimiters(String string) {
        if (string.equals("\n")) {
            string = INTERNAL_NEWLINE;
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_NEWLINE.toUpperCase(Locale.ENGLISH))) {
            return "\n";
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_CR.toUpperCase(Locale.ENGLISH))) {
            return CR;
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_LF.toUpperCase(Locale.ENGLISH))) {
            return "\n";
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_CRLF.toUpperCase(Locale.ENGLISH))) {
            return CRLF;
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_LFCR.toUpperCase(Locale.ENGLISH))) {
            return LFCR;
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_FF.toUpperCase(Locale.ENGLISH))) {
            return FF;
        }
        if (string.toUpperCase(Locale.ENGLISH).equals(INTERNAL_EMPTY_LINE.toUpperCase(Locale.ENGLISH))) {
            return EMPTY_LINE;
        }
        string = this.commonToFieldAndRecordDelimiters(string, "\\n", '\n');
        string = this.commonToFieldAndRecordDelimiters(string, "\\t", '\t');
        string = this.commonToFieldAndRecordDelimiters(string, "\\r", '\r');
        string = this.commonToFieldAndRecordDelimiters(string, "\\f", '\f');
        return string;
    }

    String getDataCodeset() throws Exception {
        return this.getCurrentProperties().getProperty(DATA_CODESET);
    }

    Properties getCurrentProperties() throws Exception {
        if (this.currentProperties == null) {
            this.loadDefaultValues();
        }
        return this.currentProperties;
    }

    public void setColumnWidths(String string) throws Exception {
        if (string != null) {
            this.currentProperties.setProperty(COLUMN_WIDTHS, string);
        }
    }

    public void setFieldSeparator(String string) throws Exception {
        if (string != null) {
            this.currentProperties.setProperty(FIELD_SEPARATOR, string);
        }
    }

    public void setFieldStartDelimiter(String string) throws Exception {
        if (string != null) {
            this.currentProperties.setProperty(FIELD_START_DELIMITER, string);
        }
    }

    public void setFieldEndDelimiter(String string) throws Exception {
        if (string != null) {
            this.currentProperties.setProperty(FIELD_END_DELIMITER, string);
        }
    }

    public void setRecordSeparator(String string) throws Exception {
        if (string != null) {
            this.currentProperties.setProperty(RECORD_SEPARATOR, string);
        }
    }

    public void setHasDelimiterAtEnd(String string) throws Exception {
        if (string != null) {
            this.currentProperties.setProperty(HAS_DELIMETER_AT_END, string);
        }
    }

    public void setNullString(String string) throws Exception {
        if (string != null) {
            this.currentProperties.setProperty(NULL_STRING, string);
        }
    }

    public void setcolumnDefinition(String string) throws Exception {
        if (string != null) {
            this.currentProperties.setProperty(COLUMN_DEFINITION, string);
        }
    }

    public void setDataCodeset(String string) throws Exception {
        if (string != null) {
            this.currentProperties.setProperty(DATA_CODESET, string);
        }
    }

    public void setCharacterDelimiter(String string) throws Exception {
        if (string != null) {
            this.setFieldStartDelimiter(string);
            this.setFieldEndDelimiter(string);
        }
    }

    public void setControlProperties(String string, String string2, String string3) throws Exception {
        this.setCharacterDelimiter(string);
        this.setFieldSeparator(string2);
        this.setDataCodeset(string3);
        this.validateDelimiters();
    }

    private void validateDelimiters() throws Exception {
        char c = this.getFieldSeparator().charAt(0);
        char c2 = this.getFieldStartDelimiter().charAt(0);
        if (c2 == '.') {
            throw LoadError.periodAsCharDelimiterNotAllowed();
        }
        if (c == c2 || c == '.' || Character.isSpaceChar(c) || Character.isSpaceChar(c2)) {
            throw LoadError.delimitersAreNotMutuallyExclusive();
        }
    }
}

