/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.utility;

import java.util.Arrays;

public class IntAllocator {
    private IntervalList base;
    private final int[] unsorted;
    private int unsortedCount = 0;

    public static IntervalList merge(IntervalList x, IntervalList y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (x.end > y.start) {
            return IntAllocator.merge(y, x);
        }
        if (y.start == x.end + 1) {
            x.end = y.end;
            x.next = IntAllocator.merge(x.next, y.next);
            return x;
        }
        x.next = IntAllocator.merge(y, x.next);
        return x;
    }

    public static IntervalList fromArray(int[] xs, int length) {
        Arrays.sort(xs, 0, length);
        IntervalList result = null;
        IntervalList current = null;
        for (int i = 0; i < length; ++i) {
            int start = i;
            while (i < length - 1 && xs[i + 1] == xs[i] + 1) {
                ++i;
            }
            IntervalList interval = new IntervalList(xs[start], xs[i]);
            if (result == null) {
                result = interval;
                current = interval;
                continue;
            }
            current.next = interval;
            current = interval;
        }
        return result;
    }

    public IntAllocator(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("illegal range [" + start + ", " + end + "]");
        }
        this.unsorted = new int[Math.max(32, (int)Math.sqrt(end - start))];
        this.base = new IntervalList(start, end);
    }

    public int allocate() {
        if (this.unsortedCount > 0) {
            return this.unsorted[--this.unsortedCount];
        }
        if (this.base != null) {
            IntervalList source = this.base;
            if (this.base.length() == 1) {
                this.base = this.base.next;
            }
            return source.start++;
        }
        return -1;
    }

    public void free(int id) {
        if (this.unsortedCount >= this.unsorted.length) {
            this.flush();
        }
        this.unsorted[this.unsortedCount++] = id;
    }

    public boolean reserve(int id) {
        this.flush();
        IntervalList current = this.base;
        while (current != null && current.end < id) {
            current = current.next;
        }
        if (current == null) {
            return false;
        }
        if (current.start > id) {
            return false;
        }
        if (current.end == id) {
            --current.end;
        } else if (current.start == id) {
            ++current.start;
        } else {
            IntervalList rest = new IntervalList(id + 1, current.end);
            current.end = id - 1;
            rest.next = current.next;
            current.next = rest;
        }
        return true;
    }

    public void flush() {
        if (this.unsortedCount == 0) {
            return;
        }
        this.base = IntAllocator.merge(this.base, IntAllocator.fromArray(this.unsorted, this.unsortedCount));
        this.unsortedCount = 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IntAllocator{");
        builder.append("intervals = [");
        IntervalList it = this.base;
        while (it != null) {
            builder.append(it.start).append("..").append(it.end);
            if (it.next != null) {
                builder.append(", ");
            }
            it = it.next;
        }
        builder.append("]");
        builder.append(", unsorted = [");
        for (int i = 0; i < this.unsortedCount; ++i) {
            builder.append(this.unsorted[i]);
            if (i >= this.unsortedCount - 1) continue;
            builder.append(", ");
        }
        builder.append("]");
        builder.append("}");
        return builder.toString();
    }

    private static class IntervalList {
        int start;
        int end;
        IntervalList next;

        IntervalList(int start, int end) {
            this.start = start;
            this.end = end;
        }

        int length() {
            return this.end - this.start + 1;
        }
    }
}

