/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Age;
import com.drew.metadata.Face;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.PanasonicMakernoteDirectory;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanasonicMakernoteDescriptor
extends TagDescriptor<PanasonicMakernoteDirectory> {
    public PanasonicMakernoteDescriptor(@NotNull PanasonicMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: {
                return this.getQualityModeDescription();
            }
            case 2: {
                return this.getVersionDescription();
            }
            case 3: {
                return this.getWhiteBalanceDescription();
            }
            case 7: {
                return this.getFocusModeDescription();
            }
            case 15: {
                return this.getAfAreaModeDescription();
            }
            case 26: {
                return this.getImageStabilizationDescription();
            }
            case 28: {
                return this.getMacroModeDescription();
            }
            case 31: {
                return this.getRecordModeDescription();
            }
            case 32: {
                return this.getAudioDescription();
            }
            case 33: {
                return this.getUnknownDataDumpDescription();
            }
            case 40: {
                return this.getColorEffectDescription();
            }
            case 41: {
                return this.getUptimeDescription();
            }
            case 42: {
                return this.getBurstModeDescription();
            }
            case 44: {
                return this.getContrastModeDescription();
            }
            case 45: {
                return this.getNoiseReductionDescription();
            }
            case 46: {
                return this.getSelfTimerDescription();
            }
            case 48: {
                return this.getRotationDescription();
            }
            case 49: {
                return this.getAfAssistLampDescription();
            }
            case 50: {
                return this.getColorModeDescription();
            }
            case 52: {
                return this.getOpticalZoomModeDescription();
            }
            case 53: {
                return this.getConversionLensDescription();
            }
            case 57: {
                return this.getContrastDescription();
            }
            case 58: {
                return this.getWorldTimeLocationDescription();
            }
            case 61: {
                return this.getAdvancedSceneModeDescription();
            }
            case 78: {
                return this.getDetectedFacesDescription();
            }
            case 89: {
                return this.getTransformDescription();
            }
            case 32786: {
                return this.getTransform1Description();
            }
            case 93: {
                return this.getIntelligentExposureDescription();
            }
            case 98: {
                return this.getFlashWarningDescription();
            }
            case 105: {
                return this.getCountryDescription();
            }
            case 107: {
                return this.getStateDescription();
            }
            case 109: {
                return this.getCityDescription();
            }
            case 111: {
                return this.getLandmarkDescription();
            }
            case 112: {
                return this.getIntelligentResolutionDescription();
            }
            case 97: {
                return this.getRecognizedFacesDescription();
            }
            case 3584: {
                return this.getPrintImageMatchingInfoDescription();
            }
            case 32769: {
                return this.getSceneModeDescription();
            }
            case 32775: {
                return this.getFlashFiredDescription();
            }
            case 59: {
                return this.getTextStampDescription();
            }
            case 62: {
                return this.getTextStamp1Description();
            }
            case 32776: {
                return this.getTextStamp2Description();
            }
            case 32777: {
                return this.getTextStamp3Description();
            }
            case 32768: {
                return this.getMakernoteVersionDescription();
            }
            case 38: {
                return this.getExifVersionDescription();
            }
            case 37: {
                return this.getInternalSerialNumberDescription();
            }
            case 101: {
                return this.getTitleDescription();
            }
            case 102: {
                return this.getBabyNameDescription();
            }
            case 103: {
                return this.getLocationDescription();
            }
            case 51: {
                return this.getBabyAgeDescription();
            }
            case 32784: {
                return this.getBabyAge1Description();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getPrintImageMatchingInfoDescription() {
        byte[] values = ((PanasonicMakernoteDirectory)this._directory).getByteArray(3584);
        if (values == null) {
            return null;
        }
        return "(" + values.length + " bytes)";
    }

    @Nullable
    public String getTextStampDescription() {
        return this.getOnOffDescription(59);
    }

    @Nullable
    public String getTextStamp1Description() {
        return this.getOnOffDescription(62);
    }

    @Nullable
    public String getTextStamp2Description() {
        return this.getOnOffDescription(32776);
    }

    @Nullable
    public String getTextStamp3Description() {
        return this.getOnOffDescription(32777);
    }

    @Nullable
    public String getMacroModeDescription() {
        return this.getOnOffDescription(28);
    }

    @Nullable
    public String getFlashFiredDescription() {
        return this.getOnOffDescription(32775);
    }

    @Nullable
    public String getImageStabilizationDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(26);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 2: {
                return "On, Mode 1";
            }
            case 3: {
                return "Off";
            }
            case 4: {
                return "On, Mode 2";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getAudioDescription() {
        return this.getOnOffDescription(32);
    }

    @Nullable
    public String getTransformDescription() {
        return this.getTransformDescription(89);
    }

    @Nullable
    public String getTransform1Description() {
        return this.getTransformDescription(32786);
    }

    @Nullable
    private String getTransformDescription(int tag) {
        byte[] values = ((PanasonicMakernoteDirectory)this._directory).getByteArray(tag);
        if (values == null) {
            return null;
        }
        ByteArrayReader reader = new ByteArrayReader(values);
        try {
            int val1 = reader.getUInt16(0);
            int val2 = reader.getUInt16(2);
            if (val1 == -1 && val2 == 1) {
                return "Slim Low";
            }
            if (val1 == -3 && val2 == 2) {
                return "Slim High";
            }
            if (val1 == 0 && val2 == 0) {
                return "Off";
            }
            if (val1 == 1 && val2 == 1) {
                return "Stretch Low";
            }
            if (val1 == 3 && val2 == 2) {
                return "Stretch High";
            }
            return "Unknown (" + val1 + " " + val2 + ")";
        }
        catch (BufferBoundsException e) {
            return null;
        }
    }

    @Nullable
    public String getIntelligentExposureDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(93);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "Standard";
            }
            case 3: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFlashWarningDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(98);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "No";
            }
            case 1: {
                return "Yes (Flash required but disabled)";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getCountryDescription() {
        return this.getTextDescription(105);
    }

    @Nullable
    public String getStateDescription() {
        return this.getTextDescription(107);
    }

    @Nullable
    public String getCityDescription() {
        return this.getTextDescription(109);
    }

    @Nullable
    public String getLandmarkDescription() {
        return this.getTextDescription(111);
    }

    @Nullable
    public String getTitleDescription() {
        return this.getTextDescription(101);
    }

    @Nullable
    public String getBabyNameDescription() {
        return this.getTextDescription(102);
    }

    @Nullable
    public String getLocationDescription() {
        return this.getTextDescription(103);
    }

    @Nullable
    public String getIntelligentResolutionDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(112);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 2: {
                return "Auto";
            }
            case 3: {
                return "On";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getContrastDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(57);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getWorldTimeLocationDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(58);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Home";
            }
            case 2: {
                return "Destination";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getAdvancedSceneModeDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(61);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Outdoor/Illuminations/Flower/HDR Art";
            }
            case 3: {
                return "Indoor/Architecture/Objects/HDR B&W";
            }
            case 4: {
                return "Creative";
            }
            case 5: {
                return "Auto";
            }
            case 7: {
                return "Expressive";
            }
            case 8: {
                return "Retro";
            }
            case 9: {
                return "Pure";
            }
            case 10: {
                return "Elegant";
            }
            case 12: {
                return "Monochrome";
            }
            case 13: {
                return "Dynamic Art";
            }
            case 14: {
                return "Silhouette";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getUnknownDataDumpDescription() {
        byte[] value = ((PanasonicMakernoteDirectory)this._directory).getByteArray(33);
        if (value == null) {
            return null;
        }
        return "[" + value.length + " bytes]";
    }

    @Nullable
    public String getColorEffectDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(40);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Off";
            }
            case 2: {
                return "Warm";
            }
            case 3: {
                return "Cool";
            }
            case 4: {
                return "Black & White";
            }
            case 5: {
                return "Sepia";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getUptimeDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(41);
        if (value == null) {
            return null;
        }
        return (float)value.intValue() / 100.0f + " s";
    }

    @Nullable
    public String getBurstModeDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(42);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
            case 2: {
                return "Infinite";
            }
            case 4: {
                return "Unlimited";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getContrastModeDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(44);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "High";
            }
            case 6: {
                return "Medium Low";
            }
            case 7: {
                return "Medium High";
            }
            case 256: {
                return "Low";
            }
            case 272: {
                return "Normal";
            }
            case 288: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getNoiseReductionDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(45);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Standard (0)";
            }
            case 1: {
                return "Low (-1)";
            }
            case 2: {
                return "High (+1)";
            }
            case 3: {
                return "Lowest (-2)";
            }
            case 4: {
                return "Highest (+2)";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSelfTimerDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(46);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Off";
            }
            case 2: {
                return "10 s";
            }
            case 3: {
                return "2 s";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getRotationDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(48);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Horizontal";
            }
            case 3: {
                return "Rotate 180";
            }
            case 6: {
                return "Rotate 90 CW";
            }
            case 8: {
                return "Rotate 270 CW";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getAfAssistLampDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(49);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Fired";
            }
            case 2: {
                return "Enabled but not used";
            }
            case 3: {
                return "Disabled but required";
            }
            case 4: {
                return "Disabled and not required";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getColorModeDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(50);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Natural";
            }
            case 2: {
                return "Vivid";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getOpticalZoomModeDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(52);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Standard";
            }
            case 2: {
                return "Extended";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getConversionLensDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(53);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Off";
            }
            case 2: {
                return "Wide";
            }
            case 3: {
                return "Telephoto";
            }
            case 4: {
                return "Macro";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getDetectedFacesDescription() {
        return this.buildFacesDescription(((PanasonicMakernoteDirectory)this._directory).getDetectedFaces());
    }

    @Nullable
    public String getRecognizedFacesDescription() {
        return this.buildFacesDescription(((PanasonicMakernoteDirectory)this._directory).getRecognizedFaces());
    }

    @Nullable
    private String buildFacesDescription(@Nullable Face[] faces) {
        if (faces == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < faces.length; ++i) {
            result.append("Face ").append(i + 1).append(": ").append(faces[i].toString()).append("\n");
        }
        if (result.length() > 0) {
            return result.substring(0, result.length() - 1);
        }
        return null;
    }

    @Nullable
    public String getRecordModeDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(31);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Portrait";
            }
            case 3: {
                return "Scenery";
            }
            case 4: {
                return "Sports";
            }
            case 5: {
                return "Night Portrait";
            }
            case 6: {
                return "Program";
            }
            case 7: {
                return "Aperture Priority";
            }
            case 8: {
                return "Shutter Priority";
            }
            case 9: {
                return "Macro";
            }
            case 10: {
                return "Spot";
            }
            case 11: {
                return "Manual";
            }
            case 12: {
                return "Movie Preview";
            }
            case 13: {
                return "Panning";
            }
            case 14: {
                return "Simple";
            }
            case 15: {
                return "Color Effects";
            }
            case 16: {
                return "Self Portrait";
            }
            case 17: {
                return "Economy";
            }
            case 18: {
                return "Fireworks";
            }
            case 19: {
                return "Party";
            }
            case 20: {
                return "Snow";
            }
            case 21: {
                return "Night Scenery";
            }
            case 22: {
                return "Food";
            }
            case 23: {
                return "Baby";
            }
            case 24: {
                return "Soft Skin";
            }
            case 25: {
                return "Candlelight";
            }
            case 26: {
                return "Starry Night";
            }
            case 27: {
                return "High Sensitivity";
            }
            case 28: {
                return "Panorama Assist";
            }
            case 29: {
                return "Underwater";
            }
            case 30: {
                return "Beach";
            }
            case 31: {
                return "Aerial Photo";
            }
            case 32: {
                return "Sunset";
            }
            case 33: {
                return "Pet";
            }
            case 34: {
                return "Intelligent ISO";
            }
            case 35: {
                return "Clipboard";
            }
            case 36: {
                return "High Speed Continuous Shooting";
            }
            case 37: {
                return "Intelligent Auto";
            }
            case 39: {
                return "Multi-aspect";
            }
            case 41: {
                return "Transform";
            }
            case 42: {
                return "Flash Burst";
            }
            case 43: {
                return "Pin Hole";
            }
            case 44: {
                return "Film Grain";
            }
            case 45: {
                return "My Color";
            }
            case 46: {
                return "Photo Frame";
            }
            case 51: {
                return "HDR";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSceneModeDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(32769);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Portrait";
            }
            case 3: {
                return "Scenery";
            }
            case 4: {
                return "Sports";
            }
            case 5: {
                return "Night Portrait";
            }
            case 6: {
                return "Program";
            }
            case 7: {
                return "Aperture Priority";
            }
            case 8: {
                return "Shutter Priority";
            }
            case 9: {
                return "Macro";
            }
            case 10: {
                return "Spot";
            }
            case 11: {
                return "Manual";
            }
            case 12: {
                return "Movie Preview";
            }
            case 13: {
                return "Panning";
            }
            case 14: {
                return "Simple";
            }
            case 15: {
                return "Color Effects";
            }
            case 16: {
                return "Self Portrait";
            }
            case 17: {
                return "Economy";
            }
            case 18: {
                return "Fireworks";
            }
            case 19: {
                return "Party";
            }
            case 20: {
                return "Snow";
            }
            case 21: {
                return "Night Scenery";
            }
            case 22: {
                return "Food";
            }
            case 23: {
                return "Baby";
            }
            case 24: {
                return "Soft Skin";
            }
            case 25: {
                return "Candlelight";
            }
            case 26: {
                return "Starry Night";
            }
            case 27: {
                return "High Sensitivity";
            }
            case 28: {
                return "Panorama Assist";
            }
            case 29: {
                return "Underwater";
            }
            case 30: {
                return "Beach";
            }
            case 31: {
                return "Aerial Photo";
            }
            case 32: {
                return "Sunset";
            }
            case 33: {
                return "Pet";
            }
            case 34: {
                return "Intelligent ISO";
            }
            case 35: {
                return "Clipboard";
            }
            case 36: {
                return "High Speed Continuous Shooting";
            }
            case 37: {
                return "Intelligent Auto";
            }
            case 39: {
                return "Multi-aspect";
            }
            case 41: {
                return "Transform";
            }
            case 42: {
                return "Flash Burst";
            }
            case 43: {
                return "Pin Hole";
            }
            case 44: {
                return "Film Grain";
            }
            case 45: {
                return "My Color";
            }
            case 46: {
                return "Photo Frame";
            }
            case 51: {
                return "HDR";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFocusModeDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(7);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Manual";
            }
            case 4: {
                return "Auto, Focus Button";
            }
            case 5: {
                return "Auto, Continuous";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getAfAreaModeDescription() {
        int[] value = ((PanasonicMakernoteDirectory)this._directory).getIntArray(15);
        if (value == null || value.length < 2) {
            return null;
        }
        switch (value[0]) {
            case 0: {
                switch (value[1]) {
                    case 1: {
                        return "Spot Mode On";
                    }
                    case 16: {
                        return "Spot Mode Off";
                    }
                }
                return "Unknown (" + value[0] + " " + value[1] + ")";
            }
            case 1: {
                switch (value[1]) {
                    case 0: {
                        return "Spot Focusing";
                    }
                    case 1: {
                        return "5-area";
                    }
                }
                return "Unknown (" + value[0] + " " + value[1] + ")";
            }
            case 16: {
                switch (value[1]) {
                    case 0: {
                        return "1-area";
                    }
                    case 16: {
                        return "1-area (high speed)";
                    }
                }
                return "Unknown (" + value[0] + " " + value[1] + ")";
            }
            case 32: {
                switch (value[1]) {
                    case 0: {
                        return "Auto or Face Detect";
                    }
                    case 1: {
                        return "3-area (left)";
                    }
                    case 2: {
                        return "3-area (center)";
                    }
                    case 3: {
                        return "3-area (right)";
                    }
                }
                return "Unknown (" + value[0] + " " + value[1] + ")";
            }
            case 64: {
                return "Face Detect";
            }
        }
        return "Unknown (" + value[0] + " " + value[1] + ")";
    }

    @Nullable
    public String getQualityModeDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(1);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 2: {
                return "High";
            }
            case 3: {
                return "Normal";
            }
            case 6: {
                return "Very High";
            }
            case 7: {
                return "Raw";
            }
            case 9: {
                return "Motion Picture";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getVersionDescription() {
        return PanasonicMakernoteDescriptor.convertBytesToVersionString(((PanasonicMakernoteDirectory)this._directory).getIntArray(2), 2);
    }

    @Nullable
    public String getMakernoteVersionDescription() {
        return PanasonicMakernoteDescriptor.convertBytesToVersionString(((PanasonicMakernoteDirectory)this._directory).getIntArray(32768), 2);
    }

    @Nullable
    public String getExifVersionDescription() {
        return PanasonicMakernoteDescriptor.convertBytesToVersionString(((PanasonicMakernoteDirectory)this._directory).getIntArray(38), 2);
    }

    @Nullable
    public String getInternalSerialNumberDescription() {
        byte[] bytes = ((PanasonicMakernoteDirectory)this._directory).getByteArray(37);
        if (bytes == null) {
            return null;
        }
        int length = bytes.length;
        for (int index = 0; index < bytes.length; ++index) {
            int i = bytes[index] & 0xFF;
            if (i != 0 && i <= 127) continue;
            length = index;
            break;
        }
        return new String(bytes, 0, length);
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(3);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Daylight";
            }
            case 3: {
                return "Cloudy";
            }
            case 4: {
                return "Incandescent";
            }
            case 5: {
                return "Manual";
            }
            case 8: {
                return "Flash";
            }
            case 10: {
                return "Black & White";
            }
            case 11: {
                return "Manual";
            }
            case 12: {
                return "Shade";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getBabyAgeDescription() {
        Age age = ((PanasonicMakernoteDirectory)this._directory).getAge(51);
        if (age == null) {
            return null;
        }
        return age.toFriendlyString();
    }

    @Nullable
    public String getBabyAge1Description() {
        Age age = ((PanasonicMakernoteDirectory)this._directory).getAge(32784);
        if (age == null) {
            return null;
        }
        return age.toFriendlyString();
    }

    @Nullable
    private String getTextDescription(int tag) {
        byte[] values = ((PanasonicMakernoteDirectory)this._directory).getByteArray(tag);
        if (values == null) {
            return null;
        }
        try {
            return new String(values, "ASCII").trim();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Nullable
    private String getOnOffDescription(int tag) {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(tag);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Off";
            }
            case 2: {
                return "On";
            }
        }
        return "Unknown (" + value + ")";
    }
}

