/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.gagravarr.flac.FlacFile;
import org.gagravarr.flac.FlacInfo;
import org.gagravarr.flac.FlacOggFile;
import org.gagravarr.tika.VorbisParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlacParser
extends AbstractParser {
    private static MediaType TYPE = MediaType.audio("x-flac");

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return Collections.singleton(TYPE);
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        metadata.set("Content-Type", TYPE.toString());
        metadata.set(XMPDM.AUDIO_COMPRESSOR, "FLAC");
        FlacFile flac = FlacFile.open(stream);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.extractInfo(metadata, flac.getInfo());
        if (flac instanceof FlacOggFile) {
            FlacOggFile ogg = (FlacOggFile)flac;
            metadata.add("version", "Flac " + ogg.getFirstPacket().getMajorVersion() + "." + ogg.getFirstPacket().getMinorVersion());
        }
        VorbisParser.extractComments(metadata, xhtml, flac.getTags());
        xhtml.endDocument();
    }

    protected void extractInfo(Metadata metadata, FlacInfo info) throws TikaException {
        metadata.set(XMPDM.AUDIO_SAMPLE_RATE, info.getSampleRate());
        VorbisParser.extractChannelInfo(metadata, info.getNumChannels());
    }
}

