/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.gagravarr.flac.FlacFirstOggPacket;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.tika.OggDetector;
import org.gagravarr.vorbis.VorbisPacket;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OggParser
extends AbstractParser {
    private static List<MediaType> TYPES = Arrays.asList(OggDetector.OGG_GENERAL, OggDetector.OGG_VIDEO);

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return new HashSet<MediaType>(TYPES);
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        OggPacket p;
        OggFile ogg = new OggFile(stream);
        int streams = 0;
        int flacCount = 0;
        int vorbisCount = 0;
        ArrayList<Integer> sids = new ArrayList<Integer>();
        OggPacketReader r = ogg.getPacketReader();
        while ((p = r.getNextPacket()) != null) {
            if (!p.isBeginningOfStream()) continue;
            ++streams;
            sids.add(p.getSid());
            if (p.getData() == null || p.getData().length <= 10) continue;
            if (VorbisPacket.isVorbisStream(p)) {
                ++vorbisCount;
            }
            if (!FlacFirstOggPacket.isFlacStream(p)) continue;
            ++flacCount;
        }
        metadata.add("streams-total", Integer.toString(streams));
        metadata.add("streams-vorbis", Integer.toString(vorbisCount));
        metadata.add("streams-flac", Integer.toString(flacCount));
    }
}

